/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.threading;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiSynchronizedStatement;
import com.intellij.psi.util.PsiUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.fixes.MakeFieldFinalFix;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class SynchronizeOnNonFinalFieldInspection
extends BaseInspection {
    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("synchronize.on.non.final.field.problem.descriptor", new Object[0]);
        if (string == null) {
            SynchronizeOnNonFinalFieldInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    public boolean isEnabledByDefault() {
        return true;
    }

    @Override
    @Nullable
    protected LocalQuickFix buildFix(Object ... infos) {
        PsiField field = (PsiField)infos[0];
        return MakeFieldFinalFix.buildFix(field);
    }

    @Override
    @NotNull
    public BaseInspectionVisitor buildVisitor() {
        return new SynchronizeOnNonFinalFieldVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/threading/SynchronizeOnNonFinalFieldInspection", "buildErrorString"));
    }

    private static class SynchronizeOnNonFinalFieldVisitor
    extends BaseInspectionVisitor {
        private SynchronizeOnNonFinalFieldVisitor() {
        }

        public void visitSynchronizedStatement(@NotNull PsiSynchronizedStatement statement) {
            if (statement == null) {
                SynchronizeOnNonFinalFieldVisitor.$$$reportNull$$$0(0);
            }
            super.visitSynchronizedStatement(statement);
            PsiExpression lockExpression = PsiUtil.skipParenthesizedExprDown((PsiExpression)statement.getLockExpression());
            if (!(lockExpression instanceof PsiReferenceExpression)) {
                return;
            }
            PsiElement element = ((PsiReferenceExpression)lockExpression).resolve();
            if (!(element instanceof PsiField)) {
                return;
            }
            PsiField field = (PsiField)element;
            if (field.hasModifierProperty("final")) {
                return;
            }
            this.registerError((PsiElement)lockExpression, field);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statement", "com/siyeh/ig/threading/SynchronizeOnNonFinalFieldInspection$SynchronizeOnNonFinalFieldVisitor", "visitSynchronizedStatement"));
        }
    }
}

