/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.threading;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.options.OptPane;
import com.intellij.codeInspection.options.OptRegularComponent;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.PsiUpdateModCommandQuickFix;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import org.jetbrains.annotations.NotNull;

public final class SynchronizedMethodInspection
extends BaseInspection {
    public boolean m_includeNativeMethods = true;
    public boolean ignoreSynchronizedSuperMethods = true;

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        PsiMethod method = (PsiMethod)infos[0];
        String string = InspectionGadgetsBundle.message("synchronized.method.problem.descriptor", method.getName());
        if (string == null) {
            SynchronizedMethodInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    protected LocalQuickFix buildFix(Object ... infos) {
        PsiMethod method = (PsiMethod)infos[0];
        if (method.getBody() == null) {
            return null;
        }
        return new SynchronizedMethodFix();
    }

    @Override
    @NotNull
    public BaseInspectionVisitor buildVisitor() {
        return new SynchronizedMethodVisitor();
    }

    @NotNull
    public OptPane getOptionsPane() {
        OptPane optPane = OptPane.pane((OptRegularComponent[])new OptRegularComponent[]{OptPane.checkbox((String)"m_includeNativeMethods", (String)InspectionGadgetsBundle.message("synchronized.method.include.option", new Object[0]), (OptRegularComponent[])new OptRegularComponent[0]), OptPane.checkbox((String)"ignoreSynchronizedSuperMethods", (String)InspectionGadgetsBundle.message("synchronized.method.ignore.synchronized.super.option", new Object[0]), (OptRegularComponent[])new OptRegularComponent[0])});
        if (optPane == null) {
            SynchronizedMethodInspection.$$$reportNull$$$0(1);
        }
        return optPane;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/siyeh/ig/threading/SynchronizedMethodInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getOptionsPane";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private static class SynchronizedMethodFix
    extends PsiUpdateModCommandQuickFix {
        private SynchronizedMethodFix() {
        }

        @NotNull
        public String getFamilyName() {
            String string = InspectionGadgetsBundle.message("synchronized.method.move.quickfix", new Object[0]);
            if (string == null) {
                SynchronizedMethodFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        protected void applyFix(@NotNull Project project, @NotNull PsiElement nameElement, @NotNull ModPsiUpdater updater) {
            String replacementText;
            if (project == null) {
                SynchronizedMethodFix.$$$reportNull$$$0(1);
            }
            if (nameElement == null) {
                SynchronizedMethodFix.$$$reportNull$$$0(2);
            }
            if (updater == null) {
                SynchronizedMethodFix.$$$reportNull$$$0(3);
            }
            PsiModifierList modifierList = (PsiModifierList)nameElement.getParent();
            assert (modifierList != null);
            PsiMethod method = (PsiMethod)modifierList.getParent();
            modifierList.setModifierProperty("synchronized", false);
            assert (method != null);
            PsiCodeBlock body = method.getBody();
            if (body == null) {
                return;
            }
            String text = body.getText();
            if (method.hasModifierProperty("static")) {
                PsiClass containingClass = method.getContainingClass();
                assert (containingClass != null);
                String className = containingClass.getName();
                replacementText = "{ synchronized(" + className + ".class)" + text + "}";
            } else {
                replacementText = "{ synchronized(this)" + text + "}";
            }
            PsiCodeBlock block = JavaPsiFacade.getElementFactory((Project)project).createCodeBlockFromText(replacementText, (PsiElement)method);
            body.replace((PsiElement)block);
            CodeStyleManager codeStyleManager = CodeStyleManager.getInstance((Project)project);
            codeStyleManager.reformat((PsiElement)method);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 2, 3 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/siyeh/ig/threading/SynchronizedMethodInspection$SynchronizedMethodFix";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "nameElement";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "updater";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/siyeh/ig/threading/SynchronizedMethodInspection$SynchronizedMethodFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1, 2, 3 -> new IllegalArgumentException(string);
            };
        }
    }

    private class SynchronizedMethodVisitor
    extends BaseInspectionVisitor {
        private SynchronizedMethodVisitor() {
        }

        public void visitMethod(@NotNull PsiMethod method) {
            if (method == null) {
                SynchronizedMethodVisitor.$$$reportNull$$$0(0);
            }
            if (!method.hasModifierProperty("synchronized")) {
                return;
            }
            if (!SynchronizedMethodInspection.this.m_includeNativeMethods && method.hasModifierProperty("native")) {
                return;
            }
            if (SynchronizedMethodInspection.this.ignoreSynchronizedSuperMethods) {
                PsiMethod[] superMethods;
                for (PsiMethod superMethod : superMethods = method.findSuperMethods()) {
                    if (!superMethod.hasModifierProperty("synchronized")) continue;
                    return;
                }
            }
            this.registerModifierError("synchronized", (PsiModifierListOwner)method, method);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/siyeh/ig/threading/SynchronizedMethodInspection$SynchronizedMethodVisitor", "visitMethod"));
        }
    }
}

