/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.threading;

import com.intellij.codeInspection.options.OptPane;
import com.intellij.codeInspection.options.OptRegularComponent;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiSynchronizedStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.psiutils.ExpressionUtils;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public final class SynchronizedOnLiteralObjectInspection
extends BaseInspection {
    public boolean warnOnAllPossiblyLiterals = false;
    private static final Set<String> LITERAL_TYPES = Set.of("java.lang.String", "java.lang.Boolean", "java.lang.Character", "java.lang.Byte", "java.lang.Short", "java.lang.Integer", "java.lang.Long");

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String typeText = ((PsiType)infos[0]).getPresentableText();
        int message = (Integer)infos[1];
        String string = switch (message) {
            case 1 -> InspectionGadgetsBundle.message("synchronized.on.literal.object.problem.descriptor", typeText);
            case 2 -> InspectionGadgetsBundle.message("synchronized.on.direct.literal.object.problem.descriptor", typeText);
            case 3 -> InspectionGadgetsBundle.message("synchronized.on.possibly.literal.object.problem.descriptor", typeText);
            default -> throw new AssertionError();
        };
        if (string == null) {
            SynchronizedOnLiteralObjectInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NotNull
    public OptPane getOptionsPane() {
        OptPane optPane = OptPane.pane((OptRegularComponent[])new OptRegularComponent[]{OptPane.checkbox((String)"warnOnAllPossiblyLiterals", (String)InspectionGadgetsBundle.message("synchronized.on.literal.object.warn.on.all.option", new Object[0]), (OptRegularComponent[])new OptRegularComponent[0])});
        if (optPane == null) {
            SynchronizedOnLiteralObjectInspection.$$$reportNull$$$0(1);
        }
        return optPane;
    }

    @Override
    @NotNull
    public BaseInspectionVisitor buildVisitor() {
        return new SynchronizeOnLiteralVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/siyeh/ig/threading/SynchronizedOnLiteralObjectInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getOptionsPane";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private class SynchronizeOnLiteralVisitor
    extends BaseInspectionVisitor {
        private SynchronizeOnLiteralVisitor() {
        }

        public void visitSynchronizedStatement(@NotNull PsiSynchronizedStatement statement) {
            if (statement == null) {
                SynchronizeOnLiteralVisitor.$$$reportNull$$$0(0);
            }
            super.visitSynchronizedStatement(statement);
            PsiExpression lockExpression = statement.getLockExpression();
            if (lockExpression == null) {
                return;
            }
            PsiType type = lockExpression.getType();
            if (type == null) {
                return;
            }
            if (!LITERAL_TYPES.contains(type.getCanonicalText())) {
                return;
            }
            if (!(lockExpression instanceof PsiReferenceExpression)) {
                if (ExpressionUtils.isLiteral(lockExpression)) {
                    this.registerError((PsiElement)lockExpression, type, 2);
                } else if (SynchronizedOnLiteralObjectInspection.this.warnOnAllPossiblyLiterals) {
                    this.registerError((PsiElement)lockExpression, type, 3);
                }
                return;
            }
            PsiReferenceExpression referenceExpression = (PsiReferenceExpression)lockExpression;
            PsiElement target = referenceExpression.resolve();
            if (!(target instanceof PsiVariable)) {
                if (SynchronizedOnLiteralObjectInspection.this.warnOnAllPossiblyLiterals) {
                    this.registerError((PsiElement)lockExpression, type, 3);
                }
                return;
            }
            PsiVariable variable = (PsiVariable)target;
            PsiExpression initializer = variable.getInitializer();
            if (!ExpressionUtils.isLiteral(initializer)) {
                if (SynchronizedOnLiteralObjectInspection.this.warnOnAllPossiblyLiterals) {
                    this.registerError((PsiElement)lockExpression, type, 3);
                }
                return;
            }
            this.registerError((PsiElement)lockExpression, type, 1);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statement", "com/siyeh/ig/threading/SynchronizedOnLiteralObjectInspection$SynchronizeOnLiteralVisitor", "visitSynchronizedStatement"));
        }
    }
}

