/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.threading;

import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassInitializer;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public final class ThreadStartInConstructionInspection
extends BaseInspection {
    @NotNull
    public String getID() {
        return "CallToThreadStartDuringObjectConstruction";
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("thread.start.in.construction.problem.descriptor", new Object[0]);
        if (string == null) {
            ThreadStartInConstructionInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    @NotNull
    public BaseInspectionVisitor buildVisitor() {
        return new ThreadStartInConstructionVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/threading/ThreadStartInConstructionInspection", "buildErrorString"));
    }

    private static class ThreadStartInConstructionVisitor
    extends BaseInspectionVisitor {
        private ThreadStartInConstructionVisitor() {
        }

        public void visitMethod(@NotNull PsiMethod method) {
            if (method == null) {
                ThreadStartInConstructionVisitor.$$$reportNull$$$0(0);
            }
            if (method.isConstructor()) {
                method.accept((PsiElementVisitor)new ThreadStartVisitor());
            }
        }

        public void visitClassInitializer(@NotNull PsiClassInitializer initializer) {
            if (initializer == null) {
                ThreadStartInConstructionVisitor.$$$reportNull$$$0(1);
            }
            if (!initializer.hasModifierProperty("static")) {
                initializer.accept((PsiElementVisitor)new ThreadStartVisitor());
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "method";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "initializer";
                    break;
                }
            }
            objectArray2[1] = "com/siyeh/ig/threading/ThreadStartInConstructionInspection$ThreadStartInConstructionVisitor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitMethod";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitClassInitializer";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }

        private class ThreadStartVisitor
        extends JavaRecursiveElementWalkingVisitor {
            private ThreadStartVisitor() {
            }

            public void visitClass(@NotNull PsiClass aClass) {
                if (aClass == null) {
                    ThreadStartVisitor.$$$reportNull$$$0(0);
                }
            }

            public void visitMethodCallExpression(@NotNull PsiMethodCallExpression expression) {
                if (expression == null) {
                    ThreadStartVisitor.$$$reportNull$$$0(1);
                }
                super.visitMethodCallExpression(expression);
                PsiReferenceExpression methodExpression = expression.getMethodExpression();
                @NonNls String methodName = methodExpression.getReferenceName();
                if (!"start".equals(methodName)) {
                    return;
                }
                PsiMethod method = expression.resolveMethod();
                if (method == null) {
                    return;
                }
                PsiParameterList parameterList = method.getParameterList();
                if (!parameterList.isEmpty()) {
                    return;
                }
                PsiClass methodClass = method.getContainingClass();
                if (methodClass == null || !InheritanceUtil.isInheritor((PsiClass)methodClass, (String)"java.lang.Thread")) {
                    return;
                }
                PsiClass containingClass = PsiUtil.getContainingClass((PsiElement)expression);
                if (containingClass == null || containingClass.hasModifierProperty("final")) {
                    return;
                }
                ThreadStartInConstructionVisitor.this.registerMethodCallError(expression, new Object[0]);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "aClass";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "expression";
                        break;
                    }
                }
                objectArray2[1] = "com/siyeh/ig/threading/ThreadStartInConstructionInspection$ThreadStartInConstructionVisitor$ThreadStartVisitor";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitClass";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitMethodCallExpression";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }
    }
}

