/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.threading;

import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.util.JavaPsiConstructorUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.psiutils.TypeUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ThreadWithDefaultRunMethodInspection
extends BaseInspection {
    @NotNull
    public String getID() {
        return "InstantiatingAThreadWithDefaultRunMethod";
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("thread.with.default.run.method.problem.descriptor", new Object[0]);
        if (string == null) {
            ThreadWithDefaultRunMethodInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    @NotNull
    public BaseInspectionVisitor buildVisitor() {
        return new ThreadWithDefaultRunMethodVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/threading/ThreadWithDefaultRunMethodInspection", "buildErrorString"));
    }

    private static class ThreadWithDefaultRunMethodVisitor
    extends BaseInspectionVisitor {
        private ThreadWithDefaultRunMethodVisitor() {
        }

        public void visitNewExpression(@NotNull PsiNewExpression expression) {
            if (expression == null) {
                ThreadWithDefaultRunMethodVisitor.$$$reportNull$$$0(0);
            }
            super.visitNewExpression(expression);
            PsiAnonymousClass anonymousClass = expression.getAnonymousClass();
            if (anonymousClass != null) {
                if (ThreadWithDefaultRunMethodVisitor.definesRun((PsiClass)anonymousClass)) {
                    return;
                }
                this.processExpression(expression, anonymousClass.getBaseClassReference());
            } else {
                PsiJavaCodeReferenceElement classReference = expression.getClassReference();
                if (classReference == null) {
                    return;
                }
                this.processExpression(expression, classReference);
            }
        }

        private void processExpression(PsiNewExpression expression, PsiJavaCodeReferenceElement baseClassReference) {
            PsiElement referent = baseClassReference.resolve();
            if (!(referent instanceof PsiClass)) {
                return;
            }
            PsiClass referencedClass = (PsiClass)referent;
            if (!InheritanceUtil.isInheritor((PsiClass)referencedClass, (String)"java.lang.Thread")) {
                return;
            }
            String referencedClassName = referencedClass.getQualifiedName();
            if ("java.lang.Thread".equals(referencedClassName)) {
                this.checkThreadCreation(expression);
                return;
            }
            PsiClass currentClass = referencedClass;
            while (currentClass != null && !"java.lang.Thread".equals(currentClass.getQualifiedName()) && !"java.lang.Object".equals(currentClass.getQualifiedName())) {
                if (ThreadWithDefaultRunMethodVisitor.definesRun(currentClass)) {
                    return;
                }
                PsiClass superClass = currentClass.getSuperClass();
                if (superClass != null && "java.lang.Thread".equals(superClass.getQualifiedName()) && ThreadWithDefaultRunMethodVisitor.hasCallSuperWithRunnable(currentClass)) {
                    return;
                }
                currentClass = superClass;
            }
            this.registerNewExpressionError(expression, new Object[0]);
        }

        private static boolean hasCallSuperWithRunnable(@NotNull PsiClass currentClass) {
            if (currentClass == null) {
                ThreadWithDefaultRunMethodVisitor.$$$reportNull$$$0(1);
            }
            for (PsiMethod method : currentClass.getMethods()) {
                PsiMethodCallExpression call;
                if (!method.isConstructor() || (call = ThreadWithDefaultRunMethodVisitor.getSuperCall(method)) == null || !ThreadWithDefaultRunMethodVisitor.anyIsRunnable(call.getArgumentList().getExpressions())) continue;
                return true;
            }
            return false;
        }

        @Nullable
        private static PsiMethodCallExpression getSuperCall(@NotNull PsiMethod method) {
            PsiExpression call;
            PsiStatement firstStmt;
            PsiCodeBlock body;
            if (method == null) {
                ThreadWithDefaultRunMethodVisitor.$$$reportNull$$$0(2);
            }
            if ((body = method.getBody()) == null) {
                return null;
            }
            PsiStatement[] statements = body.getStatements();
            PsiStatement psiStatement = firstStmt = statements.length > 0 ? statements[0] : null;
            if (firstStmt instanceof PsiExpressionStatement && (call = ((PsiExpressionStatement)firstStmt).getExpression()) instanceof PsiMethodCallExpression && JavaPsiConstructorUtil.isSuperConstructorCall((PsiElement)call)) {
                return (PsiMethodCallExpression)call;
            }
            return null;
        }

        private void checkThreadCreation(PsiNewExpression expression) {
            PsiExpressionList argumentList = expression.getArgumentList();
            if (argumentList == null) {
                return;
            }
            PsiExpression[] arguments = argumentList.getExpressions();
            if (ThreadWithDefaultRunMethodVisitor.anyIsRunnable(arguments)) {
                return;
            }
            this.registerNewExpressionError(expression, new Object[0]);
        }

        private static boolean anyIsRunnable(PsiExpression[] arguments) {
            for (PsiExpression argument : arguments) {
                if (!TypeUtils.expressionHasTypeOrSubtype(argument, "java.lang.Runnable")) continue;
                return true;
            }
            return false;
        }

        private static boolean definesRun(PsiClass aClass) {
            PsiMethod[] methods;
            for (PsiMethod method : methods = aClass.findMethodsByName("run", false)) {
                PsiParameterList parameterList = method.getParameterList();
                if (method.hasModifierProperty("abstract") || !parameterList.isEmpty()) continue;
                return true;
            }
            return false;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "expression";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "currentClass";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "method";
                    break;
                }
            }
            objectArray2[1] = "com/siyeh/ig/threading/ThreadWithDefaultRunMethodInspection$ThreadWithDefaultRunMethodVisitor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitNewExpression";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "hasCallSuperWithRunnable";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getSuperCall";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

