/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.threading;

import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiLoopStatement;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.util.PsiTreeUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.threading.ThreadingUtils;
import org.jetbrains.annotations.NotNull;

public final class WaitNotInLoopInspection
extends BaseInspection {
    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("wait.not.in.loop.problem.descriptor", new Object[0]);
        if (string == null) {
            WaitNotInLoopInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    @NotNull
    public BaseInspectionVisitor buildVisitor() {
        return new WaitNotInLoopVisitor();
    }

    static boolean isCheckedInLoop(PsiMethodCallExpression expression) {
        PsiElement parent = PsiTreeUtil.getParentOfType((PsiElement)expression, (Class[])new Class[]{PsiLoopStatement.class, PsiMember.class, PsiLambdaExpression.class});
        if (parent instanceof PsiAnonymousClass || parent instanceof PsiLambdaExpression) {
            return true;
        }
        if (!(parent instanceof PsiLoopStatement)) {
            return false;
        }
        PsiStatement body = ((PsiLoopStatement)parent).getBody();
        return PsiTreeUtil.isAncestor((PsiElement)body, (PsiElement)expression, (boolean)true);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/threading/WaitNotInLoopInspection", "buildErrorString"));
    }

    private static class WaitNotInLoopVisitor
    extends BaseInspectionVisitor {
        private WaitNotInLoopVisitor() {
        }

        public void visitMethodCallExpression(@NotNull PsiMethodCallExpression expression) {
            if (expression == null) {
                WaitNotInLoopVisitor.$$$reportNull$$$0(0);
            }
            super.visitMethodCallExpression(expression);
            if (!ThreadingUtils.isWaitCall(expression) || WaitNotInLoopInspection.isCheckedInLoop(expression)) {
                return;
            }
            this.registerMethodCallError(expression, new Object[0]);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/siyeh/ig/threading/WaitNotInLoopInspection$WaitNotInLoopVisitor", "visitMethodCallExpression"));
        }
    }
}

