/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.visibility;

import com.intellij.codeInsight.intention.preview.IntentionPreviewInfo;
import com.intellij.codeInspection.CleanupLocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.modcommand.ModCommand;
import com.intellij.modcommand.ModCommandQuickFix;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.PsiUpdateModCommandQuickFix;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.NavigatablePsiElement;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiImportStaticStatement;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiResolveHelper;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.ObjectUtils;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.PsiReplacementUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class AmbiguousFieldAccessInspection
extends BaseInspection
implements CleanupLocalInspectionTool {
    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        PsiClass fieldClass = (PsiClass)infos[0];
        PsiVariable variable = (PsiVariable)infos[1];
        if (variable instanceof PsiLocalVariable) {
            String string = InspectionGadgetsBundle.message("ambiguous.field.access.hides.local.variable.problem.descriptor", fieldClass.getName());
            if (string == null) {
                AmbiguousFieldAccessInspection.$$$reportNull$$$0(0);
            }
            return string;
        }
        if (variable instanceof PsiParameter) {
            String string = InspectionGadgetsBundle.message("ambiguous.field.access.hides.parameter.problem.descriptor", fieldClass.getName());
            if (string == null) {
                AmbiguousFieldAccessInspection.$$$reportNull$$$0(1);
            }
            return string;
        }
        String string = InspectionGadgetsBundle.message("ambiguous.field.access.hides.field.problem.descriptor", fieldClass.getName());
        if (string == null) {
            AmbiguousFieldAccessInspection.$$$reportNull$$$0(2);
        }
        return string;
    }

    @Override
    @NotNull
    public BaseInspectionVisitor buildVisitor() {
        return new AmbiguousFieldAccessVisitor();
    }

    @Override
    @Nullable
    protected LocalQuickFix buildFix(Object ... infos) {
        return new AmbiguousFieldAccessFix();
    }

    @Override
    protected LocalQuickFix @NotNull [] buildFixes(Object ... infos) {
        boolean isOnTheFly = (Boolean)infos[2];
        PsiVariable variable = (PsiVariable)infos[1];
        if (isOnTheFly) {
            LocalQuickFix[] localQuickFixArray = new LocalQuickFix[]{new NavigateToApparentlyAccessedElementFix(variable), new AmbiguousFieldAccessFix()};
            if (localQuickFixArray == null) {
                AmbiguousFieldAccessInspection.$$$reportNull$$$0(3);
            }
            return localQuickFixArray;
        }
        LocalQuickFix[] localQuickFixArray = new LocalQuickFix[]{new AmbiguousFieldAccessFix()};
        if (localQuickFixArray == null) {
            AmbiguousFieldAccessInspection.$$$reportNull$$$0(4);
        }
        return localQuickFixArray;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/siyeh/ig/visibility/AmbiguousFieldAccessInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "buildFixes";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private static class AmbiguousFieldAccessVisitor
    extends BaseInspectionVisitor {
        private AmbiguousFieldAccessVisitor() {
        }

        @Override
        public void visitReferenceExpression(@NotNull PsiReferenceExpression expression) {
            String referenceText;
            if (expression == null) {
                AmbiguousFieldAccessVisitor.$$$reportNull$$$0(0);
            }
            super.visitReferenceExpression(expression);
            if (expression.isQualified()) {
                return;
            }
            PsiElement target = expression.resolve();
            if (target == null) {
                return;
            }
            if (!(target instanceof PsiField)) {
                return;
            }
            PsiField field = (PsiField)target;
            PsiClass fieldClass = field.getContainingClass();
            if (fieldClass == null) {
                return;
            }
            PsiClass containingClass = PsiUtil.getContainingClass((PsiElement)expression);
            if (containingClass == null) {
                return;
            }
            if (!containingClass.isInheritor(fieldClass, true)) {
                return;
            }
            PsiElement parent = containingClass.getParent();
            if (parent instanceof PsiFile) {
                return;
            }
            PsiResolveHelper resolveHelper = JavaPsiFacade.getInstance((Project)expression.getProject()).getResolveHelper();
            PsiVariable variable = resolveHelper.resolveAccessibleReferencedVariable(referenceText = expression.getText(), parent);
            if (variable == null || field == variable) {
                return;
            }
            if (expression.advancedResolve(false).getCurrentFileResolveScope() instanceof PsiImportStaticStatement) {
                return;
            }
            this.registerError((PsiElement)expression, fieldClass, variable, this.isOnTheFly());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/siyeh/ig/visibility/AmbiguousFieldAccessInspection$AmbiguousFieldAccessVisitor", "visitReferenceExpression"));
        }
    }

    private static class AmbiguousFieldAccessFix
    extends PsiUpdateModCommandQuickFix {
        private AmbiguousFieldAccessFix() {
        }

        @NotNull
        public String getFamilyName() {
            String string = InspectionGadgetsBundle.message("ambiguous.field.access.quickfix", new Object[0]);
            if (string == null) {
                AmbiguousFieldAccessFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        protected void applyFix(@NotNull Project project, @NotNull PsiElement element, @NotNull ModPsiUpdater updater) {
            if (project == null) {
                AmbiguousFieldAccessFix.$$$reportNull$$$0(1);
            }
            if (element == null) {
                AmbiguousFieldAccessFix.$$$reportNull$$$0(2);
            }
            if (updater == null) {
                AmbiguousFieldAccessFix.$$$reportNull$$$0(3);
            }
            if (!(element instanceof PsiReferenceExpression)) {
                return;
            }
            PsiReferenceExpression referenceExpression = (PsiReferenceExpression)element;
            String newExpressionText = "super." + referenceExpression.getText();
            PsiReplacementUtil.replaceExpression((PsiExpression)referenceExpression, newExpressionText);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 2, 3 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/siyeh/ig/visibility/AmbiguousFieldAccessInspection$AmbiguousFieldAccessFix";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "updater";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/siyeh/ig/visibility/AmbiguousFieldAccessInspection$AmbiguousFieldAccessFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1, 2, 3 -> new IllegalArgumentException(string);
            };
        }
    }

    private static class NavigateToApparentlyAccessedElementFix
    extends ModCommandQuickFix {
        private final int type;

        NavigateToApparentlyAccessedElementFix(PsiVariable variable) {
            this.type = variable instanceof PsiLocalVariable ? 1 : (variable instanceof PsiParameter ? 2 : 3);
        }

        @NotNull
        public String getFamilyName() {
            String string = InspectionGadgetsBundle.message("ambiguous.field.access.navigate.quickfix", this.type);
            if (string == null) {
                NavigateToApparentlyAccessedElementFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        @NotNull
        public ModCommand perform(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            PsiIdentifier identifier;
            PsiElement element;
            PsiVariable variable;
            if (project == null) {
                NavigateToApparentlyAccessedElementFix.$$$reportNull$$$0(1);
            }
            if (descriptor == null) {
                NavigateToApparentlyAccessedElementFix.$$$reportNull$$$0(2);
            }
            if ((variable = NavigateToApparentlyAccessedElementFix.getApparentlyAccessedVariable(project, element = descriptor.getPsiElement())) != null && (identifier = variable.getNameIdentifier()) != null) {
                ModCommand modCommand = ModCommand.select((PsiElement)identifier);
                if (modCommand == null) {
                    NavigateToApparentlyAccessedElementFix.$$$reportNull$$$0(3);
                }
                return modCommand;
            }
            ModCommand modCommand = ModCommand.nop();
            if (modCommand == null) {
                NavigateToApparentlyAccessedElementFix.$$$reportNull$$$0(4);
            }
            return modCommand;
        }

        @Nullable
        private static PsiVariable getApparentlyAccessedVariable(Project project, PsiElement element) {
            PsiClass containingClass = PsiUtil.getContainingClass((PsiElement)element);
            if (containingClass == null) {
                return null;
            }
            PsiElement parent = containingClass.getParent();
            PsiResolveHelper resolveHelper = JavaPsiFacade.getInstance((Project)project).getResolveHelper();
            String referenceText = element.getText();
            return resolveHelper.resolveAccessibleReferencedVariable(referenceText, parent);
        }

        @NotNull
        public IntentionPreviewInfo generatePreview(@NotNull Project project, @NotNull ProblemDescriptor previewDescriptor) {
            PsiVariable variable;
            NavigatablePsiElement element;
            if (project == null) {
                NavigateToApparentlyAccessedElementFix.$$$reportNull$$$0(5);
            }
            if (previewDescriptor == null) {
                NavigateToApparentlyAccessedElementFix.$$$reportNull$$$0(6);
            }
            if ((element = (NavigatablePsiElement)ObjectUtils.tryCast((Object)(variable = NavigateToApparentlyAccessedElementFix.getApparentlyAccessedVariable(project, previewDescriptor.getPsiElement())), NavigatablePsiElement.class)) == null) {
                IntentionPreviewInfo intentionPreviewInfo = IntentionPreviewInfo.EMPTY;
                if (intentionPreviewInfo == null) {
                    NavigateToApparentlyAccessedElementFix.$$$reportNull$$$0(7);
                }
                return intentionPreviewInfo;
            }
            IntentionPreviewInfo intentionPreviewInfo = IntentionPreviewInfo.navigate((NavigatablePsiElement)element);
            if (intentionPreviewInfo == null) {
                NavigateToApparentlyAccessedElementFix.$$$reportNull$$$0(8);
            }
            return intentionPreviewInfo;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 2, 5, 6 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/siyeh/ig/visibility/AmbiguousFieldAccessInspection$NavigateToApparentlyAccessedElementFix";
                    break;
                }
                case 1: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "previewDescriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: 
                case 5: 
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/siyeh/ig/visibility/AmbiguousFieldAccessInspection$NavigateToApparentlyAccessedElementFix";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "perform";
                    break;
                }
                case 7: 
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[1] = "generatePreview";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "perform";
                    break;
                }
                case 5: 
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "generatePreview";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1, 2, 5, 6 -> new IllegalArgumentException(string);
            };
        }
    }
}

