/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.visibility;

import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.util.PsiTreeUtil;
import com.siyeh.ig.BaseInspectionVisitor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Internal
public final class AnonymousClassVariableHidesOuterClassVariableVisitor
extends BaseInspectionVisitor {
    public void visitAnonymousClass(@NotNull PsiAnonymousClass aClass) {
        PsiParameter[] parameters;
        if (aClass == null) {
            AnonymousClassVariableHidesOuterClassVariableVisitor.$$$reportNull$$$0(0);
        }
        super.visitAnonymousClass(aClass);
        PsiCodeBlock codeBlock = (PsiCodeBlock)PsiTreeUtil.getParentOfType((PsiElement)aClass, PsiCodeBlock.class);
        if (codeBlock == null) {
            return;
        }
        VariableCollector collector = new VariableCollector();
        aClass.acceptChildren((PsiElementVisitor)collector);
        PsiStatement[] statements = codeBlock.getStatements();
        int offset = aClass.getTextOffset();
        for (PsiStatement statement : statements) {
            PsiElement[] declaredElements;
            if (statement.getTextOffset() >= offset) break;
            if (!(statement instanceof PsiDeclarationStatement)) continue;
            PsiDeclarationStatement declarationStatement = (PsiDeclarationStatement)statement;
            for (PsiElement declaredElement : declaredElements = declarationStatement.getDeclaredElements()) {
                PsiVariable[] variables;
                if (!(declaredElement instanceof PsiLocalVariable)) continue;
                PsiLocalVariable localVariable = (PsiLocalVariable)declaredElement;
                String name = localVariable.getName();
                for (PsiVariable variable : variables = collector.getVariables(name)) {
                    this.registerVariableError(variable, variable);
                }
            }
        }
        PsiElement containingMethod = PsiTreeUtil.getParentOfType((PsiElement)codeBlock, (Class[])new Class[]{PsiMethod.class, PsiLambdaExpression.class});
        if (containingMethod == null) {
            return;
        }
        PsiParameterList parameterList = containingMethod instanceof PsiMethod ? ((PsiMethod)containingMethod).getParameterList() : ((PsiLambdaExpression)containingMethod).getParameterList();
        for (PsiParameter parameter : parameters = parameterList.getParameters()) {
            PsiVariable[] variables;
            String name = parameter.getName();
            for (PsiVariable variable : variables = collector.getVariables(name)) {
                this.registerVariableError(variable, variable);
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/siyeh/ig/visibility/AnonymousClassVariableHidesOuterClassVariableVisitor", "visitAnonymousClass"));
    }

    private static final class VariableCollector
    extends JavaRecursiveElementWalkingVisitor {
        private static final PsiVariable[] EMPTY_VARIABLE_LIST = new PsiVariable[0];
        private final Map<String, List<PsiVariable>> variableMap = new HashMap<String, List<PsiVariable>>();

        private VariableCollector() {
        }

        public void visitVariable(@NotNull PsiVariable variable) {
            if (variable == null) {
                VariableCollector.$$$reportNull$$$0(0);
            }
            super.visitVariable(variable);
            String name = variable.getName();
            List<PsiVariable> variableList = this.variableMap.get(name);
            if (variableList == null) {
                ArrayList<PsiVariable> list = new ArrayList<PsiVariable>();
                list.add(variable);
                this.variableMap.put(name, list);
            } else {
                variableList.add(variable);
            }
        }

        public void visitClass(@NotNull PsiClass aClass) {
            if (aClass == null) {
                VariableCollector.$$$reportNull$$$0(1);
            }
        }

        public PsiVariable @NotNull [] getVariables(String name) {
            List<PsiVariable> variableList = this.variableMap.get(name);
            if (variableList == null) {
                if (EMPTY_VARIABLE_LIST == null) {
                    VariableCollector.$$$reportNull$$$0(2);
                }
                return EMPTY_VARIABLE_LIST;
            }
            PsiVariable[] psiVariableArray = variableList.toArray(new PsiVariable[0]);
            if (psiVariableArray == null) {
                VariableCollector.$$$reportNull$$$0(3);
            }
            return psiVariableArray;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2, 3 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "variable";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "aClass";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/siyeh/ig/visibility/AnonymousClassVariableHidesOuterClassVariableVisitor$VariableCollector";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/siyeh/ig/visibility/AnonymousClassVariableHidesOuterClassVariableVisitor$VariableCollector";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getVariables";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "visitVariable";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "visitClass";
                    break;
                }
                case 2: 
                case 3: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2, 3 -> new IllegalStateException(string);
            };
        }
    }
}

