/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.java.generate.psi;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiImportList;
import com.intellij.psi.PsiImportStatement;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypes;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.javadoc.PsiDocComment;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PropertyUtil;
import com.intellij.psi.util.PropertyUtilBase;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.ArrayUtilRt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PsiAdapter {
    private PsiAdapter() {
    }

    public static boolean isConstantField(PsiField field) {
        PsiModifierList list = field.getModifierList();
        if (list == null) {
            return false;
        }
        if (!list.hasModifierProperty("static")) {
            return false;
        }
        return !StringUtil.hasLowerCaseChar((String)field.getName());
    }

    @Nullable
    public static PsiMethod findMethodByName(PsiClass clazz, String name) {
        PsiMethod[] methods = clazz.getMethods();
        for (int i = methods.length - 1; i >= 0; --i) {
            PsiMethod method = methods[i];
            if (!name.equals(method.getName())) continue;
            return method;
        }
        return null;
    }

    public static boolean isPrimitiveArrayType(PsiType type) {
        return type instanceof PsiArrayType && PsiAdapter.isPrimitiveType(((PsiArrayType)type).getComponentType());
    }

    public static boolean isObjectArrayType(PsiType type) {
        return type instanceof PsiArrayType && !PsiAdapter.isPrimitiveType(((PsiArrayType)type).getComponentType());
    }

    public static boolean isStringArrayType(PsiType type) {
        if (PsiAdapter.isPrimitiveType(type)) {
            return false;
        }
        return type.getCanonicalText().indexOf("String[]") > 0;
    }

    public static boolean isCollectionType(PsiElementFactory factory, PsiType type) {
        return PsiAdapter.isTypeOf(factory, type, "java.util.Collection");
    }

    public static boolean isMapType(PsiElementFactory factory, PsiType type) {
        return PsiAdapter.isTypeOf(factory, type, "java.util.Map");
    }

    public static boolean isSetType(PsiElementFactory factory, PsiType type) {
        return PsiAdapter.isTypeOf(factory, type, "java.util.Set");
    }

    public static boolean isListType(PsiElementFactory factory, PsiType type) {
        return PsiAdapter.isTypeOf(factory, type, "java.util.List");
    }

    public static boolean isStringType(PsiElementFactory factory, PsiType type) {
        return PsiAdapter.isTypeOf(factory, type, "java.lang.String");
    }

    public static boolean isObjectType(PsiElementFactory factory, PsiType type) {
        return PsiAdapter.isTypeOf(factory, type, "java.lang.Object");
    }

    public static boolean isDateType(PsiElementFactory factory, PsiType type) {
        return PsiAdapter.isTypeOf(factory, type, "java.util.Date");
    }

    public static boolean isCalendarType(PsiElementFactory factory, PsiType type) {
        return PsiAdapter.isTypeOf(factory, type, "java.util.Calendar");
    }

    public static boolean isBooleanType(PsiElementFactory factory, PsiType type) {
        return PsiTypes.booleanType().equals((Object)type) || type.equalsToText("java.lang.Boolean");
    }

    public static boolean isNumericType(PsiElementFactory factory, PsiType type) {
        if (PsiAdapter.isPrimitiveType(type)) {
            String s = type.getCanonicalText();
            return "byte".equals(s) || "double".equals(s) || "float".equals(s) || "int".equals(s) || "long".equals(s) || "short".equals(s);
        }
        return PsiAdapter.isTypeOf(factory, type, "java.lang.Number");
    }

    public static boolean hasImportStatement(PsiJavaFile javaFile, String importStatement) {
        PsiImportList importList = javaFile.getImportList();
        if (importList == null) {
            return false;
        }
        if (importStatement.endsWith(".*")) {
            return importList.findOnDemandImportStatement(PsiAdapter.fixImportStatement(importStatement)) != null;
        }
        return importList.findSingleClassImportStatement(importStatement) != null;
    }

    public static void addImportStatement(PsiJavaFile javaFile, String importStatementOnDemand) {
        PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)javaFile.getProject());
        PsiImportStatement is = factory.createImportStatementOnDemand(PsiAdapter.fixImportStatement(importStatementOnDemand));
        PsiImportList importList = javaFile.getImportList();
        if (importList != null) {
            importList.add((PsiElement)is);
        }
        JavaCodeStyleManager.getInstance((Project)javaFile.getProject()).optimizeImports((PsiFile)javaFile);
    }

    private static String fixImportStatement(String importStatementOnDemand) {
        if (importStatementOnDemand.endsWith(".*")) {
            return importStatementOnDemand.substring(0, importStatementOnDemand.length() - 2);
        }
        boolean hasClassname = StringUtil.hasUpperCaseChar((String)importStatementOnDemand);
        if (hasClassname) {
            int pos = importStatementOnDemand.lastIndexOf(".");
            return importStatementOnDemand.substring(0, pos);
        }
        return importStatementOnDemand;
    }

    @Nullable
    public static String getTypeQualifiedClassName(PsiType type) {
        if (PsiAdapter.isPrimitiveType(type)) {
            return null;
        }
        String name = type.getCanonicalText();
        if (name.endsWith("[]")) {
            return name.substring(0, name.length() - 2);
        }
        return name;
    }

    @Nullable
    public static String getTypeClassName(PsiType type) {
        String name = PsiAdapter.getTypeQualifiedClassName(type);
        if (name == null) {
            return null;
        }
        return StringUtil.getShortName((String)name);
    }

    @Nullable
    public static PsiMethod findPublicStaticVoidMainMethod(PsiClass clazz) {
        PsiMethod[] methods;
        for (PsiMethod method : methods = clazz.findMethodsByName("main", false)) {
            PsiParameter[] parameters;
            if (!method.hasModifierProperty("public") || !method.hasModifierProperty("static")) continue;
            PsiType returnType = method.getReturnType();
            if (!PsiTypes.voidType().equals((Object)returnType) || (parameters = method.getParameterList().getParameters()).length != 1 || !PsiAdapter.isStringArrayType(parameters[0].getType())) continue;
            return method;
        }
        return null;
    }

    @Nullable
    public static PsiComment addOrReplaceJavadoc(PsiMethod method, String javadoc, boolean replace) {
        Project project = method.getProject();
        PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)project);
        PsiComment comment = factory.createCommentFromText(javadoc, null);
        PsiDocComment doc = method.getDocComment();
        if (doc != null) {
            if (replace) {
                doc.replace((PsiElement)comment);
                CodeStyleManager codeStyleManager = CodeStyleManager.getInstance((Project)project);
                codeStyleManager.reformat((PsiElement)method);
                return comment;
            }
            return null;
        }
        method.addBefore((PsiElement)comment, method.getFirstChild());
        CodeStyleManager codeStyleManager = CodeStyleManager.getInstance((Project)project);
        codeStyleManager.reformat((PsiElement)method);
        return comment;
    }

    public static boolean isTypeOfVoid(PsiType type) {
        return type != null && type.equalsToText("void");
    }

    public static boolean isGetterMethod(PsiMethod method) {
        return PropertyUtil.isSimpleGetter(method);
    }

    @Nullable
    public static String getGetterFieldName(PsiMethod method) {
        if (!PsiAdapter.isGetterMethod(method)) {
            return null;
        }
        return PropertyUtilBase.getPropertyNameByGetter((PsiMethod)method);
    }

    public static boolean isEnumField(PsiField field) {
        PsiClass aClass = PsiUtil.resolveClassInClassTypeOnly((PsiType)field.getType());
        return aClass != null && aClass.isEnum();
    }

    public static boolean isExceptionClass(PsiClass clazz) {
        return InheritanceUtil.isInheritor((PsiClass)clazz, (String)"java.lang.Throwable");
    }

    @Nullable
    public static PsiMethod findEqualsMethod(PsiClass clazz) {
        PsiMethod[] methods;
        for (PsiMethod method : methods = clazz.findMethodsByName("equals", false)) {
            PsiParameter[] parameters;
            if (!method.hasModifierProperty("public") || method.hasModifierProperty("static")) continue;
            PsiType returnType = method.getReturnType();
            if (!PsiTypes.booleanType().equals((Object)returnType) || (parameters = method.getParameterList().getParameters()).length != 1 || !parameters[0].getType().getCanonicalText().equals("java.lang.Object")) continue;
            return method;
        }
        return null;
    }

    @Nullable
    public static PsiMethod findHashCodeMethod(PsiClass clazz) {
        PsiMethod[] methods;
        for (PsiMethod method : methods = clazz.findMethodsByName("hashCode", false)) {
            PsiParameterList parameters;
            if (!method.hasModifierProperty("public") || method.hasModifierProperty("static")) continue;
            PsiType returnType = method.getReturnType();
            if (!PsiTypes.intType().equals((Object)returnType) || !(parameters = method.getParameterList()).isEmpty()) continue;
            return method;
        }
        return null;
    }

    private static boolean isTypeOf(PsiElementFactory factory, PsiType type, String typeFQClassName) {
        if (PsiAdapter.isTypeOfVoid(type)) {
            return false;
        }
        if (PsiAdapter.isPrimitiveType(type)) {
            return false;
        }
        GlobalSearchScope scope = type.getResolveScope();
        if (scope == null) {
            return false;
        }
        PsiClassType typeTarget = factory.createTypeByFQClassName(typeFQClassName, scope);
        return typeTarget.isAssignableFrom(type);
    }

    public static String @NotNull [] getImplementsClassnames(PsiClass clazz) {
        PsiClass[] interfaces = clazz.getInterfaces();
        if (interfaces.length == 0) {
            if (ArrayUtilRt.EMPTY_STRING_ARRAY == null) {
                PsiAdapter.$$$reportNull$$$0(0);
            }
            return ArrayUtilRt.EMPTY_STRING_ARRAY;
        }
        String[] names = new String[interfaces.length];
        for (int i = 0; i < interfaces.length; ++i) {
            PsiClass anInterface = interfaces[i];
            names[i] = anInterface.getName();
        }
        if (names == null) {
            PsiAdapter.$$$reportNull$$$0(1);
        }
        return names;
    }

    public static boolean isPrimitiveType(PsiType type) {
        return type instanceof PsiPrimitiveType;
    }

    public static boolean isNestedArray(PsiType aType) {
        if (!(aType instanceof PsiArrayType)) {
            return false;
        }
        PsiType componentType = ((PsiArrayType)aType).getComponentType();
        return componentType instanceof PsiArrayType;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/java/generate/psi/PsiAdapter", "getImplementsClassnames"));
    }
}

