/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.configurations;

import com.intellij.execution.CantRunException;
import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.configurations.ParametersList;
import com.intellij.execution.configurations.SimpleJavaParameters;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.LanguageLevelUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.JavaSdkVersion;
import com.intellij.openapi.projectRoots.JavaSdkVersionUtil;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.NativeLibraryOrderRootType;
import com.intellij.openapi.roots.OrderEnumerator;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.OrderRootsEnumerator;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.encoding.EncodingProjectManager;
import com.intellij.openapi.vfs.jrt.JrtFileSystem;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.util.PathsList;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.LinkedHashSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaParameters
extends SimpleJavaParameters {
    private static final Logger LOG = Logger.getInstance(JavaParameters.class);
    private static final String JAVA_LIBRARY_PATH_PROPERTY = "java.library.path";
    public static final String JAVA_ENABLE_PREVIEW_PROPERTY = "--enable-preview";
    public static final DataKey<JavaParameters> JAVA_PARAMETERS = DataKey.create((String)"javaParameters");
    public static final int JDK_ONLY = 1;
    public static final int CLASSES_ONLY = 2;
    public static final int TESTS_ONLY = 4;
    public static final int INCLUDE_PROVIDED = 8;
    public static final int JDK_AND_CLASSES = 3;
    public static final int JDK_AND_CLASSES_AND_TESTS = 7;
    public static final int CLASSES_AND_TESTS = 6;
    public static final int JDK_AND_CLASSES_AND_PROVIDED = 11;

    public String getJdkPath() throws CantRunException {
        Sdk jdk = this.getJdk();
        if (jdk == null) {
            throw new CantRunException(ExecutionBundle.message((String)"no.jdk.specified..error.message", (Object[])new Object[0]));
        }
        VirtualFile jdkHome = jdk.getHomeDirectory();
        if (jdkHome == null) {
            throw new CantRunException(ExecutionBundle.message((String)"home.directory.not.specified.for.jdk.error.message", (Object[])new Object[0]));
        }
        return jdkHome.getPresentableUrl();
    }

    public void configureByModule(Module module, int classPathType, Sdk jdk) throws CantRunException {
        if ((classPathType & 1) != 0) {
            if (jdk == null) {
                throw CantRunException.noJdkConfigured();
            }
            this.setJdk(jdk);
        }
        if ((classPathType & 2) == 0) {
            return;
        }
        this.setDefaultCharset(module.getProject());
        JavaParameters.configureEnumerator(OrderEnumerator.orderEntries((Module)module).recursively(), classPathType, jdk).collectPaths(this.getClassPath());
        this.configureJavaLibraryPath(OrderEnumerator.orderEntries((Module)module).recursively());
        this.configureJavaEnablePreviewProperty(OrderEnumerator.orderEntries((Module)module).recursively(), jdk);
    }

    private void configureJavaEnablePreviewProperty(OrderEnumerator orderEnumerator, Sdk jdk) {
        ParametersList vmParameters = this.getVMParametersList();
        if (vmParameters.hasParameter(JAVA_ENABLE_PREVIEW_PROPERTY) || !JavaSdkVersionUtil.isAtLeast((Sdk)jdk, (JavaSdkVersion)JavaSdkVersion.JDK_11)) {
            return;
        }
        orderEnumerator.forEachModule(module -> {
            LanguageLevel languageLevel = LanguageLevelUtil.getEffectiveLanguageLevel((Module)module);
            if (languageLevel.isPreview()) {
                vmParameters.add(JAVA_ENABLE_PREVIEW_PROPERTY);
                return false;
            }
            return true;
        });
    }

    private void configureJavaLibraryPath(OrderEnumerator enumerator) {
        PathsList pathsList = new PathsList();
        enumerator.runtimeOnly().withoutSdk().roots(NativeLibraryOrderRootType.getInstance()).collectPaths(pathsList);
        if (!pathsList.getPathList().isEmpty()) {
            ParametersList vmParameters = this.getVMParametersList();
            if (vmParameters.hasProperty(JAVA_LIBRARY_PATH_PROPERTY)) {
                LOG.info("java.library.path property is already specified, native library paths from dependencies (" + pathsList.getPathsString() + ") won't be added");
            } else {
                vmParameters.addProperty(JAVA_LIBRARY_PATH_PROPERTY, pathsList.getPathsString());
            }
        }
    }

    public void setDefaultCharset(Project project) {
        Charset encoding = EncodingProjectManager.getInstance((Project)project).getDefaultCharset();
        this.setCharset(encoding);
    }

    public void configureByModule(Module module, int classPathType) throws CantRunException {
        this.configureByModule(module, classPathType, JavaParameters.getValidJdkToRunModule(module, (classPathType & 4) == 0));
    }

    @NotNull
    public static Sdk getValidJdkToRunModule(Module module, boolean productionOnly) throws CantRunException {
        Sdk jdk = JavaParameters.getJdkToRunModule(module, productionOnly);
        if (jdk == null) {
            throw CantRunException.noJdkForModule((Module)module);
        }
        VirtualFile homeDirectory = jdk.getHomeDirectory();
        if (homeDirectory == null || !homeDirectory.isValid()) {
            throw CantRunException.jdkMisconfigured((Sdk)jdk);
        }
        Sdk sdk = jdk;
        if (sdk == null) {
            JavaParameters.$$$reportNull$$$0(0);
        }
        return sdk;
    }

    @Nullable
    public static Sdk getJdkToRunModule(Module module, boolean productionOnly) {
        Sdk moduleSdk = ModuleRootManager.getInstance((Module)module).getSdk();
        if (moduleSdk == null) {
            return null;
        }
        LinkedHashSet sdksFromDependencies = new LinkedHashSet();
        OrderEnumerator enumerator = OrderEnumerator.orderEntries((Module)module).runtimeOnly().recursively();
        if (productionOnly) {
            enumerator = enumerator.productionOnly();
        }
        enumerator.forEachModule(module1 -> {
            Sdk sdk = ModuleRootManager.getInstance((Module)module1).getSdk();
            if (sdk != null && sdk.getSdkType().equals((Object)moduleSdk.getSdkType())) {
                sdksFromDependencies.add(sdk);
            }
            return true;
        });
        return sdksFromDependencies.stream().max(moduleSdk.getSdkType().versionComparator()).orElse(moduleSdk);
    }

    public void configureByProject(Project project, int classPathType, Sdk jdk) throws CantRunException {
        if ((classPathType & 1) != 0) {
            if (jdk == null) {
                throw CantRunException.noJdkConfigured();
            }
            this.setJdk(jdk);
        }
        if ((classPathType & 2) == 0) {
            return;
        }
        this.setDefaultCharset(project);
        JavaParameters.configureEnumerator(OrderEnumerator.orderEntries((Project)project).runtimeOnly(), classPathType, jdk).collectPaths(this.getClassPath());
        this.configureJavaLibraryPath(OrderEnumerator.orderEntries((Project)project));
        this.configureJavaEnablePreviewProperty(OrderEnumerator.orderEntries((Project)project), jdk);
    }

    private static OrderRootsEnumerator configureEnumerator(OrderEnumerator enumerator, int classPathType, Sdk jdk) {
        if ((classPathType & 8) == 0) {
            enumerator = enumerator.runtimeOnly();
        }
        if ((classPathType & 1) == 0) {
            enumerator = enumerator.withoutSdk();
        }
        if ((classPathType & 4) == 0) {
            enumerator = enumerator.productionOnly();
        }
        OrderRootsEnumerator rootsEnumerator = enumerator.classes();
        if ((classPathType & 1) != 0) {
            rootsEnumerator = rootsEnumerator.usingCustomSdkRootProvider(entry -> JavaParameters.jdkRoots(jdk));
        }
        return rootsEnumerator;
    }

    private static VirtualFile[] jdkRoots(Sdk jdk) {
        return (VirtualFile[])Arrays.stream(jdk.getRootProvider().getFiles(OrderRootType.CLASSES)).filter(f -> !JrtFileSystem.isModuleRoot((VirtualFile)f)).toArray(VirtualFile[]::new);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/configurations/JavaParameters", "getValidJdkToRunModule"));
    }
}

