/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.configurations;

import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.JavaExecutionUtil;
import com.intellij.execution.configurations.RunConfigurationModule;
import com.intellij.execution.configurations.RuntimeConfigurationError;
import com.intellij.execution.configurations.RuntimeConfigurationException;
import com.intellij.execution.configurations.RuntimeConfigurationWarning;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiNameHelper;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.ClassUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaRunConfigurationModule
extends RunConfigurationModule {
    private final boolean myClassesInLibraries;

    public JavaRunConfigurationModule(@NotNull Project project, boolean classesInLibs) {
        if (project == null) {
            JavaRunConfigurationModule.$$$reportNull$$$0(0);
        }
        super(project);
        this.myClassesInLibraries = classesInLibs;
    }

    @Nullable
    public PsiClass findClass(String qualifiedName) {
        GlobalSearchScope searchScope;
        if (qualifiedName == null) {
            return null;
        }
        Project project = this.getProject();
        PsiClass mainClass = JavaExecutionUtil.findMainClass(project, qualifiedName, searchScope = this.getSearchScope());
        if (mainClass == null && !PsiNameHelper.getInstance((Project)project).isQualifiedName(qualifiedName)) {
            return JavaRunConfigurationModule.findClass(StringUtil.getShortName((String)qualifiedName), StringUtil.getPackageName((String)qualifiedName), project, searchScope);
        }
        return mainClass;
    }

    private static PsiClass findClass(String shortName, String packageName, Project project, GlobalSearchScope searchScope) {
        PsiPackage aPackage = JavaPsiFacade.getInstance((Project)project).findPackage(packageName);
        if (aPackage != null) {
            int dollarIdx = shortName.indexOf("$");
            String topLevelClassName = dollarIdx > 0 && dollarIdx < shortName.length() - 1 ? shortName.substring(0, dollarIdx) : shortName;
            PsiClass topLevelClass = (PsiClass)ContainerUtil.find((Object[])aPackage.getClasses(searchScope), aClass -> topLevelClassName.equals(aClass.getName()));
            if (topLevelClass != null && !topLevelClassName.equals(shortName)) {
                String innerClassName = shortName.substring(dollarIdx + 1);
                return ClassUtil.findPsiClass((PsiManager)PsiManager.getInstance((Project)project), (String)innerClassName, (PsiClass)topLevelClass, (boolean)true);
            }
            return topLevelClass;
        }
        if (packageName.isEmpty()) {
            return null;
        }
        PsiClass topClass = JavaRunConfigurationModule.findClass(StringUtil.getShortName((String)packageName), StringUtil.getPackageName((String)packageName), project, searchScope);
        if (topClass != null) {
            return topClass.findInnerClassByName(shortName, true);
        }
        return null;
    }

    @NotNull
    public GlobalSearchScope getSearchScope() {
        Module module = this.getModule();
        if (module != null) {
            GlobalSearchScope globalSearchScope = this.myClassesInLibraries ? module.getModuleRuntimeScope(true) : GlobalSearchScope.moduleWithDependenciesScope((Module)module);
            if (globalSearchScope == null) {
                JavaRunConfigurationModule.$$$reportNull$$$0(1);
            }
            return globalSearchScope;
        }
        GlobalSearchScope globalSearchScope = this.myClassesInLibraries ? GlobalSearchScope.allScope((Project)this.getProject()) : GlobalSearchScope.projectScope((Project)this.getProject());
        if (globalSearchScope == null) {
            JavaRunConfigurationModule.$$$reportNull$$$0(2);
        }
        return globalSearchScope;
    }

    public static Collection<Module> getModulesForClass(@NotNull Project project, @Nullable String className) {
        if (project == null) {
            JavaRunConfigurationModule.$$$reportNull$$$0(3);
        }
        if (project.isDefault()) {
            return Arrays.asList(ModuleManager.getInstance((Project)project).getModules());
        }
        PsiDocumentManager.getInstance((Project)project).commitAllDocuments();
        PsiClass[] possibleClasses = className == null ? PsiClass.EMPTY_ARRAY : JavaPsiFacade.getInstance((Project)project).findClasses(className, GlobalSearchScope.projectScope((Project)project));
        HashSet<Module> modules = new HashSet<Module>();
        for (PsiClass aClass : possibleClasses) {
            Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)aClass);
            if (module == null) continue;
            modules.add(module);
        }
        if (modules.isEmpty()) {
            return Arrays.asList(ModuleManager.getInstance((Project)project).getModules());
        }
        HashSet<Module> result = new HashSet<Module>();
        for (Module module : modules) {
            ModuleUtilCore.collectModulesDependsOn((Module)module, result);
        }
        return result;
    }

    public PsiClass findNotNullClass(String className) throws RuntimeConfigurationWarning {
        PsiClass psiClass = this.findClass(className);
        if (psiClass == null) {
            throw new RuntimeConfigurationWarning(ExecutionBundle.message((String)"class.not.found.in.module.error.message", (Object[])new Object[]{className, this.getModuleName()})){

                public boolean shouldShowInDumbMode() {
                    return false;
                }
            };
        }
        return psiClass;
    }

    public PsiClass checkModuleAndClassName(String className, @NlsContexts.DialogMessage String expectedClassMessage) throws RuntimeConfigurationException {
        this.checkForWarning();
        return this.checkClassName(className, expectedClassMessage);
    }

    public PsiClass checkClassName(String className, @NlsContexts.DialogMessage String errorMessage) throws RuntimeConfigurationException {
        if (className == null || className.isEmpty()) {
            throw new RuntimeConfigurationError(errorMessage);
        }
        return this.findNotNullClass(className);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/execution/configurations/JavaRunConfigurationModule";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/execution/configurations/JavaRunConfigurationModule";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getSearchScope";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getModulesForClass";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2 -> new IllegalStateException(string);
        };
    }
}

