/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.filters;

import com.intellij.execution.filters.ExceptionInfo;
import com.intellij.execution.filters.ExceptionLineRefiner;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiArrayAccessExpression;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiKeyword;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiMethodReferenceExpression;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiPolyadicExpression;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiSwitchBlock;
import com.intellij.psi.PsiSynchronizedStatement;
import com.intellij.psi.PsiThrowStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypes;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.ObjectUtils;
import java.util.Map;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NullPointerExceptionInfo
extends ExceptionInfo {
    private static final Pattern NPE_MESSAGE = Pattern.compile("Cannot (?:invoke \"(?<invoke>.+)\\(.*\\)\"|assign field \"(?<putfield>.+)\"|read field \"(?<getfield>.+)\"|store to (?<xastore>[a-z]+) array|load from (?<xaload>[a-z]+) array|read the array (?<arraylength>length)|enter (?<monitor>synchronized) block|throw (?<athrow>exception))(?: because .+)?");
    private static final Map<String, PsiPrimitiveType> UNBOXING_METHODS = Map.of("booleanValue", PsiTypes.booleanType(), "byteValue", PsiTypes.byteType(), "charValue", PsiTypes.charType(), "shortValue", PsiTypes.shortType(), "intValue", PsiTypes.intType(), "longValue", PsiTypes.longType(), "floatValue", PsiTypes.floatType(), "doubleValue", PsiTypes.doubleType());
    @NotNull
    private final Function<PsiElement, ExceptionLineRefiner.RefinerMatchResult> myExtractor;

    NullPointerExceptionInfo(int offset, String message) {
        super(offset, "java.lang.NullPointerException", message);
        Function<PsiElement, ExceptionLineRefiner.RefinerMatchResult> jep358Predicate;
        this.myExtractor = message.isEmpty() ? NullPointerExceptionInfo.getFallbackExtractor() : ((jep358Predicate = NullPointerExceptionInfo.getJep358Extractor(message)) == null ? e -> null : jep358Predicate);
    }

    private static Function<PsiElement, ExceptionLineRefiner.RefinerMatchResult> getFallbackExtractor() {
        return e -> {
            PsiExpression qualifier;
            PsiReferenceExpression ref;
            PsiJavaToken token;
            PsiElement prevVisible;
            PsiJavaToken token2;
            PsiExpression arrayExpression;
            PsiArrayAccessExpression arrayAccess;
            PsiJavaToken token3;
            ExceptionLineRefiner.RefinerMatchResult matchResult = NullPointerExceptionInfo.fromThrow(e);
            if (matchResult != null) {
                return matchResult;
            }
            matchResult = NullPointerExceptionInfo.fromSynchronized(e);
            if (matchResult != null) {
                return matchResult;
            }
            matchResult = NullPointerExceptionInfo.matchCompilerGeneratedNullCheck(e);
            if (matchResult != null) {
                return matchResult;
            }
            matchResult = NullPointerExceptionInfo.fromUnboxing(e, null);
            if (matchResult != null) {
                return matchResult;
            }
            PsiElement nextVisible = PsiTreeUtil.nextVisibleLeaf((PsiElement)e);
            if (nextVisible instanceof PsiJavaToken && (token3 = (PsiJavaToken)nextVisible).getTokenType().equals(JavaTokenType.LBRACKET) && (arrayAccess = (PsiArrayAccessExpression)ObjectUtils.tryCast((Object)nextVisible.getParent(), PsiArrayAccessExpression.class)) != null && NullPointerExceptionInfo.mayBeNull(arrayExpression = arrayAccess.getArrayExpression())) {
                return NullPointerExceptionInfo.onTheSameLineFor(e, (PsiElement)arrayExpression, false);
            }
            Object next = null;
            if (nextVisible instanceof PsiJavaToken && (token2 = (PsiJavaToken)nextVisible).getTokenType().equals(JavaTokenType.DOT)) {
                next = token2;
            }
            if ((prevVisible = PsiTreeUtil.prevVisibleLeaf((PsiElement)e)) instanceof PsiJavaToken && (token = (PsiJavaToken)prevVisible).getTokenType().equals(JavaTokenType.DOT)) {
                next = next == null ? token : null;
            }
            if (next != null && (ref = (PsiReferenceExpression)ObjectUtils.tryCast((Object)next.getParent(), PsiReferenceExpression.class)) != null && NullPointerExceptionInfo.mayBeNull(qualifier = ref.getQualifierExpression())) {
                return NullPointerExceptionInfo.onTheSameLineFor(e, (PsiElement)qualifier, false);
            }
            return null;
        };
    }

    private static ExceptionLineRefiner.RefinerMatchResult fromThrow(PsiElement e) {
        PsiThrowStatement throwStatement;
        if (e instanceof PsiKeyword && ((PsiKeyword)e).getTokenType().equals(JavaTokenType.THROW_KEYWORD) && (throwStatement = (PsiThrowStatement)ObjectUtils.tryCast((Object)e.getParent(), PsiThrowStatement.class)) != null) {
            return NullPointerExceptionInfo.onTheSameLineFor(e, (PsiElement)throwStatement.getException(), true);
        }
        return null;
    }

    private static ExceptionLineRefiner.RefinerMatchResult fromUnboxing(PsiElement e, @Nullable PsiPrimitiveType type) {
        PsiType expressionType;
        PsiPrimitiveType unboxedType;
        PsiArrayAccessExpression arrayAccess;
        IElementType tokenType;
        PsiReferenceExpression ref;
        PsiReferenceExpression boxedExpression = null;
        if (e instanceof PsiIdentifier && (ref = (PsiReferenceExpression)ObjectUtils.tryCast((Object)e.getParent(), PsiReferenceExpression.class)) != null) {
            Object object = boxedExpression = ref.getParent() instanceof PsiMethodCallExpression ? (PsiMethodCallExpression)ref.getParent() : ref;
        }
        if (e instanceof PsiJavaToken && (tokenType = ((PsiJavaToken)e).getTokenType()).equals(JavaTokenType.RBRACKET) && (arrayAccess = (PsiArrayAccessExpression)ObjectUtils.tryCast((Object)e.getParent(), PsiArrayAccessExpression.class)) != null) {
            boxedExpression = arrayAccess;
        }
        if (boxedExpression != null && (unboxedType = PsiPrimitiveType.getUnboxedType((PsiType)(expressionType = boxedExpression.getType()))) != null && (type == null || unboxedType.equals((Object)type))) {
            return NullPointerExceptionInfo.onTheSameLineFor(e, (PsiElement)boxedExpression, false);
        }
        return null;
    }

    private static ExceptionLineRefiner.RefinerMatchResult fromSynchronized(PsiElement e) {
        PsiSynchronizedStatement synchronizedStatement;
        if (e instanceof PsiKeyword && ((PsiKeyword)e).getTokenType().equals(JavaTokenType.SYNCHRONIZED_KEYWORD) && (synchronizedStatement = (PsiSynchronizedStatement)ObjectUtils.tryCast((Object)e.getParent(), PsiSynchronizedStatement.class)) != null) {
            return NullPointerExceptionInfo.onTheSameLineFor(e, (PsiElement)synchronizedStatement.getLockExpression(), true);
        }
        return null;
    }

    private static Function<PsiElement, ExceptionLineRefiner.RefinerMatchResult> getJep358Extractor(@NonNls String message) {
        int dotPos;
        boolean arrayStore;
        String field;
        if (!message.startsWith("Cannot ")) {
            return null;
        }
        Matcher matcher = NPE_MESSAGE.matcher(message);
        if (!matcher.matches()) {
            return null;
        }
        if (matcher.group("athrow") != null) {
            return NullPointerExceptionInfo::fromThrow;
        }
        if (matcher.group("monitor") != null) {
            return NullPointerExceptionInfo::fromSynchronized;
        }
        if (matcher.group("arraylength") != null) {
            return e -> {
                PsiExpression qualifier = NullPointerExceptionInfo.getFieldReferenceQualifier(e, "length");
                return qualifier != null && qualifier.getType() instanceof PsiArrayType ? NullPointerExceptionInfo.onTheSameLineFor(e, (PsiElement)qualifier, false) : null;
            };
        }
        String getField = matcher.group("getfield");
        String putField = matcher.group("putfield");
        String string = field = getField == null ? putField : getField;
        if (field != null) {
            return e -> {
                PsiExpression qualifier = NullPointerExceptionInfo.getFieldReferenceQualifier(e, field);
                return qualifier != null && !(qualifier.getType() instanceof PsiArrayType) && NullPointerExceptionInfo.storeMatches(qualifier.getParent(), getField == null) ? NullPointerExceptionInfo.onTheSameLineFor(e, (PsiElement)qualifier, false) : null;
            };
        }
        boolean arrayLoad = matcher.group("xaload") != null;
        boolean bl = arrayStore = matcher.group("xastore") != null;
        if (arrayLoad || arrayStore) {
            return current -> {
                PsiElement e = PsiTreeUtil.nextVisibleLeaf((PsiElement)current);
                if (!(e instanceof PsiJavaToken) || !e.textMatches((CharSequence)"[")) {
                    return null;
                }
                PsiElement parent = e.getParent();
                if (!(parent instanceof PsiArrayAccessExpression)) {
                    return null;
                }
                return NullPointerExceptionInfo.storeMatches(parent, arrayStore) ? NullPointerExceptionInfo.onTheSameLineFor(current, (PsiElement)((PsiArrayAccessExpression)parent).getArrayExpression(), false) : null;
            };
        }
        String method = matcher.group("invoke");
        if (method != null && (dotPos = method.lastIndexOf(46)) != -1) {
            @NonNls String methodName = method.substring(dotPos + 1);
            PsiPrimitiveType type = UNBOXING_METHODS.get(methodName);
            return e -> {
                PsiJavaToken token;
                ExceptionLineRefiner.RefinerMatchResult result;
                if ((methodName.equals("getClass") || methodName.equals("ordinal")) && (result = NullPointerExceptionInfo.matchCompilerGeneratedNullCheck(e)) != null) {
                    return result;
                }
                if (type != null && (result = NullPointerExceptionInfo.fromUnboxing(e, type)) != null) {
                    return result;
                }
                PsiElement point = PsiTreeUtil.prevVisibleLeaf((PsiElement)e);
                if (!(point instanceof PsiJavaToken) || !(token = (PsiJavaToken)point).getTokenType().equals(JavaTokenType.DOT)) {
                    return null;
                }
                PsiElement parent = point.getParent();
                if (!(parent instanceof PsiReferenceExpression)) {
                    return null;
                }
                if (!(parent.getParent() instanceof PsiMethodCallExpression)) {
                    return null;
                }
                if (!methodName.equals(((PsiReferenceExpression)parent).getReferenceName())) {
                    return null;
                }
                PsiExpression qualifier = PsiUtil.skipParenthesizedExprDown((PsiExpression)((PsiReferenceExpression)parent).getQualifierExpression());
                return NullPointerExceptionInfo.mayBeNull(qualifier) ? NullPointerExceptionInfo.onTheSameLineFor(e, (PsiElement)qualifier, false) : null;
            };
        }
        return null;
    }

    @Nullable
    public static ExceptionLineRefiner.RefinerMatchResult matchCompilerGeneratedNullCheck(PsiElement e) {
        PsiNewExpression newExpression;
        PsiKeyword newKeyWord;
        PsiJavaToken dot;
        PsiElement switchBlock;
        PsiKeyword startSwitch;
        PsiElement methodRef;
        PsiJavaToken token;
        PsiExpression dereferenced = null;
        boolean forward = true;
        PsiElement psiElement = PsiTreeUtil.nextVisibleLeaf((PsiElement)e);
        if (psiElement instanceof PsiJavaToken && (token = (PsiJavaToken)psiElement).getTokenType().equals(JavaTokenType.DOUBLE_COLON)) {
            methodRef = (PsiMethodReferenceExpression)ObjectUtils.tryCast((Object)token.getParent(), PsiMethodReferenceExpression.class);
            if (methodRef != null) {
                dereferenced = methodRef.getQualifierExpression();
                forward = false;
            }
        } else if (e instanceof PsiJavaToken && e.textMatches((CharSequence)"(") && (methodRef = PsiTreeUtil.prevVisibleLeaf((PsiElement)e)) instanceof PsiKeyword && (startSwitch = (PsiKeyword)methodRef).textMatches((CharSequence)"switch")) {
            PsiType psiType;
            PsiExpression selector;
            switchBlock = (PsiSwitchBlock)ObjectUtils.tryCast((Object)startSwitch.getParent(), PsiSwitchBlock.class);
            if (switchBlock != null && (selector = switchBlock.getExpression()) != null && !((psiType = selector.getType()) instanceof PsiPrimitiveType) && PsiPrimitiveType.getUnboxedType((PsiType)psiType) == null) {
                dereferenced = selector;
            }
        } else if (e instanceof PsiIdentifier && (switchBlock = PsiTreeUtil.nextVisibleLeaf((PsiElement)e)) instanceof PsiJavaToken && (dot = (PsiJavaToken)switchBlock).getTokenType().equals(JavaTokenType.DOT) && (switchBlock = PsiTreeUtil.nextVisibleLeaf((PsiElement)dot)) instanceof PsiKeyword && (newKeyWord = (PsiKeyword)switchBlock).textMatches((CharSequence)"new") && (newExpression = (PsiNewExpression)ObjectUtils.tryCast((Object)newKeyWord.getParent(), PsiNewExpression.class)) != null) {
            dereferenced = newExpression.getQualifier();
        }
        return NullPointerExceptionInfo.mayBeNull(dereferenced) ? NullPointerExceptionInfo.onTheSameLineFor(e, dereferenced, forward) : null;
    }

    private static boolean mayBeNull(PsiExpression qualifier) {
        return qualifier != null && !(qualifier instanceof PsiNewExpression) && !(qualifier instanceof PsiLiteralExpression) && !(qualifier instanceof PsiPolyadicExpression);
    }

    @Nullable
    private static PsiExpression getFieldReferenceQualifier(PsiElement current, String fieldName) {
        PsiElement e = PsiTreeUtil.nextVisibleLeaf((PsiElement)current);
        if (!(e instanceof PsiJavaToken) || !((PsiJavaToken)e).getTokenType().equals(JavaTokenType.DOT)) {
            return null;
        }
        PsiElement parent = e.getParent();
        if (!(parent instanceof PsiReferenceExpression)) {
            return null;
        }
        if (parent.getParent() instanceof PsiMethodCallExpression) {
            return null;
        }
        PsiExpression qualifier = PsiUtil.skipParenthesizedExprDown((PsiExpression)((PsiReferenceExpression)parent).getQualifierExpression());
        if (!NullPointerExceptionInfo.mayBeNull(qualifier)) {
            return null;
        }
        if (!fieldName.equals(((PsiReferenceExpression)parent).getReferenceName())) {
            return null;
        }
        return qualifier;
    }

    private static boolean storeMatches(PsiElement element, boolean mustBeStore) {
        PsiElement parent = element.getParent();
        while (parent instanceof PsiParenthesizedExpression) {
            element = parent;
            parent = element.getParent();
        }
        if (parent instanceof PsiAssignmentExpression) {
            PsiAssignmentExpression assignment = (PsiAssignmentExpression)parent;
            boolean isStore = assignment.getOperationTokenType().equals(JavaTokenType.EQ) && assignment.getLExpression() == element;
            return isStore == mustBeStore;
        }
        return !mustBeStore;
    }

    @Override
    ExceptionLineRefiner.RefinerMatchResult matchSpecificExceptionElement(@NotNull PsiElement e) {
        if (e == null) {
            NullPointerExceptionInfo.$$$reportNull$$$0(0);
        }
        return this.myExtractor.apply(e);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/execution/filters/NullPointerExceptionInfo", "matchSpecificExceptionElement"));
    }
}

