/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.java.refactoring.suggested;

import com.intellij.java.refactoring.suggested.JavaSuggestedRefactoringAvailability;
import com.intellij.java.refactoring.suggested.JavaSuggestedRefactoringExecution;
import com.intellij.java.refactoring.suggested.JavaSuggestedRefactoringStateChanges;
import com.intellij.java.refactoring.suggested.JavaSuggestedRefactoringUI;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.psi.PsiCallExpression;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiNameIdentifierOwner;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.impl.source.tree.java.MethodElement;
import com.intellij.psi.util.PsiTreeUtilKt;
import com.intellij.refactoring.suggested.SuggestedRefactoringSupport;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\f\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0012\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u0007H\u0016J\u0012\u0010\u000b\u001a\u0004\u0018\u00010\t2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0012\u0010\u000e\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u0007H\u0016J\u0010\u0010\u000f\u001a\u00020\u00052\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0010\u0010\u0012\u001a\u00020\u00052\u0006\u0010\u0010\u001a\u00020\u0011H\u0016R\u0014\u0010\u0013\u001a\u00020\u0014X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0014\u0010\u0017\u001a\u00020\u0018X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u0014\u0010\u001b\u001a\u00020\u001c8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u001eR\u0014\u0010\u001f\u001a\u00020 X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\"\u00a8\u0006#"}, d2={"Lcom/intellij/java/refactoring/suggested/JavaSuggestedRefactoringSupport;", "Lcom/intellij/refactoring/suggested/SuggestedRefactoringSupport;", "<init>", "()V", "isAnchor", "", "psiElement", "Lcom/intellij/psi/PsiElement;", "signatureRange", "Lcom/intellij/openapi/util/TextRange;", "anchor", "importsRange", "psiFile", "Lcom/intellij/psi/PsiFile;", "nameRange", "isIdentifierStart", "c", "", "isIdentifierPart", "stateChanges", "Lcom/intellij/java/refactoring/suggested/JavaSuggestedRefactoringStateChanges;", "getStateChanges", "()Lcom/intellij/java/refactoring/suggested/JavaSuggestedRefactoringStateChanges;", "availability", "Lcom/intellij/java/refactoring/suggested/JavaSuggestedRefactoringAvailability;", "getAvailability", "()Lcom/intellij/java/refactoring/suggested/JavaSuggestedRefactoringAvailability;", "ui", "Lcom/intellij/java/refactoring/suggested/JavaSuggestedRefactoringUI;", "getUi", "()Lcom/intellij/java/refactoring/suggested/JavaSuggestedRefactoringUI;", "execution", "Lcom/intellij/java/refactoring/suggested/JavaSuggestedRefactoringExecution;", "getExecution", "()Lcom/intellij/java/refactoring/suggested/JavaSuggestedRefactoringExecution;", "intellij.java.impl.refactorings"})
public final class JavaSuggestedRefactoringSupport
implements SuggestedRefactoringSupport {
    @NotNull
    private final JavaSuggestedRefactoringStateChanges stateChanges = new JavaSuggestedRefactoringStateChanges(this);
    @NotNull
    private final JavaSuggestedRefactoringAvailability availability = new JavaSuggestedRefactoringAvailability(this);
    @NotNull
    private final JavaSuggestedRefactoringExecution execution = new JavaSuggestedRefactoringExecution(this);

    public boolean isAnchor(@NotNull PsiElement psiElement) {
        Intrinsics.checkNotNullParameter((Object)psiElement, (String)"psiElement");
        Project project = psiElement.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        if (DumbService.Companion.isDumb(project)) {
            return false;
        }
        if (psiElement instanceof PsiCallExpression && Registry.Companion.is("ide.java.refactoring.suggested.call.site")) {
            return ((PsiCallExpression)psiElement).getArgumentList() != null;
        }
        if (!(psiElement instanceof PsiNameIdentifierOwner)) {
            return false;
        }
        return !(psiElement instanceof PsiParameter) || !(((PsiParameter)psiElement).getParent() instanceof PsiParameterList) || !(((PsiParameter)psiElement).getParent().getParent() instanceof PsiMethod);
    }

    @Nullable
    public TextRange signatureRange(@NotNull PsiElement anchor) {
        TextRange textRange;
        Intrinsics.checkNotNullParameter((Object)anchor, (String)"anchor");
        if (anchor instanceof PsiCallExpression) {
            PsiExpressionList psiExpressionList = ((PsiCallExpression)anchor).getArgumentList();
            Intrinsics.checkNotNull((Object)psiExpressionList);
            return psiExpressionList.getTextRange();
        }
        PsiElement psiElement = ((PsiNameIdentifierOwner)anchor).getNameIdentifier();
        if (psiElement == null) {
            return null;
        }
        PsiElement nameIdentifier = psiElement;
        if ((PsiNameIdentifierOwner)anchor instanceof PsiMethod) {
            int n;
            ASTNode semicolon;
            PsiModifierList psiModifierList = ((PsiMethod)anchor).getModifierList();
            Intrinsics.checkNotNullExpressionValue((Object)psiModifierList, (String)"getModifierList(...)");
            int startOffset = PsiTreeUtilKt.getStartOffset((PsiElement)((PsiElement)psiModifierList));
            ASTNode aSTNode = ((PsiMethod)anchor).getNode();
            Intrinsics.checkNotNull((Object)aSTNode, (String)"null cannot be cast to non-null type com.intellij.psi.impl.source.tree.java.MethodElement");
            ASTNode aSTNode2 = semicolon = ((MethodElement)aSTNode).findChildByRole(22);
            if (aSTNode2 != null) {
                n = aSTNode2.getStartOffset();
            } else {
                PsiCodeBlock psiCodeBlock = ((PsiMethod)anchor).getBody();
                n = psiCodeBlock != null ? PsiTreeUtilKt.getStartOffset((PsiElement)((PsiElement)psiCodeBlock)) : PsiTreeUtilKt.getEndOffset((PsiElement)anchor);
            }
            int endOffset = n;
            textRange = new TextRange(startOffset, endOffset);
        } else {
            textRange = nameIdentifier.getTextRange();
        }
        return textRange;
    }

    @Nullable
    public TextRange importsRange(@NotNull PsiFile psiFile) {
        Intrinsics.checkNotNullParameter((Object)psiFile, (String)"psiFile");
        PsiJavaFile psiJavaFile = psiFile instanceof PsiJavaFile ? (PsiJavaFile)psiFile : null;
        Object object = psiJavaFile != null ? psiJavaFile.getImportList() : null;
        Intrinsics.checkNotNull((Object)object);
        return object.getTextRange();
    }

    @Nullable
    public TextRange nameRange(@NotNull PsiElement anchor) {
        Intrinsics.checkNotNullParameter((Object)anchor, (String)"anchor");
        PsiElement psiElement = anchor;
        PsiElement psiElement2 = psiElement instanceof PsiMethodCallExpression ? ((PsiMethodCallExpression)anchor).getMethodExpression().getReferenceNameElement() : (psiElement instanceof PsiNewExpression ? (PsiElement)((PsiNewExpression)anchor).getClassOrAnonymousClassReference() : (psiElement instanceof PsiNameIdentifierOwner ? ((PsiNameIdentifierOwner)anchor).getNameIdentifier() : null));
        return psiElement2 != null ? psiElement2.getTextRange() : null;
    }

    public boolean isIdentifierStart(char c) {
        return Character.isJavaIdentifierStart(c);
    }

    public boolean isIdentifierPart(char c) {
        return Character.isJavaIdentifierPart(c);
    }

    @NotNull
    public JavaSuggestedRefactoringStateChanges getStateChanges() {
        return this.stateChanges;
    }

    @NotNull
    public JavaSuggestedRefactoringAvailability getAvailability() {
        return this.availability;
    }

    @NotNull
    public JavaSuggestedRefactoringUI getUi() {
        return JavaSuggestedRefactoringUI.INSTANCE;
    }

    @NotNull
    public JavaSuggestedRefactoringExecution getExecution() {
        return this.execution;
    }
}

