/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.java.refactoring.suggested;

import com.intellij.codeInsight.generation.OverrideImplementsAnnotationsHandler;
import com.intellij.java.refactoring.suggested.JavaCallAdditionalData;
import com.intellij.java.refactoring.suggested.JavaParameterAdditionalData;
import com.intellij.java.refactoring.suggested.JavaSignatureAdditionalData;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiCallExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiJvmModifiersOwner;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiType;
import com.intellij.psi.formatter.java.JavaFormatterUtil;
import com.intellij.refactoring.suggested.SuggestedChangeSignatureData;
import com.intellij.refactoring.suggested.SuggestedRefactoringSupport;
import com.siyeh.ig.psiutils.TypeUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=2, xi=48, d1={"\u0000T\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u000e\u0010\u0005\u001a\u0004\u0018\u00010\u0001*\u00020\u0010H\u0000\u001a\f\u0010\u0011\u001a\u00020\u0001*\u00020\u0010H\u0000\u001a\f\u0010\u0012\u001a\u00020\u0013*\u00020\u0010H\u0000\u001a\f\u0010\u0014\u001a\u00020\u0001*\u00020\u0015H\u0000\u001a\u0012\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00010\n*\u00020\u0010H\u0000\u001a \u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00180\n*\u00020\u00192\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00180\nH\u0000\u001a&\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001c0\n2\u0006\u0010\u001d\u001a\u00020\u00182\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!H\u0000\"\u0018\u0010\u0000\u001a\u00020\u0001*\u00020\u00028@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\u0004\"\u001a\u0010\u0005\u001a\u0004\u0018\u00010\u0001*\u00020\u00068@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\b\"\u0018\u0010\u0000\u001a\u00020\u0001*\u00020\u00068@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\b\"\u001e\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00010\n*\u00020\u00068@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\f\" \u0010\r\u001a\n\u0012\u0004\u0012\u00020\u0001\u0018\u00010\n*\u00020\u00068@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\f\"\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00010\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"annotations", "", "Lcom/intellij/refactoring/suggested/SuggestedRefactoringSupport$Parameter;", "getAnnotations", "(Lcom/intellij/refactoring/suggested/SuggestedRefactoringSupport$Parameter;)Ljava/lang/String;", "visibility", "Lcom/intellij/refactoring/suggested/SuggestedRefactoringSupport$Signature;", "getVisibility", "(Lcom/intellij/refactoring/suggested/SuggestedRefactoringSupport$Signature;)Ljava/lang/String;", "exceptionTypes", "", "getExceptionTypes", "(Lcom/intellij/refactoring/suggested/SuggestedRefactoringSupport$Signature;)Ljava/util/List;", "origArguments", "getOrigArguments", "visibilityModifiers", "Lcom/intellij/psi/PsiMethod;", "explicitVisibility", "explicitAbstract", "", "extractAnnotations", "Lcom/intellij/psi/PsiJvmModifiersOwner;", "extractExceptions", "correctParameterTypes", "Lcom/intellij/psi/PsiType;", "Lcom/intellij/refactoring/suggested/SuggestedChangeSignatureData;", "origTypes", "extractAnnotationsToCopy", "Lcom/intellij/psi/PsiAnnotation;", "type", "owner", "Lcom/intellij/psi/PsiModifierListOwner;", "file", "Lcom/intellij/psi/PsiFile;", "intellij.java.impl.refactorings"})
@SourceDebugExtension(value={"SMAP\nJavaSuggestedRefactoringSupport.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JavaSuggestedRefactoringSupport.kt\ncom/intellij/java/refactoring/suggested/JavaSuggestedRefactoringSupportKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,185:1\n296#2,2:186\n296#2,2:188\n1596#2:194\n1629#2,4:195\n1391#2:199\n1480#2,5:200\n11705#3:190\n12052#3,3:191\n*S KotlinDebug\n*F\n+ 1 JavaSuggestedRefactoringSupport.kt\ncom/intellij/java/refactoring/suggested/JavaSuggestedRefactoringSupportKt\n*L\n125#1:186,2\n129#1:188,2\n154#1:194\n154#1:195,4\n172#1:199\n172#1:200,5\n146#1:190\n146#1:191,3\n*E\n"})
public final class JavaSuggestedRefactoringSupportKt {
    @NotNull
    private static final List<String> visibilityModifiers;

    @NotNull
    public static final String getAnnotations(@NotNull SuggestedRefactoringSupport.Parameter $this$annotations) {
        Intrinsics.checkNotNullParameter((Object)$this$annotations, (String)"<this>");
        Object object = (JavaParameterAdditionalData)$this$annotations.getAdditionalData();
        if (object == null || (object = ((JavaParameterAdditionalData)object).getAnnotations()) == null) {
            object = "";
        }
        return object;
    }

    @Nullable
    public static final String getVisibility(@NotNull SuggestedRefactoringSupport.Signature $this$visibility) {
        Intrinsics.checkNotNullParameter((Object)$this$visibility, (String)"<this>");
        SuggestedRefactoringSupport.SignatureAdditionalData signatureAdditionalData = $this$visibility.getAdditionalData();
        JavaSignatureAdditionalData javaSignatureAdditionalData = signatureAdditionalData instanceof JavaSignatureAdditionalData ? (JavaSignatureAdditionalData)signatureAdditionalData : null;
        return javaSignatureAdditionalData != null ? javaSignatureAdditionalData.getVisibility() : null;
    }

    @NotNull
    public static final String getAnnotations(@NotNull SuggestedRefactoringSupport.Signature $this$annotations) {
        Intrinsics.checkNotNullParameter((Object)$this$annotations, (String)"<this>");
        Object object = (JavaSignatureAdditionalData)$this$annotations.getAdditionalData();
        if (object == null || (object = object.getAnnotations()) == null) {
            object = "";
        }
        return object;
    }

    @NotNull
    public static final List<String> getExceptionTypes(@NotNull SuggestedRefactoringSupport.Signature $this$exceptionTypes) {
        Intrinsics.checkNotNullParameter((Object)$this$exceptionTypes, (String)"<this>");
        Object object = (JavaSignatureAdditionalData)$this$exceptionTypes.getAdditionalData();
        if (object == null || (object = object.getExceptionTypes()) == null) {
            object = CollectionsKt.emptyList();
        }
        return object;
    }

    @Nullable
    public static final List<String> getOrigArguments(@NotNull SuggestedRefactoringSupport.Signature $this$origArguments) {
        Intrinsics.checkNotNullParameter((Object)$this$origArguments, (String)"<this>");
        SuggestedRefactoringSupport.SignatureAdditionalData signatureAdditionalData = $this$origArguments.getAdditionalData();
        JavaCallAdditionalData javaCallAdditionalData = signatureAdditionalData instanceof JavaCallAdditionalData ? (JavaCallAdditionalData)signatureAdditionalData : null;
        return javaCallAdditionalData != null ? javaCallAdditionalData.getOrigArguments() : null;
    }

    @Nullable
    public static final String visibility(@NotNull PsiMethod $this$visibility) {
        Object v0;
        block1: {
            Intrinsics.checkNotNullParameter((Object)$this$visibility, (String)"<this>");
            Iterable $this$firstOrNull$iv = visibilityModifiers;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                String it = (String)element$iv;
                boolean bl = false;
                if (!$this$visibility.hasModifierProperty(it)) continue;
                v0 = element$iv;
                break block1;
            }
            v0 = null;
        }
        return v0;
    }

    @NotNull
    public static final String explicitVisibility(@NotNull PsiMethod $this$explicitVisibility) {
        String explicitModifier;
        Object v0;
        block3: {
            Intrinsics.checkNotNullParameter((Object)$this$explicitVisibility, (String)"<this>");
            Iterable $this$firstOrNull$iv = visibilityModifiers;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                String modifier = (String)element$iv;
                boolean bl = false;
                if (!$this$explicitVisibility.getModifierList().hasExplicitModifier(modifier)) continue;
                v0 = element$iv;
                break block3;
            }
            v0 = null;
        }
        String string = explicitModifier = (String)v0;
        if (string != null) {
            return string;
        }
        PsiElement psiElement = $this$explicitVisibility.getParent();
        PsiClass psiClass = psiElement instanceof PsiClass ? (PsiClass)psiElement : null;
        boolean bl = psiClass != null ? psiClass.isInterface() : false;
        if (bl) {
            return "public";
        }
        return "packageLocal";
    }

    public static final boolean explicitAbstract(@NotNull PsiMethod $this$explicitAbstract) {
        Intrinsics.checkNotNullParameter((Object)$this$explicitAbstract, (String)"<this>");
        return JavaFormatterUtil.isExplicitlyAbstract((PsiMethod)$this$explicitAbstract);
    }

    @NotNull
    public static final String extractAnnotations(@NotNull PsiJvmModifiersOwner $this$extractAnnotations) {
        Intrinsics.checkNotNullParameter((Object)$this$extractAnnotations, (String)"<this>");
        PsiAnnotation[] psiAnnotationArray = $this$extractAnnotations.getAnnotations();
        Intrinsics.checkNotNullExpressionValue((Object)psiAnnotationArray, (String)"getAnnotations(...)");
        return ArraysKt.joinToString$default((Object[])psiAnnotationArray, (CharSequence)" ", null, null, (int)0, null, JavaSuggestedRefactoringSupportKt::extractAnnotations$lambda$0, (int)30, null);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<String> extractExceptions(@NotNull PsiMethod $this$extractExceptions) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)$this$extractExceptions, (String)"<this>");
        PsiJavaCodeReferenceElement[] psiJavaCodeReferenceElementArray = $this$extractExceptions.getThrowsList().getReferenceElements();
        Intrinsics.checkNotNullExpressionValue((Object)psiJavaCodeReferenceElementArray, (String)"getReferenceElements(...)");
        Object[] $this$map$iv = psiJavaCodeReferenceElementArray;
        boolean $i$f$map = false;
        Object[] objectArray = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.length);
        boolean $i$f$mapTo = false;
        for (void item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            PsiJavaCodeReferenceElement psiJavaCodeReferenceElement = (PsiJavaCodeReferenceElement)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getText());
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<PsiType> correctParameterTypes(@NotNull SuggestedChangeSignatureData $this$correctParameterTypes, @NotNull List<? extends PsiType> origTypes) {
        List list;
        Intrinsics.checkNotNullParameter((Object)$this$correctParameterTypes, (String)"<this>");
        Intrinsics.checkNotNullParameter(origTypes, (String)"origTypes");
        PsiElement anchor = $this$correctParameterTypes.getAnchor();
        if (anchor instanceof PsiCallExpression) {
            void $this$mapIndexedTo$iv$iv;
            PsiExpressionList psiExpressionList = ((PsiCallExpression)anchor).getArgumentList();
            Intrinsics.checkNotNull((Object)psiExpressionList);
            PsiExpression[] psiExpressionArray = psiExpressionList.getExpressions();
            Intrinsics.checkNotNullExpressionValue((Object)psiExpressionArray, (String)"getExpressions(...)");
            PsiExpression[] expressions = psiExpressionArray;
            Iterable $this$mapIndexed$iv = $this$correctParameterTypes.getNewSignature().getParameters();
            boolean $i$f$mapIndexed = false;
            Iterable iterable = $this$mapIndexed$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$mapIndexed$iv, (int)10));
            boolean $i$f$mapIndexedTo = false;
            int index$iv$iv = 0;
            for (Object item$iv$iv : $this$mapIndexedTo$iv$iv) {
                PsiType psiType;
                void param;
                int n;
                if ((n = index$iv$iv++) < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                SuggestedRefactoringSupport.Parameter parameter = (SuggestedRefactoringSupport.Parameter)item$iv$iv;
                int n2 = n;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                SuggestedRefactoringSupport.Parameter oldParam = $this$correctParameterTypes.getOldSignature().parameterById(param.getId());
                if (oldParam != null) {
                    psiType = (PsiType)origTypes.get($this$correctParameterTypes.getOldSignature().parameterIndex(oldParam));
                } else {
                    void idx;
                    psiType = expressions[idx].getType();
                    if (psiType == null) {
                        psiType = (PsiType)TypeUtils.getObjectType((PsiElement)$this$correctParameterTypes.getDeclaration());
                    }
                }
                collection.add(psiType);
            }
            list = (List)destination$iv$iv;
        } else {
            list = origTypes;
        }
        return list;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<PsiAnnotation> extractAnnotationsToCopy(@NotNull PsiType type, @NotNull PsiModifierListOwner owner, @NotNull PsiFile file) {
        void $this$flatMapTo$iv$iv;
        void $this$flatMap$iv;
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        Intrinsics.checkNotNullParameter((Object)owner, (String)"owner");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        PsiModifierList psiModifierList = owner.getModifierList();
        if (psiModifierList == null) {
            return CollectionsKt.emptyList();
        }
        PsiAnnotation[] psiAnnotationArray = psiModifierList.getApplicableAnnotations();
        Intrinsics.checkNotNullExpressionValue((Object)psiAnnotationArray, (String)"getApplicableAnnotations(...)");
        PsiAnnotation[] applicableAnnotations = psiAnnotationArray;
        if (applicableAnnotations.length == 0) {
            PsiAnnotation[] psiAnnotationArray2 = type.getAnnotations();
            Intrinsics.checkNotNullExpressionValue((Object)psiAnnotationArray2, (String)"getAnnotations(...)");
            return ArraysKt.asList((Object[])psiAnnotationArray2);
        }
        Iterable iterable = OverrideImplementsAnnotationsHandler.EP_NAME.getExtensionList();
        boolean $i$f$flatMap = false;
        void var7_7 = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            OverrideImplementsAnnotationsHandler it = (OverrideImplementsAnnotationsHandler)element$iv$iv;
            boolean bl = false;
            String[] stringArray = it.getAnnotations(file);
            Intrinsics.checkNotNullExpressionValue((Object)stringArray, (String)"getAnnotations(...)");
            Iterable list$iv$iv = ArraysKt.asList((Object[])stringArray);
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        Set annotationNamesToCopy = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
        Iterable $this$extractAnnotationsToCopy_u24lambda_u241 = iterable = (List)new ArrayList();
        boolean bl = false;
        for (PsiAnnotation annotation : applicableAnnotations) {
            String qualifiedName;
            if (annotation.getQualifiedName() == null || !annotationNamesToCopy.contains(qualifiedName) || type.hasAnnotation(qualifiedName)) continue;
            Intrinsics.checkNotNull((Object)annotation);
            $this$extractAnnotationsToCopy_u24lambda_u241.add(annotation);
        }
        Collection collection = (Collection)$this$extractAnnotationsToCopy_u24lambda_u241;
        PsiAnnotation[] psiAnnotationArray3 = type.getAnnotations();
        Intrinsics.checkNotNullExpressionValue((Object)psiAnnotationArray3, (String)"getAnnotations(...)");
        CollectionsKt.addAll((Collection)collection, (Object[])psiAnnotationArray3);
        return iterable;
    }

    private static final CharSequence extractAnnotations$lambda$0(PsiAnnotation it) {
        String string = it.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        return string;
    }

    static {
        Object[] objectArray = new String[]{"public", "protected", "packageLocal", "private"};
        visibilityModifiers = CollectionsKt.listOf((Object[])objectArray);
    }
}

