/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.anonymousToInner;

import com.intellij.java.refactoring.JavaRefactoringBundle;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiNameHelper;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.codeStyle.VariableKind;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.refactoring.anonymousToInner.AnonymousToInnerHandler;
import com.intellij.refactoring.anonymousToInner.VariableInfo;
import com.intellij.refactoring.ui.NameSuggestionsField;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.refactoring.util.ParameterTablePanel;
import com.intellij.refactoring.util.RefactoringMessageUtil;
import com.intellij.refactoring.util.VariableData;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.NonFocusableCheckBox;
import com.intellij.util.ui.FormBuilder;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.border.Border;
import org.jetbrains.annotations.Nullable;

class AnonymousToInnerDialog
extends DialogWrapper {
    private static final Logger LOG = Logger.getInstance(AnonymousToInnerDialog.class);
    private final Project myProject;
    private final PsiClass myAnonOrLocalClass;
    private final boolean myShowCanBeStatic;
    private NameSuggestionsField myNameField;
    private final VariableData[] myVariableData;
    private final Map<PsiVariable, VariableInfo> myVariableToInfoMap = new HashMap<PsiVariable, VariableInfo>();
    private JCheckBox myCbMakeStatic;

    AnonymousToInnerDialog(Project project, PsiClass anonOrLocalClass, VariableInfo[] variableInfos, boolean showCanBeStatic) {
        super(project, true);
        if (!(anonOrLocalClass instanceof PsiAnonymousClass) && !PsiUtil.isLocalClass((PsiClass)anonOrLocalClass)) {
            throw new IllegalArgumentException();
        }
        this.myProject = project;
        this.myAnonOrLocalClass = anonOrLocalClass;
        this.myShowCanBeStatic = showCanBeStatic;
        this.setTitle(anonOrLocalClass instanceof PsiAnonymousClass ? JavaRefactoringBundle.message((String)"anonymousToInner.refactoring.name", (Object[])new Object[0]) : JavaRefactoringBundle.message((String)"localToInner.refactoring.name", (Object[])new Object[0]));
        for (VariableInfo info : variableInfos) {
            this.myVariableToInfoMap.put(info.variable, info);
        }
        this.myVariableData = new VariableData[variableInfos.length];
        AnonymousToInnerDialog.fillVariableData(this.myProject, variableInfos, this.myVariableData);
        this.init();
        String[] names = AnonymousToInnerDialog.suggestNewClassNames(this.myAnonOrLocalClass);
        this.myNameField.setSuggestions(names);
        this.myNameField.selectNameWithoutExtension();
    }

    public static String[] suggestNewClassNames(PsiClass anonOrLocalClass) {
        String[] stringArray;
        String className = anonOrLocalClass.getName();
        if (className != null) {
            return new String[]{className};
        }
        if (!(anonOrLocalClass instanceof PsiAnonymousClass)) {
            return new String[]{"MyClass"};
        }
        PsiAnonymousClass anonymousClass = (PsiAnonymousClass)anonOrLocalClass;
        String name = anonymousClass.getBaseClassReference().getReferenceName();
        Object[] typeParameters = anonymousClass.getBaseClassReference().getTypeParameters();
        String typeParamsList = StringUtil.join((Object[])typeParameters, psiType -> {
            PsiType type = psiType;
            if (psiType instanceof PsiClassType) {
                type = TypeConversionUtil.erasure((PsiType)psiType);
            }
            if (type == null || type.equalsToText("java.lang.Object")) {
                return "";
            }
            if (type instanceof PsiArrayType) {
                type = type.getDeepComponentType();
            }
            return StringUtil.getShortName((String)type.getPresentableText());
        }, (String)"") + name;
        if (!typeParamsList.equals(name)) {
            String[] stringArray2 = new String[2];
            stringArray2[0] = typeParamsList;
            stringArray = stringArray2;
            stringArray2[1] = "My" + name;
        } else {
            String[] stringArray3 = new String[1];
            stringArray = stringArray3;
            stringArray3[0] = "My" + name;
        }
        return stringArray;
    }

    public static void fillVariableData(Project project, VariableInfo[] variableInfos, VariableData[] variableData) {
        JavaCodeStyleManager codeStyleManager = JavaCodeStyleManager.getInstance((Project)project);
        for (int idx = 0; idx < variableInfos.length; ++idx) {
            VariableInfo info = variableInfos[idx];
            String name = info.variable.getName();
            VariableKind kind = codeStyleManager.getVariableKind(info.variable);
            name = codeStyleManager.variableNameToPropertyName(name, kind);
            name = codeStyleManager.propertyNameToVariableName(name, VariableKind.PARAMETER);
            VariableData data = new VariableData(info.variable);
            data.name = name;
            data.passAsParameter = true;
            variableData[idx] = data;
        }
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myNameField.getFocusableComponent();
    }

    public boolean isMakeStatic() {
        return this.myCbMakeStatic.isSelected();
    }

    public String getClassName() {
        return this.myNameField.getEnteredName();
    }

    public VariableInfo[] getVariableInfos() {
        return AnonymousToInnerDialog.getVariableInfos(this.myProject, this.myVariableData, this.myVariableToInfoMap);
    }

    public static VariableInfo[] getVariableInfos(Project myProject, VariableData[] myVariableData, Map<PsiVariable, VariableInfo> myVariableToInfoMap) {
        JavaCodeStyleManager codeStyleManager = JavaCodeStyleManager.getInstance((Project)myProject);
        VariableInfo[] infos = new VariableInfo[myVariableData.length];
        for (int idx = 0; idx < myVariableData.length; ++idx) {
            VariableData data = myVariableData[idx];
            VariableInfo info = myVariableToInfoMap.get(data.variable);
            info.passAsParameter = data.passAsParameter;
            info.parameterName = data.name;
            String propertyName = codeStyleManager.variableNameToPropertyName(data.name, VariableKind.PARAMETER);
            info.fieldName = codeStyleManager.propertyNameToVariableName(propertyName, VariableKind.FIELD);
            infos[idx] = info;
        }
        return infos;
    }

    protected void doOKAction() {
        String errorString = null;
        String innerClassName = this.getClassName();
        PsiManager manager = PsiManager.getInstance((Project)this.myProject);
        if ("".equals(innerClassName)) {
            errorString = JavaRefactoringBundle.message((String)"anonymousToInner.no.inner.class.name", (Object[])new Object[0]);
        } else if (!PsiNameHelper.getInstance((Project)manager.getProject()).isIdentifier(innerClassName)) {
            errorString = RefactoringMessageUtil.getIncorrectIdentifierMessage((String)innerClassName);
        } else {
            PsiElement targetContainer = AnonymousToInnerHandler.findTargetContainer(this.myAnonOrLocalClass);
            if (targetContainer instanceof PsiClass) {
                PsiClass[] innerClasses;
                PsiClass targetClass = (PsiClass)targetContainer;
                for (PsiClass innerClass : innerClasses = targetClass.getInnerClasses()) {
                    if (!innerClassName.equals(innerClass.getName())) continue;
                    errorString = JavaRefactoringBundle.message((String)"inner.class.exists", (Object[])new Object[]{innerClassName, targetClass.getName()});
                    break;
                }
            } else {
                LOG.assertTrue(false);
            }
        }
        if (errorString != null) {
            CommonRefactoringUtil.showErrorMessage((String)JavaRefactoringBundle.message((String)"anonymousToInner.refactoring.name", (Object[])new Object[0]), (String)errorString, (String)"refactoring.convertAnonymous", (Project)this.myProject);
            this.myNameField.requestFocusInWindow();
            return;
        }
        super.doOKAction();
        this.myNameField.requestFocusInWindow();
    }

    protected JComponent createNorthPanel() {
        this.myNameField = new NameSuggestionsField(this.myProject);
        FormBuilder formBuilder = FormBuilder.createFormBuilder().addLabeledComponent(JavaRefactoringBundle.message((String)"anonymousToInner.class.name.label.text", (Object[])new Object[0]), (JComponent)this.myNameField);
        if (this.myShowCanBeStatic) {
            this.myCbMakeStatic = new NonFocusableCheckBox(JavaRefactoringBundle.message((String)"anonymousToInner.make.class.static.checkbox.text", (Object[])new Object[0]));
            this.myCbMakeStatic.setSelected(true);
            formBuilder.addComponent((JComponent)this.myCbMakeStatic);
        }
        return formBuilder.getPanel();
    }

    private JComponent createParametersPanel() {
        ParameterTablePanel panel = new ParameterTablePanel(this.myProject, this.myVariableData, new PsiElement[]{this.myAnonOrLocalClass}){

            protected void updateSignature() {
            }

            protected void doEnterAction() {
                AnonymousToInnerDialog.this.clickDefaultButton();
            }

            protected void doCancelAction() {
                AnonymousToInnerDialog.this.doCancelAction();
            }
        };
        ((JComponent)((Object)panel)).setBorder((Border)IdeBorderFactory.createTitledBorder((String)JavaRefactoringBundle.message((String)"anonymousToInner.parameters.panel.border.title", (Object[])new Object[0]), (boolean)false));
        return panel;
    }

    protected JComponent createCenterPanel() {
        JPanel panel = new JPanel(new BorderLayout());
        panel.add((Component)this.createParametersPanel(), "Center");
        return panel;
    }

    protected String getHelpId() {
        return "refactoring.convertAnonymous";
    }

    @Nullable
    protected String getDimensionServiceKey() {
        return "anonymous.to.inner.dialog";
    }
}

