/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.changeSignature;

import com.intellij.codeInsight.daemon.impl.quickfix.CreateFromUsageBaseFix;
import com.intellij.codeInsight.template.Expression;
import com.intellij.codeInsight.template.Template;
import com.intellij.codeInsight.template.TemplateBuilderImpl;
import com.intellij.codeInsight.template.impl.TextExpression;
import com.intellij.java.JavaBundle;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.LambdaUtil;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiModifier;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiType;
import com.intellij.refactoring.BaseRefactoringProcessor;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.changeSignature.ChangeSignatureProcessor;
import com.intellij.refactoring.changeSignature.JavaChangeInfo;
import com.intellij.refactoring.changeSignature.JavaChangeInfoImpl;
import com.intellij.refactoring.changeSignature.JavaChangeSignatureDetector;
import com.intellij.refactoring.changeSignature.JavaChangeSignatureDialog;
import com.intellij.refactoring.changeSignature.JavaChangeSignatureUsageProcessor;
import com.intellij.refactoring.changeSignature.JavaMethodDescriptor;
import com.intellij.refactoring.changeSignature.JavaParameterInfo;
import com.intellij.refactoring.changeSignature.ParameterInfo;
import com.intellij.refactoring.changeSignature.ParameterInfoImpl;
import com.intellij.refactoring.changeSignature.ThrownExceptionInfo;
import com.intellij.refactoring.changeSignature.inplace.InplaceChangeSignature;
import com.intellij.refactoring.util.CanonicalTypes;
import com.intellij.usageView.UsageInfo;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.VisibilityUtil;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class DetectedJavaChangeInfo
extends JavaChangeInfoImpl {
    private PsiMethod mySuperMethod;
    private final String[] myModifiers;

    DetectedJavaChangeInfo(@PsiModifier.ModifierConstant @NotNull String newVisibility, PsiMethod method, CanonicalTypes.Type newType, ParameterInfoImpl @NotNull [] newParms, ThrownExceptionInfo[] newExceptions, String newName, @NotNull String oldName, boolean delegate) {
        if (newVisibility == null) {
            DetectedJavaChangeInfo.$$$reportNull$$$0(0);
        }
        if (oldName == null) {
            DetectedJavaChangeInfo.$$$reportNull$$$0(1);
        }
        if (newParms == null) {
            DetectedJavaChangeInfo.$$$reportNull$$$0(2);
        }
        super(newVisibility, method, newName, newType, newParms, newExceptions, delegate, new HashSet(), new HashSet(), oldName);
        PsiParameter[] parameters = method.getParameterList().getParameters();
        this.myModifiers = new String[parameters.length];
        for (int i = 0; i < parameters.length; ++i) {
            String text;
            PsiParameter parameter = parameters[i];
            PsiModifierList modifierList = parameter.getModifierList();
            if (modifierList == null) continue;
            this.myModifiers[i] = text = modifierList.getText();
        }
    }

    @Nullable
    static DetectedJavaChangeInfo createFromMethod(PsiMethod method, boolean delegate) {
        ParameterInfoImpl[] parameterInfos;
        String newVisibility = VisibilityUtil.getVisibilityModifier((PsiModifierList)method.getModifierList());
        PsiType returnType = method.getReturnType();
        CanonicalTypes.Type newReturnType = returnType != null ? CanonicalTypes.createTypeWrapper((PsiType)returnType) : null;
        for (ParameterInfoImpl parameterInfo : parameterInfos = ParameterInfoImpl.fromMethod((PsiMethod)method)) {
            if (parameterInfo.getTypeWrapper().isValid()) continue;
            return null;
        }
        DetectedJavaChangeInfo fromMethod = new DetectedJavaChangeInfo(newVisibility, method, newReturnType, parameterInfos, null, method.getName(), method.getName(), delegate);
        PsiMethod deepestSuperMethod = method.findDeepestSuperMethod();
        if (deepestSuperMethod != null && !deepestSuperMethod.getManager().isInProject((PsiElement)deepestSuperMethod)) {
            return null;
        }
        fromMethod.setSuperMethod(deepestSuperMethod);
        return fromMethod;
    }

    protected void setupPropagationEnabled(PsiParameter[] parameters, ParameterInfoImpl[] newParams) {
        this.isPropagationEnabled = false;
    }

    public PsiMethod getSuperMethod() {
        if (this.mySuperMethod == null) {
            return this.getMethod();
        }
        return this.mySuperMethod;
    }

    public void setSuperMethod(PsiMethod superMethod) {
        this.mySuperMethod = superMethod;
    }

    public String[] getModifiers() {
        return this.myModifiers;
    }

    protected boolean checkMethodEquality() {
        return false;
    }

    @Nullable
    DetectedJavaChangeInfo createNextInfo(PsiMethod method, boolean delegate) {
        DetectedJavaChangeInfo fromMethod = DetectedJavaChangeInfo.createFromMethod(method, delegate);
        if (fromMethod == null) {
            return null;
        }
        if (!this.equals((Object)fromMethod)) {
            String visibility;
            if (!this.createParametersInfo(fromMethod.newParms)) {
                return null;
            }
            if (!(!(fromMethod.newReturnType != null && this.getNewReturnType() == null || fromMethod.newReturnType == null && this.getNewReturnType() != null) && (fromMethod.newReturnType == null || this.getNewReturnType() == null || Comparing.strEqual((String)this.getNewReturnType().getTypeText(), (String)fromMethod.newReturnType.getTypeText())) || !Comparing.strEqual((String)(visibility = this.getNewVisibility()), (String)"private") || this.isArrayToVarargs() || this.isExceptionSetOrOrderChanged() || this.isExceptionSetChanged() || this.isNameChanged() || this.isParameterSetOrOrderChanged() || this.isParameterNamesChanged() || this.isParameterTypesChanged())) {
                return null;
            }
            try {
                DetectedJavaChangeInfo javaChangeInfo = new DetectedJavaChangeInfo(fromMethod.getNewVisibility(), this.getMethod(), fromMethod.newReturnType, fromMethod.newParms, this.getNewExceptions(), method.getName(), this.getOldName(), delegate){

                    protected void fillOldParams(PsiMethod method) {
                        this.oldParameterNames = DetectedJavaChangeInfo.this.getOldParameterNames();
                        this.oldParameterTypes = DetectedJavaChangeInfo.this.getOldParameterTypes();
                        if (!method.isConstructor()) {
                            try {
                                this.isReturnTypeChanged = this.isReturnTypeChanged || (DetectedJavaChangeInfo.this.getNewReturnType() != null ? !Comparing.strEqual((String)DetectedJavaChangeInfo.this.getNewReturnType().getTypeText(), (String)this.newReturnType.getTypeText()) : this.newReturnType != null);
                            }
                            catch (IncorrectOperationException e) {
                                this.isReturnTypeChanged = true;
                            }
                        }
                        int length = Math.min(this.newParms.length, this.oldParameterNames.length);
                        for (int i = 0; i < length; ++i) {
                            ParameterInfoImpl parm = this.newParms[i];
                            if (!parm.getName().equals(this.oldParameterNames[i]) || !parm.getTypeText().equals(this.oldParameterTypes[i])) continue;
                            parm.oldParameterIndex = i;
                        }
                    }
                };
                javaChangeInfo.setSuperMethod(this.getSuperMethod());
                return javaChangeInfo;
            }
            catch (IncorrectOperationException e) {
                return null;
            }
        }
        return this;
    }

    ChangeSignatureProcessor createChangeSignatureProcessor(final PsiMethod method) {
        return new ChangeSignatureProcessor(method.getProject(), (JavaChangeInfo)new DetectedJavaChangeInfo(this.getNewVisibility(), this.getSuperMethod(), this.getNewReturnType(), (ParameterInfoImpl[])this.getNewParameters(), this.getNewExceptions(), this.getNewName(), method.getName(), this.isGenerateDelegate()){

            protected void fillOldParams(PsiMethod method) {
                super.fillOldParams(method);
                this.oldParameterNames = DetectedJavaChangeInfo.this.getOldParameterNames();
                this.oldParameterTypes = DetectedJavaChangeInfo.this.getOldParameterTypes();
            }
        }){

            protected void performRefactoring(UsageInfo @NotNull [] usages) {
                if (usages == null) {
                    3.$$$reportNull$$$0(0);
                }
                super.performRefactoring(usages);
                PsiElementFactory elementFactory = JavaPsiFacade.getElementFactory((Project)method.getProject());
                PsiParameter[] parameters = method.getParameterList().getParameters();
                for (int i = 0; i < DetectedJavaChangeInfo.this.getModifiers().length; ++i) {
                    PsiModifierList newModifierList;
                    String modifier = DetectedJavaChangeInfo.this.getModifiers()[i];
                    PsiModifierList modifierList = parameters[i].getModifierList();
                    if (modifierList == null || Comparing.strEqual((String)modifier, (String)modifierList.getText()) || (newModifierList = elementFactory.createParameterFromText((String)(modifier.isEmpty() ? "" : modifier + " ") + "type name", (PsiElement)method).getModifierList()) == null) continue;
                    modifierList.replace((PsiElement)newModifierList);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "usages", "com/intellij/refactoring/changeSignature/DetectedJavaChangeInfo$3", "performRefactoring"));
            }
        };
    }

    private boolean createParametersInfo(ParameterInfoImpl[] parameterInfos) {
        JavaParameterInfo oldParameter;
        ParameterInfoImpl parameterInfo;
        int i;
        JavaParameterInfo[] oldParameters = this.getNewParameters();
        String[] oldParameterNames = this.getOldParameterNames();
        String[] oldParameterTypes = this.getOldParameterTypes();
        HashMap<ParameterInfoImpl, Integer> untouchedParams = new HashMap<ParameterInfoImpl, Integer>();
        for (i = 0; i < parameterInfos.length; ++i) {
            parameterInfo = parameterInfos[i];
            oldParameter = null;
            for (JavaParameterInfo parameter : oldParameters) {
                if (!Comparing.strEqual((String)parameter.getName(), (String)parameterInfo.getName()) || !Comparing.strEqual((String)parameter.getTypeText(), (String)parameterInfo.getTypeText())) continue;
                oldParameter = parameter;
                break;
            }
            if (oldParameter == null) continue;
            parameterInfos[i] = ParameterInfoImpl.create((int)oldParameter.getOldIndex()).withName(oldParameter.getName()).withType(oldParameter.getTypeWrapper()).withDefaultValue(null);
            untouchedParams.put(parameterInfos[i], oldParameter.getOldIndex());
        }
        for (i = 0; i < parameterInfos.length; ++i) {
            CanonicalTypes.Type typeWrapper;
            parameterInfo = parameterInfos[i];
            if (untouchedParams.containsKey(parameterInfo)) continue;
            oldParameter = null;
            if (oldParameters.length > i && oldParameterNames.length > i && (Comparing.strEqual((String)oldParameterNames[i], (String)parameterInfo.getName()) || Comparing.strEqual((String)oldParameterTypes[i], (String)parameterInfo.getTypeText())) && !untouchedParams.containsValue(oldParameters[i].getOldIndex())) {
                oldParameter = oldParameters[i];
            }
            if (!(typeWrapper = parameterInfo.getTypeWrapper()).isValid()) {
                return false;
            }
            parameterInfos[i] = ParameterInfoImpl.create((int)(oldParameter != null ? oldParameter.getOldIndex() : -1)).withName(parameterInfo.getName()).withType(typeWrapper).withDefaultValue(null);
        }
        return true;
    }

    void perform(final String oldText, Editor editor, boolean silently) {
        final PsiMethod method = this.getSuperMethod();
        final Project project = this.getMethod().getProject();
        final PsiMethod currentMethod = this.getMethod();
        TextRange signatureRange = JavaChangeSignatureDetector.getSignatureRange(currentMethod);
        PsiDocumentManager documentManager = PsiDocumentManager.getInstance((Project)project);
        final Document document = documentManager.getDocument(currentMethod.getContainingFile());
        if (silently || ApplicationManager.getApplication().isUnitTestMode()) {
            PsiMethod prototype;
            String currentSignature = signatureRange.substring(currentMethod.getContainingFile().getText());
            InplaceChangeSignature.temporallyRevertChanges((TextRange)JavaChangeSignatureDetector.getSignatureRange(currentMethod), (Document)document, (String)oldText, (Project)project);
            if (this.isGenerateDelegate()) {
                for (JavaParameterInfo info : this.getNewParameters()) {
                    if (!info.isNew()) continue;
                    ((ParameterInfoImpl)info).setDefaultValue("null");
                }
                prototype = JavaChangeSignatureUsageProcessor.generateDelegatePrototype((JavaChangeInfo)this);
            } else {
                prototype = null;
            }
            this.createChangeSignatureProcessor(method).run();
            InplaceChangeSignature.temporallyRevertChanges((TextRange)JavaChangeSignatureDetector.getSignatureRange(currentMethod), (Document)document, (String)currentSignature, (Project)project);
            if (prototype != null) {
                WriteCommandAction.runWriteCommandAction((Project)project, (String)JavaBundle.message((String)"command.name.delegate.detected.change", (Object[])new Object[0]), null, () -> {
                    PsiExpression expression;
                    PsiMethod delegate = currentMethod.getContainingClass().findMethodBySignature(prototype, false);
                    PsiExpression psiExpression = expression = delegate != null ? LambdaUtil.extractSingleExpressionFromBody((PsiElement)delegate.getBody()) : null;
                    if (expression instanceof PsiMethodCallExpression) {
                        PsiExpression[] expressions = ((PsiMethodCallExpression)expression).getArgumentList().getExpressions();
                        JavaParameterInfo[] parameters = this.getNewParameters();
                        PsiExpression[] toBeDefault = (PsiExpression[])Arrays.stream(parameters).filter(ParameterInfo::isNew).map(info -> {
                            int i = ArrayUtil.find((Object[])parameters, (Object)info);
                            return expressions[i];
                        }).toArray(PsiExpression[]::new);
                        DetectedJavaChangeInfo.startTemplate(project, editor, toBeDefault, delegate);
                    }
                }, (PsiFile[])new PsiFile[0]);
            }
            return;
        }
        JavaMethodDescriptor descriptor = new JavaMethodDescriptor(currentMethod){

            public String getReturnTypeText() {
                return DetectedJavaChangeInfo.this.getNewReturnType().getTypeText();
            }
        };
        JavaChangeSignatureDialog dialog = new JavaChangeSignatureDialog(method.getProject(), descriptor, true, (PsiElement)method){

            protected BaseRefactoringProcessor createRefactoringProcessor() {
                return DetectedJavaChangeInfo.this.createChangeSignatureProcessor(method);
            }

            protected void invokeRefactoring(BaseRefactoringProcessor processor) {
                CommandProcessor.getInstance().executeCommand(this.myProject, () -> {
                    InplaceChangeSignature.temporallyRevertChanges((TextRange)JavaChangeSignatureDetector.getSignatureRange(currentMethod), (Document)document, (String)oldText, (Project)project);
                    this.doRefactor(processor);
                }, RefactoringBundle.message((String)"changeSignature.refactoring.name"), null);
            }

            private void doRefactor(BaseRefactoringProcessor processor) {
                super.invokeRefactoring(processor);
            }
        };
        dialog.showAndGet();
    }

    private static void startTemplate(@NotNull Project project, Editor editor, PsiExpression[] argsToBeDelegated, PsiMethod delegateMethod) {
        if (project == null) {
            DetectedJavaChangeInfo.$$$reportNull$$$0(3);
        }
        TemplateBuilderImpl builder = new TemplateBuilderImpl((PsiElement)delegateMethod);
        RangeMarker rangeMarker = editor.getDocument().createRangeMarker(delegateMethod.getTextRange());
        for (PsiExpression exprToBeDefault : argsToBeDelegated) {
            builder.replaceElement((PsiElement)exprToBeDefault, (Expression)new TextExpression(exprToBeDefault.getText()));
        }
        Template template = builder.buildTemplate();
        editor.getCaretModel().moveToOffset(rangeMarker.getStartOffset());
        PsiDocumentManager.getInstance((Project)project).doPostponedOperationsAndUnblockDocument(editor.getDocument());
        editor.getDocument().deleteString(rangeMarker.getStartOffset(), rangeMarker.getEndOffset());
        rangeMarker.dispose();
        CreateFromUsageBaseFix.startTemplate((Editor)editor, (Template)template, (Project)project);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newVisibility";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "oldName";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newParms";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        objectArray2[1] = "com/intellij/refactoring/changeSignature/DetectedJavaChangeInfo";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "startTemplate";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

