/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.changeSignature;

import com.intellij.ide.highlighter.JavaFileType;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiImportList;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.changeSignature.DetectedJavaChangeInfo;
import com.intellij.refactoring.changeSignature.JavaParameterInfo;
import com.intellij.refactoring.changeSignature.inplace.LanguageChangeSignatureDetector;
import com.intellij.refactoring.util.CanonicalTypes;
import com.intellij.util.ObjectUtils;
import com.intellij.util.VisibilityUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public final class JavaChangeSignatureDetector
implements LanguageChangeSignatureDetector<DetectedJavaChangeInfo> {
    @NotNull
    public DetectedJavaChangeInfo createInitialChangeInfo(@NotNull PsiElement element) {
        if (element == null) {
            JavaChangeSignatureDetector.$$$reportNull$$$0(0);
        }
        DetectedJavaChangeInfo detectedJavaChangeInfo = DetectedJavaChangeInfo.createFromMethod((PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)element, PsiMethod.class), false);
        if (detectedJavaChangeInfo == null) {
            JavaChangeSignatureDetector.$$$reportNull$$$0(1);
        }
        return detectedJavaChangeInfo;
    }

    public void performChange(DetectedJavaChangeInfo changeInfo, Editor editor, @NotNull String oldText) {
        if (oldText == null) {
            JavaChangeSignatureDetector.$$$reportNull$$$0(2);
        }
        changeInfo.perform(oldText, editor, true);
    }

    public boolean isChangeSignatureAvailableOnElement(@NotNull PsiElement element, DetectedJavaChangeInfo currentInfo) {
        if (element == null) {
            JavaChangeSignatureDetector.$$$reportNull$$$0(3);
        }
        PsiMethod method = currentInfo.getMethod();
        TextRange range = method.getTextRange();
        PsiCodeBlock body = method.getBody();
        if (body != null) {
            range = new TextRange(range.getStartOffset(), body.getTextOffset());
        }
        return element.getContainingFile() == method.getContainingFile() && range.contains(element.getTextRange());
    }

    public boolean ignoreChanges(PsiElement element) {
        if (element instanceof PsiMethod) {
            return true;
        }
        return PsiTreeUtil.getParentOfType((PsiElement)element, PsiImportList.class) != null;
    }

    @NotNull
    public TextRange getHighlightingRange(@NotNull DetectedJavaChangeInfo changeInfo) {
        if (changeInfo == null) {
            JavaChangeSignatureDetector.$$$reportNull$$$0(4);
        }
        PsiMethod method = changeInfo.getMethod();
        return JavaChangeSignatureDetector.getSignatureRange(method);
    }

    public String getMethodSignaturePreview(DetectedJavaChangeInfo initialChangeInfo, List<? super TextRange> deleteRanges, List<? super TextRange> newRanges) {
        CanonicalTypes.Type returnType;
        StringBuilder buf = new StringBuilder();
        String visibility = VisibilityUtil.getVisibilityString((String)initialChangeInfo.getNewVisibility());
        buf.append(visibility);
        if (!StringUtil.isEmptyOrSpaces((String)visibility)) {
            buf.append(" ");
        }
        if ((returnType = initialChangeInfo.getNewReturnType()) != null) {
            buf.append(returnType.getTypeText()).append(" ");
        }
        buf.append(initialChangeInfo.getNewName()).append("(");
        JavaParameterInfo[] newParameters2 = initialChangeInfo.getNewParameters();
        boolean first = true;
        boolean[] toRemove = initialChangeInfo.toRemoveParm();
        block0: for (int i = 0; i < toRemove.length; ++i) {
            if (first) {
                first = false;
            } else {
                buf.append(", ");
            }
            String oldParamName = initialChangeInfo.getOldParameterNames()[i];
            String oldParamType = initialChangeInfo.getOldParameterTypes()[i];
            if (toRemove[i]) {
                String deletedParam = oldParamType + " " + oldParamName;
                deleteRanges.add((TextRange)new TextRange(buf.length(), buf.length() + deletedParam.length()));
                buf.append(deletedParam);
                continue;
            }
            for (JavaParameterInfo parameter : newParameters2) {
                if (parameter.getOldIndex() != i) continue;
                buf.append(parameter.getTypeText());
                buf.append(" ");
                if (!oldParamName.equals(parameter.getName())) {
                    deleteRanges.add((TextRange)new TextRange(buf.length(), buf.length() + oldParamName.length()));
                    buf.append(oldParamName);
                }
                buf.append(parameter.getName());
                continue block0;
            }
        }
        for (JavaParameterInfo param : newParameters2) {
            if (!param.isNew()) continue;
            if (first) {
                first = false;
            } else {
                buf.append(", ");
            }
            String paramPresentation = param.getTypeText() + " " + (String)ObjectUtils.notNull((Object)param.getName(), (Object)"");
            newRanges.add((TextRange)new TextRange(buf.length(), buf.length() + paramPresentation.length()));
            buf.append(paramPresentation);
        }
        buf.append(")");
        return buf.toString();
    }

    public FileType getFileType() {
        return JavaFileType.INSTANCE;
    }

    public DetectedJavaChangeInfo createNextChangeInfo(String signature, @NotNull DetectedJavaChangeInfo currentInfo, boolean delegate) {
        if (currentInfo == null) {
            JavaChangeSignatureDetector.$$$reportNull$$$0(5);
        }
        PsiMethod currentInfoMethod = currentInfo.getMethod();
        Project project = currentInfoMethod.getProject();
        PsiMethod oldMethod = currentInfo.getMethod();
        String visibility = "";
        PsiClass containingClass = oldMethod.getContainingClass();
        if (containingClass != null && containingClass.isInterface()) {
            visibility = "public ";
        }
        PsiMethod method = JavaPsiFacade.getElementFactory((Project)project).createMethodFromText((visibility + signature).trim(), (PsiElement)oldMethod);
        return currentInfo.createNextInfo(method, delegate);
    }

    @NotNull
    public static TextRange getSignatureRange(@NotNull PsiMethod method) {
        if (method == null) {
            JavaChangeSignatureDetector.$$$reportNull$$$0(6);
        }
        int endOffset = method.getThrowsList().getTextRange().getEndOffset();
        int startOffset = method.getTextRange().getStartOffset();
        return new TextRange(startOffset, endOffset);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/refactoring/changeSignature/JavaChangeSignatureDetector";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "oldText";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "changeInfo";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "currentInfo";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/refactoring/changeSignature/JavaChangeSignatureDetector";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "createInitialChangeInfo";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createInitialChangeInfo";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "performChange";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isChangeSignatureAvailableOnElement";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getHighlightingRange";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "createNextChangeInfo";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getSignatureRange";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1 -> new IllegalStateException(string);
        };
    }
}

