/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.changeSignature;

import com.intellij.lang.Language;
import com.intellij.lang.java.JavaLanguage;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.psi.PsiCaseLabelElement;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDeconstructionPattern;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFunctionalExpression;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodReferenceExpression;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiPattern;
import com.intellij.psi.PsiPatternVariable;
import com.intellij.psi.PsiRecordComponent;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.impl.light.LightRecordCanonicalConstructor;
import com.intellij.psi.impl.light.LightRecordMethod;
import com.intellij.psi.javadoc.PsiDocTagValue;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.FunctionalExpressionSearch;
import com.intellij.psi.search.searches.MethodReferencesSearch;
import com.intellij.psi.search.searches.OverridingMethodsSearch;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.JavaPsiPatternUtil;
import com.intellij.psi.util.JavaPsiRecordUtil;
import com.intellij.psi.xml.XmlElement;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.changeSignature.CallerUsageInfo;
import com.intellij.refactoring.changeSignature.ChangeInfo;
import com.intellij.refactoring.changeSignature.ChangeSignatureParameterUsageInfo;
import com.intellij.refactoring.changeSignature.ChangeSignatureUsageProvider;
import com.intellij.refactoring.changeSignature.ChangeSignatureUsageProviders;
import com.intellij.refactoring.changeSignature.DeconstructionUsageInfo;
import com.intellij.refactoring.changeSignature.FunctionalInterfaceChangedUsageInfo;
import com.intellij.refactoring.changeSignature.JavaChangeInfo;
import com.intellij.refactoring.changeSignature.JavaChangeInfoImpl;
import com.intellij.refactoring.changeSignature.JavaParameterInfo;
import com.intellij.refactoring.changeSignature.NewParameterCollidesWithLocalUsageInfo;
import com.intellij.refactoring.changeSignature.ParameterInfo;
import com.intellij.refactoring.changeSignature.RecordGetterDeclarationUsageInfo;
import com.intellij.refactoring.rename.JavaUnresolvableLocalCollisionDetector;
import com.intellij.refactoring.rename.UnresolvableCollisionUsageInfo;
import com.intellij.refactoring.util.MoveRenameUsageInfo;
import com.intellij.refactoring.util.RefactoringUIUtil;
import com.intellij.usageView.UsageInfo;
import com.intellij.usageView.UsageViewUtil;
import com.intellij.util.containers.ContainerUtil;
import com.siyeh.ig.psiutils.VariableAccessUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

final class JavaChangeSignatureUsageSearcher {
    private final JavaChangeInfo myChangeInfo;

    JavaChangeSignatureUsageSearcher(JavaChangeInfo changeInfo) {
        this.myChangeInfo = changeInfo;
    }

    public UsageInfo[] findUsages() {
        ArrayList result = new ArrayList();
        PsiMethod method = this.myChangeInfo.getMethod();
        this.findSimpleUsages(method, result);
        UsageInfo[] usageInfos = result.toArray(UsageInfo.EMPTY_ARRAY);
        return UsageViewUtil.removeDuplicatedUsages((UsageInfo[])usageInfos);
    }

    private void findSimpleUsages(PsiMethod method, ArrayList<? super UsageInfo> result) {
        PsiMethod[] overridingMethods = this.findSimpleUsagesWithoutParameters(method, result, true, true, true);
        this.findUsagesInCallers(result);
        ArrayList<PsiMethod> methods = new ArrayList<PsiMethod>(Arrays.asList(overridingMethods));
        methods.add(method);
        for (PsiMethod psiMethod : methods) {
            for (PsiFunctionalExpression functionalExpression : FunctionalExpressionSearch.search((PsiMethod)psiMethod).asIterable()) {
                result.add(new FunctionalInterfaceChangedUsageInfo((PsiElement)functionalExpression, method));
            }
        }
        PsiDeconstructionPattern[] deconstructions = JavaChangeSignatureUsageSearcher.findDeconstructionUsages(method, result);
        this.findParametersUsage(method, result, overridingMethods, deconstructions);
    }

    private static PsiDeconstructionPattern[] findDeconstructionUsages(PsiMethod method, ArrayList<? super UsageInfo> result) {
        if (!(JavaPsiRecordUtil.isCompactConstructor((PsiMethod)method) || JavaPsiRecordUtil.isExplicitCanonicalConstructor((PsiMethod)method) || method instanceof LightRecordCanonicalConstructor)) {
            return PsiDeconstructionPattern.EMPTY_ARRAY;
        }
        PsiClass aClass = method.getContainingClass();
        if (aClass == null) {
            return PsiDeconstructionPattern.EMPTY_ARRAY;
        }
        PsiParameter[] parameters = method.getParameterList().getParameters();
        ArrayList<PsiDeconstructionPattern> deconstructions = new ArrayList<PsiDeconstructionPattern>();
        GlobalSearchScope projectScope = GlobalSearchScope.projectScope((Project)method.getProject());
        for (PsiReference reference : ReferencesSearch.search((PsiElement)aClass, (SearchScope)projectScope).asIterable()) {
            PsiElement grandParent;
            PsiElement element = reference.getElement();
            PsiElement parent = element.getParent();
            if (!(parent instanceof PsiTypeElement) || !((grandParent = parent.getParent()) instanceof PsiDeconstructionPattern) || !JavaChangeSignatureUsageSearcher.isSuitableDeconstruction((PsiDeconstructionPattern)grandParent, parameters)) continue;
            result.add((UsageInfo)new DeconstructionUsageInfo((PsiDeconstructionPattern)grandParent));
            deconstructions.add((PsiDeconstructionPattern)grandParent);
        }
        return deconstructions.toArray(PsiDeconstructionPattern.EMPTY_ARRAY);
    }

    private static boolean isSuitableDeconstruction(PsiDeconstructionPattern deconstruction, PsiParameter[] parameters) {
        PsiPattern[] components = deconstruction.getDeconstructionList().getDeconstructionComponents();
        return components.length == parameters.length;
    }

    private void findUsagesInCallers(ArrayList<? super UsageInfo> usages) {
        JavaChangeInfo javaChangeInfo = this.myChangeInfo;
        if (javaChangeInfo instanceof JavaChangeInfoImpl) {
            JavaChangeInfoImpl changeInfo = (JavaChangeInfoImpl)javaChangeInfo;
            for (PsiMethod caller : changeInfo.propagateParametersMethods) {
                usages.add(new CallerUsageInfo(caller, true, changeInfo.propagateExceptionsMethods.contains(caller)));
            }
            for (PsiMethod caller : changeInfo.propagateExceptionsMethods) {
                usages.add(new CallerUsageInfo(caller, changeInfo.propagateParametersMethods.contains(caller), true));
            }
            HashSet merged = new HashSet();
            merged.addAll(changeInfo.propagateParametersMethods);
            merged.addAll(changeInfo.propagateExceptionsMethods);
            for (PsiMethod method : merged) {
                this.findSimpleUsagesWithoutParameters(method, usages, changeInfo.propagateParametersMethods.contains(method), changeInfo.propagateExceptionsMethods.contains(method), false);
            }
        }
    }

    private void detectLocalsCollisionsInMethod(final PsiMethod method, final ArrayList<? super UsageInfo> result, boolean isOriginal) {
        if (!JavaLanguage.INSTANCE.equals(method.getLanguage())) {
            return;
        }
        Object[] parameters = method.getParameterList().getParameters();
        final HashSet deletedOrRenamedParameters = new HashSet();
        if (isOriginal) {
            ContainerUtil.addAll(deletedOrRenamedParameters, (Object[])parameters);
            for (JavaParameterInfo parameterInfo : this.myChangeInfo.getNewParameters()) {
                if (parameterInfo.getOldIndex() < 0 || parameterInfo.getOldIndex() >= parameters.length) continue;
                Object parameter = parameters[parameterInfo.getOldIndex()];
                if (!parameterInfo.getName().equals(parameter.getName())) continue;
                deletedOrRenamedParameters.remove(parameter);
            }
        }
        for (JavaParameterInfo parameterInfo : this.myChangeInfo.getNewParameters()) {
            int oldParameterIndex = parameterInfo.getOldIndex();
            String newName = parameterInfo.getName();
            if (oldParameterIndex >= 0) {
                Object parameter;
                if (!isOriginal || oldParameterIndex >= parameters.length || newName.equals(this.myChangeInfo.getOldParameterNames()[oldParameterIndex]) || newName.equals((parameter = parameters[oldParameterIndex]).getName())) continue;
                JavaUnresolvableLocalCollisionDetector.visitLocalsCollisions((PsiElement)parameter, newName, (PsiElement)method.getBody(), null, new JavaUnresolvableLocalCollisionDetector.CollidingVariableVisitor(){
                    final /* synthetic */ PsiParameter val$parameter;
                    final /* synthetic */ PsiMethod val$method;
                    {
                        this.val$parameter = psiParameter;
                        this.val$method = psiMethod;
                    }

                    @Override
                    public void visitCollidingElement(PsiVariable collidingVariable) {
                        if (!deletedOrRenamedParameters.contains(collidingVariable)) {
                            result.add(new RenamedParameterCollidesWithLocalUsageInfo(this.val$parameter, (PsiElement)collidingVariable, this.val$method));
                        }
                    }
                });
                continue;
            }
            JavaUnresolvableLocalCollisionDetector.visitLocalsCollisions((PsiElement)method, newName, (PsiElement)method.getBody(), null, new JavaUnresolvableLocalCollisionDetector.CollidingVariableVisitor(){

                @Override
                public void visitCollidingElement(PsiVariable collidingVariable) {
                    if (!deletedOrRenamedParameters.contains(collidingVariable)) {
                        result.add(new NewParameterCollidesWithLocalUsageInfo((PsiElement)collidingVariable, (PsiElement)collidingVariable, method));
                    }
                }
            });
        }
    }

    private void findParametersUsage(PsiMethod method, ArrayList<? super UsageInfo> result, PsiMethod[] overriders, PsiDeconstructionPattern[] deconstructions) {
        if (JavaLanguage.INSTANCE.equals(this.myChangeInfo.getLanguage())) {
            PsiClass aClass = method.getContainingClass();
            PsiRecordComponent[] components = null;
            if (aClass != null && JavaPsiRecordUtil.isCanonicalConstructor((PsiMethod)method)) {
                components = aClass.getRecordComponents();
            }
            PsiParameter[] parameters = method.getParameterList().getParameters();
            for (JavaParameterInfo info : this.myChangeInfo.getNewParameters()) {
                PsiMethod explicitGetter;
                PsiField field;
                boolean nameChanged;
                if (info.getOldIndex() < 0) continue;
                PsiParameter parameter = parameters[info.getOldIndex()];
                boolean bl = nameChanged = !info.getName().equals(parameter.getName());
                if (nameChanged) {
                    JavaChangeSignatureUsageSearcher.addParameterUsages((PsiNamedElement)parameter, result, (ParameterInfo)info);
                    for (PsiMethod psiMethod : overriders) {
                        PsiParameter parameter1 = psiMethod.getParameterList().getParameters()[info.getOldIndex()];
                        if (parameter1 == null || !Comparing.strEqual((String)parameter.getName(), (String)parameter1.getName())) continue;
                        JavaChangeSignatureUsageSearcher.addParameterUsages((PsiNamedElement)parameter1, result, (ParameterInfo)info);
                    }
                    for (PsiMethod psiMethod : deconstructions) {
                        PsiPattern[] component = psiMethod.getDeconstructionList().getDeconstructionComponents();
                        PsiPatternVariable patternVariable = JavaPsiPatternUtil.getPatternVariable((PsiCaseLabelElement)component[info.getOldIndex()]);
                        if (patternVariable == null || !Comparing.strEqual((String)parameter.getName(), (String)patternVariable.getName())) continue;
                        JavaChangeSignatureUsageSearcher.addParameterUsages((PsiNamedElement)patternVariable, result, (ParameterInfo)info);
                    }
                }
                if (components == null || components.length <= info.getOldIndex()) continue;
                PsiRecordComponent component = components[info.getOldIndex()];
                if (nameChanged && (field = JavaPsiRecordUtil.getFieldForComponent((PsiRecordComponent)component)) != null) {
                    for (PsiReferenceExpression psiReferenceExpression : VariableAccessUtils.getVariableReferences((PsiVariable)field, (PsiElement)aClass)) {
                        ChangeSignatureParameterUsageInfo usageInfo = new ChangeSignatureParameterUsageInfo((PsiElement)psiReferenceExpression, parameter.getName(), info.getName());
                        result.add(usageInfo);
                    }
                }
                if ((explicitGetter = (PsiMethod)ContainerUtil.find((Object[])aClass.findMethodsByName(parameter.getName(), false), m -> m.getParameterList().isEmpty())) == null) continue;
                if (nameChanged) {
                    JavaChangeSignatureUsageSearcher.addParameterUsages((PsiNamedElement)explicitGetter, result, (ParameterInfo)info);
                }
                if (explicitGetter instanceof LightRecordMethod || !nameChanged && parameter.getType().equalsToText(info.getTypeText())) continue;
                result.add(new RecordGetterDeclarationUsageInfo((PsiElement)explicitGetter, info.getName(), info.getTypeText()));
            }
        }
    }

    private PsiMethod[] findSimpleUsagesWithoutParameters(PsiMethod method, ArrayList<? super UsageInfo> result, boolean isToModifyArgs, boolean isToThrowExceptions, boolean isOriginal) {
        boolean needToChangeCalls;
        PsiMethod[] overridingMethods;
        GlobalSearchScope projectScope = GlobalSearchScope.projectScope((Project)method.getProject());
        for (PsiMethod overridingMethod : overridingMethods = (PsiMethod[])OverridingMethodsSearch.search((PsiMethod)method).toArray((Object[])PsiMethod.EMPTY_ARRAY)) {
            ChangeSignatureUsageProvider provider = JavaChangeSignatureUsageSearcher.getProvider((PsiElement)overridingMethod);
            result.add((UsageInfo)provider.createOverrideUsageInfo((ChangeInfo)this.myChangeInfo, (PsiElement)overridingMethod, (PsiElement)method, isOriginal, isToModifyArgs, isToThrowExceptions, result));
        }
        boolean bl = needToChangeCalls = !this.myChangeInfo.isGenerateDelegate() && (this.myChangeInfo.isNameChanged() || this.myChangeInfo.isParameterSetOrOrderChanged() || this.myChangeInfo.isExceptionSetOrOrderChanged() || this.myChangeInfo.isVisibilityChanged());
        if (needToChangeCalls) {
            PsiReference[] refs;
            for (PsiReference ref : refs = (PsiReference[])MethodReferencesSearch.search((PsiMethod)method, (SearchScope)projectScope, (boolean)true).toArray((Object[])PsiReference.EMPTY_ARRAY)) {
                ChangeSignatureUsageProvider provider = JavaChangeSignatureUsageSearcher.getProvider(ref.getElement());
                ContainerUtil.addIfNotNull(result, (Object)provider.createUsageInfo((ChangeInfo)this.myChangeInfo, ref, (PsiElement)method, isToModifyArgs, isToThrowExceptions));
            }
        } else if (this.myChangeInfo.isParameterTypesChanged()) {
            PsiReference[] refs;
            for (PsiReference reference : refs = (PsiReference[])MethodReferencesSearch.search((PsiMethod)method, (SearchScope)projectScope, (boolean)true).toArray((Object[])PsiReference.EMPTY_ARRAY)) {
                PsiElement element = reference.getElement();
                if (element instanceof PsiDocTagValue) {
                    result.add((UsageInfo)new UsageInfo(reference));
                    continue;
                }
                if (element instanceof XmlElement) {
                    result.add((UsageInfo)new MoveRenameUsageInfo(reference, (PsiElement)method));
                    continue;
                }
                if (!(element instanceof PsiMethodReferenceExpression)) continue;
                result.add((UsageInfo)new UsageInfo(reference));
            }
        }
        this.detectLocalsCollisionsInMethod(method, result, isOriginal);
        for (PsiMethod overridingMethod : overridingMethods) {
            this.detectLocalsCollisionsInMethod(overridingMethod, result, isOriginal);
        }
        return overridingMethods;
    }

    @NotNull
    private static ChangeSignatureUsageProvider getProvider(PsiElement element) {
        ChangeSignatureUsageProvider provider = ChangeSignatureUsageProviders.findProvider((Language)element.getLanguage());
        if (provider == null) {
            provider = ChangeSignatureUsageProviders.findProvider((Language)JavaLanguage.INSTANCE);
        }
        ChangeSignatureUsageProvider changeSignatureUsageProvider = Objects.requireNonNull(provider);
        if (changeSignatureUsageProvider == null) {
            JavaChangeSignatureUsageSearcher.$$$reportNull$$$0(0);
        }
        return changeSignatureUsageProvider;
    }

    private static void addParameterUsages(PsiNamedElement parameter, ArrayList<? super UsageInfo> results, ParameterInfo info) {
        PsiManager manager = parameter.getManager();
        GlobalSearchScope projectScope = GlobalSearchScope.projectScope((Project)manager.getProject());
        for (PsiReference psiReference : ReferencesSearch.search((PsiElement)parameter, (SearchScope)projectScope, (boolean)false).asIterable()) {
            PsiElement parmRef = psiReference.getElement();
            ChangeSignatureParameterUsageInfo usageInfo = new ChangeSignatureParameterUsageInfo(parmRef, parameter.getName(), info.getName());
            results.add(usageInfo);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/refactoring/changeSignature/JavaChangeSignatureUsageSearcher", "getProvider"));
    }

    private static class RenamedParameterCollidesWithLocalUsageInfo
    extends UnresolvableCollisionUsageInfo {
        private final PsiElement myCollidingElement;
        private final PsiMethod myMethod;

        RenamedParameterCollidesWithLocalUsageInfo(PsiParameter parameter, PsiElement collidingElement, PsiMethod method) {
            super((PsiElement)parameter, collidingElement);
            this.myCollidingElement = collidingElement;
            this.myMethod = method;
        }

        public String getDescription() {
            return RefactoringBundle.message((String)"there.is.already.a.0.in.the.1.it.will.conflict.with.the.renamed.parameter", (Object[])new Object[]{RefactoringUIUtil.getDescription((PsiElement)this.myCollidingElement, (boolean)true), RefactoringUIUtil.getDescription((PsiElement)this.myMethod, (boolean)true)});
        }
    }
}

