/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.convertToInstanceMethod;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.convertToInstanceMethod.ConvertToInstanceMethodHandler;
import com.intellij.refactoring.convertToInstanceMethod.ConvertToInstanceMethodProcessor;
import com.intellij.refactoring.move.moveInstanceMethod.MoveInstanceMethodDialogBase;
import com.intellij.ui.DoubleClickListener;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Point;
import java.awt.event.MouseEvent;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.TestOnly;

public class ConvertToInstanceMethodDialog
extends MoveInstanceMethodDialogBase {
    private static final Logger LOG = Logger.getInstance(ConvertToInstanceMethodDialog.class);

    public ConvertToInstanceMethodDialog(PsiMethod method, Object[] variables) {
        super(method, variables, ConvertToInstanceMethodHandler.getRefactoringName(), false);
        this.init();
    }

    protected void doAction() {
        Object targetVariable = this.myList.getSelectedValue();
        LOG.assertTrue(targetVariable != null);
        ConvertToInstanceMethodProcessor processor = new ConvertToInstanceMethodProcessor(this.myMethod.getProject(), this.myMethod, targetVariable instanceof PsiParameter ? (PsiParameter)targetVariable : null, this.myVisibilityPanel.getVisibility());
        if (!ApplicationManager.getApplication().isUnitTestMode() && !this.verifyTargetClass(processor.getTargetClass())) {
            return;
        }
        this.invokeRefactoring(processor);
    }

    protected String getHelpId() {
        return "refactoring.convertToInstanceMethod";
    }

    protected JComponent createCenterPanel() {
        JPanel panel = new JPanel(new BorderLayout(10, 4));
        JLabel label = new JLabel(RefactoringBundle.message((String)"moveInstanceMethod.select.an.instance.parameter"));
        panel.add((Component)label, "North");
        panel.add((Component)this.createListAndVisibilityPanels(), "Center");
        return panel;
    }

    protected JList createTargetVariableChooser() {
        final JList<Object> variableChooser = super.createTargetVariableChooser();
        new DoubleClickListener(){

            protected boolean onDoubleClick(@NotNull MouseEvent e) {
                Point point;
                int index;
                if (e == null) {
                    1.$$$reportNull$$$0(0);
                }
                if ((index = variableChooser.locationToIndex(point = e.getPoint())) == -1) {
                    return false;
                }
                if (!variableChooser.getCellBounds(index, index).contains(point)) {
                    return false;
                }
                ConvertToInstanceMethodDialog.this.doRefactorAction();
                return true;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/refactoring/convertToInstanceMethod/ConvertToInstanceMethodDialog$1", "onDoubleClick"));
            }
        }.installOn(variableChooser);
        return variableChooser;
    }

    @TestOnly
    public void setVisibility(String visibility) {
        this.myVisibilityPanel.setVisibility(visibility);
    }
}

