/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.copy;

import com.intellij.codeInsight.actions.OptimizeImportsProcessor;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.execution.ExecutionBundle;
import com.intellij.featureStatistics.FeatureUsageTracker;
import com.intellij.ide.util.EditorHelper;
import com.intellij.java.refactoring.JavaRefactoringBundle;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.application.ex.ApplicationEx;
import com.intellij.openapi.application.ex.ApplicationManagerEx;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.JavaProjectRootsUtil;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaRecursiveElementVisitor;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassOwner;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiImplicitClass;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiReference;
import com.intellij.psi.SyntheticElement;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.impl.file.PsiDirectoryImpl;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.refactoring.MoveDestination;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.SkipOverwriteChoice;
import com.intellij.refactoring.copy.CopyClassDialog;
import com.intellij.refactoring.copy.CopyFilesOrDirectoriesDialog;
import com.intellij.refactoring.copy.CopyFilesOrDirectoriesHandler;
import com.intellij.refactoring.copy.CopyHandler;
import com.intellij.refactoring.copy.CopyHandlerDelegateBase;
import com.intellij.refactoring.move.moveClassesOrPackages.MoveDirectoryWithClassesProcessor;
import com.intellij.util.ArrayFactory;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ThrowableConsumer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import javax.swing.Icon;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class CopyClassesHandler
extends CopyHandlerDelegateBase
implements DumbAware {
    private static final Logger LOG = Logger.getInstance(CopyClassesHandler.class);

    public boolean forbidToClone(PsiElement[] elements, boolean fromUpdate) {
        Map<PsiFile, PsiClass[]> fileMap = CopyClassesHandler.convertToTopLevelClasses(elements, fromUpdate, null, null);
        if (fileMap != null && fileMap.size() == 1) {
            PsiClass[] psiClasses = fileMap.values().iterator().next();
            return psiClasses != null && psiClasses.length > 1;
        }
        return true;
    }

    public boolean canCopy(PsiElement[] elements, boolean fromUpdate) {
        return CopyClassesHandler.canCopyClass(fromUpdate, elements);
    }

    @NotNull
    public String getActionName(PsiElement[] elements) {
        if (elements.length == 1 && !(elements[0] instanceof PsiPackage) && !(elements[0] instanceof PsiDirectory)) {
            String string = JavaRefactoringBundle.message((String)"copy.handler.copy.class.with.dialog", (Object[])new Object[0]);
            if (string == null) {
                CopyClassesHandler.$$$reportNull$$$0(0);
            }
            return string;
        }
        String string = JavaRefactoringBundle.message((String)"copy.handler.copy.classes.with.dialog", (Object[])new Object[0]);
        if (string == null) {
            CopyClassesHandler.$$$reportNull$$$0(1);
        }
        return string;
    }

    public static boolean canCopyClass(PsiElement ... elements) {
        return CopyClassesHandler.canCopyClass(false, elements);
    }

    public static boolean canCopyClass(boolean fromUpdate, PsiElement ... elements) {
        if (fromUpdate && elements.length > 0 && elements[0] instanceof PsiDirectory) {
            return true;
        }
        return CopyClassesHandler.convertToTopLevelClasses(elements, fromUpdate, null, null) != null;
    }

    @Nullable
    private static Map<PsiFile, PsiClass[]> convertToTopLevelClasses(PsiElement[] elements, boolean fromUpdate, String relativePath, Map<PsiFile, String> relativeMap) {
        HashMap<PsiFile, PsiClass[]> result = new HashMap<PsiFile, PsiClass[]>();
        for (PsiElement element : elements) {
            PsiElement navigationElement = element.getNavigationElement();
            LOG.assertTrue(navigationElement != null, (Object)element);
            PsiFile containingFile = navigationElement.getContainingFile();
            if (containingFile instanceof PsiClassOwner && JavaProjectRootsUtil.isOutsideJavaSourceRoot((PsiFile)containingFile) || containingFile != null && ("package-info.class".equals(containingFile.getName()) || containingFile.getContainingDirectory() == null)) continue;
            PsiClass[] topLevelClasses = CopyClassesHandler.getTopLevelClasses(element);
            if (topLevelClasses == null) {
                if (element instanceof PsiDirectory) {
                    if (fromUpdate) continue;
                    String name = ((PsiDirectory)element).getName();
                    String path = relativePath != null ? (String)(!relativePath.isEmpty() ? relativePath + "/" : "") + name : null;
                    Map<PsiFile, PsiClass[]> map = CopyClassesHandler.convertToTopLevelClasses(element.getChildren(), false, path, relativeMap);
                    if (map == null) {
                        return null;
                    }
                    for (Map.Entry<PsiFile, PsiClass[]> entry : map.entrySet()) {
                        CopyClassesHandler.fillResultsMap(result, entry.getKey(), entry.getValue());
                    }
                    continue;
                }
                if (!(element instanceof PsiFileSystemItem)) {
                    return null;
                }
            }
            CopyClassesHandler.fillResultsMap(result, containingFile, topLevelClasses);
            if (relativeMap == null) continue;
            relativeMap.put(containingFile, relativePath);
        }
        if (result.isEmpty()) {
            return null;
        }
        boolean hasClasses = false;
        for (PsiClass[] classes : result.values()) {
            if (classes == null) continue;
            hasClasses = true;
            break;
        }
        return hasClasses ? result : null;
    }

    @Nullable
    private static String normalizeRelativeMap(Map<PsiFile, String> relativeMap) {
        String vector = null;
        for (String relativePath : relativeMap.values()) {
            if (vector == null) {
                vector = relativePath;
                continue;
            }
            if (vector.startsWith(relativePath + "/")) {
                vector = relativePath;
                continue;
            }
            if (relativePath.startsWith(vector + "/") || relativePath.equals(vector)) continue;
            return null;
        }
        if (vector != null) {
            Iterator<String> iterator = relativeMap.keySet().iterator();
            while (iterator.hasNext()) {
                PsiFile psiFile;
                String path = relativeMap.get(psiFile = (PsiFile)iterator.next());
                relativeMap.put(psiFile, path.equals(vector) ? "" : path.substring(vector.length() + 1));
            }
        }
        return vector;
    }

    private static void fillResultsMap(Map<PsiFile, PsiClass[]> result, PsiFile containingFile, PsiClass[] topLevelClasses) {
        Object[] classes = result.get(containingFile);
        if (topLevelClasses != null) {
            if (classes != null) {
                topLevelClasses = (PsiClass[])ArrayUtil.mergeArrays((Object[])classes, (Object[])topLevelClasses, (ArrayFactory)PsiClass.ARRAY_FACTORY);
            }
            result.put(containingFile, topLevelClasses);
        } else {
            result.put(containingFile, (PsiClass[])classes);
        }
    }

    public void doCopy(PsiElement[] elements, PsiDirectory defaultTargetDirectory) {
        Project project;
        VirtualFile sourceRootForFile;
        FeatureUsageTracker.getInstance().triggerFeatureUsed("refactoring.copyClass");
        HashMap<PsiFile, String> relativePathsMap = new HashMap<PsiFile, String>();
        Map<PsiFile, PsiClass[]> classes = CopyClassesHandler.convertToTopLevelClasses(elements, false, "", relativePathsMap);
        assert (classes != null);
        if (defaultTargetDirectory == null) {
            PsiFile psiFile = classes.keySet().iterator().next();
            defaultTargetDirectory = psiFile.getContainingDirectory();
            LOG.assertTrue(defaultTargetDirectory != null, (Object)psiFile);
        }
        if ((sourceRootForFile = ProjectRootManager.getInstance((Project)(project = defaultTargetDirectory.getProject())).getFileIndex().getSourceRootForFile(defaultTargetDirectory.getVirtualFile())) == null) {
            CopyClassesHandler.copyAsFiles(elements, defaultTargetDirectory, project);
            return;
        }
        PsiDirectory targetDirectory = null;
        String className = null;
        boolean openInEditor = true;
        if (CopyClassesHandler.copyOneClass(classes, elements)) {
            final String commonPath = ArrayUtilRt.find((Object[])elements, (Object)classes.values().iterator().next()) == -1 ? CopyClassesHandler.normalizeRelativeMap(relativePathsMap) : null;
            CopyClassDialog dialog = new CopyClassDialog(this, classes.values().iterator().next()[0], defaultTargetDirectory, project, false){

                @Override
                protected String getQualifiedName() {
                    String qualifiedName = super.getQualifiedName();
                    if (commonPath != null && !commonPath.isEmpty() && !qualifiedName.endsWith(commonPath)) {
                        return StringUtil.getQualifiedName((String)qualifiedName, (String)commonPath.replaceAll("/", "."));
                    }
                    return qualifiedName;
                }
            };
            dialog.setTitle(JavaRefactoringBundle.message((String)"copy.handler.copy.class", (Object[])new Object[0]));
            if (dialog.showAndGet()) {
                openInEditor = dialog.isOpenInEditor();
                targetDirectory = dialog.getTargetDirectory();
                className = dialog.getClassName();
                if (className == null || className.isEmpty()) {
                    return;
                }
            }
        } else if (ApplicationManager.getApplication().isUnitTestMode()) {
            targetDirectory = defaultTargetDirectory;
        } else {
            if ((defaultTargetDirectory = CopyFilesOrDirectoriesHandler.resolveDirectory((PsiDirectory)defaultTargetDirectory)) == null) {
                return;
            }
            final PsiFile[] files = PsiUtilCore.toPsiFileArray(classes.keySet());
            CopyFilesOrDirectoriesDialog dialog = new CopyFilesOrDirectoriesDialog(this, (PsiElement[])files, defaultTargetDirectory, project, false){

                public JComponent getPreferredFocusedComponent() {
                    return files.length == 1 ? this.getTargetDirectoryComponent() : super.getPreferredFocusedComponent();
                }
            };
            if (dialog.showAndGet()) {
                targetDirectory = dialog.getTargetDirectory();
                String newName = dialog.getNewName();
                if (files.length == 1) {
                    className = StringUtil.trimEnd((String)newName, (String)("." + CopyClassesHandler.getFileExtension(files[0])));
                }
                openInEditor = dialog.isOpenInEditor();
            }
        }
        if (targetDirectory != null) {
            CopyClassesHandler.copyClassesImpl(className, project, classes, relativePathsMap, targetDirectory, defaultTargetDirectory, JavaRefactoringBundle.message((String)"copy.handler.copy.class", (Object[])new Object[0]), false, openInEditor);
        }
    }

    private static void copyAsFiles(PsiElement[] elements, PsiDirectory defaultTargetDirectory, Project project) {
        ArrayList<Object> files = new ArrayList<Object>();
        for (PsiElement element : elements) {
            PsiFile containingFile = element.getContainingFile();
            if (containingFile != null) {
                files.add(containingFile);
                continue;
            }
            if (!(element instanceof PsiDirectory)) continue;
            files.add(element);
        }
        CopyFilesOrDirectoriesHandler.copyAsFiles((PsiElement[])files.toArray(PsiElement.EMPTY_ARRAY), (PsiDirectory)defaultTargetDirectory, (Project)project);
    }

    private static boolean copyOneClass(Map<PsiFile, PsiClass[]> classes, PsiElement[] elements) {
        if (!(classes.size() != 1 || elements.length == 1 && elements[0] instanceof PsiDirectory)) {
            PsiClass[] psiClasses = classes.values().iterator().next();
            return psiClasses != null && psiClasses.length == 1;
        }
        return false;
    }

    public void doClone(PsiElement element) {
        FeatureUsageTracker.getInstance().triggerFeatureUsed("refactoring.copyClass");
        PsiClass[] classes = CopyClassesHandler.getTopLevelClasses(element);
        if (classes == null) {
            CopyFilesOrDirectoriesHandler.doCloneFile((PsiElement)element);
            return;
        }
        Project project = element.getProject();
        CopyClassDialog dialog = new CopyClassDialog(classes[0], null, project, true);
        dialog.setTitle(JavaRefactoringBundle.message((String)"copy.handler.clone.class", (Object[])new Object[0]));
        if (dialog.showAndGet()) {
            String className = dialog.getClassName();
            PsiDirectory targetDirectory = element.getContainingFile().getContainingDirectory();
            CopyClassesHandler.copyClassesImpl(className, project, Collections.singletonMap(classes[0].getContainingFile(), classes), null, targetDirectory, targetDirectory, JavaRefactoringBundle.message((String)"copy.handler.clone.class", (Object[])new Object[0]), true, true);
        }
    }

    private static void copyClassesImpl(String copyClassName, Project project, Map<PsiFile, PsiClass[]> classes, HashMap<PsiFile, String> map, Object targetDirectory, PsiDirectory defaultTargetDirectory, @NlsContexts.Command String commandName, boolean selectInActivePanel, boolean openInEditor) {
        Runnable command = () -> {
            PsiDirectory target = targetDirectory instanceof PsiDirectory ? (PsiDirectory)targetDirectory : (PsiDirectory)WriteAction.compute(() -> ((MoveDestination)targetDirectory).getTargetDirectory(defaultTargetDirectory));
            try {
                Collection<PsiFile> files = CopyClassesHandler.doCopyClasses(classes, map, copyClassName, target, project);
                if (openInEditor) {
                    for (PsiFile file : files) {
                        CopyHandler.updateSelectionInActiveProjectView((PsiElement)file, (Project)project, (boolean)selectInActivePanel);
                    }
                    EditorHelper.openFilesInEditor((PsiElement[])files.toArray(PsiFile.EMPTY_ARRAY));
                }
            }
            catch (IncorrectOperationException ex) {
                Messages.showMessageDialog((Project)project, (String)ex.getMessage(), (String)RefactoringBundle.message((String)"error.title"), (Icon)Messages.getErrorIcon());
            }
        };
        CommandProcessor processor = CommandProcessor.getInstance();
        processor.executeCommand(project, command, commandName, null);
    }

    @NotNull
    public static Collection<PsiFile> doCopyClasses(Map<PsiFile, PsiClass[]> fileToClasses, String copyClassName, PsiDirectory targetDirectory, Project project) throws IncorrectOperationException {
        return CopyClassesHandler.doCopyClasses(fileToClasses, null, copyClassName, targetDirectory, project);
    }

    private static List<PsiFile> checkExistingFiles(@NotNull Collection<PsiFile> files, @NotNull PsiDirectory directory, @Nullable Map<PsiFile, String> relativePaths, @Nullable String className) {
        if (files == null) {
            CopyClassesHandler.$$$reportNull$$$0(2);
        }
        if (directory == null) {
            CopyClassesHandler.$$$reportNull$$$0(3);
        }
        SkipOverwriteChoice choice = SkipOverwriteChoice.OVERWRITE;
        ArrayList<PsiFile> filesToProcess = new ArrayList<PsiFile>();
        for (PsiFile file : files) {
            PsiFile existingFile;
            String relativePath = relativePaths != null ? relativePaths.get(file) : null;
            PsiDirectory targetDirectory = CopyClassesHandler.buildRelativeDir(directory, relativePath).getTargetDirectory();
            String fileName = CopyClassesHandler.getNewFileName(file, className);
            PsiFile psiFile = existingFile = targetDirectory != null ? targetDirectory.findFile(fileName) : null;
            if (existingFile != null && choice != SkipOverwriteChoice.SKIP_ALL && choice != SkipOverwriteChoice.OVERWRITE_ALL) {
                String message = ExecutionBundle.message((String)"copy.classes.command.name", (Object[])new Object[0]);
                choice = SkipOverwriteChoice.askUser((PsiDirectory)targetDirectory, (String)fileName, (String)message, (files.size() > 1 ? 1 : 0) != 0);
            }
            if (existingFile != null && choice != SkipOverwriteChoice.OVERWRITE && choice != SkipOverwriteChoice.OVERWRITE_ALL || existingFile == file) continue;
            filesToProcess.add(file);
        }
        return filesToProcess;
    }

    private static <E extends IncorrectOperationException> void runWriteAction(@NotNull Project project, @NlsContexts.ProgressTitle @NotNull String title, @NotNull ThrowableConsumer<@Nullable ProgressIndicator, E> consumer) throws E {
        AtomicReference thrown;
        ApplicationEx application;
        if (project == null) {
            CopyClassesHandler.$$$reportNull$$$0(4);
        }
        if (title == null) {
            CopyClassesHandler.$$$reportNull$$$0(5);
        }
        if (consumer == null) {
            CopyClassesHandler.$$$reportNull$$$0(6);
        }
        if (!(application = ApplicationManagerEx.getApplicationEx()).runWriteActionWithCancellableProgressInDispatchThread(title, project, null, arg_0 -> CopyClassesHandler.lambda$runWriteAction$2(consumer, thrown = new AtomicReference(), arg_0))) {
            return;
        }
        Throwable throwable = (Throwable)thrown.get();
        if (throwable instanceof IncorrectOperationException) {
            throw (IncorrectOperationException)throwable;
        }
        if (throwable != null) {
            throw new IncorrectOperationException(throwable);
        }
    }

    @NotNull
    public static Collection<PsiFile> doCopyClasses(Map<PsiFile, PsiClass[]> fileToClasses, @Nullable HashMap<PsiFile, String> fileToRelativePath, String copyClassName, PsiDirectory targetDirectory, Project project) throws IncorrectOperationException {
        HashMap oldToNewMap = new HashMap();
        ArrayList<PsiFile> createdFiles = new ArrayList<PsiFile>(fileToClasses.size());
        DumbService dumbService = DumbService.getInstance((Project)project);
        List<PsiFile> filesToProcess = CopyClassesHandler.checkExistingFiles(fileToClasses.keySet(), targetDirectory, fileToRelativePath, copyClassName);
        CopyClassesHandler.runWriteAction(project, RefactoringBundle.message((String)"command.name.copy"), progress -> {
            for (int i = 0; i < filesToProcess.size(); ++i) {
                PsiFile psiFile = (PsiFile)filesToProcess.get(i);
                if (progress != null) {
                    progress.setIndeterminate(false);
                    progress.setFraction((double)((float)i / (float)filesToProcess.size()));
                    progress.setText2(InspectionsBundle.message((String)"processing.progress.text", (Object[])new Object[]{psiFile.getName()}));
                }
                PsiClass[] sources = (PsiClass[])fileToClasses.get(psiFile);
                String relativePath = fileToRelativePath != null ? (String)fileToRelativePath.get(psiFile) : null;
                PsiDirectoryImpl directory = (PsiDirectoryImpl)WriteAction.compute(() -> (PsiDirectoryImpl)CopyClassesHandler.buildRelativeDir(targetDirectory, relativePath).findOrCreateTargetDirectory());
                Ref createdFileReference = new Ref();
                directory.executeWithUpdatingAddedFilesDisabled(() -> createdFileReference.set((Object)CopyClassesHandler.copy((PsiDirectory)directory, psiFile, copyClassName)));
                PsiFile createdFile = (PsiFile)createdFileReference.get();
                if (createdFile == null) continue;
                createdFiles.add(createdFile);
                if (!(createdFile instanceof PsiClassOwner) || sources == null) continue;
                LinkedHashMap<PsiClass, PsiClass> sourceToDestination = new LinkedHashMap<PsiClass, PsiClass>();
                for (PsiClass destination : ((PsiClassOwner)createdFile).getClasses()) {
                    if (CopyClassesHandler.isSynthetic(destination)) continue;
                    PsiClass source = CopyClassesHandler.findByName(sources, destination.getName());
                    if (source == null) {
                        destination.delete();
                        continue;
                    }
                    sourceToDestination.put(source, destination);
                }
                for (Map.Entry entry : sourceToDestination.entrySet()) {
                    if (copyClassName != null && sourceToDestination.size() == 1) {
                        try {
                            PsiClass newClass = (PsiClass)dumbService.computeWithAlternativeResolveEnabled(() -> {
                                PsiClass copy = CopyClassesHandler.copy((PsiClass)classEntry.getKey(), copyClassName);
                                return (PsiClass)((PsiClass)classEntry.getValue()).replace((PsiElement)copy);
                            });
                            oldToNewMap.put((PsiClass)entry.getKey(), newClass);
                        }
                        catch (IndexNotReadyException e) {
                            LOG.error((Throwable)e);
                        }
                        continue;
                    }
                    oldToNewMap.put((PsiClass)entry.getKey(), (PsiClass)entry.getValue());
                }
            }
        });
        dumbService.completeJustSubmittedTasks();
        CopyFilesOrDirectoriesHandler.updateAddedFiles(createdFiles, filesToProcess);
        CopyClassesHandler.runWriteAction(project, RefactoringBundle.message((String)"copy.update.references"), progress -> {
            HashSet rebindExpressions = new HashSet();
            JavaCodeStyleManager codeStyleManager = JavaCodeStyleManager.getInstance((Project)project);
            float numberOfProcessedClasses = 0.0f;
            for (PsiClass copiedClass : oldToNewMap.values()) {
                if (copiedClass == null) {
                    LOG.error("Unexpected null value, keys = " + String.valueOf(oldToNewMap.keySet()));
                    continue;
                }
                if (progress != null) {
                    progress.setIndeterminate(false);
                    progress.setFraction((double)(numberOfProcessedClasses / (float)filesToProcess.size()));
                    progress.setText2(InspectionsBundle.message((String)"processing.progress.text", (Object[])new Object[]{copiedClass.getName()}));
                    numberOfProcessedClasses += 1.0f;
                }
                dumbService.runWithAlternativeResolveEnabled(() -> {
                    CopyClassesHandler.decodeRefs((PsiElement)copiedClass, oldToNewMap, rebindExpressions);
                    PsiFile psiFile = copiedClass.getContainingFile();
                    if (psiFile instanceof PsiJavaFile) {
                        codeStyleManager.removeRedundantImports((PsiJavaFile)psiFile);
                    }
                    for (PsiElement expression : rebindExpressions) {
                        if (!expression.isValid()) continue;
                        codeStyleManager.shortenClassReferences(expression);
                    }
                });
            }
        });
        new OptimizeImportsProcessor(project, createdFiles.toArray(PsiFile.EMPTY_ARRAY), null).run();
        ArrayList<PsiFile> arrayList = createdFiles;
        if (arrayList == null) {
            CopyClassesHandler.$$$reportNull$$$0(7);
        }
        return arrayList;
    }

    private static boolean isSynthetic(PsiClass aClass) {
        return aClass instanceof SyntheticElement || !aClass.isPhysical();
    }

    private static PsiFile copy(@NotNull PsiDirectory directory, @NotNull PsiFile file, String name) {
        if (directory == null) {
            CopyClassesHandler.$$$reportNull$$$0(8);
        }
        if (file == null) {
            CopyClassesHandler.$$$reportNull$$$0(9);
        }
        String fileName = CopyClassesHandler.getNewFileName(file, name);
        PsiFile existingFile = directory.findFile(fileName);
        return (PsiFile)WriteAction.compute(() -> {
            if (existingFile != null) {
                existingFile.delete();
            }
            return directory.copyFileFrom(fileName, file);
        });
    }

    private static String getNewFileName(PsiFile file, String name) {
        if (name != null) {
            String fileExtension = CopyClassesHandler.getFileExtension(file);
            return StringUtil.isEmpty((String)fileExtension) ? name : StringUtil.getQualifiedName((String)name, (String)fileExtension);
        }
        return file.getName();
    }

    private static String getFileExtension(PsiFile file) {
        if (file instanceof PsiClassOwner) {
            for (PsiClass psiClass : ((PsiClassOwner)file).getClasses()) {
                if (CopyClassesHandler.isSynthetic(psiClass)) continue;
                return file.getViewProvider().getVirtualFile().getExtension();
            }
        }
        return "";
    }

    @NotNull
    private static MoveDirectoryWithClassesProcessor.TargetDirectoryWrapper buildRelativeDir(@NotNull PsiDirectory directory, @Nullable String relativePath) {
        if (directory == null) {
            CopyClassesHandler.$$$reportNull$$$0(10);
        }
        if (StringUtil.isEmpty((String)relativePath)) {
            return new MoveDirectoryWithClassesProcessor.TargetDirectoryWrapper(directory);
        }
        MoveDirectoryWithClassesProcessor.TargetDirectoryWrapper current = null;
        for (String pathElement : relativePath.split("/")) {
            current = current == null ? new MoveDirectoryWithClassesProcessor.TargetDirectoryWrapper(directory, pathElement) : new MoveDirectoryWithClassesProcessor.TargetDirectoryWrapper(current, pathElement);
        }
        LOG.assertTrue(current != null);
        MoveDirectoryWithClassesProcessor.TargetDirectoryWrapper targetDirectoryWrapper = current;
        if (targetDirectoryWrapper == null) {
            CopyClassesHandler.$$$reportNull$$$0(11);
        }
        return targetDirectoryWrapper;
    }

    private static PsiClass copy(@NotNull PsiClass aClass, @NotNull String name) {
        if (aClass == null) {
            CopyClassesHandler.$$$reportNull$$$0(12);
        }
        if (name == null) {
            CopyClassesHandler.$$$reportNull$$$0(13);
        }
        PsiClass classNavigationElement = (PsiClass)aClass.getNavigationElement();
        PsiClass classCopy = (PsiClass)classNavigationElement.copy();
        classCopy.setName(name);
        return classCopy;
    }

    @Nullable
    private static PsiClass findByName(PsiClass[] classes, String name) {
        if (name != null) {
            for (PsiClass aClass : classes) {
                if (!name.equals(aClass.getName())) continue;
                return aClass;
            }
        }
        return null;
    }

    private static void rebindExternalReferences(PsiElement element, Map<PsiClass, PsiClass> oldToNewMap, Set<? super PsiElement> rebindExpressions) {
        LocalSearchScope searchScope = new LocalSearchScope(element);
        for (PsiClass aClass : oldToNewMap.keySet()) {
            PsiElement newClass = (PsiElement)oldToNewMap.get(aClass);
            for (PsiReference reference : ReferencesSearch.search((PsiElement)aClass, (SearchScope)searchScope).asIterable()) {
                rebindExpressions.add((PsiElement)reference.bindToElement(newClass));
            }
        }
    }

    private static void decodeRefs(@NotNull PsiElement element, final Map<PsiClass, PsiClass> oldToNewMap, Set<? super PsiElement> rebindExpressions) {
        if (element == null) {
            CopyClassesHandler.$$$reportNull$$$0(14);
        }
        final LinkedHashMap rebindMap = new LinkedHashMap();
        element.accept((PsiElementVisitor)new JavaRecursiveElementVisitor(){

            public void visitReferenceElement(@NotNull PsiJavaCodeReferenceElement reference) {
                if (reference == null) {
                    3.$$$reportNull$$$0(0);
                }
                super.visitReferenceElement(reference);
                CopyClassesHandler.decodeRef(reference, oldToNewMap, rebindMap);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "reference", "com/intellij/refactoring/copy/CopyClassesHandler$3", "visitReferenceElement"));
            }
        });
        for (Map.Entry entry : rebindMap.entrySet()) {
            rebindExpressions.add((PsiElement)((PsiJavaCodeReferenceElement)entry.getKey()).bindToElement((PsiElement)entry.getValue()));
        }
        CopyClassesHandler.rebindExternalReferences(element, oldToNewMap, rebindExpressions);
    }

    private static void decodeRef(PsiJavaCodeReferenceElement expression, Map<PsiClass, PsiClass> oldToNewMap, Map<PsiJavaCodeReferenceElement, PsiElement> rebindExpressions) {
        PsiClass psiClass;
        PsiElement resolved = expression.resolve();
        if (resolved instanceof PsiClass && oldToNewMap.containsKey(psiClass = (PsiClass)resolved)) {
            rebindExpressions.put(expression, (PsiElement)oldToNewMap.get(psiClass));
        }
    }

    private static PsiClass @Nullable [] getTopLevelClasses(PsiElement element) {
        PsiClass[] psiClassArray;
        while (element != null && !(element instanceof PsiFile) && (!(element instanceof PsiClass) || element.getParent() == null || ((PsiClass)element).getContainingClass() != null || element instanceof PsiAnonymousClass || element instanceof PsiImplicitClass)) {
            element = element.getParent();
        }
        if (element instanceof PsiClassOwner) {
            PsiClass[] classes = ((PsiClassOwner)element).getClasses();
            ArrayList<PsiClass> buffer = new ArrayList<PsiClass>();
            for (PsiClass aClass : classes) {
                if (CopyClassesHandler.isSynthetic(aClass)) {
                    return null;
                }
                if (aClass instanceof PsiImplicitClass) {
                    return null;
                }
                buffer.add(aClass);
            }
            return buffer.toArray(PsiClass.EMPTY_ARRAY);
        }
        if (element instanceof PsiClass) {
            PsiClass[] psiClassArray2 = new PsiClass[1];
            psiClassArray = psiClassArray2;
            psiClassArray2[0] = (PsiClass)element;
        } else {
            psiClassArray = null;
        }
        return psiClassArray;
    }

    private static /* synthetic */ void lambda$runWriteAction$2(ThrowableConsumer consumer, AtomicReference thrown, ProgressIndicator progress) {
        try {
            consumer.consume((Object)progress);
        }
        catch (ProcessCanceledException e) {
            throw e;
        }
        catch (Throwable e) {
            thrown.set(e);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 2, 3, 4, 5, 6, 8, 9, 10, 12, 13, 14 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/refactoring/copy/CopyClassesHandler";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
            case 3: 
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "directory";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "title";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionName";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/refactoring/copy/CopyClassesHandler";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "doCopyClasses";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "buildRelativeDir";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "checkExistingFiles";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "runWriteAction";
                break;
            }
            case 8: 
            case 9: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "copy";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "buildRelativeDir";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "decodeRefs";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 2, 3, 4, 5, 6, 8, 9, 10, 12, 13, 14 -> new IllegalArgumentException(string);
        };
    }
}

