/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.encapsulateFields;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.icons.AllIcons;
import com.intellij.java.JavaBundle;
import com.intellij.java.refactoring.JavaRefactoringBundle;
import com.intellij.openapi.actionSystem.ex.ActionUtil;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifier;
import com.intellij.psi.PsiNameHelper;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.util.PsiFormatUtil;
import com.intellij.refactoring.JavaRefactoringSettings;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.encapsulateFields.EncapsulateFieldHelper;
import com.intellij.refactoring.encapsulateFields.EncapsulateFieldsDescriptor;
import com.intellij.refactoring.encapsulateFields.EncapsulateFieldsProcessor;
import com.intellij.refactoring.encapsulateFields.FieldDescriptor;
import com.intellij.refactoring.encapsulateFields.FieldDescriptorImpl;
import com.intellij.refactoring.ui.DocCommentPanel;
import com.intellij.refactoring.ui.RefactoringDialog;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.refactoring.util.RefactoringMessageUtil;
import com.intellij.ui.BooleanTableCellRenderer;
import com.intellij.ui.IconManager;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.JBColor;
import com.intellij.ui.NonFocusableCheckBox;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.TableUtil;
import com.intellij.ui.border.IdeaTitledBorder;
import com.intellij.ui.components.JBBox;
import com.intellij.ui.icons.RowIcon;
import com.intellij.ui.table.JBTable;
import com.intellij.util.IconUtil;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.ui.EmptyIcon;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.InputMap;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.border.Border;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EncapsulateFieldsDialog
extends RefactoringDialog
implements EncapsulateFieldsDescriptor {
    private static final Logger LOG = Logger.getInstance(EncapsulateFieldsDialog.class);
    private static final int CHECKED_COLUMN = 0;
    private static final int FIELD_COLUMN = 1;
    private static final int GETTER_COLUMN = 2;
    private static final int SETTER_COLUMN = 3;
    private final EncapsulateFieldHelper myHelper;
    private final PsiClass myClass;
    private final PsiField[] myFields;
    private final ConcurrentHashMap<PsiField, Icon> myIconFields;
    private final boolean[] myCheckedMarks;
    private final boolean[] myFinalMarks;
    private final String[] myFieldNames;
    private final String[] myGetterNames;
    private final ConcurrentHashMap<Integer, PsiMethod> myGetterPrototypes;
    private final ConcurrentHashMap<Integer, RowIcon> myGetterPrototypesIcons;
    private final String[] mySetterNames;
    private final ConcurrentHashMap<Integer, PsiMethod> mySetterPrototypes;
    private final ConcurrentHashMap<Integer, RowIcon> mySetterPrototypesIcons;
    private JBTable myTable;
    private MyTableModel myTableModel;
    private final JCheckBox myCbEncapsulateGet = new NonFocusableCheckBox();
    private final JCheckBox myCbEncapsulateSet = new NonFocusableCheckBox();
    private final JCheckBox myCbUseAccessorsWhenAccessible = new NonFocusableCheckBox();
    private final JRadioButton myRbFieldPrivate = new JRadioButton();
    private final JRadioButton myRbFieldProtected = new JRadioButton();
    private final JRadioButton myRbFieldPackageLocal = new JRadioButton();
    private final JRadioButton myRbFieldAsIs = new JRadioButton();
    private final JRadioButton myRbAccessorPublic = new JRadioButton();
    private final JRadioButton myRbAccessorProtected = new JRadioButton();
    private final JRadioButton myRbAccessorPrivate = new JRadioButton();
    private final JRadioButton myRbAccessorPackageLocal = new JRadioButton();
    private DocCommentPanel myJavadocPolicy;
    private boolean myCbUseAccessorWhenAccessibleValue;

    public EncapsulateFieldsDialog(Project project, PsiClass aClass, Set preselectedFields, EncapsulateFieldHelper helper) {
        this(project, EncapsulateFieldsContainer.create(aClass, preselectedFields, helper));
    }

    public EncapsulateFieldsDialog(Project project, EncapsulateFieldsContainer container) {
        super(project, true);
        PsiMethod prototype;
        int i;
        this.myRbAccessorPackageLocal.setFocusable(false);
        this.myRbAccessorPrivate.setFocusable(false);
        this.myRbAccessorProtected.setFocusable(false);
        this.myRbAccessorPublic.setFocusable(false);
        this.myRbFieldAsIs.setFocusable(false);
        this.myRbFieldPackageLocal.setFocusable(false);
        this.myRbFieldPrivate.setFocusable(false);
        this.myRbFieldProtected.setFocusable(false);
        this.myClass = container.myClass;
        this.myHelper = container.myHelper;
        this.myFields = container.myFields;
        this.myIconFields = new ConcurrentHashMap<PsiField, Icon>(container.myIconFields);
        this.myCheckedMarks = container.myCheckedMarks;
        this.myFinalMarks = container.myFinalMarks;
        this.myFieldNames = container.myFieldNames;
        this.myGetterNames = container.myGetterNames;
        this.myGetterPrototypes = new ConcurrentHashMap();
        for (i = 0; i < container.myGetterPrototypes.length; ++i) {
            prototype = container.myGetterPrototypes[i];
            if (prototype == null) continue;
            this.myGetterPrototypes.put(i, prototype);
        }
        this.myGetterPrototypesIcons = new ConcurrentHashMap<Integer, RowIcon>(container.myGetterPrototypesIcons);
        this.mySetterNames = container.mySetterNames;
        this.mySetterPrototypes = new ConcurrentHashMap();
        for (i = 0; i < container.mySetterPrototypes.length; ++i) {
            prototype = container.mySetterPrototypes[i];
            if (prototype == null) continue;
            this.mySetterPrototypes.put(i, prototype);
        }
        this.mySetterPrototypesIcons = new ConcurrentHashMap<Integer, RowIcon>(container.mySetterPrototypesIcons);
        Object title = EncapsulateFieldsDialog.getRefactoringName();
        String qName = this.myClass.getQualifiedName();
        if (qName != null) {
            title = (String)title + " - " + qName;
        }
        this.setTitle((String)title);
        this.init();
    }

    public FieldDescriptor[] getSelectedFields() {
        int[] rows = this.getCheckedRows();
        FieldDescriptor[] descriptors = new FieldDescriptor[rows.length];
        for (int idx = 0; idx < rows.length; ++idx) {
            String getterName = this.myGetterNames[rows[idx]];
            PsiField field = this.myFields[rows[idx]];
            String setterName = this.mySetterNames[rows[idx]];
            descriptors[idx] = new FieldDescriptorImpl(field, getterName, setterName, this.isToEncapsulateGet() ? this.myHelper.generateMethodPrototype(field, getterName, true) : null, this.isToEncapsulateSet() ? this.myHelper.generateMethodPrototype(field, setterName, false) : null);
        }
        return descriptors;
    }

    public boolean isToEncapsulateGet() {
        return this.myCbEncapsulateGet.isSelected();
    }

    public boolean isToEncapsulateSet() {
        return this.myCbEncapsulateSet.isSelected();
    }

    public boolean isToUseAccessorsWhenAccessible() {
        if (this.getFieldsVisibility() == null) {
            return true;
        }
        return this.myCbUseAccessorsWhenAccessible.isSelected();
    }

    @PsiModifier.ModifierConstant
    public String getFieldsVisibility() {
        if (this.myRbFieldPrivate.isSelected()) {
            return "private";
        }
        if (this.myRbFieldPackageLocal.isSelected()) {
            return "packageLocal";
        }
        if (this.myRbFieldProtected.isSelected()) {
            return "protected";
        }
        if (this.myRbFieldAsIs.isSelected()) {
            return null;
        }
        LOG.assertTrue(false);
        return null;
    }

    public int getJavadocPolicy() {
        return this.myJavadocPolicy.getPolicy();
    }

    public PsiClass getTargetClass() {
        return this.myClass;
    }

    protected String getDimensionServiceKey() {
        return "#com.intellij.refactoring.encapsulateFields.EncalpsulateFieldsDialog";
    }

    @PsiModifier.ModifierConstant
    public String getAccessorsVisibility() {
        if (this.myRbAccessorPublic.isSelected()) {
            return "public";
        }
        if (this.myRbAccessorProtected.isSelected()) {
            return "protected";
        }
        if (this.myRbAccessorPackageLocal.isSelected()) {
            return "packageLocal";
        }
        if (this.myRbAccessorPrivate.isSelected()) {
            return "private";
        }
        LOG.assertTrue(false);
        return null;
    }

    protected JComponent createCenterPanel() {
        JPanel panel = new JPanel(new BorderLayout());
        panel.add((Component)this.createTable(), "Center");
        this.myCbEncapsulateGet.setText(JavaRefactoringBundle.message((String)"encapsulate.fields.get.access.checkbox", (Object[])new Object[0]));
        this.myCbEncapsulateSet.setText(JavaRefactoringBundle.message((String)"encapsulate.fields.set.access.checkbox", (Object[])new Object[0]));
        this.myCbUseAccessorsWhenAccessible.setText(JavaRefactoringBundle.message((String)"encapsulate.fields.use.accessors.even.when.field.is.accessible.checkbox", (Object[])new Object[0]));
        this.myRbFieldPrivate.setText(JavaRefactoringBundle.message((String)"encapsulate.fields.private.radio", (Object[])new Object[0]));
        this.myRbFieldProtected.setText(JavaRefactoringBundle.message((String)"encapsulate.fields.protected.radio", (Object[])new Object[0]));
        this.myRbFieldPackageLocal.setText(JavaRefactoringBundle.message((String)"encapsulate.fields..package.local.radio", (Object[])new Object[0]));
        this.myRbFieldAsIs.setText(RefactoringBundle.getVisibilityAsIs());
        this.myRbAccessorPublic.setText(RefactoringBundle.getVisibilityPublic());
        this.myRbAccessorProtected.setText(RefactoringBundle.getVisibilityProtected());
        this.myRbAccessorPrivate.setText(RefactoringBundle.getVisibilityPrivate());
        this.myRbAccessorPackageLocal.setText(RefactoringBundle.getVisibilityPackageLocal());
        ButtonGroup fieldGroup = new ButtonGroup();
        fieldGroup.add(this.myRbFieldAsIs);
        fieldGroup.add(this.myRbFieldPackageLocal);
        fieldGroup.add(this.myRbFieldPrivate);
        fieldGroup.add(this.myRbFieldProtected);
        ButtonGroup methodGroup = new ButtonGroup();
        methodGroup.add(this.myRbAccessorPackageLocal);
        methodGroup.add(this.myRbAccessorPrivate);
        methodGroup.add(this.myRbAccessorProtected);
        methodGroup.add(this.myRbAccessorPublic);
        this.myCbEncapsulateGet.setSelected(true);
        this.myCbEncapsulateSet.setSelected(true);
        ActionListener checkboxListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (EncapsulateFieldsDialog.this.myCbEncapsulateGet.equals(e.getSource())) {
                    if (!EncapsulateFieldsDialog.this.myCbEncapsulateGet.isSelected()) {
                        EncapsulateFieldsDialog.this.myCbEncapsulateSet.setSelected(true);
                    }
                } else if (!EncapsulateFieldsDialog.this.myCbEncapsulateSet.isSelected()) {
                    EncapsulateFieldsDialog.this.myCbEncapsulateGet.setSelected(true);
                }
                int[] rows = EncapsulateFieldsDialog.this.myTable.getSelectedRows();
                EncapsulateFieldsDialog.this.myTableModel.fireTableDataChanged();
                TableUtil.selectRows((JTable)EncapsulateFieldsDialog.this.myTable, (int[])rows);
            }
        };
        this.myCbEncapsulateGet.addActionListener(checkboxListener);
        this.myCbEncapsulateSet.addActionListener(checkboxListener);
        this.myRbFieldAsIs.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (EncapsulateFieldsDialog.this.myRbFieldAsIs.isSelected()) {
                    EncapsulateFieldsDialog.this.myCbUseAccessorWhenAccessibleValue = EncapsulateFieldsDialog.this.myCbUseAccessorsWhenAccessible.isSelected();
                    EncapsulateFieldsDialog.this.myCbUseAccessorsWhenAccessible.setSelected(true);
                    EncapsulateFieldsDialog.this.myCbUseAccessorsWhenAccessible.setEnabled(false);
                } else {
                    EncapsulateFieldsDialog.this.myCbUseAccessorsWhenAccessible.setEnabled(true);
                    EncapsulateFieldsDialog.this.myCbUseAccessorsWhenAccessible.setSelected(EncapsulateFieldsDialog.this.myCbUseAccessorWhenAccessibleValue);
                }
            }
        });
        this.myCbUseAccessorsWhenAccessible.setSelected(JavaRefactoringSettings.getInstance().ENCAPSULATE_FIELDS_USE_ACCESSORS_WHEN_ACCESSIBLE);
        this.myCbUseAccessorWhenAccessibleValue = this.myCbUseAccessorsWhenAccessible.isSelected();
        this.myRbFieldPrivate.setSelected(true);
        this.myRbAccessorPublic.setSelected(true);
        JBBox leftBox = JBBox.createVerticalBox();
        this.myCbEncapsulateGet.setPreferredSize(this.myCbUseAccessorsWhenAccessible.getPreferredSize());
        leftBox.add((Component)this.myCbEncapsulateGet);
        leftBox.add((Component)this.myCbEncapsulateSet);
        leftBox.add(Box.createVerticalStrut(10));
        leftBox.add((Component)this.myCbUseAccessorsWhenAccessible);
        JPanel leftPanel = new JPanel(new BorderLayout());
        leftPanel.setBorder(IdeBorderFactory.createTitledBorder((String)JavaRefactoringBundle.message((String)"encapsulate.fields.encapsulate.border.title", (Object[])new Object[0])));
        leftPanel.add((Component)leftBox, "Center");
        leftPanel.add(Box.createHorizontalStrut(5), "West");
        JPanel encapsulateBox = new JPanel(new BorderLayout());
        encapsulateBox.add((Component)leftPanel, "Center");
        this.myJavadocPolicy = new DocCommentPanel(JavaBundle.message((String)"encapsulate.fields.dialog.javadoc.title", (Object[])new Object[0]));
        encapsulateBox.add((Component)this.myJavadocPolicy, "East");
        boolean hasJavadoc = false;
        for (PsiField field : this.myFields) {
            if (field.getDocComment() == null) continue;
            hasJavadoc = true;
            break;
        }
        this.myJavadocPolicy.setVisible(hasJavadoc);
        JBBox fieldsBox = JBBox.createVerticalBox();
        fieldsBox.add((Component)this.myRbFieldPrivate);
        fieldsBox.add((Component)this.myRbFieldPackageLocal);
        fieldsBox.add((Component)this.myRbFieldProtected);
        fieldsBox.add((Component)this.myRbFieldAsIs);
        JPanel fieldsVisibilityPanel = new JPanel(new BorderLayout());
        fieldsVisibilityPanel.setBorder(IdeBorderFactory.createTitledBorder((String)JavaRefactoringBundle.message((String)"encapsulate.fields..encapsulated.fields.visibility.border.title", (Object[])new Object[0])));
        fieldsVisibilityPanel.add((Component)fieldsBox, "Center");
        fieldsVisibilityPanel.add(Box.createHorizontalStrut(5), "West");
        JBBox methodsBox = JBBox.createVerticalBox();
        methodsBox.add((Component)this.myRbAccessorPublic);
        methodsBox.add((Component)this.myRbAccessorProtected);
        methodsBox.add((Component)this.myRbAccessorPackageLocal);
        methodsBox.add((Component)this.myRbAccessorPrivate);
        JPanel methodsVisibilityPanel = new JPanel(new BorderLayout());
        methodsVisibilityPanel.setBorder(IdeBorderFactory.createTitledBorder((String)JavaRefactoringBundle.message((String)"encapsulate.fields.accessors.visibility.border.title", (Object[])new Object[0])));
        methodsVisibilityPanel.add((Component)methodsBox, "Center");
        methodsVisibilityPanel.add(Box.createHorizontalStrut(5), "West");
        JBBox visibilityBox = JBBox.createHorizontalBox();
        visibilityBox.add((Component)fieldsVisibilityPanel);
        visibilityBox.add(Box.createHorizontalStrut(5));
        visibilityBox.add((Component)methodsVisibilityPanel);
        JBBox box = JBBox.createVerticalBox();
        box.add((Component)encapsulateBox);
        box.add(Box.createVerticalStrut(5));
        box.add((Component)visibilityBox);
        JPanel boxPanel = new JPanel(new BorderLayout());
        boxPanel.add((Component)box, "Center");
        boxPanel.add(Box.createVerticalStrut(5), "North");
        panel.add((Component)boxPanel, "South");
        return panel;
    }

    private JComponent createTable() {
        this.myTableModel = new MyTableModel();
        this.myTable = new JBTable((TableModel)this.myTableModel);
        this.myTable.setSurrendersFocusOnKeystroke(true);
        MyTableRenderer renderer = new MyTableRenderer();
        TableColumnModel columnModel = this.myTable.getColumnModel();
        columnModel.getColumn(0).setCellRenderer((TableCellRenderer)new BooleanTableCellRenderer());
        columnModel.getColumn(1).setCellRenderer(renderer);
        columnModel.getColumn(2).setCellRenderer(renderer);
        columnModel.getColumn(3).setCellRenderer(renderer);
        TableUtil.setupCheckboxColumn((TableColumn)columnModel.getColumn(0));
        this.myTable.setPreferredScrollableViewportSize((Dimension)JBUI.size((int)550, (int)-1));
        this.myTable.setVisibleRowCount(12);
        this.myTable.getSelectionModel().setSelectionMode(2);
        JScrollPane scrollPane = ScrollPaneFactory.createScrollPane((Component)this.myTable);
        JPanel panel = new JPanel(new BorderLayout());
        IdeaTitledBorder border = IdeBorderFactory.createTitledBorder((String)JavaRefactoringBundle.message((String)"encapsulate.fields.fields.to.encapsulate.border.title", (Object[])new Object[0]), (boolean)false);
        panel.setBorder((Border)border);
        panel.add(scrollPane);
        this.myTable.registerKeyboardAction(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TableCellEditor editor = EncapsulateFieldsDialog.this.myTable.getCellEditor();
                if (editor != null) {
                    editor.cancelCellEditing();
                } else {
                    EncapsulateFieldsDialog.this.doCancelAction();
                }
            }
        }, KeyStroke.getKeyStroke(27, 0), 1);
        @NonNls InputMap inputMap = this.myTable.getInputMap();
        inputMap.put(KeyStroke.getKeyStroke(32, 0), "enable_disable");
        @NonNls ActionMap actionMap = this.myTable.getActionMap();
        actionMap.put("enable_disable", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (EncapsulateFieldsDialog.this.myTable.isEditing()) {
                    return;
                }
                int[] rows = EncapsulateFieldsDialog.this.myTable.getSelectedRows();
                if (rows.length > 0) {
                    boolean valueToBeSet = false;
                    for (int row : rows) {
                        if (EncapsulateFieldsDialog.this.myCheckedMarks[row]) continue;
                        valueToBeSet = true;
                        break;
                    }
                    for (int row : rows) {
                        EncapsulateFieldsDialog.this.myCheckedMarks[row] = valueToBeSet;
                    }
                    EncapsulateFieldsDialog.this.myTableModel.fireTableRowsUpdated(rows[0], rows[rows.length - 1]);
                    TableUtil.selectRows((JTable)EncapsulateFieldsDialog.this.myTable, (int[])rows);
                }
            }
        });
        inputMap.put(KeyStroke.getKeyStroke(10, 0), "invokeImpl");
        actionMap.put("invokeImpl", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TableCellEditor editor = EncapsulateFieldsDialog.this.myTable.getCellEditor();
                if (editor != null) {
                    editor.stopCellEditing();
                } else {
                    EncapsulateFieldsDialog.this.clickDefaultButton();
                }
            }
        });
        return panel;
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myTable;
    }

    protected void doAction() {
        String errorString;
        TableCellEditor editor;
        if (this.myTable.isEditing() && (editor = this.myTable.getCellEditor()) != null) {
            editor.stopCellEditing();
        }
        if ((errorString = this.validateData()) != null) {
            CommonRefactoringUtil.showErrorMessage((String)EncapsulateFieldsDialog.getRefactoringName(), (String)errorString, (String)"refactoring.encapsulateFields", (Project)this.myProject);
            return;
        }
        if (this.getCheckedRows().length == 0) {
            String noTargetMessage = JavaRefactoringBundle.message((String)"encapsulate.fields.no.target", (Object[])new Object[0]);
            CommonRefactoringUtil.showErrorMessage((String)EncapsulateFieldsDialog.getRefactoringName(), (String)noTargetMessage, (String)"refactoring.encapsulateFields", (Project)this.myProject);
            return;
        }
        EncapsulateFieldsProcessor processor = (EncapsulateFieldsProcessor)((Object)ActionUtil.underModalProgress((Project)this.myProject, (String)CodeInsightBundle.message((String)"progress.title.resolving.reference", (Object[])new Object[0]), () -> new EncapsulateFieldsProcessor(this.myProject, this)));
        this.invokeRefactoring(processor);
        JavaRefactoringSettings settings = JavaRefactoringSettings.getInstance();
        settings.ENCAPSULATE_FIELDS_USE_ACCESSORS_WHEN_ACCESSIBLE = this.myCbUseAccessorsWhenAccessible.isSelected();
    }

    @NlsContexts.DialogMessage
    private String validateData() {
        PsiManager manager = PsiManager.getInstance((Project)this.myProject);
        for (int idx = 0; idx < this.myFields.length; ++idx) {
            String name;
            if (!this.myCheckedMarks[idx]) continue;
            if (this.isToEncapsulateGet()) {
                name = this.myGetterNames[idx];
                if (!PsiNameHelper.getInstance((Project)manager.getProject()).isIdentifier(name)) {
                    return RefactoringMessageUtil.getIncorrectIdentifierMessage((String)name);
                }
            }
            if (this.myFinalMarks[idx] || !this.isToEncapsulateSet()) continue;
            name = this.mySetterNames[idx];
            if (PsiNameHelper.getInstance((Project)manager.getProject()).isIdentifier(name)) continue;
            return RefactoringMessageUtil.getIncorrectIdentifierMessage((String)name);
        }
        return null;
    }

    protected boolean areButtonsValid() {
        return this.getCheckedRows().length > 0;
    }

    private int[] getCheckedRows() {
        int count = 0;
        for (boolean checkedMark : this.myCheckedMarks) {
            if (!checkedMark) continue;
            ++count;
        }
        int[] rows = new int[count];
        int currentRow = 0;
        for (int idx = 0; idx < this.myCheckedMarks.length; ++idx) {
            if (!this.myCheckedMarks[idx]) continue;
            rows[currentRow++] = idx;
        }
        return rows;
    }

    protected String getHelpId() {
        return "refactoring.encapsulateFields";
    }

    @NlsContexts.DialogTitle
    private static String getRefactoringName() {
        return JavaRefactoringBundle.message((String)"encapsulate.fields.title", (Object[])new Object[0]);
    }

    public record EncapsulateFieldsContainer(EncapsulateFieldHelper myHelper, PsiClass myClass, PsiField[] myFields, Map<PsiField, Icon> myIconFields, boolean[] myCheckedMarks, boolean[] myFinalMarks, String[] myFieldNames, String[] myGetterNames, PsiMethod[] myGetterPrototypes, Map<Integer, RowIcon> myGetterPrototypesIcons, String[] mySetterNames, PsiMethod[] mySetterPrototypes, Map<Integer, RowIcon> mySetterPrototypesIcons) {
        static EncapsulateFieldsContainer create(@NotNull PsiClass aClass, @NotNull Set preselectedFields, @NotNull EncapsulateFieldHelper helper) {
            PsiMethod prototype;
            int i;
            if (aClass == null) {
                EncapsulateFieldsContainer.$$$reportNull$$$0(0);
            }
            if (preselectedFields == null) {
                EncapsulateFieldsContainer.$$$reportNull$$$0(1);
            }
            if (helper == null) {
                EncapsulateFieldsContainer.$$$reportNull$$$0(2);
            }
            PsiClass myClass = aClass;
            EncapsulateFieldHelper myHelper = helper;
            PsiField[] myFields = helper.getApplicableFields(myClass);
            HashMap<PsiField, Icon> myIconFields = new HashMap<PsiField, Icon>();
            for (PsiField field : myFields) {
                myIconFields.put(field, field.getIcon(1));
            }
            String[] myFieldNames = new String[myFields.length];
            boolean[] myCheckedMarks = new boolean[myFields.length];
            boolean[] myFinalMarks = new boolean[myFields.length];
            String[] myGetterNames = new String[myFields.length];
            String[] mySetterNames = new String[myFields.length];
            PsiMethod[] myGetterPrototypes = new PsiMethod[myFields.length];
            PsiMethod[] mySetterPrototypes = new PsiMethod[myFields.length];
            for (int idx = 0; idx < myFields.length; ++idx) {
                PsiField field = myFields[idx];
                myCheckedMarks[idx] = preselectedFields.contains(field);
                myFinalMarks[idx] = field.hasModifierProperty("final");
                myFieldNames[idx] = PsiFormatUtil.formatVariable((PsiVariable)field, (int)7, (PsiSubstitutor)PsiSubstitutor.EMPTY);
                myGetterNames[idx] = myHelper.suggestGetterName(field);
                mySetterNames[idx] = myHelper.suggestSetterName(field);
                myGetterPrototypes[idx] = myHelper.generateMethodPrototype(field, myGetterNames[idx], true);
                mySetterPrototypes[idx] = myHelper.generateMethodPrototype(field, mySetterNames[idx], false);
            }
            HashMap<Integer, RowIcon> myGetterPrototypesIcons = new HashMap<Integer, RowIcon>();
            HashMap<Integer, RowIcon> mySetterPrototypesIcons = new HashMap<Integer, RowIcon>();
            for (i = 0; i < myGetterPrototypes.length; ++i) {
                prototype = myGetterPrototypes[i];
                myGetterPrototypesIcons.put(i, EncapsulateFieldsContainer.getIcon(prototype, myClass));
            }
            for (i = 0; i < mySetterPrototypes.length; ++i) {
                prototype = mySetterPrototypes[i];
                mySetterPrototypesIcons.put(i, EncapsulateFieldsContainer.getIcon(prototype, myClass));
            }
            return new EncapsulateFieldsContainer(myHelper, myClass, myFields, myIconFields, myCheckedMarks, myFinalMarks, myFieldNames, myGetterNames, myGetterPrototypes, myGetterPrototypesIcons, mySetterNames, mySetterPrototypes, mySetterPrototypesIcons);
        }

        @NotNull
        private static RowIcon getIcon(@Nullable PsiMethod prototype, @Nullable PsiClass psiClass) {
            Icon methodIcon = IconUtil.getEmptyIcon((boolean)true);
            Icon overrideIcon = EmptyIcon.ICON_16;
            if (prototype != null && psiClass != null) {
                PsiMethod[] superMethods;
                PsiMethod existing = psiClass.findMethodBySignature(prototype, false);
                if (existing != null) {
                    methodIcon = existing.getIcon(1);
                }
                if ((superMethods = prototype.findSuperMethods(psiClass)).length > 0) {
                    overrideIcon = !superMethods[0].hasModifierProperty("abstract") ? AllIcons.General.OverridingMethod : AllIcons.General.ImplementingMethod;
                }
            }
            RowIcon rowIcon = IconManager.getInstance().createRowIcon(new Icon[]{methodIcon, overrideIcon});
            if (rowIcon == null) {
                EncapsulateFieldsContainer.$$$reportNull$$$0(3);
            }
            return rowIcon;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 3 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "aClass";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "preselectedFields";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "helper";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/refactoring/encapsulateFields/EncapsulateFieldsDialog$EncapsulateFieldsContainer";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/refactoring/encapsulateFields/EncapsulateFieldsDialog$EncapsulateFieldsContainer";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getIcon";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "create";
                    break;
                }
                case 3: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 3 -> new IllegalStateException(string);
            };
        }
    }

    private class MyTableModel
    extends AbstractTableModel {
        private MyTableModel() {
        }

        @Override
        public int getColumnCount() {
            return 4;
        }

        @Override
        public int getRowCount() {
            return EncapsulateFieldsDialog.this.myFields.length;
        }

        public Class getColumnClass(int columnIndex) {
            if (columnIndex == 0) {
                return Boolean.class;
            }
            return super.getColumnClass(columnIndex);
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            return switch (columnIndex) {
                case 0 -> EncapsulateFieldsDialog.this.myCheckedMarks[rowIndex];
                case 1 -> EncapsulateFieldsDialog.this.myFieldNames[rowIndex];
                case 2 -> EncapsulateFieldsDialog.this.myGetterNames[rowIndex];
                case 3 -> EncapsulateFieldsDialog.this.mySetterNames[rowIndex];
                default -> throw new RuntimeException("Incorrect column index");
            };
        }

        @Override
        public String getColumnName(int column) {
            return switch (column) {
                case 0 -> " ";
                case 1 -> JavaRefactoringBundle.message((String)"encapsulate.fields.field.column.name", (Object[])new Object[0]);
                case 2 -> JavaRefactoringBundle.message((String)"encapsulate.fields.getter.column.name", (Object[])new Object[0]);
                case 3 -> JavaRefactoringBundle.message((String)"encapsulate.fields.setter.column.name", (Object[])new Object[0]);
                default -> throw new RuntimeException("Incorrect column index");
            };
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            if (columnIndex == 0) {
                return true;
            }
            if (EncapsulateFieldsDialog.this.myCheckedMarks[rowIndex]) {
                if (columnIndex == 2 && EncapsulateFieldsDialog.this.myCbEncapsulateGet.isSelected()) {
                    return true;
                }
                if (columnIndex == 3 && !EncapsulateFieldsDialog.this.myFinalMarks[rowIndex] && EncapsulateFieldsDialog.this.myCbEncapsulateSet.isSelected()) {
                    return true;
                }
            }
            return false;
        }

        @Override
        public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
            if (columnIndex == 0) {
                EncapsulateFieldsDialog.this.myCheckedMarks[rowIndex] = (Boolean)aValue;
                this.fireTableRowsUpdated(rowIndex, rowIndex);
            } else {
                String name = (String)aValue;
                PsiField field = EncapsulateFieldsDialog.this.myFields[rowIndex];
                switch (columnIndex) {
                    case 2: {
                        EncapsulateFieldsDialog.this.myGetterNames[rowIndex] = name;
                        break;
                    }
                    case 3: {
                        EncapsulateFieldsDialog.this.mySetterNames[rowIndex] = name;
                        break;
                    }
                    default: {
                        throw new RuntimeException("Incorrect column index");
                    }
                }
                ReadAction.nonBlocking(() -> {
                    switch (columnIndex) {
                        case 2: {
                            PsiMethod method = EncapsulateFieldsDialog.this.myHelper.generateMethodPrototype(field, name, true);
                            if (method != null) {
                                EncapsulateFieldsDialog.this.myGetterPrototypes.put(rowIndex, method);
                            }
                            EncapsulateFieldsDialog.this.myGetterPrototypesIcons.put(rowIndex, EncapsulateFieldsContainer.getIcon(EncapsulateFieldsDialog.this.myGetterPrototypes.get(rowIndex), EncapsulateFieldsDialog.this.myClass));
                            break;
                        }
                        case 3: {
                            PsiMethod method = EncapsulateFieldsDialog.this.myHelper.generateMethodPrototype(field, name, false);
                            if (method != null) {
                                EncapsulateFieldsDialog.this.mySetterPrototypes.put(rowIndex, method);
                            }
                            EncapsulateFieldsDialog.this.mySetterPrototypesIcons.put(rowIndex, EncapsulateFieldsContainer.getIcon(EncapsulateFieldsDialog.this.mySetterPrototypes.get(rowIndex), EncapsulateFieldsDialog.this.myClass));
                            break;
                        }
                        default: {
                            throw new RuntimeException("Incorrect column index");
                        }
                    }
                    return null;
                }).finishOnUiThread(ModalityState.stateForComponent((Component)EncapsulateFieldsDialog.this.myTable), nill -> EncapsulateFieldsDialog.this.repaint()).expireWith(EncapsulateFieldsDialog.this.getDisposable()).submit((Executor)AppExecutorUtil.getAppExecutorService());
            }
        }
    }

    private class MyTableRenderer
    extends DefaultTableCellRenderer {
        private MyTableRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            int modelColumn = EncapsulateFieldsDialog.this.myTable.convertColumnIndexToModel(column);
            this.setIconTextGap(0);
            PsiField field = EncapsulateFieldsDialog.this.myFields[row];
            switch (modelColumn) {
                case 1: {
                    Icon icon = EncapsulateFieldsDialog.this.myIconFields.get(field);
                    if (icon != null) {
                        this.setIcon(icon);
                        this.setDisabledIcon(icon);
                    }
                    this.configureColors(isSelected, table, hasFocus, row, column);
                    break;
                }
                case 2: 
                case 3: {
                    RowIcon rowIcon;
                    PsiMethod prototype = modelColumn == 2 ? EncapsulateFieldsDialog.this.myGetterPrototypes.get(row) : EncapsulateFieldsDialog.this.mySetterPrototypes.get(row);
                    RowIcon rowIcon2 = rowIcon = modelColumn == 2 ? EncapsulateFieldsDialog.this.myGetterPrototypesIcons.get(row) : EncapsulateFieldsDialog.this.mySetterPrototypesIcons.get(row);
                    if (prototype != null) {
                        this.configureColors(isSelected, table, hasFocus, row, column);
                    } else {
                        this.setForeground((Color)JBColor.RED);
                    }
                    if (rowIcon == null) break;
                    this.setIcon((Icon)rowIcon);
                    this.setDisabledIcon((Icon)rowIcon);
                    break;
                }
                default: {
                    this.setIcon(null);
                    this.setDisabledIcon(null);
                }
            }
            boolean enabled = EncapsulateFieldsDialog.this.myCheckedMarks[row];
            if (enabled) {
                if (modelColumn == 2) {
                    enabled = EncapsulateFieldsDialog.this.myCbEncapsulateGet.isSelected();
                } else if (modelColumn == 3) {
                    enabled = !EncapsulateFieldsDialog.this.myFinalMarks[row] && EncapsulateFieldsDialog.this.myCbEncapsulateSet.isSelected();
                }
            }
            this.setEnabled(enabled);
            return this;
        }

        private void configureColors(boolean isSelected, JTable table, boolean hasFocus, int row, int column) {
            this.setForeground(isSelected ? UIUtil.getTableSelectionForeground((boolean)true) : UIUtil.getTableForeground());
            this.setBackground(isSelected ? UIUtil.getTableSelectionBackground((boolean)true) : UIUtil.getTableBackground());
            if (hasFocus && table.isCellEditable(row, column)) {
                super.setForeground(UIUtil.getTableFocusCellForeground());
                super.setBackground(UIUtil.getTableFocusCellBackground());
            }
        }
    }
}

