/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.encapsulateFields;

import com.intellij.codeInsight.generation.GenerateMembersUtil;
import com.intellij.codeInsight.intention.preview.IntentionPreviewInfo;
import com.intellij.java.refactoring.JavaRefactoringBundle;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiEnumConstant;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.refactoring.PreviewableRefactoringActionHandler;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.encapsulateFields.EncapsulateFieldsDescriptor;
import com.intellij.refactoring.encapsulateFields.EncapsulateFieldsDialog;
import com.intellij.refactoring.encapsulateFields.EncapsulateFieldsProcessor;
import com.intellij.refactoring.encapsulateFields.FieldDescriptor;
import com.intellij.refactoring.encapsulateFields.FieldDescriptorImpl;
import com.intellij.refactoring.encapsulateFields.JavaEncapsulateFieldHelper;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.containers.ContainerUtil;
import com.siyeh.ig.psiutils.VariableAccessUtils;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Executor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;

public class EncapsulateFieldsHandler
implements PreviewableRefactoringActionHandler {
    private static final Logger LOG = Logger.getInstance(EncapsulateFieldsHandler.class);

    public void invoke(@NotNull Project project, Editor editor, PsiFile file, DataContext dataContext) {
        if (project == null) {
            EncapsulateFieldsHandler.$$$reportNull$$$0(0);
        }
        editor.getScrollingModel().scrollToCaret(ScrollType.MAKE_VISIBLE);
        List elements = CommonRefactoringUtil.findElementsFromCaretsAndSelections((Editor)editor, (PsiFile)file, null, e -> {
            PsiField field;
            return e instanceof PsiField && (field = (PsiField)e).getContainingClass() != null || e instanceof PsiClass;
        });
        if (elements.isEmpty()) {
            String message = RefactoringBundle.getCannotRefactorMessage((String)RefactoringBundle.message((String)"error.wrong.caret.position.class"));
            CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)message, (String)EncapsulateFieldsHandler.getRefactoringName(), (String)"refactoring.encapsulateFields");
            return;
        }
        this.invoke(project, elements.toArray(PsiElement.EMPTY_ARRAY), dataContext);
    }

    public void invoke(@NotNull Project project, PsiElement @NotNull [] elements, DataContext dataContext) {
        if (project == null) {
            EncapsulateFieldsHandler.$$$reportNull$$$0(1);
        }
        if (elements == null) {
            EncapsulateFieldsHandler.$$$reportNull$$$0(2);
        }
        if (elements.length == 0) {
            return;
        }
        PsiElement containingClass = elements[0];
        if (containingClass instanceof PsiField) {
            PsiField field = (PsiField)containingClass;
            containingClass = field.getContainingClass();
        }
        if (!(containingClass instanceof PsiClass)) {
            return;
        }
        PsiElement finalContainingClass = containingClass;
        ArrayList<SmartPsiElementPointer> smartElements = new ArrayList<SmartPsiElementPointer>();
        SmartPointerManager smartPointerManager = SmartPointerManager.getInstance((Project)project);
        for (PsiElement psiElement : elements) {
            if (psiElement == null) continue;
            smartElements.add(smartPointerManager.createSmartPsiElementPointer(psiElement));
        }
        ReadAction.nonBlocking(() -> {
            PsiClass aClass = null;
            HashSet<PsiField> preselectedFields = new HashSet<PsiField>();
            if (smartElements.size() == 1) {
                PsiElement element = ((SmartPsiElementPointer)smartElements.get(0)).getElement();
                if (element == null) {
                    return null;
                }
                if (element instanceof PsiClass) {
                    aClass = (PsiClass)elements[0];
                } else {
                    if (!(element instanceof PsiField)) return null;
                    PsiField field2 = (PsiField)element;
                    aClass = field2.getContainingClass();
                    preselectedFields.add(field2);
                }
            } else {
                for (SmartPsiElementPointer smartElement : smartElements) {
                    PsiElement element = smartElement.getElement();
                    if (element == null) {
                        return null;
                    }
                    if (!(element instanceof PsiField)) return null;
                    PsiField field3 = (PsiField)element;
                    if (aClass == null) {
                        aClass = field3.getContainingClass();
                        preselectedFields.add(field3);
                        continue;
                    }
                    if (!aClass.equals((Object)field3.getContainingClass())) return () -> {
                        String message = RefactoringBundle.getCannotRefactorMessage((String)JavaRefactoringBundle.message((String)"fields.to.be.refactored.should.belong.to.the.same.class", (Object[])new Object[0]));
                        Editor editor = (Editor)CommonDataKeys.EDITOR.getData(dataContext);
                        CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)message, (String)EncapsulateFieldsHandler.getRefactoringName(), (String)"refactoring.encapsulateFields");
                    };
                    preselectedFields.add(field3);
                }
            }
            LOG.assertTrue(aClass != null);
            List fields = ContainerUtil.filter((Object[])aClass.getFields(), field -> !(field instanceof PsiEnumConstant));
            if (fields.isEmpty()) {
                return () -> CommonRefactoringUtil.showErrorHint((Project)project, (Editor)((Editor)CommonDataKeys.EDITOR.getData(dataContext)), (String)JavaRefactoringBundle.message((String)"encapsulate.fields.nothing.todo.warning.message", (Object[])new Object[0]), (String)EncapsulateFieldsHandler.getRefactoringName(), (String)"refactoring.encapsulateFields");
            }
            if (aClass.isInterface()) {
                return () -> {
                    String message = RefactoringBundle.getCannotRefactorMessage((String)JavaRefactoringBundle.message((String)"encapsulate.fields.refactoring.cannot.be.applied.to.interface", (Object[])new Object[0]));
                    Editor editor = (Editor)CommonDataKeys.EDITOR.getData(dataContext);
                    CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)message, (String)EncapsulateFieldsHandler.getRefactoringName(), (String)"refactoring.encapsulateFields");
                };
            }
            EncapsulateFieldsDialog.EncapsulateFieldsContainer container = EncapsulateFieldsHandler.prepare(aClass, preselectedFields);
            PsiClass finalAClass = aClass;
            return () -> {
                EncapsulateFieldsDialog dialog = EncapsulateFieldsHandler.getDialog(project, container);
                if (!CommonRefactoringUtil.checkReadOnlyStatus((Project)project, (PsiElement)finalAClass)) {
                    return;
                }
                dialog.show();
            };
        }).finishOnUiThread(ModalityState.defaultModalityState(), callback -> {
            if (callback != null) {
                callback.run();
            }
        }).expireWhen(() -> !finalContainingClass.isValid()).submit((Executor)AppExecutorUtil.getAppExecutorService());
    }

    @NotNull
    private static EncapsulateFieldsDialog.EncapsulateFieldsContainer prepare(@NotNull PsiClass aClass, @NotNull Set<PsiField> preselectedFields) {
        if (aClass == null) {
            EncapsulateFieldsHandler.$$$reportNull$$$0(3);
        }
        if (preselectedFields == null) {
            EncapsulateFieldsHandler.$$$reportNull$$$0(4);
        }
        EncapsulateFieldsDialog.EncapsulateFieldsContainer encapsulateFieldsContainer = EncapsulateFieldsDialog.EncapsulateFieldsContainer.create(aClass, preselectedFields, new JavaEncapsulateFieldHelper());
        if (encapsulateFieldsContainer == null) {
            EncapsulateFieldsHandler.$$$reportNull$$$0(5);
        }
        return encapsulateFieldsContainer;
    }

    protected static EncapsulateFieldsDialog createDialog(@Nullable Project project, @NotNull PsiClass aClass, @NotNull Set<PsiField> preselectedFields) {
        if (aClass == null) {
            EncapsulateFieldsHandler.$$$reportNull$$$0(6);
        }
        if (preselectedFields == null) {
            EncapsulateFieldsHandler.$$$reportNull$$$0(7);
        }
        EncapsulateFieldsDialog.EncapsulateFieldsContainer container = EncapsulateFieldsHandler.prepare(aClass, preselectedFields);
        return EncapsulateFieldsHandler.getDialog(project, container);
    }

    @NotNull
    private static EncapsulateFieldsDialog getDialog(@Nullable Project project, @NotNull EncapsulateFieldsDialog.EncapsulateFieldsContainer container) {
        if (container == null) {
            EncapsulateFieldsHandler.$$$reportNull$$$0(8);
        }
        return new EncapsulateFieldsDialog(project, container);
    }

    @NotNull
    public IntentionPreviewInfo generatePreview(@NotNull Project project, @NotNull PsiElement element) {
        if (project == null) {
            EncapsulateFieldsHandler.$$$reportNull$$$0(9);
        }
        if (element == null) {
            EncapsulateFieldsHandler.$$$reportNull$$$0(10);
        }
        if (!(element instanceof PsiField)) {
            IntentionPreviewInfo intentionPreviewInfo = IntentionPreviewInfo.EMPTY;
            if (intentionPreviewInfo == null) {
                EncapsulateFieldsHandler.$$$reportNull$$$0(11);
            }
            return intentionPreviewInfo;
        }
        PsiField field = (PsiField)element;
        FieldDescriptorImpl fieldDescriptor = new FieldDescriptorImpl(field, GenerateMembersUtil.suggestGetterName((PsiField)field), GenerateMembersUtil.suggestSetterName((PsiField)field), GenerateMembersUtil.generateGetterPrototype((PsiField)field), GenerateMembersUtil.generateSetterPrototype((PsiField)field));
        EncapsulateOnPreviewDescriptor descriptor = new EncapsulateOnPreviewDescriptor(fieldDescriptor);
        EncapsulateFieldsProcessor processor = new EncapsulateFieldsProcessor(this, project, descriptor){

            protected @Unmodifiable Iterable<PsiReferenceExpression> getFieldReferences(@NotNull PsiField field) {
                if (field == null) {
                    1.$$$reportNull$$$0(0);
                }
                return VariableAccessUtils.getVariableReferences((PsiVariable)field);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "field", "com/intellij/refactoring/encapsulateFields/EncapsulateFieldsHandler$1", "getFieldReferences"));
            }
        };
        processor.performRefactoring(processor.findUsages());
        IntentionPreviewInfo intentionPreviewInfo = IntentionPreviewInfo.DIFF;
        if (intentionPreviewInfo == null) {
            EncapsulateFieldsHandler.$$$reportNull$$$0(12);
        }
        return intentionPreviewInfo;
    }

    @NlsContexts.DialogTitle
    public static String getRefactoringName() {
        return JavaRefactoringBundle.message((String)"encapsulate.fields.title", (Object[])new Object[0]);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 5, 11, 12 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "preselectedFields";
                break;
            }
            case 5: 
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/refactoring/encapsulateFields/EncapsulateFieldsHandler";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "container";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/refactoring/encapsulateFields/EncapsulateFieldsHandler";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "prepare";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "generatePreview";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "prepare";
                break;
            }
            case 5: 
            case 11: 
            case 12: {
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "createDialog";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getDialog";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "generatePreview";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 5, 11, 12 -> new IllegalStateException(string);
        };
    }

    private static class EncapsulateOnPreviewDescriptor
    implements EncapsulateFieldsDescriptor {
        private final FieldDescriptor myFieldDescriptor;

        EncapsulateOnPreviewDescriptor(FieldDescriptor fieldDescriptor) {
            this.myFieldDescriptor = fieldDescriptor;
        }

        public FieldDescriptor[] getSelectedFields() {
            return new FieldDescriptor[]{this.myFieldDescriptor};
        }

        public boolean isToEncapsulateGet() {
            return true;
        }

        public boolean isToEncapsulateSet() {
            return true;
        }

        public boolean isToUseAccessorsWhenAccessible() {
            return true;
        }

        public String getFieldsVisibility() {
            return "private";
        }

        public String getAccessorsVisibility() {
            return "public";
        }

        public int getJavadocPolicy() {
            return 1;
        }

        public PsiClass getTargetClass() {
            return this.myFieldDescriptor.getField().getContainingClass();
        }
    }
}

