/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.extractInterface;

import com.intellij.history.LocalHistory;
import com.intellij.history.LocalHistoryAction;
import com.intellij.lang.ContextAwareActionHandler;
import com.intellij.lang.findUsages.DescriptiveNameUtil;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.psi.JavaDirectoryService;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiImplicitClass;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiReferenceList;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.actions.RefactoringActionContextUtil;
import com.intellij.refactoring.extractInterface.ExtractClassUtil;
import com.intellij.refactoring.extractInterface.ExtractInterfaceDialog;
import com.intellij.refactoring.extractSuperclass.ExtractSuperClassUtil;
import com.intellij.refactoring.lang.ElementsHandler;
import com.intellij.refactoring.listeners.RefactoringEventListener;
import com.intellij.refactoring.memberPullUp.PullUpProcessor;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.refactoring.util.DocCommentPolicy;
import com.intellij.refactoring.util.classMembers.MemberInfo;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class ExtractInterfaceHandler
implements ElementsHandler,
ContextAwareActionHandler {
    private PsiClass myClass;
    private String myInterfaceName;
    private MemberInfo[] mySelectedMembers;
    private PsiDirectory myTargetDir;
    private DocCommentPolicy myJavaDocPolicy;

    public boolean isAvailableForQuickList(@NotNull Editor editor, @NotNull PsiFile file, @NotNull DataContext dataContext) {
        if (editor == null) {
            ExtractInterfaceHandler.$$$reportNull$$$0(0);
        }
        if (file == null) {
            ExtractInterfaceHandler.$$$reportNull$$$0(1);
        }
        if (dataContext == null) {
            ExtractInterfaceHandler.$$$reportNull$$$0(2);
        }
        return RefactoringActionContextUtil.isOutsideModuleAndCodeBlock(editor, file);
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile file, DataContext dataContext) {
        if (project == null) {
            ExtractInterfaceHandler.$$$reportNull$$$0(3);
        }
        editor.getScrollingModel().scrollToCaret(ScrollType.MAKE_VISIBLE);
        List elements = CommonRefactoringUtil.findElementsFromCaretsAndSelections((Editor)editor, (PsiFile)file, null, e -> {
            PsiMember member;
            return e instanceof PsiMember && !((member = (PsiMember)e).getContainingClass() instanceof PsiAnonymousClass);
        });
        if (elements.isEmpty()) {
            String message = RefactoringBundle.getCannotRefactorMessage((String)RefactoringBundle.message((String)"error.wrong.caret.position.class"));
            CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)message, (String)ExtractInterfaceHandler.getRefactoringName(), (String)"refactoring.extractInterface");
            return;
        }
        this.invoke(project, elements.toArray(PsiElement.EMPTY_ARRAY), dataContext);
    }

    public void invoke(@NotNull Project project, PsiElement @NotNull [] elements, DataContext dataContext) {
        String message;
        PsiClass aClass;
        PsiElement parent;
        if (project == null) {
            ExtractInterfaceHandler.$$$reportNull$$$0(4);
        }
        if (elements == null) {
            ExtractInterfaceHandler.$$$reportNull$$$0(5);
        }
        PsiClass psiClass = this.myClass = (parent = PsiTreeUtil.findCommonParent((PsiElement[])elements)) instanceof PsiClass ? (aClass = (PsiClass)parent) : (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)parent, PsiClass.class, (boolean)false);
        if (this.myClass == null) {
            message = RefactoringBundle.message((String)"error.select.class.to.be.refactored");
            CommonRefactoringUtil.showErrorHint((Project)project, null, (String)message, (String)ExtractInterfaceHandler.getRefactoringName(), (String)"refactoring.extractInterface");
            return;
        }
        if (this.myClass instanceof PsiImplicitClass) {
            message = RefactoringBundle.message((String)"error.interface.cannot.be.extracted.from.implicit.class");
            CommonRefactoringUtil.showErrorHint((Project)project, null, (String)message, (String)ExtractInterfaceHandler.getRefactoringName(), (String)"refactoring.extractInterface");
            return;
        }
        if (!CommonRefactoringUtil.checkReadOnlyStatus((Project)project, (PsiElement)this.myClass)) {
            return;
        }
        HashSet<PsiElement> selectedMembers = new HashSet<PsiElement>();
        Collections.addAll(selectedMembers, elements);
        ExtractInterfaceDialog dialog = new ExtractInterfaceDialog(project, this.myClass, selectedMembers);
        if (!dialog.showAndGet() || !dialog.isExtractSuperclass()) {
            return;
        }
        MultiMap conflicts = new MultiMap();
        ExtractSuperClassUtil.checkSuperAccessible(dialog.getTargetDirectory(), (MultiMap<PsiElement, String>)conflicts, this.myClass);
        if (!ExtractSuperClassUtil.showConflicts((DialogWrapper)dialog, (MultiMap<PsiElement, String>)conflicts, project)) {
            return;
        }
        PsiClass anInterface = (PsiClass)WriteCommandAction.writeCommandAction((Project)project).withName(ExtractInterfaceHandler.getRefactoringName()).compute(() -> {
            this.myInterfaceName = dialog.getExtractedSuperName();
            this.mySelectedMembers = dialog.getSelectedMemberInfos().toArray(new MemberInfo[0]);
            this.myTargetDir = dialog.getTargetDirectory();
            this.myJavaDocPolicy = new DocCommentPolicy(dialog.getDocCommentPolicy());
            LocalHistoryAction a = LocalHistory.getInstance().startAction(this.getCommandName());
            try {
                PsiClass psiClass = ExtractInterfaceHandler.extractInterface(this.myTargetDir, this.myClass, this.myInterfaceName, this.mySelectedMembers, this.myJavaDocPolicy);
                return psiClass;
            }
            finally {
                a.finish();
            }
        });
        ExtractClassUtil.askAndTurnRefsToSuper(this.myClass, anInterface);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static PsiClass extractInterface(PsiDirectory targetDir, PsiClass aClass, String interfaceName, MemberInfo[] selectedMembers, DocCommentPolicy javaDocPolicy) {
        Project project = aClass.getProject();
        ((RefactoringEventListener)project.getMessageBus().syncPublisher(RefactoringEventListener.REFACTORING_EVENT_TOPIC)).refactoringStarted("refactoring.extractSuper", ExtractSuperClassUtil.createBeforeData(aClass, selectedMembers));
        PsiClass anInterface = JavaDirectoryService.getInstance().createInterface(targetDir, interfaceName);
        try {
            PsiReferenceList referenceList;
            PsiJavaCodeReferenceElement ref = ExtractSuperClassUtil.createExtendingReference(anInterface, aClass, selectedMembers);
            PsiReferenceList psiReferenceList = referenceList = aClass.isInterface() ? aClass.getExtendsList() : aClass.getImplementsList();
            assert (referenceList != null);
            CodeStyleManager.getInstance((Project)project).reformat(referenceList.add((PsiElement)ref));
            PullUpProcessor pullUpHelper = new PullUpProcessor(aClass, anInterface, selectedMembers, javaDocPolicy);
            pullUpHelper.moveMembersToBase();
            PsiClass psiClass = anInterface;
            return psiClass;
        }
        finally {
            ((RefactoringEventListener)project.getMessageBus().syncPublisher(RefactoringEventListener.REFACTORING_EVENT_TOPIC)).refactoringDone("refactoring.extractSuper", ExtractSuperClassUtil.createAfterData(anInterface));
        }
    }

    @Nls
    private String getCommandName() {
        return RefactoringBundle.message((String)"extract.interface.command.name", (Object[])new Object[]{this.myInterfaceName, DescriptiveNameUtil.getDescriptiveName((PsiElement)this.myClass)});
    }

    public boolean isEnabledOnElements(PsiElement[] elements) {
        return ContainerUtil.exists((Object[])elements, element -> element instanceof PsiMember);
    }

    @NlsContexts.DialogTitle
    public static String getRefactoringName() {
        return RefactoringBundle.message((String)"extract.interface.title");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataContext";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
        }
        objectArray2[1] = "com/intellij/refactoring/extractInterface/ExtractInterfaceHandler";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "isAvailableForQuickList";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "invoke";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

