/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.extractMethod.newImpl;

import com.intellij.codeInsight.CodeInsightUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiBlockStatement;
import com.intellij.psi.PsiBreakStatement;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiContinueStatement;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiIfStatement;
import com.intellij.psi.PsiLambdaParameterType;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiSwitchExpression;
import com.intellij.psi.PsiSwitchLabelStatement;
import com.intellij.psi.PsiSwitchLabelStatementBase;
import com.intellij.psi.PsiSwitchLabeledRuleStatement;
import com.intellij.psi.PsiSwitchStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.PsiYieldStatement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.IntroduceVariableUtil;
import com.intellij.util.CommonJavaRefactoringUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.ListIterator;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001e\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J\u001c\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nJ\u001c\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u0002J\u0010\u0010\u000e\u001a\u00020\u00062\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0012\u0010\u0011\u001a\u00020\u00122\b\u0010\u000f\u001a\u0004\u0018\u00010\u0013H\u0002J\u0010\u0010\u0014\u001a\u00020\u00062\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u0015\u0010\u0017\u001a\u0004\u0018\u00010\u00182\b\u0010\u0019\u001a\u0004\u0018\u00010\u0018H\u0082\u0010J\u0010\u0010\u001a\u001a\u00020\u00122\u0006\u0010\u0019\u001a\u00020\u0018H\u0002J\u001c\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u0002J\u0010\u0010\u001d\u001a\u00020\u00122\u0006\u0010\u0019\u001a\u00020\u0018H\u0002J\u0016\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u001f\u001a\u00020 H\u0002J\u0012\u0010!\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u000f\u001a\u00020\u0013H\u0002\u00a8\u0006\""}, d2={"Lcom/intellij/refactoring/extractMethod/newImpl/ExtractSelector;", "", "<init>", "()V", "findElementsInRange", "", "Lcom/intellij/psi/PsiElement;", "file", "Lcom/intellij/psi/PsiFile;", "range", "Lcom/intellij/openapi/util/TextRange;", "suggestElementsToExtract", "alignElements", "elements", "alignExpressionStatement", "statement", "Lcom/intellij/psi/PsiExpressionStatement;", "isControlFlowStatement", "", "Lcom/intellij/psi/PsiStatement;", "alignIfStatement", "ifStatement", "Lcom/intellij/psi/PsiIfStatement;", "alignExpression", "Lcom/intellij/psi/PsiExpression;", "expression", "hasAssignmentInside", "alignStatements", "statements", "isInsideAnnotation", "alignCodeBlock", "codeBlock", "Lcom/intellij/psi/PsiCodeBlock;", "alignStatement", "intellij.java.impl.refactorings"})
@SourceDebugExtension(value={"SMAP\nExtractSelector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ExtractSelector.kt\ncom/intellij/refactoring/extractMethod/newImpl/ExtractSelector\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,156:1\n1786#2,3:157\n759#2,10:161\n742#2,9:171\n1807#2,3:180\n742#2,9:193\n1#3:160\n1#3:213\n3776#4,10:183\n12033#4,10:202\n14060#4:212\n14061#4:214\n12043#4:215\n*S KotlinDebug\n*F\n+ 1 ExtractSelector.kt\ncom/intellij/refactoring/extractMethod/newImpl/ExtractSelector\n*L\n77#1:157,3\n130#1:161,10\n131#1:171,9\n132#1:180,3\n144#1:193,9\n151#1:213\n144#1:183,10\n151#1:202,10\n151#1:212\n151#1:214\n151#1:215\n*E\n"})
public final class ExtractSelector {
    private final List<PsiElement> findElementsInRange(PsiFile file, TextRange range) {
        PsiType originalType;
        PsiExpression expression;
        PsiExpression psiExpression = expression = CodeInsightUtil.findExpressionInRange((PsiFile)file, (int)range.getStartOffset(), (int)range.getEndOffset());
        if (psiExpression != null) {
            return CollectionsKt.listOf((Object)psiExpression);
        }
        Object[] objectArray = CodeInsightUtil.findStatementsInRange((PsiFile)file, (int)range.getStartOffset(), (int)range.getEndOffset());
        Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"findStatementsInRange(...)");
        Object[] statements = objectArray;
        if (!(statements.length == 0)) {
            return ArraysKt.toList((Object[])statements);
        }
        PsiExpression subExpression = IntroduceVariableUtil.getSelectedExpression((Project)file.getProject(), (PsiFile)file, (int)range.getStartOffset(), (int)range.getEndOffset());
        if (subExpression != null && IntroduceVariableUtil.getErrorMessage((PsiExpression)subExpression) == null && (originalType = CommonJavaRefactoringUtil.getTypeByExpressionWithExpectedType((PsiExpression)subExpression)) != null) {
            return CollectionsKt.listOf((Object)subExpression);
        }
        return CollectionsKt.emptyList();
    }

    @NotNull
    public final List<PsiElement> suggestElementsToExtract(@NotNull PsiFile file, @NotNull TextRange range) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)range, (String)"range");
        List<PsiElement> selectedElements = this.findElementsInRange(file, range);
        return this.alignElements(selectedElements);
    }

    private final List<PsiElement> alignElements(List<? extends PsiElement> elements) {
        List list;
        PsiElement singleElement = (PsiElement)CollectionsKt.singleOrNull(elements);
        List alignedElements = elements.size() > 1 ? this.alignStatements(elements) : (singleElement instanceof PsiIfStatement ? CollectionsKt.listOf((Object)this.alignIfStatement((PsiIfStatement)singleElement)) : (singleElement instanceof PsiBlockStatement ? (((PsiBlockStatement)singleElement).getCodeBlock().getFirstBodyElement() != null ? CollectionsKt.listOf((Object)singleElement) : CollectionsKt.emptyList()) : (singleElement instanceof PsiCodeBlock ? this.alignCodeBlock((PsiCodeBlock)singleElement) : (singleElement instanceof PsiExpression ? CollectionsKt.listOfNotNull((Object)this.alignExpression((PsiExpression)singleElement)) : (singleElement instanceof PsiSwitchLabeledRuleStatement ? CollectionsKt.listOfNotNull((Object)((PsiSwitchLabeledRuleStatement)singleElement).getBody()) : (singleElement instanceof PsiExpressionStatement ? CollectionsKt.listOf((Object)this.alignExpressionStatement((PsiExpressionStatement)singleElement)) : elements))))));
        if (alignedElements.isEmpty()) {
            list = CollectionsKt.emptyList();
        } else {
            boolean bl;
            block5: {
                Iterable $this$all$iv = alignedElements;
                boolean $i$f$all = false;
                if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                    bl = true;
                } else {
                    for (Object element$iv : $this$all$iv) {
                        PsiElement it = (PsiElement)element$iv;
                        boolean bl2 = false;
                        if (it instanceof PsiComment) continue;
                        bl = false;
                        break block5;
                    }
                    bl = true;
                }
            }
            list = bl ? CollectionsKt.emptyList() : (CollectionsKt.first((List)alignedElements) != CollectionsKt.first((List)elements) || CollectionsKt.last((List)alignedElements) != CollectionsKt.last((List)elements) ? this.alignElements(alignedElements) : alignedElements);
        }
        return list;
    }

    private final PsiElement alignExpressionStatement(PsiExpressionStatement statement) {
        PsiElement psiElement = statement.getParent();
        PsiSwitchLabeledRuleStatement switchRule = psiElement instanceof PsiSwitchLabeledRuleStatement ? (PsiSwitchLabeledRuleStatement)psiElement : null;
        PsiSwitchExpression switchExpression = (PsiSwitchExpression)PsiTreeUtil.getParentOfType((PsiElement)((PsiElement)switchRule), PsiSwitchExpression.class);
        if (switchExpression != null) {
            PsiExpression psiExpression = statement.getExpression();
            Intrinsics.checkNotNullExpressionValue((Object)psiExpression, (String)"getExpression(...)");
            return (PsiElement)psiExpression;
        }
        return (PsiElement)statement;
    }

    private final boolean isControlFlowStatement(PsiStatement statement) {
        return statement instanceof PsiBreakStatement || statement instanceof PsiContinueStatement || statement instanceof PsiReturnStatement || statement instanceof PsiYieldStatement;
    }

    private final PsiElement alignIfStatement(PsiIfStatement ifStatement) {
        PsiElement psiElement;
        if (ifStatement.getElseBranch() == null && this.isControlFlowStatement(ifStatement.getThenBranch())) {
            PsiExpression psiExpression = ifStatement.getCondition();
            psiElement = psiExpression != null ? (PsiElement)psiExpression : (PsiElement)ifStatement;
        } else {
            psiElement = (PsiElement)ifStatement;
        }
        return psiElement;
    }

    private final PsiExpression alignExpression(PsiExpression expression) {
        Object object;
        block7: {
            ExtractSelector extractSelector;
            ExtractSelector extractSelector2 = this;
            while (true) {
                if (expression == null) {
                    object = null;
                    break block7;
                }
                if (expression.getType() instanceof PsiLambdaParameterType) {
                    object = null;
                    break block7;
                }
                if (extractSelector2.hasAssignmentInside(expression)) {
                    object = null;
                    break block7;
                }
                if (extractSelector2.isInsideAnnotation(expression)) {
                    object = null;
                    break block7;
                }
                if (!(expression instanceof PsiReturnStatement)) break;
                extractSelector = extractSelector2;
                PsiExpression psiExpression = ((PsiReturnStatement)expression).getReturnValue();
                extractSelector2 = extractSelector;
                expression = psiExpression;
            }
            if (expression instanceof PsiParenthesizedExpression) {
                extractSelector = expression;
                PsiParenthesizedExpression it = (PsiParenthesizedExpression)extractSelector;
                boolean bl = false;
                object = ((PsiParenthesizedExpression)expression).getExpression() != null ? extractSelector : null;
            } else {
                object = expression;
            }
        }
        return object;
    }

    private final boolean hasAssignmentInside(PsiExpression expression) {
        PsiAssignmentExpression assignment = (PsiAssignmentExpression)PsiTreeUtil.findChildOfType((PsiElement)((PsiElement)expression), PsiAssignmentExpression.class, (boolean)false);
        if (assignment == null) {
            return false;
        }
        PsiExpression psiExpression = assignment.getLExpression();
        Intrinsics.checkNotNullExpressionValue((Object)psiExpression, (String)"getLExpression(...)");
        PsiExpression lhs = psiExpression;
        if (lhs instanceof PsiReferenceExpression) {
            PsiElement target = ((PsiReferenceExpression)lhs).resolve();
            return target != null && !expression.getTextRange().contains(target.getTextRange());
        }
        return false;
    }

    private final List<PsiElement> alignStatements(List<? extends PsiElement> statements) {
        boolean bl;
        List filteredStatements;
        block9: {
            List list;
            Iterable $this$dropWhile$iv = statements;
            boolean $i$f$dropWhile = false;
            boolean yielding$iv = false;
            ArrayList list$iv = new ArrayList();
            for (Object item$iv : $this$dropWhile$iv) {
                if (yielding$iv) {
                    list$iv.add(item$iv);
                    continue;
                }
                PsiElement it = (PsiElement)item$iv;
                boolean bl2 = false;
                if (it instanceof PsiSwitchLabelStatement || it instanceof PsiWhiteSpace) continue;
                list$iv.add(item$iv);
                yielding$iv = true;
            }
            List $this$dropLastWhile$iv = list$iv;
            boolean $i$f$dropLastWhile = false;
            if (!$this$dropLastWhile$iv.isEmpty()) {
                ListIterator iterator$iv = $this$dropLastWhile$iv.listIterator($this$dropLastWhile$iv.size());
                while (iterator$iv.hasPrevious()) {
                    PsiElement it = (PsiElement)iterator$iv.previous();
                    boolean bl3 = false;
                    if (it instanceof PsiSwitchLabelStatement || it instanceof PsiWhiteSpace) continue;
                    list = CollectionsKt.take((Iterable)$this$dropLastWhile$iv, (int)(iterator$iv.nextIndex() + 1));
                    break;
                }
            } else {
                list = CollectionsKt.emptyList();
            }
            filteredStatements = list;
            Iterable $this$any$iv = filteredStatements;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    PsiElement it = (PsiElement)element$iv;
                    boolean bl4 = false;
                    if (!(it instanceof PsiSwitchLabelStatementBase)) continue;
                    bl = true;
                    break block9;
                }
                bl = false;
            }
        }
        if (bl) {
            return CollectionsKt.emptyList();
        }
        return filteredStatements;
    }

    private final boolean isInsideAnnotation(PsiExpression expression) {
        return PsiTreeUtil.getParentOfType((PsiElement)((PsiElement)expression), PsiAnnotation.class) != null;
    }

    private final List<PsiElement> alignCodeBlock(PsiCodeBlock codeBlock) {
        List list;
        if (codeBlock.getParent() instanceof PsiSwitchStatement) {
            list = CollectionsKt.listOf((Object)codeBlock.getParent());
        } else {
            PsiElement[] psiElementArray = codeBlock.getChildren();
            Intrinsics.checkNotNullExpressionValue((Object)psiElementArray, (String)"getChildren(...)");
            Object[] $this$dropWhile$iv = psiElementArray;
            boolean $i$f$dropWhile = false;
            boolean yielding$iv = false;
            ArrayList<Object> list$iv = new ArrayList<Object>();
            for (Object item$iv : $this$dropWhile$iv) {
                if (yielding$iv) {
                    list$iv.add(item$iv);
                    continue;
                }
                PsiElement it = (PsiElement)item$iv;
                boolean bl = false;
                if (it != codeBlock.getFirstBodyElement()) continue;
                list$iv.add(item$iv);
                yielding$iv = true;
            }
            List $this$dropLastWhile$iv = list$iv;
            boolean $i$f$dropLastWhile = false;
            if (!$this$dropLastWhile$iv.isEmpty()) {
                ListIterator iterator$iv = $this$dropLastWhile$iv.listIterator($this$dropLastWhile$iv.size());
                while (iterator$iv.hasPrevious()) {
                    PsiElement it = (PsiElement)iterator$iv.previous();
                    boolean bl = false;
                    if (it != codeBlock.getLastBodyElement()) continue;
                    list = CollectionsKt.take((Iterable)$this$dropLastWhile$iv, (int)(iterator$iv.nextIndex() + 1));
                    break;
                }
            } else {
                list = CollectionsKt.emptyList();
            }
        }
        return list;
    }

    /*
     * WARNING - void declaration
     */
    private final PsiElement alignStatement(PsiStatement statement) {
        PsiElement psiElement;
        PsiStatement psiStatement = statement;
        if (psiStatement instanceof PsiExpressionStatement) {
            psiElement = (PsiElement)this.alignExpression(((PsiExpressionStatement)statement).getExpression());
        } else if (psiStatement instanceof PsiDeclarationStatement) {
            void $this$mapNotNullTo$iv$iv;
            PsiElement[] psiElementArray = ((PsiDeclarationStatement)statement).getDeclaredElements();
            Intrinsics.checkNotNullExpressionValue((Object)psiElementArray, (String)"getDeclaredElements(...)");
            Object[] $this$mapNotNull$iv = psiElementArray;
            boolean $i$f$mapNotNull = false;
            Object[] objectArray = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            int n = ((void)$this$forEach$iv$iv$iv).length;
            for (int i = 0; i < n; ++i) {
                PsiExpression it$iv$iv;
                void element$iv$iv$iv;
                void element$iv$iv = element$iv$iv$iv = $this$forEach$iv$iv$iv[i];
                boolean bl = false;
                PsiElement it = (PsiElement)element$iv$iv;
                boolean bl2 = false;
                PsiLocalVariable psiLocalVariable = it instanceof PsiLocalVariable ? (PsiLocalVariable)it : null;
                if ((psiLocalVariable != null ? psiLocalVariable.getInitializer() : null) == null) continue;
                it$iv$iv = it$iv$iv;
                boolean bl3 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            PsiExpression psiExpression = (PsiExpression)CollectionsKt.singleOrNull((List)((List)destination$iv$iv));
            psiElement = psiExpression != null ? (PsiElement)psiExpression : (PsiElement)statement;
        } else {
            psiElement = (PsiElement)statement;
        }
        return psiElement;
    }
}

