/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.extractMethod.newImpl.inplace;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.command.undo.UndoManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.impl.source.PostprocessReformattingAspect;
import com.intellij.refactoring.extractMethod.newImpl.ExtractMethodHelper;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0006\u0010\u0012\u001a\u00020\u0013J\b\u0010\u0014\u001a\u00020\u0013H\u0002J\b\u0010\u0015\u001a\u00020\u0013H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/intellij/refactoring/extractMethod/newImpl/inplace/EditorState;", "", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/editor/Editor;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "getEditor", "()Lcom/intellij/openapi/editor/Editor;", "caretToRevert", "", "selectionToRevert", "Lcom/intellij/openapi/util/TextRange;", "textToRevert", "", "revert", "", "revertWithoutPostprocessing", "revertState", "intellij.java.impl.refactorings"})
public final class EditorState {
    @NotNull
    private final Project project;
    @NotNull
    private final Editor editor;
    private final int caretToRevert;
    @Nullable
    private final TextRange selectionToRevert;
    @NotNull
    private final String textToRevert;

    public EditorState(@NotNull Project project, @NotNull Editor editor) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        this.project = project;
        this.editor = editor;
        this.caretToRevert = this.editor.getCaretModel().getCurrentCaret().getOffset();
        this.selectionToRevert = ExtractMethodHelper.findEditorSelection(this.editor);
        String string = this.editor.getDocument().getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        this.textToRevert = string;
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @NotNull
    public final Editor getEditor() {
        return this.editor;
    }

    public final void revert() {
        if (UndoManager.getInstance((Project)this.project).isUndoOrRedoInProgress()) {
            ApplicationManager.getApplication().invokeLater(() -> EditorState.revert$lambda$0(this));
        } else {
            this.revertWithoutPostprocessing();
        }
    }

    private final void revertWithoutPostprocessing() {
        WriteAction.run(() -> EditorState.revertWithoutPostprocessing$lambda$0(this));
    }

    private final void revertState() {
        Project project = this.editor.getProject();
        this.editor.getDocument().setText((CharSequence)this.textToRevert);
        if (project != null) {
            PsiDocumentManager.getInstance((Project)project).commitDocument(this.editor.getDocument());
        }
        this.editor.getCaretModel().moveToOffset(this.caretToRevert);
        if (this.selectionToRevert != null) {
            this.editor.getSelectionModel().setSelection(this.selectionToRevert.getStartOffset(), this.selectionToRevert.getEndOffset());
        }
    }

    private static final void revert$lambda$0(EditorState this$0) {
        this$0.revertWithoutPostprocessing();
    }

    private static final void revertWithoutPostprocessing$lambda$0(EditorState this$0) {
        PostprocessReformattingAspect.getInstance((Project)this$0.project).disablePostprocessFormattingInside(this$0::revertState);
    }
}

