/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.extractMethod.preview;

import com.intellij.java.refactoring.JavaRefactoringBundle;
import com.intellij.refactoring.extractMethod.preview.FragmentNode;
import com.intellij.refactoring.extractMethod.preview.MethodNode;
import com.intellij.ui.ColoredTreeCellRenderer;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.usageView.UsageTreeColors;
import com.intellij.usages.TextChunk;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class PreviewTreeRenderer
extends ColoredTreeCellRenderer {
    PreviewTreeRenderer() {
    }

    public void customizeCellRenderer(@NotNull JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        Object object;
        if (tree == null) {
            PreviewTreeRenderer.$$$reportNull$$$0(0);
        }
        if (value instanceof MethodNode) {
            MethodNode methodNode = (MethodNode)value;
            this.setIcon(methodNode.getIcon());
            this.appendText(methodNode);
        } else if (value instanceof FragmentNode) {
            FragmentNode node = (FragmentNode)value;
            this.appendText(node);
        }
        if (value instanceof DefaultMutableTreeNode && (object = ((DefaultMutableTreeNode)value).getUserObject()) instanceof String) {
            this.append((String)object, SimpleTextAttributes.REGULAR_BOLD_ATTRIBUTES);
        }
    }

    private void appendText(@NotNull FragmentNode node) {
        if (node == null) {
            PreviewTreeRenderer.$$$reportNull$$$0(1);
        }
        if (node.isValid()) {
            this.append(node.getLineNumberChunk(), node);
        } else {
            this.append(JavaRefactoringBundle.message((String)"extract.method.preview.node.invalid.prefix", (Object[])new Object[0]), PreviewTreeRenderer.patchMainTextAttrs(UsageTreeColors.INVALID_ATTRIBUTES, node));
        }
        for (TextChunk textChunk : node.getTextChunks()) {
            this.append(textChunk, node);
        }
    }

    private void append(@Nullable TextChunk textChunk, @NotNull FragmentNode node) {
        if (node == null) {
            PreviewTreeRenderer.$$$reportNull$$$0(2);
        }
        if (textChunk != null) {
            SimpleTextAttributes attributes = textChunk.getSimpleAttributesIgnoreBackground();
            this.append(textChunk.getText(), PreviewTreeRenderer.patchMainTextAttrs(attributes, node), true);
        }
    }

    private static SimpleTextAttributes patchMainTextAttrs(@NotNull SimpleTextAttributes attributes, @NotNull FragmentNode node) {
        if (attributes == null) {
            PreviewTreeRenderer.$$$reportNull$$$0(3);
        }
        if (node == null) {
            PreviewTreeRenderer.$$$reportNull$$$0(4);
        }
        if (node.isExcluded()) {
            return attributes.derive(attributes.getStyle() | 4, null, null, null);
        }
        return attributes;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tree";
                break;
            }
            case 1: 
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attributes";
                break;
            }
        }
        objectArray2[1] = "com/intellij/refactoring/extractMethod/preview/PreviewTreeRenderer";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "customizeCellRenderer";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "appendText";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "append";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "patchMainTextAttrs";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

