/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.extractMethodObject;

import com.intellij.java.refactoring.JavaRefactoringBundle;
import com.intellij.lang.ContextAwareActionHandler;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.impl.source.PostprocessReformattingAspect;
import com.intellij.refactoring.RefactoringActionHandler;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.extractMethod.ExtractMethodHandler;
import com.intellij.refactoring.extractMethod.PrepareFailedException;
import com.intellij.refactoring.extractMethodObject.ExtractMethodObjectProcessor;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.refactoring.util.duplicates.DuplicatesImpl;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;

public class ExtractMethodObjectHandler
implements RefactoringActionHandler,
ContextAwareActionHandler {
    private static final Logger LOG = Logger.getInstance(ExtractMethodObjectHandler.class);

    public void invoke(@NotNull Project project, Editor editor, PsiFile file, DataContext dataContext) {
        if (project == null) {
            ExtractMethodObjectHandler.$$$reportNull$$$0(0);
        }
        ExtractMethodHandler.selectAndPass(project, editor, file, selectedValue -> ExtractMethodObjectHandler.invokeOnElements(project, editor, file, selectedValue));
    }

    public boolean isAvailableForQuickList(@NotNull Editor editor, @NotNull PsiFile file, @NotNull DataContext dataContext) {
        if (editor == null) {
            ExtractMethodObjectHandler.$$$reportNull$$$0(1);
        }
        if (file == null) {
            ExtractMethodObjectHandler.$$$reportNull$$$0(2);
        }
        if (dataContext == null) {
            ExtractMethodObjectHandler.$$$reportNull$$$0(3);
        }
        return false;
    }

    private static void invokeOnElements(@NotNull Project project, @NotNull Editor editor, @NotNull PsiFile file, PsiElement @NotNull [] elements) {
        if (project == null) {
            ExtractMethodObjectHandler.$$$reportNull$$$0(4);
        }
        if (editor == null) {
            ExtractMethodObjectHandler.$$$reportNull$$$0(5);
        }
        if (file == null) {
            ExtractMethodObjectHandler.$$$reportNull$$$0(6);
        }
        if (elements == null) {
            ExtractMethodObjectHandler.$$$reportNull$$$0(7);
        }
        if (elements.length == 0) {
            String message = RefactoringBundle.getCannotRefactorMessage((String)RefactoringBundle.message((String)"selected.block.should.represent.a.set.of.statements.or.an.expression"));
            CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)message, (String)JavaRefactoringBundle.message((String)"extract.method.object", (Object[])new Object[0]), (String)"refactoring.extractMethodObject");
            return;
        }
        try {
            ExtractMethodObjectHandler.extractMethodObject(project, editor, new ExtractMethodObjectProcessor(project, editor, elements, ""));
        }
        catch (PrepareFailedException e) {
            CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)e.getMessage(), (String)JavaRefactoringBundle.message((String)"extract.method.object", (Object[])new Object[0]), (String)"refactoring.extractMethodObject");
            ExtractMethodHandler.highlightPrepareError(e, file, editor, project);
        }
    }

    static void extractMethodObject(Project project, Editor editor, ExtractMethodObjectProcessor processor) throws PrepareFailedException {
        ExtractMethodObjectProcessor.MyExtractMethodProcessor extractProcessor = processor.getExtractProcessor();
        if (!extractProcessor.prepare()) {
            return;
        }
        if (!CommonRefactoringUtil.checkReadOnlyStatus((Project)project, (PsiElement)extractProcessor.getTargetClass().getContainingFile())) {
            return;
        }
        if (extractProcessor.showDialog()) {
            ExtractMethodObjectHandler.extractMethodObject(project, editor, processor, extractProcessor);
        }
    }

    public static void extractMethodObject(@NotNull Project project, Editor editor, @NotNull ExtractMethodObjectProcessor processor, @NotNull ExtractMethodObjectProcessor.MyExtractMethodProcessor extractProcessor) {
        RangeMarker marker;
        if (project == null) {
            ExtractMethodObjectHandler.$$$reportNull$$$0(8);
        }
        if (processor == null) {
            ExtractMethodObjectHandler.$$$reportNull$$$0(9);
        }
        if (extractProcessor == null) {
            ExtractMethodObjectHandler.$$$reportNull$$$0(10);
        }
        if (editor != null) {
            int offset = editor.getCaretModel().getOffset();
            marker = editor.getDocument().createRangeMarker(offset, offset);
        } else {
            marker = null;
        }
        CommandProcessor.getInstance().executeCommand(project, () -> ExtractMethodObjectHandler.doRefactoring(project, editor, processor, extractProcessor), JavaRefactoringBundle.message((String)"extract.method.object", (Object[])new Object[0]), (Object)JavaRefactoringBundle.message((String)"extract.method.object", (Object[])new Object[0]));
        if (editor != null) {
            editor.getCaretModel().moveToOffset(marker.getStartOffset());
            marker.dispose();
            editor.getScrollingModel().scrollToCaret(ScrollType.RELATIVE);
        }
    }

    private static void doRefactoring(@NotNull Project project, Editor editor, @NotNull ExtractMethodObjectProcessor processor, @NotNull ExtractMethodObjectProcessor.MyExtractMethodProcessor extractProcessor) {
        if (project == null) {
            ExtractMethodObjectHandler.$$$reportNull$$$0(11);
        }
        if (processor == null) {
            ExtractMethodObjectHandler.$$$reportNull$$$0(12);
        }
        if (extractProcessor == null) {
            ExtractMethodObjectHandler.$$$reportNull$$$0(13);
        }
        PostprocessReformattingAspect.getInstance((Project)project).postponeFormattingInside(() -> {
            try {
                ApplicationManager.getApplication().runWriteAction(() -> extractProcessor.doRefactoring());
                processor.run();
                ApplicationManager.getApplication().runWriteAction(() -> processor.runChangeSignature());
            }
            catch (IncorrectOperationException e) {
                LOG.error((Throwable)e);
            }
            PsiDocumentManager.getInstance((Project)project).commitAllDocuments();
            if (processor.isCreateInnerClass()) {
                processor.moveUsedMethodsToInner();
                PsiDocumentManager.getInstance((Project)project).commitAllDocuments();
                if (editor != null) {
                    DuplicatesImpl.processDuplicates(extractProcessor, project, editor);
                }
            }
            ApplicationManager.getApplication().runWriteAction(() -> {
                PsiMethod method;
                if (processor.isCreateInnerClass()) {
                    processor.changeInstanceAccess(project);
                }
                LOG.assertTrue((method = processor.getMethod()) != null);
                method.delete();
            });
        });
    }

    public void invoke(@NotNull Project project, PsiElement @NotNull [] elements, DataContext dataContext) {
        if (project == null) {
            ExtractMethodObjectHandler.$$$reportNull$$$0(14);
        }
        if (elements == null) {
            ExtractMethodObjectHandler.$$$reportNull$$$0(15);
        }
        throw new UnsupportedOperationException();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 2: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataContext";
                break;
            }
            case 7: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
            case 9: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 10: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extractProcessor";
                break;
            }
        }
        objectArray2[1] = "com/intellij/refactoring/extractMethodObject/ExtractMethodObjectHandler";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "invoke";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "isAvailableForQuickList";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "invokeOnElements";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "extractMethodObject";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[2] = "doRefactoring";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

