/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.extractMethodObject;

import com.intellij.application.options.CodeStyle;
import com.intellij.codeInsight.Nullability;
import com.intellij.codeInsight.NullableNotNullManager;
import com.intellij.codeInsight.generation.GenerateMembersUtil;
import com.intellij.java.refactoring.JavaRefactoringBundle;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaRecursiveElementVisitor;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiBinaryExpression;
import com.intellij.psi.PsiBlockStatement;
import com.intellij.psi.PsiCatchSection;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiEllipsisType;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiForeachStatement;
import com.intellij.psi.PsiIfStatement;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReferenceParameterList;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiSuperExpression;
import com.intellij.psi.PsiThisExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiTypeParameterList;
import com.intellij.psi.PsiTypes;
import com.intellij.psi.PsiUnaryExpression;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.codeStyle.JavaCodeStyleSettings;
import com.intellij.psi.codeStyle.VariableKind;
import com.intellij.psi.controlFlow.ControlFlowUtil;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PropertyUtilBase;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.refactoring.BaseRefactoringProcessor;
import com.intellij.refactoring.classMembers.MemberInfoBase;
import com.intellij.refactoring.extractMethod.AbstractExtractDialog;
import com.intellij.refactoring.extractMethod.ExtractMethodProcessor;
import com.intellij.refactoring.extractMethodObject.ExtractMethodObjectDialog;
import com.intellij.refactoring.extractMethodObject.ExtractMethodObjectViewDescriptor;
import com.intellij.refactoring.extractMethodObject.MethodToMoveUsageInfo;
import com.intellij.refactoring.ui.MemberSelectionPanel;
import com.intellij.refactoring.util.RefactoringChangeUtil;
import com.intellij.refactoring.util.classMembers.MemberInfo;
import com.intellij.refactoring.util.duplicates.Match;
import com.intellij.usageView.UsageInfo;
import com.intellij.usageView.UsageViewDescriptor;
import com.intellij.usageView.UsageViewUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.CommonJavaRefactoringUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.VisibilityUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.text.UniqueNameGenerator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import javax.swing.JComponent;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExtractMethodObjectProcessor
extends BaseRefactoringProcessor {
    private static final Logger LOG = Logger.getInstance(ExtractMethodObjectProcessor.class);
    private final PsiElementFactory myElementFactory;
    protected final MyExtractMethodProcessor myExtractProcessor;
    private boolean myCreateInnerClass;
    @NotNull
    private String myInnerClassName;
    private boolean myMultipleExitPoints;
    private PsiField[] myOutputFields;
    private PsiMethod myInnerMethod;
    private boolean myMadeStatic;
    private final Set<MethodToMoveUsageInfo> myUsages;
    private PsiClass myInnerClass;
    private boolean myChangeReturnType;
    private Runnable myCopyMethodToInner;
    private final UniqueNameGenerator myFieldNameGenerator;
    private String myResultFieldName;
    private final CodeStyleSettings myStyleSettings;
    private static final Key<Boolean> GENERATED_RETURN = new Key("GENERATED_RETURN");

    public ExtractMethodObjectProcessor(Project project, Editor editor, PsiElement[] elements, @NotNull String innerClassName) {
        if (innerClassName == null) {
            ExtractMethodObjectProcessor.$$$reportNull$$$0(0);
        }
        super(project);
        this.myCreateInnerClass = true;
        this.myUsages = new LinkedHashSet<MethodToMoveUsageInfo>();
        this.myFieldNameGenerator = new UniqueNameGenerator();
        this.myResultFieldName = null;
        this.myInnerClassName = innerClassName;
        this.myExtractProcessor = new MyExtractMethodProcessor(project, editor, elements, null, JavaRefactoringBundle.message((String)"extract.method.object", (Object[])new Object[0]), innerClassName, "refactoring.extractMethodObject");
        this.myElementFactory = JavaPsiFacade.getElementFactory((Project)project);
        this.myStyleSettings = editor != null ? CodeStyle.getSettings((Editor)editor) : CodeStyle.getSettings((PsiFile)elements[0].getContainingFile());
    }

    @NotNull
    protected UsageViewDescriptor createUsageViewDescriptor(UsageInfo @NotNull [] usages) {
        if (usages == null) {
            ExtractMethodObjectProcessor.$$$reportNull$$$0(1);
        }
        return new ExtractMethodObjectViewDescriptor(this.getMethod());
    }

    protected UsageInfo @NotNull [] findUsages() {
        PsiReference[] refs;
        ArrayList<UsageInfo> result = new ArrayList<UsageInfo>();
        PsiClass containingClass = Objects.requireNonNull(this.getMethod().getContainingClass());
        LocalSearchScope scope = PsiUtilCore.getVirtualFile((PsiElement)containingClass) == null ? new LocalSearchScope((PsiElement)containingClass) : GlobalSearchScope.projectScope((Project)this.myProject);
        for (PsiReference ref : refs = (PsiReference[])ReferencesSearch.search((PsiElement)this.getMethod(), (SearchScope)scope, (boolean)false).toArray((Object[])PsiReference.EMPTY_ARRAY)) {
            PsiElement element = ref.getElement();
            if (!element.isValid()) continue;
            result.add(new UsageInfo(element));
        }
        if (this.isCreateInnerClass()) {
            final LinkedHashSet usedMethods = new LinkedHashSet();
            this.getMethod().accept((PsiElementVisitor)new JavaRecursiveElementWalkingVisitor(this){

                public void visitMethodCallExpression(@NotNull PsiMethodCallExpression expression) {
                    if (expression == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    super.visitMethodCallExpression(expression);
                    PsiMethod method = expression.resolveMethod();
                    if (method != null) {
                        usedMethods.add(method);
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/intellij/refactoring/extractMethodObject/ExtractMethodObjectProcessor$1", "visitMethodCallExpression"));
                }
            });
            for (PsiMethod usedMethod : usedMethods) {
                if (!usedMethod.hasModifierProperty("private") || usedMethod.hasModifierProperty("static") && !this.myExtractProcessor.isStatic()) continue;
                PsiMethod toMove = usedMethod;
                for (PsiReference reference : ReferencesSearch.search((PsiElement)usedMethod).asIterable()) {
                    if (PsiTreeUtil.isAncestor((PsiElement)this.getMethod(), (PsiElement)reference.getElement(), (boolean)false)) continue;
                    toMove = null;
                    break;
                }
                if (toMove == null) continue;
                this.myUsages.add(new MethodToMoveUsageInfo(toMove));
            }
        }
        UsageInfo[] usageInfos = result.toArray(UsageInfo.EMPTY_ARRAY);
        UsageInfo[] usageInfoArray = UsageViewUtil.removeDuplicatedUsages((UsageInfo[])usageInfos);
        if (usageInfoArray == null) {
            ExtractMethodObjectProcessor.$$$reportNull$$$0(2);
        }
        return usageInfoArray;
    }

    public void performRefactoring(UsageInfo @NotNull [] usages) {
        if (usages == null) {
            ExtractMethodObjectProcessor.$$$reportNull$$$0(3);
        }
        try {
            if (this.isCreateInnerClass()) {
                PsiParameter[] parameters;
                PsiClass containingClass = Objects.requireNonNull(this.getMethod().getContainingClass());
                this.myInnerClass = (PsiClass)this.addInnerClass(containingClass, this.myElementFactory.createClass(this.getInnerClassName()));
                boolean isStatic = this.copyMethodModifiers() && this.notHasGeneratedFields();
                for (UsageInfo usage : usages) {
                    PsiMethodCallExpression methodCallExpression = (PsiMethodCallExpression)PsiTreeUtil.getParentOfType((PsiElement)usage.getElement(), PsiMethodCallExpression.class);
                    if (methodCallExpression == null) continue;
                    this.replaceMethodCallExpression(this.inferTypeArguments(methodCallExpression), methodCallExpression);
                }
                if (this.myExtractProcessor.generatesConditionalExit()) {
                    this.myResultFieldName = this.uniqueFieldName(new String[]{"myResult"});
                    this.myInnerClass.add((PsiElement)this.myElementFactory.createField(this.myResultFieldName, (PsiType)PsiTypes.booleanType()));
                    this.myInnerClass.add((PsiElement)this.myElementFactory.createMethodFromText("boolean is(){return " + this.myResultFieldName + ";}", (PsiElement)this.myInnerClass));
                }
                if ((parameters = this.getMethod().getParameterList().getParameters()).length > 0) {
                    this.createInnerClassConstructor(parameters);
                } else if (isStatic) {
                    PsiMethod copy = (PsiMethod)this.getMethod().copy();
                    copy.setName("invoke");
                    this.myInnerClass.add((PsiElement)copy);
                    if (this.myMultipleExitPoints) {
                        this.addOutputVariableFieldsWithGetters();
                    }
                    return;
                }
                if (this.myMultipleExitPoints) {
                    this.addOutputVariableFieldsWithGetters();
                }
                this.myCopyMethodToInner = () -> {
                    this.copyMethodWithoutParameters();
                    this.copyMethodTypeParameters();
                };
            } else {
                for (UsageInfo usage : usages) {
                    PsiMethodCallExpression methodCallExpression = (PsiMethodCallExpression)PsiTreeUtil.getParentOfType((PsiElement)usage.getElement(), PsiMethodCallExpression.class);
                    if (methodCallExpression == null) continue;
                    methodCallExpression.replace((PsiElement)this.processMethodDeclaration(methodCallExpression.getArgumentList()));
                }
            }
        }
        catch (IncorrectOperationException e) {
            LOG.error((Throwable)e);
        }
    }

    void moveUsedMethodsToInner() {
        if (!this.myUsages.isEmpty()) {
            if (ApplicationManager.getApplication().isUnitTestMode()) {
                WriteAction.run(() -> {
                    for (MethodToMoveUsageInfo usage : this.myUsages) {
                        PsiMember member = (PsiMember)usage.getElement();
                        LOG.assertTrue(member != null);
                        this.myInnerClass.add(member.copy());
                        member.delete();
                    }
                });
                return;
            }
            ArrayList<MemberInfo> memberInfos = new ArrayList<MemberInfo>();
            for (MethodToMoveUsageInfo usage : this.myUsages) {
                memberInfos.add(new MemberInfo((PsiMember)((PsiMethod)usage.getElement())));
            }
            final MemberSelectionPanel panel = new MemberSelectionPanel(JavaRefactoringBundle.message((String)"move.methods.panel.title", (Object[])new Object[0]), memberInfos, null);
            DialogWrapper dlg = new DialogWrapper(this, this.myProject, false){
                {
                    super(arg0, arg1);
                    this.init();
                    this.setTitle(JavaRefactoringBundle.message((String)"move.methods.used.in.extracted.block.only", (Object[])new Object[0]));
                }

                protected JComponent createCenterPanel() {
                    return panel;
                }
            };
            if (dlg.showAndGet()) {
                WriteAction.run(() -> {
                    for (MemberInfoBase memberInfo : panel.getTable().getSelectedMemberInfos()) {
                        if (!memberInfo.isChecked()) continue;
                        this.myInnerClass.add(((PsiMember)memberInfo.getMember()).copy());
                        ((PsiMember)memberInfo.getMember()).delete();
                    }
                });
            }
        }
    }

    private void addOutputVariableFieldsWithGetters() throws IncorrectOperationException {
        HashMap<String, String> var2FieldNames = new HashMap<String, String>();
        Object[] outputVariables = this.myExtractProcessor.getOutputVariables();
        for (int i = 0; i < outputVariables.length; ++i) {
            PsiField field;
            PsiVariable var = outputVariables[i];
            PsiField outputField = this.myOutputFields[i];
            String name = this.getPureName(var);
            if (outputField != null) {
                var2FieldNames.put(var.getName(), outputField.getName());
                this.myInnerClass.add((PsiElement)outputField);
                field = outputField;
            } else {
                field = PropertyUtilBase.findPropertyField((PsiClass)this.myInnerClass, (String)name, (boolean)false);
            }
            LOG.assertTrue(field != null, (Object)("i:" + i + "; output variables: " + Arrays.toString(outputVariables) + "; parameters: " + Arrays.toString(this.getMethod().getParameterList().getParameters()) + "; output field: " + String.valueOf(outputField)));
            this.myInnerClass.add((PsiElement)GenerateMembersUtil.generateGetterPrototype((PsiField)field));
        }
        PsiCodeBlock body = this.getMethod().getBody();
        LOG.assertTrue(body != null);
        LinkedHashSet vars = new LinkedHashSet();
        final LinkedHashMap replacementMap = new LinkedHashMap();
        final ArrayList returnStatements = new ArrayList();
        body.accept((PsiElementVisitor)new JavaRecursiveElementWalkingVisitor(this){

            public void visitReturnStatement(@NotNull PsiReturnStatement statement) {
                if (statement == null) {
                    3.$$$reportNull$$$0(0);
                }
                returnStatements.add(statement);
            }

            public void visitClass(@NotNull PsiClass aClass) {
                if (aClass == null) {
                    3.$$$reportNull$$$0(1);
                }
            }

            public void visitLambdaExpression(@NotNull PsiLambdaExpression expression) {
                if (expression == null) {
                    3.$$$reportNull$$$0(2);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "statement";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "aClass";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "expression";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/refactoring/extractMethodObject/ExtractMethodObjectProcessor$3";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitReturnStatement";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitClass";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitLambdaExpression";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        if (this.myExtractProcessor.generatesConditionalExit()) {
            for (int i = 0; i < returnStatements.size() - 1; ++i) {
                PsiReturnStatement condition = (PsiReturnStatement)returnStatements.get(i);
                PsiElement container = condition.getParent();
                LOG.assertTrue(this.myResultFieldName != null);
                PsiStatement resultStmt = this.myElementFactory.createStatementFromText(this.myResultFieldName + " = true;", container);
                if (!CommonJavaRefactoringUtil.isLoopOrIf((PsiElement)container)) {
                    container.addBefore((PsiElement)resultStmt, (PsiElement)condition);
                    continue;
                }
                CommonJavaRefactoringUtil.putStatementInLoopBody((PsiStatement)resultStmt, (PsiElement)container, (PsiElement)condition);
            }
            LOG.assertTrue(!returnStatements.isEmpty());
            PsiReturnStatement returnStatement = (PsiReturnStatement)returnStatements.getLast();
            PsiElement container = returnStatement.getParent();
            LOG.assertTrue(this.myResultFieldName != null);
            PsiStatement resultStmt = this.myElementFactory.createStatementFromText(this.myResultFieldName + " = false;", container);
            if (!CommonJavaRefactoringUtil.isLoopOrIf((PsiElement)container)) {
                container.addBefore((PsiElement)resultStmt, (PsiElement)returnStatement);
            } else {
                CommonJavaRefactoringUtil.putStatementInLoopBody((PsiStatement)resultStmt, (PsiElement)container, (PsiElement)returnStatement);
            }
        }
        body.accept((PsiElementVisitor)new JavaRecursiveElementWalkingVisitor((PsiVariable[])outputVariables, var2FieldNames, vars){
            final /* synthetic */ PsiVariable[] val$outputVariables;
            final /* synthetic */ Map val$var2FieldNames;
            final /* synthetic */ LinkedHashSet val$vars;
            {
                this.val$outputVariables = psiVariableArray;
                this.val$var2FieldNames = map2;
                this.val$vars = linkedHashSet;
            }

            public void visitReturnStatement(@NotNull PsiReturnStatement statement) {
                if (statement == null) {
                    4.$$$reportNull$$$0(0);
                }
                super.visitReturnStatement(statement);
                try {
                    PsiStatement returnThisStatement = ExtractMethodObjectProcessor.this.myElementFactory.createStatementFromText("return this;", (PsiElement)statement);
                    returnThisStatement.putCopyableUserData(GENERATED_RETURN, (Object)true);
                    replacementMap.put(statement, returnThisStatement);
                }
                catch (IncorrectOperationException e) {
                    LOG.error((Throwable)e);
                }
            }

            public void visitClass(@NotNull PsiClass aClass) {
                if (aClass == null) {
                    4.$$$reportNull$$$0(1);
                }
            }

            public void visitLambdaExpression(@NotNull PsiLambdaExpression expression) {
                if (expression == null) {
                    4.$$$reportNull$$$0(2);
                }
            }

            public void visitDeclarationStatement(@NotNull PsiDeclarationStatement statement) {
                PsiElement[] declaredElements;
                if (statement == null) {
                    4.$$$reportNull$$$0(3);
                }
                super.visitDeclarationStatement(statement);
                for (PsiElement declaredElement : declaredElements = statement.getDeclaredElements()) {
                    if (!(declaredElement instanceof PsiVariable)) continue;
                    for (PsiVariable variable : this.val$outputVariables) {
                        PsiVariable var = (PsiVariable)declaredElement;
                        if (!Comparing.strEqual((String)var.getName(), (String)variable.getName())) continue;
                        replacementMap.put(var, var.getInitializer());
                    }
                }
            }

            public void visitParameter(@NotNull PsiParameter parameter) {
                if (parameter == null) {
                    4.$$$reportNull$$$0(4);
                }
                super.visitParameter(parameter);
                PsiElement declarationScope = parameter.getDeclarationScope();
                for (PsiVariable variable : this.val$outputVariables) {
                    if (!Comparing.strEqual((String)variable.getName(), (String)parameter.getName())) continue;
                    replacementMap.put(parameter, ExtractMethodObjectProcessor.this.myElementFactory.createStatementFromText(ExtractMethodObjectProcessor.this.myInnerClassName + ".this." + (String)this.val$var2FieldNames.get(variable.getName()) + " = " + parameter.getName() + ";", declarationScope));
                }
            }

            public void visitReferenceExpression(@NotNull PsiReferenceExpression expression) {
                if (expression == null) {
                    4.$$$reportNull$$$0(5);
                }
                super.visitReferenceExpression(expression);
                PsiElement resolved = expression.resolve();
                if (resolved instanceof PsiLocalVariable) {
                    String var = ((PsiLocalVariable)resolved).getName();
                    for (PsiVariable variable : this.val$outputVariables) {
                        if (!Comparing.strEqual((String)variable.getName(), (String)var)) continue;
                        this.val$vars.add((PsiLocalVariable)resolved);
                        break;
                    }
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "statement";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "aClass";
                        break;
                    }
                    case 2: 
                    case 5: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "expression";
                        break;
                    }
                    case 4: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "parameter";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/refactoring/extractMethodObject/ExtractMethodObjectProcessor$4";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitReturnStatement";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitClass";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitLambdaExpression";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitDeclarationStatement";
                        break;
                    }
                    case 4: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitParameter";
                        break;
                    }
                    case 5: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitReferenceExpression";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        for (PsiLocalVariable var : vars) {
            String fieldName = (String)var2FieldNames.get(var.getName());
            for (PsiReference reference : ReferencesSearch.search((PsiElement)var, (SearchScope)var.getUseScope()).asIterable()) {
                reference.handleElementRename(fieldName);
            }
        }
        LinkedHashMap<PsiStatement, PsiForeachStatement> blocksToReplace = new LinkedHashMap<PsiStatement, PsiForeachStatement>();
        for (PsiElement statement : replacementMap.keySet()) {
            PsiElement replacement2 = (PsiElement)replacementMap.get(statement);
            if (replacement2 != null) {
                PsiExpression returnValue;
                if (statement instanceof PsiParameter) {
                    PsiCodeBlock codeBlock = null;
                    PsiElement declarationScope = ((PsiParameter)statement).getDeclarationScope();
                    if (declarationScope instanceof PsiForeachStatement) {
                        PsiStatement loopBody = ((PsiForeachStatement)declarationScope).getBody();
                        if (loopBody instanceof PsiBlockStatement) {
                            codeBlock = ((PsiBlockStatement)loopBody).getCodeBlock();
                        } else {
                            blocksToReplace.put((PsiStatement)replacement2, (PsiForeachStatement)declarationScope);
                        }
                    } else if (declarationScope instanceof PsiCatchSection) {
                        codeBlock = ((PsiCatchSection)declarationScope).getCatchBlock();
                    }
                    if (codeBlock == null) continue;
                    codeBlock.addBefore(replacement2, codeBlock.getFirstBodyElement());
                    continue;
                }
                if (statement instanceof PsiLocalVariable) {
                    PsiLocalVariable variable = (PsiLocalVariable)statement;
                    variable.normalizeDeclaration();
                    PsiExpression initializer = variable.getInitializer();
                    LOG.assertTrue(initializer != null);
                    PsiStatement assignmentStatement = this.myElementFactory.createStatementFromText((String)var2FieldNames.get(variable.getName()) + " = " + initializer.getText() + ";", statement);
                    PsiDeclarationStatement declaration = (PsiDeclarationStatement)PsiTreeUtil.getParentOfType((PsiElement)statement, PsiDeclarationStatement.class);
                    LOG.assertTrue(declaration != null);
                    declaration.replace((PsiElement)assignmentStatement);
                    continue;
                }
                if (statement instanceof PsiReturnStatement && !((returnValue = ((PsiReturnStatement)statement).getReturnValue()) instanceof PsiReferenceExpression) && returnValue != null && !(returnValue instanceof PsiLiteralExpression)) {
                    statement.getParent().addBefore((PsiElement)this.myElementFactory.createStatementFromText(returnValue.getText() + ";", (PsiElement)returnValue), statement);
                }
                statement.replace(replacement2);
                continue;
            }
            statement.delete();
        }
        for (PsiElement statement : blocksToReplace.keySet()) {
            CommonJavaRefactoringUtil.putStatementInLoopBody((PsiStatement)statement, (PsiElement)((PsiElement)blocksToReplace.get(statement)), null);
        }
        this.myChangeReturnType = true;
    }

    void runChangeSignature() {
        if (this.myCopyMethodToInner != null) {
            this.myCopyMethodToInner.run();
        }
        if (this.myChangeReturnType) {
            PsiTypeElement typeElement = ((PsiLocalVariable)((PsiDeclarationStatement)JavaPsiFacade.getElementFactory((Project)this.myProject).createStatementFromText(this.myInnerClassName + " l =null;", (PsiElement)this.myInnerClass)).getDeclaredElements()[0]).getTypeElement();
            PsiTypeElement innerMethodReturnTypeElement = this.myInnerMethod.getReturnTypeElement();
            LOG.assertTrue(innerMethodReturnTypeElement != null);
            innerMethodReturnTypeElement.replace((PsiElement)typeElement);
        }
    }

    @NotNull
    private String getPureName(@NotNull PsiVariable var) {
        if (var == null) {
            ExtractMethodObjectProcessor.$$$reportNull$$$0(4);
        }
        JavaCodeStyleManager styleManager = JavaCodeStyleManager.getInstance((Project)this.myProject);
        String string = styleManager.variableNameToPropertyName(var.getName(), styleManager.getVariableKind(var));
        if (string == null) {
            ExtractMethodObjectProcessor.$$$reportNull$$$0(5);
        }
        return string;
    }

    public PsiExpression processMethodDeclaration(PsiExpressionList expressionList) throws IncorrectOperationException {
        if (this.isCreateInnerClass()) {
            String typeArguments = this.getMethod().hasTypeParameters() ? "<" + StringUtil.join(Arrays.asList(this.getMethod().getTypeParameters()), typeParameter -> {
                String typeParameterName = typeParameter.getName();
                LOG.assertTrue(typeParameterName != null);
                return typeParameterName;
            }, (String)", ") + ">" : "";
            PsiMethodCallExpression methodCallExpression = (PsiMethodCallExpression)this.myElementFactory.createExpressionFromText("invoke" + expressionList.getText(), null);
            return this.replaceMethodCallExpression(typeArguments, methodCallExpression);
        }
        String paramsDeclaration = this.getMethod().getParameterList().getText();
        PsiType returnType = this.getMethod().getReturnType();
        LOG.assertTrue(returnType != null);
        PsiCodeBlock methodBody = this.getMethod().getBody();
        LOG.assertTrue(methodBody != null);
        this.adjustTargetClassReferences((PsiElement)methodBody);
        return this.myElementFactory.createExpressionFromText("new Object(){ \nprivate " + returnType.getPresentableText() + " " + this.myInnerClassName + paramsDeclaration + methodBody.getText() + "}." + this.myInnerClassName + expressionList.getText(), null);
    }

    private PsiMethodCallExpression replaceMethodCallExpression(String inferredTypeArguments, PsiMethodCallExpression methodCallExpression) throws IncorrectOperationException {
        String newReplacement;
        @NonNls String staticqualifier = this.getMethod().hasModifierProperty("static") && this.notHasGeneratedFields() ? this.getInnerClassName() : null;
        PsiReferenceExpression methodExpression = methodCallExpression.getMethodExpression();
        PsiExpressionList argumentList = methodCallExpression.getArgumentList();
        if (staticqualifier != null) {
            newReplacement = argumentList.isEmpty() ? staticqualifier + "." : "new " + staticqualifier + inferredTypeArguments + argumentList.getText() + ".";
        } else {
            PsiExpression qualifierExpression = methodExpression.getQualifierExpression();
            String qualifier = qualifierExpression != null ? qualifierExpression.getText() + "." : "";
            newReplacement = qualifier + "new " + this.getInnerClassName() + inferredTypeArguments + argumentList.getText() + ".";
        }
        return (PsiMethodCallExpression)methodCallExpression.replace((PsiElement)this.myElementFactory.createExpressionFromText(newReplacement + "invoke()", null));
    }

    @NotNull
    private String inferTypeArguments(PsiMethodCallExpression methodCallExpression) {
        PsiReferenceParameterList list = methodCallExpression.getMethodExpression().getParameterList();
        if (list != null && list.getTypeArguments().length > 0) {
            String string = list.getText();
            if (string == null) {
                ExtractMethodObjectProcessor.$$$reportNull$$$0(6);
            }
            return string;
        }
        PsiTypeParameter[] methodTypeParameters = this.getMethod().getTypeParameters();
        if (methodTypeParameters.length > 0) {
            ArrayList<String> typeSignature = new ArrayList<String>();
            PsiSubstitutor substitutor = methodCallExpression.resolveMethodGenerics().getSubstitutor();
            for (PsiTypeParameter typeParameter : methodTypeParameters) {
                PsiType type = substitutor.substitute(typeParameter);
                if (!PsiTypesUtil.isDenotableType((PsiType)type, (PsiElement)methodCallExpression)) {
                    return "";
                }
                typeSignature.add(type.getPresentableText());
            }
            String string = "<" + StringUtil.join(typeSignature, (String)", ") + ">";
            if (string == null) {
                ExtractMethodObjectProcessor.$$$reportNull$$$0(7);
            }
            return string;
        }
        return "";
    }

    @NotNull
    protected String getCommandName() {
        String string = JavaRefactoringBundle.message((String)"extract.method.object", (Object[])new Object[0]);
        if (string == null) {
            ExtractMethodObjectProcessor.$$$reportNull$$$0(8);
        }
        return string;
    }

    private boolean copyMethodModifiers() throws IncorrectOperationException {
        PsiModifierList methodModifierList = this.getMethod().getModifierList();
        PsiModifierList innerClassModifierList = this.myInnerClass.getModifierList();
        LOG.assertTrue(innerClassModifierList != null);
        innerClassModifierList.setModifierProperty(VisibilityUtil.getVisibilityModifier((PsiModifierList)methodModifierList), true);
        boolean isStatic = methodModifierList.hasModifierProperty("static");
        innerClassModifierList.setModifierProperty("static", isStatic);
        return isStatic;
    }

    private void copyMethodTypeParameters() throws IncorrectOperationException {
        PsiTypeParameterList typeParameterList = this.myInnerClass.getTypeParameterList();
        LOG.assertTrue(typeParameterList != null);
        for (PsiTypeParameter parameter : this.getMethod().getTypeParameters()) {
            typeParameterList.add((PsiElement)parameter);
        }
    }

    private void copyMethodWithoutParameters() throws IncorrectOperationException {
        PsiMethod newMethod = this.myElementFactory.createMethod("invoke", this.getMethod().getReturnType());
        newMethod.getThrowsList().replace((PsiElement)this.getMethod().getThrowsList());
        PsiCodeBlock replacedMethodBody = newMethod.getBody();
        LOG.assertTrue(replacedMethodBody != null);
        PsiCodeBlock methodBody = this.getMethod().getBody();
        LOG.assertTrue(methodBody != null);
        if (this.isCreateInnerClass()) {
            this.adjustTargetClassReferences((PsiElement)methodBody);
        }
        replacedMethodBody.replace((PsiElement)methodBody);
        PsiUtil.setModifierProperty((PsiModifierListOwner)newMethod, (String)"static", (this.myInnerClass.hasModifierProperty("static") && this.notHasGeneratedFields() ? 1 : 0) != 0);
        this.myInnerMethod = (PsiMethod)this.myInnerClass.add((PsiElement)newMethod);
    }

    private void adjustTargetClassReferences(PsiElement body) throws IncorrectOperationException {
        final PsiManager manager = PsiManager.getInstance((Project)this.myProject);
        final PsiClass targetClass = this.getMethod().getContainingClass();
        body.accept((PsiElementVisitor)new JavaRecursiveElementVisitor(this){

            public void visitReturnStatement(@NotNull PsiReturnStatement statement) {
                if (statement == null) {
                    5.$$$reportNull$$$0(0);
                }
                if (statement.getCopyableUserData(GENERATED_RETURN) == null) {
                    super.visitReturnStatement(statement);
                }
            }

            public void visitThisExpression(@NotNull PsiThisExpression expression) {
                if (expression == null) {
                    5.$$$reportNull$$$0(1);
                }
                if (expression.getQualifier() == null) {
                    expression.replace((PsiElement)RefactoringChangeUtil.createThisExpression((PsiManager)manager, (PsiClass)targetClass));
                }
            }

            public void visitSuperExpression(@NotNull PsiSuperExpression expression) {
                if (expression == null) {
                    5.$$$reportNull$$$0(2);
                }
                if (expression.getQualifier() == null) {
                    expression.replace((PsiElement)RefactoringChangeUtil.createSuperExpression((PsiManager)manager, (PsiClass)targetClass));
                }
            }

            public void visitClass(@NotNull PsiClass aClass) {
                if (aClass == null) {
                    5.$$$reportNull$$$0(3);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "statement";
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "expression";
                        break;
                    }
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "aClass";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/refactoring/extractMethodObject/ExtractMethodObjectProcessor$5";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitReturnStatement";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitThisExpression";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitSuperExpression";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitClass";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
    }

    private boolean notHasGeneratedFields() {
        return !this.myMultipleExitPoints && this.getMethod().getParameterList().isEmpty();
    }

    private void createInnerClassConstructor(PsiParameter[] parameters) throws IncorrectOperationException {
        PsiMethod constructor = this.myElementFactory.createConstructor();
        PsiParameterList parameterList = constructor.getParameterList();
        for (PsiParameter parameter : parameters) {
            PsiModifierList parameterModifierList = parameter.getModifierList();
            LOG.assertTrue(parameterModifierList != null);
            String parameterName = parameter.getName();
            PsiParameter parm = this.myElementFactory.createParameter(parameterName, parameter.getType());
            if (((JavaCodeStyleSettings)this.myStyleSettings.getCustomSettings(JavaCodeStyleSettings.class)).GENERATE_FINAL_PARAMETERS) {
                PsiModifierList modifierList = parm.getModifierList();
                LOG.assertTrue(modifierList != null);
                modifierList.setModifierProperty("final", true);
            }
            parameterList.add((PsiElement)parm);
            PsiField field = this.createField(parm, constructor, parameterModifierList.hasModifierProperty("final"));
            for (PsiReference reference : ReferencesSearch.search((PsiElement)parameter, (SearchScope)parameter.getUseScope()).asIterable()) {
                reference.handleElementRename(field.getName());
            }
        }
        this.myInnerClass.add((PsiElement)constructor);
    }

    private PsiField createField(PsiParameter parameter, PsiMethod constructor, boolean isFinal) {
        String parameterName = parameter.getName();
        PsiType type = parameter.getType();
        if (type instanceof PsiEllipsisType) {
            type = ((PsiEllipsisType)type).toArrayType();
        }
        try {
            JavaCodeStyleManager styleManager = JavaCodeStyleManager.getInstance((Project)this.getMethod().getProject());
            String fieldName = this.uniqueFieldName(styleManager.suggestVariableName((VariableKind)VariableKind.FIELD, (String)styleManager.variableNameToPropertyName((String)parameterName, (VariableKind)VariableKind.PARAMETER), null, (PsiType)type).names);
            PsiField field = this.myElementFactory.createField(fieldName, type);
            PsiModifierList modifierList = field.getModifierList();
            LOG.assertTrue(modifierList != null);
            if (NullableNotNullManager.isNullable((PsiModifierListOwner)parameter)) {
                String annotationName = NullableNotNullManager.getInstance((Project)this.myProject).getDefaultAnnotation(Nullability.NULLABLE, (PsiElement)field);
                modifierList.addAfter((PsiElement)this.myElementFactory.createAnnotationFromText("@" + annotationName, (PsiElement)field), null);
            }
            modifierList.setModifierProperty("final", isFinal);
            PsiCodeBlock methodBody = constructor.getBody();
            LOG.assertTrue(methodBody != null);
            @NonNls String stmtText = Comparing.strEqual((String)parameterName, (String)fieldName) ? "this." + fieldName + " = " + parameterName + ";" : fieldName + " = " + parameterName + ";";
            PsiStatement assignmentStmt = this.myElementFactory.createStatementFromText(stmtText, (PsiElement)methodBody);
            assignmentStmt = (PsiStatement)CodeStyleManager.getInstance((Project)constructor.getProject()).reformat((PsiElement)assignmentStmt);
            methodBody.add((PsiElement)assignmentStmt);
            field = (PsiField)this.myInnerClass.add((PsiElement)field);
            return field;
        }
        catch (IncorrectOperationException e) {
            LOG.error((Throwable)e);
            return null;
        }
    }

    protected void changeInstanceAccess(Project project) throws IncorrectOperationException {
        if (this.myMadeStatic) {
            PsiReference[] refs;
            for (PsiReference ref : refs = (PsiReference[])ReferencesSearch.search((PsiElement)this.myInnerMethod, (SearchScope)GlobalSearchScope.projectScope((Project)project), (boolean)false).toArray((Object[])PsiReference.EMPTY_ARRAY)) {
                PsiElement element = ref.getElement();
                PsiMethodCallExpression callExpression = (PsiMethodCallExpression)PsiTreeUtil.getParentOfType((PsiElement)element, PsiMethodCallExpression.class);
                if (callExpression == null) continue;
                this.replaceMethodCallExpression(this.inferTypeArguments(callExpression), callExpression);
            }
        }
    }

    public PsiMethod getMethod() {
        return this.myExtractProcessor.getExtractedMethod();
    }

    @NotNull
    public String getInnerClassName() {
        String string = this.myInnerClassName;
        if (string == null) {
            ExtractMethodObjectProcessor.$$$reportNull$$$0(9);
        }
        return string;
    }

    public void setCreateInnerClass(boolean createInnerClass) {
        this.myCreateInnerClass = createInnerClass;
    }

    public boolean isCreateInnerClass() {
        return this.myCreateInnerClass;
    }

    public MyExtractMethodProcessor getExtractProcessor() {
        return this.myExtractProcessor;
    }

    protected AbstractExtractDialog createExtractMethodObjectDialog(final MyExtractMethodProcessor processor) {
        return new ExtractMethodObjectDialog(this, this.myProject, processor.getTargetClass(), processor.getInputVariables(), processor.getReturnType(), processor.getTypeParameterList(), (PsiType[])processor.getThrownExceptions(), processor.isStatic(), processor.isCanBeStatic(), processor.getElements(), this.myMultipleExitPoints){

            @Override
            protected boolean isUsedAfter(PsiVariable variable) {
                return ArrayUtil.find((Object[])processor.getOutputVariables(), (Object)variable) != -1;
            }
        };
    }

    protected PsiElement addInnerClass(PsiClass containingClass, PsiClass innerClass) {
        return containingClass.add((PsiElement)innerClass);
    }

    public PsiClass getInnerClass() {
        return this.myInnerClass;
    }

    protected boolean isFoldingApplicable() {
        return true;
    }

    private String uniqueFieldName(String[] candidates) {
        String name = (String)ContainerUtil.find((Object[])candidates, arg_0 -> ((UniqueNameGenerator)this.myFieldNameGenerator).isUnique(arg_0));
        if (name == null) {
            name = this.myFieldNameGenerator.generateUniqueName(candidates[0]);
        }
        this.myFieldNameGenerator.addExistingName(name);
        return name;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 5, 6, 7, 8, 9 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "innerClassName";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "usages";
                break;
            }
            case 2: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/refactoring/extractMethodObject/ExtractMethodObjectProcessor";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "var";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/refactoring/extractMethodObject/ExtractMethodObjectProcessor";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "findUsages";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getPureName";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "inferTypeArguments";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getCommandName";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getInnerClassName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "createUsageViewDescriptor";
                break;
            }
            case 2: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "performRefactoring";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getPureName";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 5, 6, 7, 8, 9 -> new IllegalStateException(string);
        };
    }

    public class MyExtractMethodProcessor
    extends ExtractMethodProcessor {
        public MyExtractMethodProcessor(Project project, Editor editor, PsiElement[] elements, @NlsContexts.DialogTitle PsiType forcedReturnType, String refactoringName, String initialMethodName, String helpId) {
            super(project, editor, elements, forcedReturnType, refactoringName, initialMethodName, helpId);
        }

        @Override
        protected void initDuplicates(@Nullable Set<? extends TextRange> textRanges) {
            this.myDuplicates = Optional.ofNullable(this.getExactDuplicatesFinder()).map(finder -> finder.findDuplicates((PsiElement)this.myTargetClass)).orElse(new ArrayList());
        }

        @Override
        public boolean initParametrizedDuplicates(boolean showDialog) {
            return false;
        }

        @Override
        protected boolean insertNotNullCheckIfPossible() {
            return false;
        }

        @Override
        protected boolean isNeedToChangeCallContext() {
            return false;
        }

        @Override
        protected void apply(AbstractExtractDialog dialog) {
            super.apply(dialog);
            ExtractMethodObjectProcessor.this.myCreateInnerClass = !(dialog instanceof ExtractMethodObjectDialog) || ((ExtractMethodObjectDialog)dialog).createInnerClass();
            ExtractMethodObjectProcessor.this.myInnerClassName = ExtractMethodObjectProcessor.this.myCreateInnerClass ? StringUtil.capitalize((String)dialog.getChosenMethodName()) : dialog.getChosenMethodName();
        }

        @Override
        protected AbstractExtractDialog createExtractMethodDialog(boolean direct) {
            return ExtractMethodObjectProcessor.this.createExtractMethodObjectDialog(this);
        }

        @Override
        protected PsiExpression expressionToReplace(PsiExpression expression) {
            PsiExpression operand;
            IElementType elementType;
            if (expression instanceof PsiUnaryExpression && ((elementType = ((PsiUnaryExpression)expression).getOperationTokenType()) == JavaTokenType.PLUSPLUS || elementType == JavaTokenType.MINUSMINUS) && (operand = ((PsiUnaryExpression)expression).getOperand()) != null) {
                return ((PsiBinaryExpression)expression.replace((PsiElement)ExtractMethodObjectProcessor.this.myElementFactory.createExpressionFromText(operand.getText() + " + x", (PsiElement)operand))).getROperand();
            }
            return super.expressionToReplace(expression);
        }

        @Override
        protected boolean checkOutputVariablesCount() {
            ExtractMethodObjectProcessor.this.myMultipleExitPoints = super.checkOutputVariablesCount();
            ExtractMethodObjectProcessor.this.myOutputFields = new PsiField[this.myOutputVariables.length];
            for (int i = 0; i < this.myOutputVariables.length; ++i) {
                PsiVariable variable = this.myOutputVariables[i];
                if (this.myInputVariables.contains(variable)) continue;
                String fieldName = ExtractMethodObjectProcessor.this.uniqueFieldName(JavaCodeStyleManager.getInstance((Project)this.myProject).suggestVariableName((VariableKind)VariableKind.FIELD, (String)ExtractMethodObjectProcessor.this.getPureName((PsiVariable)variable), null, (PsiType)variable.getType()).names);
                try {
                    ExtractMethodObjectProcessor.this.myOutputFields[i] = ExtractMethodObjectProcessor.this.myElementFactory.createField(fieldName, variable.getType());
                    continue;
                }
                catch (IncorrectOperationException e) {
                    LOG.error((Throwable)e);
                }
            }
            return !ExtractMethodObjectProcessor.this.myCreateInnerClass && ExtractMethodObjectProcessor.this.myMultipleExitPoints;
        }

        @Override
        public PsiElement processMatch(Match match) throws IncorrectOperationException {
            PsiMethodCallExpression methodCallExpression;
            boolean makeStatic = ExtractMethodObjectProcessor.this.myInnerMethod != null && CommonJavaRefactoringUtil.isInStaticContext((PsiElement)match.getMatchStart(), (PsiClass)this.getExtractedMethod().getContainingClass()) && !ExtractMethodObjectProcessor.this.myInnerMethod.getContainingClass().hasModifierProperty("static");
            PsiElement element = super.processMatch(match);
            if (makeStatic) {
                ExtractMethodObjectProcessor.this.myMadeStatic = true;
                PsiModifierList modifierList = ExtractMethodObjectProcessor.this.myInnerMethod.getContainingClass().getModifierList();
                LOG.assertTrue(modifierList != null);
                modifierList.setModifierProperty("static", true);
                PsiUtil.setModifierProperty((PsiModifierListOwner)ExtractMethodObjectProcessor.this.myInnerMethod, (String)"static", (boolean)true);
            }
            if ((methodCallExpression = this.getMatchMethodCallExpression(element)) == null) {
                return element;
            }
            PsiExpression expression = ExtractMethodObjectProcessor.this.processMethodDeclaration(methodCallExpression.getArgumentList());
            return methodCallExpression.replace((PsiElement)expression);
        }

        @Override
        protected void declareNecessaryVariablesAfterCall(PsiVariable outputVariable) throws IncorrectOperationException {
            if (ExtractMethodObjectProcessor.this.myMultipleExitPoints) {
                String object = JavaCodeStyleManager.getInstance((Project)this.myProject).suggestUniqueVariableName(StringUtil.decapitalize((String)ExtractMethodObjectProcessor.this.myInnerClassName), (PsiElement)outputVariable, true);
                PsiStatement methodCallStatement = (PsiStatement)PsiTreeUtil.getParentOfType((PsiElement)this.getMethodCall(), PsiStatement.class);
                LOG.assertTrue(methodCallStatement != null);
                PsiStatement declarationStatement = ExtractMethodObjectProcessor.this.myElementFactory.createStatementFromText(ExtractMethodObjectProcessor.this.myInnerClassName + " " + object + " = " + this.getMethodCall().getText() + ";", (PsiElement)ExtractMethodObjectProcessor.this.myInnerMethod);
                if (methodCallStatement instanceof PsiIfStatement) {
                    methodCallStatement.getParent().addBefore((PsiElement)declarationStatement, (PsiElement)methodCallStatement);
                    PsiExpression conditionExpression = ((PsiIfStatement)methodCallStatement).getCondition();
                    this.setMethodCall((PsiMethodCallExpression)conditionExpression.replace((PsiElement)ExtractMethodObjectProcessor.this.myElementFactory.createExpressionFromText(object + ".is()", (PsiElement)ExtractMethodObjectProcessor.this.myInnerMethod)));
                } else if (this.myElements[0] instanceof PsiExpression) {
                    methodCallStatement.getParent().addBefore((PsiElement)declarationStatement, (PsiElement)methodCallStatement);
                } else {
                    PsiDeclarationStatement replace = (PsiDeclarationStatement)methodCallStatement.replace((PsiElement)declarationStatement);
                    this.setMethodCall((PsiMethodCallExpression)((PsiLocalVariable)replace.getDeclaredElements()[0]).getInitializer());
                }
                Object[] usedVariables = this.myOutputVariables;
                if (this.generatesConditionalExit() && this.myOutputVariable != null && !this.myControlFlowWrapper.needVariableValueAfterEnd(this.myOutputVariable)) {
                    usedVariables = (PsiVariable[])ArrayUtil.remove((Object[])usedVariables, (Object)this.myOutputVariable);
                }
                Collection reassigned = this.myControlFlowWrapper.getInitializedTwice();
                for (Object variable : usedVariables) {
                    String getterName;
                    String name = variable.getName();
                    LOG.assertTrue(name != null);
                    PsiStatement st = null;
                    String pureName = ExtractMethodObjectProcessor.this.getPureName((PsiVariable)variable);
                    int varIdxInOutput = ArrayUtil.find((Object[])this.myOutputVariables, (Object)variable);
                    String string = getterName = varIdxInOutput > -1 && ExtractMethodObjectProcessor.this.myOutputFields[varIdxInOutput] != null ? GenerateMembersUtil.suggestGetterName((PsiField)ExtractMethodObjectProcessor.this.myOutputFields[varIdxInOutput]) : GenerateMembersUtil.suggestGetterName((String)pureName, (PsiType)variable.getType(), (Project)this.myProject);
                    if (this.isDeclaredInside((PsiVariable)variable)) {
                        st = ExtractMethodObjectProcessor.this.myElementFactory.createStatementFromText(variable.getType().getCanonicalText() + " " + name + " = " + object + "." + getterName + "();", (PsiElement)ExtractMethodObjectProcessor.this.myInnerMethod);
                        if (reassigned.contains(new ControlFlowUtil.VariableInfo((PsiVariable)variable, null))) {
                            PsiElement[] psiElements = ((PsiDeclarationStatement)st).getDeclaredElements();
                            assert (psiElements.length > 0);
                            PsiVariable var = (PsiVariable)psiElements[0];
                            PsiUtil.setModifierProperty((PsiModifierListOwner)var, (String)"final", (boolean)false);
                        }
                    } else if (varIdxInOutput != -1) {
                        st = ExtractMethodObjectProcessor.this.myElementFactory.createStatementFromText(name + " = " + object + "." + getterName + "();", (PsiElement)ExtractMethodObjectProcessor.this.myInnerMethod);
                    }
                    if (st == null) continue;
                    this.addToMethodCallLocation(st);
                }
                if (this.myElements[0] instanceof PsiAssignmentExpression) {
                    this.getMethodCall().getParent().replace((PsiElement)((PsiAssignmentExpression)this.getMethodCall().getParent()).getLExpression());
                } else if (this.myElements[0] instanceof PsiUnaryExpression) {
                    this.getMethodCall().getParent().replace((PsiElement)((PsiBinaryExpression)this.getMethodCall().getParent()).getLOperand());
                }
                this.rebindExitStatement(object);
            } else {
                super.declareNecessaryVariablesAfterCall(outputVariable);
            }
        }

        @Override
        protected boolean isFoldingApplicable() {
            return ExtractMethodObjectProcessor.this.isFoldingApplicable();
        }

        private void rebindExitStatement(final String objectName) {
            PsiStatement exitStatementCopy = ExtractMethodObjectProcessor.this.myExtractProcessor.myFirstExitStatementCopy;
            if (exitStatementCopy != null) {
                ExtractMethodObjectProcessor.this.myExtractProcessor.myDuplicates = new ArrayList();
                final HashMap<String, PsiVariable> outVarsNames = new HashMap<String, PsiVariable>();
                for (PsiVariable variable : this.myOutputVariables) {
                    outVarsNames.put(variable.getName(), variable);
                }
                final HashMap replaceMap = new HashMap();
                exitStatementCopy.accept((PsiElementVisitor)new JavaRecursiveElementWalkingVisitor(){

                    public void visitReferenceExpression(@NotNull PsiReferenceExpression expression) {
                        PsiVariable variable;
                        if (expression == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        super.visitReferenceExpression(expression);
                        if (expression.resolve() == null && (variable = (PsiVariable)outVarsNames.get(expression.getReferenceName())) != null) {
                            String call2Getter = objectName + "." + GenerateMembersUtil.suggestGetterName((String)ExtractMethodObjectProcessor.this.getPureName(variable), (PsiType)variable.getType(), (Project)MyExtractMethodProcessor.this.myProject) + "()";
                            PsiExpression callToGetter = ExtractMethodObjectProcessor.this.myElementFactory.createExpressionFromText(call2Getter, (PsiElement)variable);
                            replaceMap.put(expression, callToGetter);
                        }
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/intellij/refactoring/extractMethodObject/ExtractMethodObjectProcessor$MyExtractMethodProcessor$1", "visitReferenceExpression"));
                    }
                });
                for (PsiElement element : replaceMap.keySet()) {
                    if (!element.isValid()) continue;
                    element.replace((PsiElement)replaceMap.get(element));
                }
            }
        }

        public boolean generatesConditionalExit() {
            return this.myGenerateConditionalExit;
        }
    }
}

