/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.extractMethodObject.reflect;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiEllipsisType;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.ClassUtil;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.refactoring.extractMethodObject.reflect.FieldAccessType;
import com.intellij.refactoring.extractMethodObject.reflect.PsiReflectionAccessUtil;
import com.intellij.util.SmartList;
import java.util.Collections;
import java.util.List;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ReflectionAccessMethodBuilder {
    private static final Logger LOG = Logger.getInstance(ReflectionAccessMethodBuilder.class);
    private boolean myIsStatic;
    private String myReturnType;
    private final String myName;
    private MyBodyProvider myBodyProvider;
    private final List<ParameterInfo> myParameters;

    public ReflectionAccessMethodBuilder(@NotNull String name) {
        if (name == null) {
            ReflectionAccessMethodBuilder.$$$reportNull$$$0(0);
        }
        this.myIsStatic = false;
        this.myReturnType = "void";
        this.myParameters = new SmartList();
        this.myName = name;
    }

    public PsiMethod build(@NotNull PsiElementFactory elementFactory, @Nullable PsiElement context) {
        if (elementFactory == null) {
            ReflectionAccessMethodBuilder.$$$reportNull$$$0(1);
        }
        this.checkRequirements();
        String parameters = StreamEx.of(this.myParameters).map(p -> p.accessibleType + " " + p.name).joining((CharSequence)", ", (CharSequence)"(", (CharSequence)")");
        Object methodBody = this.myBodyProvider.createBody(this.myReturnType);
        List<String> possibleExceptions = this.myBodyProvider.getPossibleExceptions();
        if (!possibleExceptions.isEmpty()) {
            methodBody = "try {\n" + (String)methodBody + "}\n" + ReflectionAccessMethodBuilder.createCatchBlocks(possibleExceptions);
        }
        String methodText = "public" + (this.myIsStatic ? " static " : " ") + this.myReturnType + " " + this.myName + parameters + " { \n" + (String)methodBody + "}\n";
        return elementFactory.createMethodFromText(methodText, context);
    }

    private void checkRequirements() {
        if (this.myBodyProvider == null) {
            LOG.error("Accessed member not specified");
        }
    }

    public ReflectionAccessMethodBuilder accessedMethod(@NotNull String jvmClassName, @NotNull String methodName) {
        if (jvmClassName == null) {
            ReflectionAccessMethodBuilder.$$$reportNull$$$0(2);
        }
        if (methodName == null) {
            ReflectionAccessMethodBuilder.$$$reportNull$$$0(3);
        }
        this.myBodyProvider = new MyMethodAccessor(jvmClassName, methodName);
        return this;
    }

    public ReflectionAccessMethodBuilder accessedField(@NotNull String jvmClassName, @NotNull String fieldName) {
        if (jvmClassName == null) {
            ReflectionAccessMethodBuilder.$$$reportNull$$$0(4);
        }
        if (fieldName == null) {
            ReflectionAccessMethodBuilder.$$$reportNull$$$0(5);
        }
        this.myBodyProvider = new MyFieldAccessor(jvmClassName, fieldName, FieldAccessType.GET);
        return this;
    }

    public ReflectionAccessMethodBuilder updatedField(@NotNull String jvmClassName, @NotNull String fieldName) {
        if (jvmClassName == null) {
            ReflectionAccessMethodBuilder.$$$reportNull$$$0(6);
        }
        if (fieldName == null) {
            ReflectionAccessMethodBuilder.$$$reportNull$$$0(7);
        }
        this.myBodyProvider = new MyFieldAccessor(jvmClassName, fieldName, FieldAccessType.SET);
        return this;
    }

    public ReflectionAccessMethodBuilder accessedConstructor(@NotNull String jvmClassName) {
        if (jvmClassName == null) {
            ReflectionAccessMethodBuilder.$$$reportNull$$$0(8);
        }
        this.myBodyProvider = new MyConstructorAccessor(jvmClassName);
        return this;
    }

    public ReflectionAccessMethodBuilder newArray(@NotNull String jvmClassName) {
        if (jvmClassName == null) {
            ReflectionAccessMethodBuilder.$$$reportNull$$$0(9);
        }
        this.myBodyProvider = new MyNewArrayGenerator(jvmClassName);
        return this;
    }

    public ReflectionAccessMethodBuilder setReturnType(@NotNull String returnType) {
        if (returnType == null) {
            ReflectionAccessMethodBuilder.$$$reportNull$$$0(10);
        }
        this.myReturnType = returnType;
        return this;
    }

    public ReflectionAccessMethodBuilder setStatic(boolean isStatic) {
        this.myIsStatic = isStatic;
        return this;
    }

    public ReflectionAccessMethodBuilder addParameter(@NotNull String jvmType, @NotNull String name) {
        if (jvmType == null) {
            ReflectionAccessMethodBuilder.$$$reportNull$$$0(11);
        }
        if (name == null) {
            ReflectionAccessMethodBuilder.$$$reportNull$$$0(12);
        }
        this.myParameters.add(new ParameterInfo(jvmType.replace('$', '.'), name, new TypeInfo(jvmType, 0)));
        return this;
    }

    public ReflectionAccessMethodBuilder addParameters(@NotNull PsiParameterList parameterList) {
        if (parameterList == null) {
            ReflectionAccessMethodBuilder.$$$reportNull$$$0(13);
        }
        PsiParameter[] parameters = parameterList.getParameters();
        for (int i = 0; i < parameters.length; ++i) {
            PsiType parameterType = parameters[i].getType();
            PsiType erasedType = TypeConversionUtil.erasure((PsiType)parameterType);
            String typeName = ReflectionAccessMethodBuilder.typeName(parameterType, erasedType);
            TypeInfo jvmType = erasedType != null ? ReflectionAccessMethodBuilder.extractJvmType(erasedType) : new TypeInfo(typeName, 0);
            String name = "p" + i;
            if (ReflectionAccessMethodBuilder.requiresObjectType(parameterType)) {
                this.myParameters.add(new ParameterInfo("java.lang.Object", name, jvmType));
                continue;
            }
            PsiType accessedType = PsiReflectionAccessUtil.nearestAccessibleType(parameterType, (PsiElement)parameterList);
            this.myParameters.add(new ParameterInfo(accessedType.getCanonicalText(), name, jvmType));
        }
        return this;
    }

    private static boolean requiresObjectType(PsiType type) {
        if (type instanceof PsiEllipsisType) {
            return false;
        }
        if (type instanceof PsiArrayType) {
            return true;
        }
        PsiClass psiClass = PsiTypesUtil.getPsiClass((PsiType)type);
        return psiClass != null && (psiClass.isRecord() || psiClass.isEnum());
    }

    @NotNull
    private static String typeName(@NotNull PsiType type, @Nullable PsiType erasedType) {
        if (type == null) {
            ReflectionAccessMethodBuilder.$$$reportNull$$$0(14);
        }
        if (erasedType == null) {
            String typeName = type.getCanonicalText();
            int typeParameterIndex = typeName.indexOf(60);
            if (typeParameterIndex != -1) {
                typeName = typeName.substring(0, typeParameterIndex);
            }
            LOG.warn("Type erasure failed, the following type used instead: " + typeName);
            String string = typeName;
            if (string == null) {
                ReflectionAccessMethodBuilder.$$$reportNull$$$0(15);
            }
            return string;
        }
        String string = erasedType.getCanonicalText();
        if (string == null) {
            ReflectionAccessMethodBuilder.$$$reportNull$$$0(16);
        }
        return string;
    }

    @NotNull
    private static TypeInfo extractJvmType(@NotNull PsiType type) {
        if (type == null) {
            ReflectionAccessMethodBuilder.$$$reportNull$$$0(17);
        }
        int arrayDimension = 0;
        while (type instanceof PsiArrayType) {
            PsiArrayType arrayType = (PsiArrayType)type;
            ++arrayDimension;
            type = arrayType.getComponentType();
        }
        PsiClass psiClass = PsiUtil.resolveClassInType((PsiType)type);
        String canonicalText = type.getCanonicalText();
        String jvmName = psiClass == null ? canonicalText : ClassUtil.getJVMClassName((PsiClass)psiClass);
        return new TypeInfo(jvmName == null ? canonicalText : jvmName, arrayDimension);
    }

    private static String createCatchBlocks(@NotNull List<String> exceptions) {
        if (exceptions == null) {
            ReflectionAccessMethodBuilder.$$$reportNull$$$0(18);
        }
        return StreamEx.of(exceptions).map(x -> "catch(" + x + " e) { throw new java.lang.RuntimeException(e); }").joining((CharSequence)"\n");
    }

    private String parametersStringForInvoke() {
        return StreamEx.of(this.myParameters).map(x -> {
            if (x.jvmType.arrayDimension > 0) {
                return "(java.lang.Object)" + x.name;
            }
            return x.name;
        }).joining((CharSequence)", ", (CharSequence)"(", (CharSequence)")");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 15, 16 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementFactory";
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jvmClassName";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methodName";
                break;
            }
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fieldName";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "returnType";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jvmType";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameterList";
                break;
            }
            case 14: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 15: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/refactoring/extractMethodObject/reflect/ReflectionAccessMethodBuilder";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "exceptions";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/refactoring/extractMethodObject/reflect/ReflectionAccessMethodBuilder";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "typeName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "build";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "accessedMethod";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "accessedField";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "updatedField";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "accessedConstructor";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "newArray";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "setReturnType";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "addParameter";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "addParameters";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "typeName";
                break;
            }
            case 15: 
            case 16: {
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "extractJvmType";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "createCatchBlocks";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 15, 16 -> new IllegalStateException(string);
        };
    }

    private static interface MyBodyProvider {
        public List<String> getPossibleExceptions();

        public String createBody(String var1);
    }

    private class MyMethodAccessor
    extends MyMemberAccessor {
        private final String myClassName;
        private final String myMethodName;

        MyMethodAccessor(@NotNull String className, String methodName) {
            if (className == null) {
                MyMethodAccessor.$$$reportNull$$$0(0);
            }
            if (methodName == null) {
                MyMethodAccessor.$$$reportNull$$$0(1);
            }
            this.myClassName = className;
            this.myMethodName = methodName;
        }

        @Override
        public String getMemberLookupExpression() {
            String args = ((StreamEx)StreamEx.of(ReflectionAccessMethodBuilder.this.myParameters).skip(1L)).map(x -> x.jvmType.lookupClass()).prepend((Object)StringUtil.wrapWithDoubleQuote((String)this.myMethodName)).joining((CharSequence)", ", (CharSequence)"(", (CharSequence)")");
            return "getDeclaredMethod" + args;
        }

        @Override
        public String getClassLookupExpression() {
            return PsiReflectionAccessUtil.classForName(this.myClassName);
        }

        @Override
        public String getMemberType() {
            return "java.lang.reflect.Method";
        }

        @Override
        public List<String> getPossibleExceptions() {
            return Collections.singletonList("java.lang.ReflectiveOperationException");
        }

        @Override
        String getReturnExpression(String returnType) {
            String invokeString = "member.invoke" + ReflectionAccessMethodBuilder.this.parametersStringForInvoke();
            return "void".equals(returnType) ? invokeString : "return (" + returnType + ")" + invokeString;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "className";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "methodName";
                    break;
                }
            }
            objectArray[1] = "com/intellij/refactoring/extractMethodObject/reflect/ReflectionAccessMethodBuilder$MyMethodAccessor";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class MyFieldAccessor
    extends MyMemberAccessor {
        private static final List<String> EXCEPTIONS = Collections.singletonList("java.lang.ReflectiveOperationException");
        private final String myFieldName;
        private final String myClassName;
        private final FieldAccessType myAccessType;

        MyFieldAccessor(@NotNull String className, @NotNull String fieldName, @NotNull FieldAccessType accessType) {
            if (className == null) {
                MyFieldAccessor.$$$reportNull$$$0(0);
            }
            if (fieldName == null) {
                MyFieldAccessor.$$$reportNull$$$0(1);
            }
            if (accessType == null) {
                MyFieldAccessor.$$$reportNull$$$0(2);
            }
            this.myFieldName = fieldName;
            this.myClassName = className;
            this.myAccessType = accessType;
        }

        @Override
        public String getClassLookupExpression() {
            return PsiReflectionAccessUtil.classForName(this.myClassName);
        }

        @Override
        public String getMemberLookupExpression() {
            return "getDeclaredField(" + StringUtil.wrapWithDoubleQuote((String)this.myFieldName) + ")";
        }

        @Override
        String getReturnExpression(String returnType) {
            return FieldAccessType.GET.equals((Object)this.myAccessType) ? "return (" + returnType + ")member.get(object)" : "member.set(object, value); \n return value";
        }

        @Override
        public String getMemberType() {
            return "java.lang.reflect.Field";
        }

        @Override
        public List<String> getPossibleExceptions() {
            return EXCEPTIONS;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "className";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "fieldName";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "accessType";
                    break;
                }
            }
            objectArray[1] = "com/intellij/refactoring/extractMethodObject/reflect/ReflectionAccessMethodBuilder$MyFieldAccessor";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private class MyConstructorAccessor
    extends MyMemberAccessor {
        private final String myClassName;

        MyConstructorAccessor(String className) {
            if (className == null) {
                MyConstructorAccessor.$$$reportNull$$$0(0);
            }
            this.myClassName = className;
        }

        @Override
        public String getMemberLookupExpression() {
            String args = StreamEx.of(ReflectionAccessMethodBuilder.this.myParameters).map(x -> x.jvmType.lookupClass()).joining((CharSequence)", ", (CharSequence)"(", (CharSequence)")");
            return "getDeclaredConstructor" + args;
        }

        @Override
        public String getClassLookupExpression() {
            return PsiReflectionAccessUtil.classForName(this.myClassName);
        }

        @Override
        String getReturnExpression(String returnType) {
            return "return (" + returnType + ")member.newInstance" + ReflectionAccessMethodBuilder.this.parametersStringForInvoke();
        }

        @Override
        public String getMemberType() {
            return "java.lang.reflect.Constructor<?>";
        }

        @Override
        public List<String> getPossibleExceptions() {
            return Collections.singletonList("java.lang.ReflectiveOperationException");
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "className", "com/intellij/refactoring/extractMethodObject/reflect/ReflectionAccessMethodBuilder$MyConstructorAccessor", "<init>"));
        }
    }

    private static class MyNewArrayGenerator
    implements MyBodyProvider {
        private final String myClassName;

        MyNewArrayGenerator(@NotNull String className) {
            if (className == null) {
                MyNewArrayGenerator.$$$reportNull$$$0(0);
            }
            this.myClassName = className;
        }

        @Override
        public String createBody(String returnType) {
            return "return (" + returnType + ")java.lang.reflect.Array.newInstance(" + PsiReflectionAccessUtil.classForName(this.myClassName) + ", dimensions);";
        }

        @Override
        public List<String> getPossibleExceptions() {
            return Collections.singletonList("java.lang.ReflectiveOperationException");
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "className", "com/intellij/refactoring/extractMethodObject/reflect/ReflectionAccessMethodBuilder$MyNewArrayGenerator", "<init>"));
        }
    }

    private record ParameterInfo(@NotNull String accessibleType, @NotNull String name, @NotNull TypeInfo jvmType) {
        @NotNull
        private final String accessibleType;
        @NotNull
        private final String name;
        @NotNull
        private final TypeInfo jvmType;

        private ParameterInfo(@NotNull String accessibleType, @NotNull String name, @NotNull TypeInfo jvmType) {
            if (accessibleType == null) {
                ParameterInfo.$$$reportNull$$$0(0);
            }
            if (name == null) {
                ParameterInfo.$$$reportNull$$$0(1);
            }
            if (jvmType == null) {
                ParameterInfo.$$$reportNull$$$0(2);
            }
        }

        @NotNull
        public String accessibleType() {
            String string = this.accessibleType;
            if (string == null) {
                ParameterInfo.$$$reportNull$$$0(3);
            }
            return string;
        }

        @NotNull
        public String name() {
            String string = this.name;
            if (string == null) {
                ParameterInfo.$$$reportNull$$$0(4);
            }
            return string;
        }

        @NotNull
        public TypeInfo jvmType() {
            TypeInfo typeInfo = this.jvmType;
            if (typeInfo == null) {
                ParameterInfo.$$$reportNull$$$0(5);
            }
            return typeInfo;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 3, 4, 5 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "accessibleType";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "jvmType";
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/refactoring/extractMethodObject/reflect/ReflectionAccessMethodBuilder$ParameterInfo";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/refactoring/extractMethodObject/reflect/ReflectionAccessMethodBuilder$ParameterInfo";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "accessibleType";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "name";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "jvmType";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 3, 4, 5 -> new IllegalStateException(string);
            };
        }
    }

    private static class TypeInfo {
        final int arrayDimension;
        final String typeName;

        private TypeInfo(String name, int dimension) {
            this.arrayDimension = dimension;
            this.typeName = name;
        }

        String lookupClass() {
            if (TypeConversionUtil.isPrimitive((String)this.typeName)) {
                return this.typeName + StringUtil.repeat((String)"[]", (int)this.arrayDimension) + ".class";
            }
            Object className = this.typeName;
            if (this.arrayDimension > 0) {
                className = StringUtil.repeat((String)"[", (int)this.arrayDimension) + "L" + this.typeName + ";";
            }
            return "java.lang.Class.forName(\"" + (String)className + "\")";
        }
    }

    private static abstract class MyMemberAccessor
    implements MyBodyProvider {
        private MyMemberAccessor() {
        }

        abstract String getMemberLookupExpression();

        abstract String getClassLookupExpression();

        abstract String getReturnExpression(String var1);

        abstract String getMemberType();

        @Override
        public String createBody(String returnType) {
            return "  java.lang.Class<?> klass = " + this.getClassLookupExpression() + ";\n  " + this.getMemberType() + " member = null;\n  int interfaceNumber = -1;\n  Class<?>[] interfaces = null;\n  while (member == null) {\n    try {\n      member = klass." + this.getMemberLookupExpression() + ";\n    } catch (java.lang.ReflectiveOperationException e) {\n      if (interfaceNumber == -1) {\n        interfaces = klass.getInterfaces();\n        interfaceNumber = 0;\n      }\n      if (interfaceNumber < interfaces.length) {\n        klass = interfaces[interfaceNumber];\n        interfaceNumber += 1;\n      } else {\n        klass = klass.getSuperclass();\n        if (klass == null) throw e;\n        interfaceNumber = -1;\n      }\n    }\n  }\n  member.setAccessible(true);\n  " + this.getReturnExpression(returnType) + ";\n";
        }
    }
}

