/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.extractclass.usageInfo;

import com.intellij.codeInsight.generation.GenerateMembersUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiBinaryExpression;
import com.intellij.psi.PsiCallExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiSwitchLabelStatementBase;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.psi.MutationUtils;
import com.intellij.refactoring.util.FixableUsageInfo;
import com.intellij.util.ArrayUtil;

public class ReplaceStaticVariableAccess
extends FixableUsageInfo {
    private final PsiReferenceExpression expression;
    private final String delegateClass;
    private final boolean myEnumConstant;
    private static final Logger LOGGER = Logger.getInstance(ReplaceStaticVariableAccess.class);

    public ReplaceStaticVariableAccess(PsiReferenceExpression expression, String delegateClass, boolean enumConstant) {
        super((PsiElement)expression);
        this.expression = expression;
        this.delegateClass = delegateClass;
        this.myEnumConstant = enumConstant;
    }

    public void fixUsage() {
        PsiSwitchLabelStatementBase switchStatement;
        String name = this.expression.getReferenceName();
        if (this.myEnumConstant && (switchStatement = (PsiSwitchLabelStatementBase)PsiTreeUtil.getParentOfType((PsiElement)this.expression, PsiSwitchLabelStatementBase.class)) != null && name != null) {
            MutationUtils.replaceExpression(name, (PsiExpression)this.expression);
            return;
        }
        boolean replaceWithGetEnumValue = this.myEnumConstant && !this.alreadyMigratedToEnum();
        String link = replaceWithGetEnumValue ? "." + GenerateMembersUtil.suggestGetterName((String)"value", (PsiType)this.expression.getType(), (Project)this.expression.getProject()) + "()" : "";
        MutationUtils.replaceExpression(this.delegateClass + "." + name + link, (PsiExpression)this.expression);
    }

    private boolean alreadyMigratedToEnum() {
        PsiCallExpression callExpression = (PsiCallExpression)PsiTreeUtil.getParentOfType((PsiElement)this.expression, PsiCallExpression.class);
        if (callExpression != null) {
            PsiMethod resolvedMethod = callExpression.resolveMethod();
            if (resolvedMethod != null) {
                PsiParameter[] parameters = resolvedMethod.getParameterList().getParameters();
                PsiExpression[] args = callExpression.getArgumentList().getExpressions();
                int idx = -1;
                for (int i = 0; i < args.length; ++i) {
                    if (!PsiTreeUtil.isAncestor((PsiElement)args[i], (PsiElement)this.expression, (boolean)false)) continue;
                    idx = i;
                    break;
                }
                if (idx != -1 && parameters[idx].getType().equalsToText(this.delegateClass)) {
                    return true;
                }
            }
        } else {
            PsiReturnStatement returnStatement = (PsiReturnStatement)PsiTreeUtil.getParentOfType((PsiElement)this.expression, PsiReturnStatement.class);
            if (returnStatement != null) {
                PsiMethod psiMethod = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)this.expression, PsiMethod.class);
                LOGGER.assertTrue(psiMethod != null);
                PsiType returnType = psiMethod.getReturnType();
                if (returnType != null && returnType.getCanonicalText().equals(this.delegateClass)) {
                    return true;
                }
            } else {
                PsiVariable psiVariable = (PsiVariable)PsiTreeUtil.getParentOfType((PsiElement)this.expression, PsiVariable.class);
                if (psiVariable != null) {
                    if (psiVariable.getType().equalsToText(this.delegateClass)) {
                        return true;
                    }
                } else {
                    PsiAssignmentExpression assignmentExpression = (PsiAssignmentExpression)PsiTreeUtil.getParentOfType((PsiElement)this.expression, PsiAssignmentExpression.class);
                    if (assignmentExpression != null && assignmentExpression.getRExpression() == this.expression) {
                        PsiElement resolve;
                        PsiExpression lExpression = assignmentExpression.getLExpression();
                        if (lExpression instanceof PsiReferenceExpression && (resolve = ((PsiReferenceExpression)lExpression).resolve()) instanceof PsiVariable && ((PsiVariable)resolve).getType().equalsToText(this.delegateClass)) {
                            return true;
                        }
                    } else {
                        Object[] operands;
                        int index;
                        PsiBinaryExpression binaryExpression = (PsiBinaryExpression)PsiTreeUtil.getParentOfType((PsiElement)this.expression, PsiBinaryExpression.class);
                        if (binaryExpression != null && binaryExpression.getOperationTokenType() == JavaTokenType.EQEQ && (index = ArrayUtil.find((Object[])(operands = binaryExpression.getOperands()), (Object)this.expression)) >= 0) {
                            PsiType type = operands[index].getType();
                            return type != null && type.equalsToText(this.delegateClass);
                        }
                    }
                }
            }
        }
        return false;
    }
}

