/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.inheritanceToDelegation;

import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiMethod;

public final class InheritanceToDelegationUtil {
    private InheritanceToDelegationUtil() {
    }

    public static boolean isInnerClassNeeded(PsiClass aClass, PsiClass baseClass) {
        PsiMethod[] methods;
        if (baseClass.isInterface()) {
            return true;
        }
        if (baseClass.hasModifierProperty("abstract")) {
            return true;
        }
        for (PsiMethod method : methods = aClass.getMethods()) {
            PsiClass containingClass;
            String qName;
            PsiMethod baseMethod;
            if (method.isConstructor() || method.hasModifierProperty("private") || (baseMethod = baseClass.findMethodBySignature(method, true)) == null || "java.lang.Object".equals(qName = (containingClass = baseMethod.getContainingClass()).getQualifiedName())) continue;
            return true;
        }
        return false;
    }
}

