/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.inheritanceToDelegation;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.refactoring.inheritanceToDelegation.InnerClassMethod;
import com.intellij.util.IncorrectOperationException;

final class InnerClassConstructor
extends InnerClassMethod {
    private static final Logger LOG = Logger.getInstance(InnerClassConstructor.class);

    InnerClassConstructor(PsiMethod method) {
        super(method);
        LOG.assertTrue(method.isConstructor());
    }

    @Override
    public void createMethod(PsiClass innerClass) throws IncorrectOperationException {
        PsiParameter[] parameters;
        PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)innerClass.getProject());
        PsiMethod constructor = factory.createConstructor();
        constructor.getNameIdentifier().replace((PsiElement)innerClass.getNameIdentifier());
        PsiParameterList parameterList = this.myMethod.getParameterList();
        constructor.getParameterList().replace((PsiElement)parameterList);
        PsiExpressionStatement superCallStatement = (PsiExpressionStatement)factory.createStatementFromText("super();", null);
        PsiExpressionList arguments = ((PsiMethodCallExpression)superCallStatement.getExpression()).getArgumentList();
        for (PsiParameter parameter : parameters = parameterList.getParameters()) {
            arguments.add((PsiElement)factory.createExpressionFromText(parameter.getName(), null));
        }
        constructor.getBody().add((PsiElement)superCallStatement);
        innerClass.add((PsiElement)constructor);
    }
}

