/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.inline;

import com.intellij.java.refactoring.JavaRefactoringBundle;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiImportStatementBase;
import com.intellij.psi.PsiNameIdentifierOwner;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.util.PsiFormatUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.JavaRefactoringSettings;
import com.intellij.refactoring.inline.InlineConstantFieldProcessor;
import com.intellij.refactoring.inline.InlineOptionsWithSearchSettingsDialog;

public class InlineFieldDialog
extends InlineOptionsWithSearchSettingsDialog {
    private final PsiElement myReferenceExpression;
    private final PsiField myField;
    protected final int myOccurrencesNumber;

    public InlineFieldDialog(Project project, PsiField field, PsiElement ref) {
        super(project, true, (PsiElement)field);
        this.myField = field;
        this.myReferenceExpression = ref;
        this.myOccurrencesNumber = this.getNumberOfOccurrences((PsiNameIdentifierOwner)this.myField);
        this.myInvokedOnReference = this.myReferenceExpression != null;
        this.setTitle(InlineFieldDialog.getRefactoringName());
        this.init();
    }

    protected String getNameLabelText() {
        int options2 = this.myReferenceExpression != null ? 4097 : 1;
        String fieldText = PsiFormatUtil.formatVariable((PsiVariable)this.myField, (int)options2, (PsiSubstitutor)PsiSubstitutor.EMPTY);
        return this.myOccurrencesNumber > -1 ? JavaRefactoringBundle.message((String)"inline.field.field.occurrences", (Object[])new Object[]{fieldText, this.myOccurrencesNumber}) : JavaRefactoringBundle.message((String)"inline.field.field.name.label", (Object[])new Object[]{fieldText});
    }

    protected String getInlineThisText() {
        return JavaRefactoringBundle.message((String)"this.reference.only.and.keep.the.field", (Object[])new Object[0]);
    }

    protected String getInlineAllText() {
        return JavaRefactoringBundle.message((String)(this.isLibraryInline() ? "all.invocations.in.project" : "all.references.and.remove.the.field"), (Object[])new Object[0]);
    }

    protected String getKeepTheDeclarationText() {
        if (!this.isLibraryInline()) {
            return JavaRefactoringBundle.message((String)"all.references.keep.field", (Object[])new Object[0]);
        }
        return super.getKeepTheDeclarationText();
    }

    private boolean isLibraryInline() {
        return this.myField.getOriginalElement() instanceof PsiCompiledElement;
    }

    protected boolean allowInlineAll() {
        return true;
    }

    protected boolean isInlineThis() {
        return JavaRefactoringSettings.getInstance().INLINE_FIELD_THIS;
    }

    protected boolean isKeepTheDeclarationByDefault() {
        return JavaRefactoringSettings.getInstance().INLINE_FIELD_KEEP;
    }

    protected boolean ignoreOccurrence(PsiReference reference) {
        return PsiTreeUtil.getParentOfType((PsiElement)reference.getElement(), PsiImportStatementBase.class) == null;
    }

    protected boolean isSearchInCommentsAndStrings() {
        return JavaRefactoringSettings.getInstance().RENAME_SEARCH_IN_COMMENTS_FOR_FIELD;
    }

    protected void saveSearchInCommentsAndStrings(boolean searchInComments) {
        JavaRefactoringSettings.getInstance().RENAME_SEARCH_IN_COMMENTS_FOR_FIELD = searchInComments;
    }

    protected boolean isSearchForTextOccurrences() {
        return JavaRefactoringSettings.getInstance().RENAME_SEARCH_FOR_TEXT_FOR_FIELD;
    }

    protected void saveSearchInTextOccurrences(boolean searchInTextOccurrences) {
        JavaRefactoringSettings.getInstance().RENAME_SEARCH_FOR_TEXT_FOR_FIELD = searchInTextOccurrences;
    }

    protected void doAction() {
        super.doAction();
        this.invokeRefactoring(new InlineConstantFieldProcessor(this.myField, this.getProject(), this.myReferenceExpression, this.isInlineThisOnly(), this.isSearchInCommentsAndStrings(), this.isSearchForTextOccurrences(), !this.isLibraryInline() && !this.isKeepTheDeclaration()));
        JavaRefactoringSettings settings = JavaRefactoringSettings.getInstance();
        if (this.myRbInlineThisOnly.isEnabled() && this.myRbInlineAll.isEnabled()) {
            settings.INLINE_FIELD_THIS = this.isInlineThisOnly();
        }
        if (this.myKeepTheDeclaration != null && this.myKeepTheDeclaration.isEnabled()) {
            settings.INLINE_FIELD_KEEP = this.isKeepTheDeclaration();
        }
    }

    protected String getHelpId() {
        return "refactoring.inlineField";
    }

    @NlsContexts.DialogTitle
    public static String getRefactoringName() {
        return JavaRefactoringBundle.message((String)"inline.field.title", (Object[])new Object[0]);
    }
}

