/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.inline;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.psi.GenericsUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiArrayInitializerExpression;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiCallExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiEllipsisType;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiRecordComponent;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiTypeParameterListOwner;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.codeStyle.VariableKind;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.JavaPsiRecordUtil;
import com.intellij.psi.util.MethodSignature;
import com.intellij.psi.util.MethodSignatureUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.refactoring.util.InlineUtil;
import com.intellij.refactoring.util.RefactoringUtil;
import com.intellij.util.ObjectUtils;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

class InlineMethodHelper {
    private static final Logger LOG = Logger.getInstance(InlineMethodHelper.class);
    @NotNull
    private final Project myProject;
    @NotNull
    private final PsiManager myManager;
    @NotNull
    private final PsiMethod myMethod;
    @NotNull
    private final PsiMethod myMethodCopy;
    @NotNull
    private final PsiElementFactory myFactory;
    @NotNull
    private final JavaCodeStyleManager myJavaCodeStyle;
    @NotNull
    private final PsiCallExpression myCall;
    @NotNull
    private final PsiExpressionList myCallArguments;
    @NotNull
    private final PsiSubstitutor mySubstitutor;

    InlineMethodHelper(@NotNull Project project, @NotNull PsiMethod method, @NotNull PsiMethod methodCopy, @NotNull PsiCallExpression call) {
        if (project == null) {
            InlineMethodHelper.$$$reportNull$$$0(0);
        }
        if (method == null) {
            InlineMethodHelper.$$$reportNull$$$0(1);
        }
        if (methodCopy == null) {
            InlineMethodHelper.$$$reportNull$$$0(2);
        }
        if (call == null) {
            InlineMethodHelper.$$$reportNull$$$0(3);
        }
        this.myProject = project;
        this.myManager = method.getManager();
        this.myMethod = method;
        this.myMethodCopy = methodCopy;
        this.myCall = call;
        this.myCallArguments = Objects.requireNonNull(call.getArgumentList());
        this.myFactory = JavaPsiFacade.getElementFactory((Project)this.myProject);
        this.myJavaCodeStyle = JavaCodeStyleManager.getInstance((Project)this.myProject);
        this.mySubstitutor = this.createSubstitutor();
    }

    @NotNull
    PsiSubstitutor getSubstitutor() {
        PsiSubstitutor psiSubstitutor = this.mySubstitutor;
        if (psiSubstitutor == null) {
            InlineMethodHelper.$$$reportNull$$$0(4);
        }
        return psiSubstitutor;
    }

    @NotNull
    private PsiSubstitutor createSubstitutor() {
        JavaResolveResult resolveResult = this.myCall.resolveMethodGenerics();
        PsiSubstitutor origSubstitutor = resolveResult.getSubstitutor();
        PsiSubstitutor substitutor = resolveResult.getSubstitutor();
        if (substitutor != PsiSubstitutor.EMPTY) {
            PsiMethod calledMethod;
            if (this.myMethod.isPhysical() && (calledMethod = (PsiMethod)ObjectUtils.tryCast((Object)resolveResult.getElement(), PsiMethod.class)) != null && !this.myManager.areElementsEquivalent((PsiElement)calledMethod, (PsiElement)this.myMethod)) {
                PsiSubstitutor superSubstitutor = TypeConversionUtil.getSuperClassSubstitutor((PsiClass)Objects.requireNonNull(calledMethod.getContainingClass()), (PsiClass)Objects.requireNonNull(this.myMethod.getContainingClass()), (PsiSubstitutor)PsiSubstitutor.EMPTY);
                PsiSubstitutor superMethodSubstitutor = MethodSignatureUtil.getSuperMethodSignatureSubstitutor((MethodSignature)this.myMethod.getHierarchicalMethodSignature(), (MethodSignature)calledMethod.getHierarchicalMethodSignature());
                if (superMethodSubstitutor != null) {
                    superSubstitutor = superSubstitutor.putAll(superMethodSubstitutor);
                }
                for (Map.Entry entry : superSubstitutor.getSubstitutionMap().entrySet()) {
                    PsiClassType classType;
                    PsiClass psiClass;
                    PsiTypeParameter parameter = (PsiTypeParameter)entry.getKey();
                    PsiType type = (PsiType)entry.getValue();
                    if (!(type instanceof PsiClassType) || !((psiClass = (classType = (PsiClassType)type).resolve()) instanceof PsiTypeParameter)) continue;
                    PsiTypeParameter typeParameter = (PsiTypeParameter)psiClass;
                    substitutor = substitutor.put(typeParameter, origSubstitutor.substitute(parameter));
                }
                origSubstitutor = substitutor;
            }
            Iterator oldTypeParameters = PsiUtil.typeParametersIterator((PsiTypeParameterListOwner)this.myMethod);
            Iterator newTypeParameters = PsiUtil.typeParametersIterator((PsiTypeParameterListOwner)this.myMethodCopy);
            while (newTypeParameters.hasNext()) {
                PsiTypeParameter newTypeParameter = (PsiTypeParameter)newTypeParameters.next();
                PsiTypeParameter oldTypeParameter = (PsiTypeParameter)oldTypeParameters.next();
                substitutor = substitutor.put(newTypeParameter, origSubstitutor.substitute(oldTypeParameter));
            }
        }
        PsiSubstitutor psiSubstitutor = substitutor;
        if (psiSubstitutor == null) {
            InlineMethodHelper.$$$reportNull$$$0(5);
        }
        return psiSubstitutor;
    }

    PsiLocalVariable @NotNull [] declareParameters() {
        PsiCodeBlock block = Objects.requireNonNull(this.myMethodCopy.getBody());
        boolean compactConstructor = JavaPsiRecordUtil.isCompactConstructor((PsiMethod)this.myMethodCopy);
        int applicabilityLevel = PsiUtil.getApplicabilityLevel((PsiMethod)this.myMethod, (PsiSubstitutor)this.mySubstitutor, (PsiExpressionList)this.myCallArguments);
        PsiParameter[] parameters = compactConstructor ? this.myMethod.getParameterList().getParameters() : this.myMethodCopy.getParameterList().getParameters();
        PsiLocalVariable[] parameterVars = new PsiLocalVariable[parameters.length];
        for (int i = parameters.length - 1; i >= 0; --i) {
            Object defaultValue;
            PsiType paramType;
            String variableName;
            PsiRecordComponent component;
            PsiParameter variable = parameters[i];
            if (compactConstructor && (component = JavaPsiRecordUtil.getComponentForCanonicalConstructorParameter((PsiParameter)variable)) != null) {
                variable = JavaPsiRecordUtil.getFieldForComponent((PsiRecordComponent)component);
            }
            assert (variable != null);
            String name = variableName = variable.getName();
            assert (name != null);
            name = this.myJavaCodeStyle.variableNameToPropertyName(name, VariableKind.PARAMETER);
            if (!(name = this.myJavaCodeStyle.propertyNameToVariableName(name, VariableKind.LOCAL_VARIABLE)).equals(variableName)) {
                name = this.myJavaCodeStyle.suggestUniqueVariableName(name, block.getFirstChild(), true);
                RefactoringUtil.renameVariableReferences((PsiVariable)variable, name, (SearchScope)new LocalSearchScope((PsiElement)block), true);
            }
            if ((paramType = variable.getType()) instanceof PsiEllipsisType) {
                PsiEllipsisType ellipsisType = (PsiEllipsisType)paramType;
                paramType = this.mySubstitutor.substitute(ellipsisType.toArrayType());
                if (applicabilityLevel == 2) {
                    PsiType componentType = ((PsiArrayType)paramType).getComponentType();
                    defaultValue = "new " + ((PsiType)ObjectUtils.notNull((Object)TypeConversionUtil.erasure((PsiType)componentType), (Object)componentType)).getCanonicalText() + "[]{}";
                } else {
                    defaultValue = PsiTypesUtil.getDefaultValueOfType((PsiType)paramType);
                }
            } else {
                defaultValue = PsiTypesUtil.getDefaultValueOfType((PsiType)paramType);
            }
            PsiExpression initializer = this.myFactory.createExpressionFromText((String)defaultValue, null);
            PsiDeclarationStatement declaration = this.myFactory.createVariableDeclarationStatement(name, paramType, initializer);
            declaration = (PsiDeclarationStatement)block.addAfter((PsiElement)declaration, null);
            parameterVars[i] = (PsiLocalVariable)declaration.getDeclaredElements()[0];
            PsiUtil.setModifierProperty((PsiModifierListOwner)parameterVars[i], (String)"final", (boolean)variable.hasModifierProperty("final"));
            if (!compactConstructor) continue;
            block.add((PsiElement)this.myFactory.createStatementFromText("this." + variableName + "=" + name + ";", (PsiElement)this.myMethod));
        }
        if (parameterVars == null) {
            InlineMethodHelper.$$$reportNull$$$0(6);
        }
        return parameterVars;
    }

    void initializeParameters(PsiLocalVariable[] vars) {
        PsiExpression[] args = this.myCallArguments.getExpressions();
        if (vars.length > 0) {
            for (int i = 0; i < args.length; ++i) {
                PsiNewExpression newExpression;
                PsiArrayInitializerExpression arrayInitializer;
                int j = Math.min(i, vars.length - 1);
                PsiExpression initializer = vars[j].getInitializer();
                LOG.assertTrue(initializer != null);
                if (initializer instanceof PsiNewExpression && (arrayInitializer = (newExpression = (PsiNewExpression)initializer).getArrayInitializer()) != null) {
                    arrayInitializer.add((PsiElement)args[i]);
                    continue;
                }
                initializer.replace((PsiElement)args[i]);
            }
        }
    }

    void inlineParameters(PsiLocalVariable[] parmVars) {
        PsiParameter[] parameters = (this.myMethod.isValid() ? this.myMethod : this.myMethodCopy).getParameterList().getParameters();
        for (int i = 0; i < parmVars.length; ++i) {
            PsiParameter parameter = parameters[i];
            boolean strictlyFinal = parameter.hasModifierProperty("final") && this.isStrictlyFinal(parameter);
            InlineUtil.tryInlineGeneratedLocal(parmVars[i], strictlyFinal);
        }
    }

    private boolean isStrictlyFinal(PsiParameter parameter) {
        for (PsiReference reference : ReferencesSearch.search((PsiElement)parameter, (SearchScope)GlobalSearchScope.projectScope((Project)this.myProject), (boolean)false).asIterable()) {
            PsiElement refElement = reference.getElement();
            PsiElement anonymousClass = PsiTreeUtil.getParentOfType((PsiElement)refElement, PsiAnonymousClass.class);
            if (anonymousClass == null || !PsiTreeUtil.isAncestor((PsiElement)this.myMethod, (PsiElement)anonymousClass, (boolean)true)) continue;
            return true;
        }
        return false;
    }

    public void substituteTypes(PsiLocalVariable[] vars) {
        for (PsiLocalVariable var : vars) {
            PsiType newType = GenericsUtil.getVariableTypeByExpressionType((PsiType)this.mySubstitutor.substitute(var.getType()));
            var.getTypeElement().replace((PsiElement)JavaPsiFacade.getElementFactory((Project)this.myProject).createTypeElement(newType));
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 5, 6 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methodCopy";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "call";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/refactoring/inline/InlineMethodHelper";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/refactoring/inline/InlineMethodHelper";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getSubstitutor";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "createSubstitutor";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "declareParameters";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4, 5, 6 -> new IllegalStateException(string);
        };
    }
}

