/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.inline;

import com.intellij.codeInsight.BlockUtils;
import com.intellij.codeInsight.ChangeContextUtil;
import com.intellij.codeInsight.editorActions.DeclarationJoinLinesHandler;
import com.intellij.java.refactoring.JavaRefactoringBundle;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiCallExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiQualifiedExpression;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiThisExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypes;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.refactoring.BaseRefactoringProcessor;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.inline.InlineMethodHelper;
import com.intellij.refactoring.inline.InlineMethodProcessor;
import com.intellij.refactoring.inline.InlineTransformer;
import com.intellij.refactoring.inline.InlineViewDescriptor;
import com.intellij.refactoring.inline.ReferencedElementsCollector;
import com.intellij.refactoring.util.InlineUtil;
import com.intellij.refactoring.util.RefactoringUIUtil;
import com.intellij.usageView.UsageInfo;
import com.intellij.usageView.UsageViewDescriptor;
import com.intellij.util.ArrayUtil;
import com.intellij.util.CommonJavaRefactoringUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.MultiMap;
import com.siyeh.ig.psiutils.CommentTracker;
import com.siyeh.ig.psiutils.ControlFlowUtils;
import com.siyeh.ig.psiutils.ExpressionUtils;
import com.siyeh.ig.psiutils.SideEffectChecker;
import com.siyeh.ig.psiutils.StatementExtractor;
import com.siyeh.ig.psiutils.TypeUtils;
import com.siyeh.ig.psiutils.VariableAccessUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class InlineObjectProcessor
extends BaseRefactoringProcessor {
    private final PsiMethod myMethod;
    private final PsiReference myReference;
    private final PsiNewExpression myNewExpression;
    private final PsiMethodCallExpression myNextCall;
    private final PsiMethod myNextMethod;

    private InlineObjectProcessor(PsiMethod method, PsiReference reference) {
        super(method.getProject());
        this.myMethod = method;
        this.myReference = reference;
        PsiElement element = this.myReference.getElement();
        this.myNewExpression = (PsiNewExpression)ObjectUtils.tryCast((Object)element.getParent(), PsiNewExpression.class);
        assert (this.myNewExpression != null);
        this.myNextCall = ExpressionUtils.getCallForQualifier((PsiExpression)this.myNewExpression);
        assert (this.myNextCall != null);
        PsiMethod nextMethod = this.myNextCall.resolveMethod();
        assert (nextMethod != null);
        PsiElement nav = nextMethod.getNavigationElement();
        if (nav instanceof PsiMethod) {
            nextMethod = (PsiMethod)nav;
        }
        this.myNextMethod = nextMethod;
    }

    @NotNull
    protected UsageViewDescriptor createUsageViewDescriptor(UsageInfo @NotNull [] usages) {
        if (usages == null) {
            InlineObjectProcessor.$$$reportNull$$$0(0);
        }
        return new InlineViewDescriptor((PsiElement)this.myMethod);
    }

    @NotNull
    protected Collection<? extends PsiElement> getElementsToWrite(@NotNull UsageViewDescriptor descriptor) {
        if (descriptor == null) {
            InlineObjectProcessor.$$$reportNull$$$0(1);
        }
        List<PsiElement> list = Collections.singletonList(this.myReference.getElement());
        if (list == null) {
            InlineObjectProcessor.$$$reportNull$$$0(2);
        }
        return list;
    }

    protected UsageInfo @NotNull [] findUsages() {
        UsageInfo[] usageInfoArray = new UsageInfo[]{new UsageInfo(this.myReference)};
        if (usageInfoArray == null) {
            InlineObjectProcessor.$$$reportNull$$$0(3);
        }
        return usageInfoArray;
    }

    protected void performRefactoring(UsageInfo @NotNull [] usages) {
        PsiLocalVariable resultVar;
        PsiReferenceExpression resultUsage;
        if (usages == null) {
            InlineObjectProcessor.$$$reportNull$$$0(4);
        }
        ChangeContextUtil.encodeContextInfo((PsiElement)this.myMethod, (boolean)false);
        PsiMethod ctorCopy = (PsiMethod)this.myMethod.copy();
        ChangeContextUtil.clearContextInfo((PsiElement)this.myMethod);
        ChangeContextUtil.encodeContextInfo((PsiElement)this.myNextMethod, (boolean)false);
        PsiMethod nextCopy = (PsiMethod)this.myNextMethod.copy();
        ChangeContextUtil.clearContextInfo((PsiElement)this.myNextMethod);
        InlineMethodHelper ctorHelper = new InlineMethodHelper(this.myProject, this.myMethod, ctorCopy, (PsiCallExpression)this.myNewExpression);
        InlineMethodHelper nextHelper = new InlineMethodHelper(this.myProject, this.myNextMethod, nextCopy, (PsiCallExpression)this.myNextCall);
        PsiClass aClass = this.myMethod.getContainingClass();
        assert (aClass != null);
        PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)this.myProject);
        PsiCodeBlock target = factory.createCodeBlock();
        ArrayList<PsiLocalVariable> fieldLocals = new ArrayList<PsiLocalVariable>();
        for (PsiField field : aClass.getFields()) {
            if (field.hasModifierProperty("static")) continue;
            PsiDeclarationStatement declaration = factory.createVariableDeclarationStatement(field.getName(), field.getType(), field.getInitializer(), (PsiElement)aClass);
            fieldLocals.add((PsiLocalVariable)((PsiDeclarationStatement)target.add((PsiElement)declaration)).getDeclaredElements()[0]);
        }
        PsiLocalVariable[] ctorParameters = ctorHelper.declareParameters();
        ctorHelper.substituteTypes(ctorParameters);
        InlineTransformer ctorTransformer = InlineTransformer.getSuitableTransformer(this.myMethod).apply(this.myReference);
        ctorTransformer.transformBody(ctorCopy, this.myReference, (PsiType)PsiTypes.voidType());
        PsiCodeBlock ctorBody = Objects.requireNonNull(ctorCopy.getBody());
        InlineUtil.solveLocalNameConflicts((PsiElement)ctorBody, (PsiElement)target, (PsiElement)ctorBody);
        InlineObjectProcessor.updateFieldRefs(ctorCopy, aClass);
        ctorParameters = InlineObjectProcessor.addRange(target, ctorBody, ctorParameters);
        Object[] nextParameters = nextHelper.declareParameters();
        nextHelper.substituteTypes((PsiLocalVariable[])nextParameters);
        InlineTransformer nextTransformer = InlineTransformer.getSuitableTransformer(this.myNextMethod).apply((PsiReference)this.myNextCall.getMethodExpression());
        PsiLocalVariable result = nextTransformer.transformBody(nextCopy, (PsiReference)this.myNextCall.getMethodExpression(), this.myNextCall.getType());
        PsiCodeBlock nextBody = Objects.requireNonNull(nextCopy.getBody());
        InlineUtil.solveLocalNameConflicts((PsiElement)nextBody, (PsiElement)target, (PsiElement)nextBody);
        InlineObjectProcessor.updateFieldRefs(nextCopy, aClass);
        if (result != null) {
            PsiLocalVariable[] resultAndParameters = (PsiLocalVariable[])ArrayUtil.prepend((Object)result, (Object[])nextParameters);
            resultAndParameters = InlineObjectProcessor.addRange(target, nextBody, resultAndParameters);
            result = resultAndParameters[0];
            nextParameters = Arrays.copyOfRange(resultAndParameters, 1, resultAndParameters.length);
        } else {
            nextParameters = InlineObjectProcessor.addRange(target, nextBody, (PsiLocalVariable[])nextParameters);
        }
        InlineUtil.solveLocalNameConflicts((PsiElement)target, this.myReference.getElement(), (PsiElement)target);
        ctorHelper.initializeParameters(ctorParameters);
        nextHelper.initializeParameters((PsiLocalVariable[])nextParameters);
        InlineObjectProcessor.removeRedundantFieldVars(fieldLocals, target);
        ctorHelper.inlineParameters(ctorParameters);
        nextHelper.inlineParameters((PsiLocalVariable[])nextParameters);
        PsiElement anchor = CommonJavaRefactoringUtil.getParentStatement((PsiElement)this.myNextCall, (boolean)true);
        assert (anchor != null);
        PsiElement anchorParent = anchor.getParent();
        PsiStatement[] statements = target.getStatements();
        PsiElement firstBodyElement = target.getFirstBodyElement();
        if (firstBodyElement instanceof PsiWhiteSpace) {
            firstBodyElement = PsiTreeUtil.skipWhitespacesForward((PsiElement)firstBodyElement);
        }
        PsiElement firstAdded = null;
        if (firstBodyElement != null && firstBodyElement != target.getRBrace()) {
            PsiElement rBraceOrReturnStatement;
            int last = statements.length - 1;
            PsiElement psiElement = rBraceOrReturnStatement = last >= 0 ? PsiTreeUtil.skipWhitespacesAndCommentsForward((PsiElement)statements[last]) : target.getLastBodyElement();
            assert (rBraceOrReturnStatement != null);
            PsiElement beforeRBraceStatement = rBraceOrReturnStatement.getPrevSibling();
            assert (beforeRBraceStatement != null);
            firstAdded = anchorParent.addRangeBefore(firstBodyElement, beforeRBraceStatement, anchor);
            ChangeContextUtil.decodeContextInfo((PsiElement)anchorParent, null, null);
        }
        if ((resultUsage = InlineMethodProcessor.replaceCall(factory, this.myNextCall, firstAdded, result)) != null && (resultVar = ExpressionUtils.resolveLocalVariable((PsiExpression)resultUsage)) != null) {
            InlineUtil.tryInlineResultVariable(resultVar, resultUsage);
        }
    }

    private static void removeRedundantFieldVars(List<PsiLocalVariable> vars, PsiCodeBlock block) {
        for (PsiLocalVariable var : vars) {
            List references = VariableAccessUtils.getVariableReferences((PsiVariable)var, (PsiElement)block);
            PsiAssignmentExpression firstAssignment = null;
            ArrayList<PsiAssignmentExpression> assignments = new ArrayList<PsiAssignmentExpression>();
            for (PsiReferenceExpression reference : references) {
                PsiAssignmentExpression assignment = (PsiAssignmentExpression)ObjectUtils.tryCast((Object)PsiUtil.skipParenthesizedExprUp((PsiElement)reference.getParent()), PsiAssignmentExpression.class);
                if (assignment != null && assignment.getOperationTokenType().equals(JavaTokenType.EQ) && PsiUtil.skipParenthesizedExprDown((PsiExpression)assignment.getLExpression()) == reference && assignment.getParent() instanceof PsiExpressionStatement) {
                    assignments.add(assignment);
                    if (firstAssignment != null || assignment.getParent().getParent() != block) continue;
                    firstAssignment = assignment;
                    continue;
                }
                assignments = null;
                break;
            }
            if (assignments != null) {
                for (PsiAssignmentExpression assignment : assignments) {
                    PsiExpressionStatement statement = (PsiExpressionStatement)assignment.getParent();
                    PsiExpression expression = assignment.getRExpression();
                    CommentTracker ct = new CommentTracker();
                    if (expression != null) {
                        List sideEffects = SideEffectChecker.extractSideEffectExpressions((PsiExpression)expression);
                        sideEffects.forEach(arg_0 -> ((CommentTracker)ct).markUnchanged(arg_0));
                        PsiStatement[] statements = StatementExtractor.generateStatements((List)sideEffects, (PsiExpression)expression);
                        if (statements.length > 0) {
                            BlockUtils.addBefore((PsiStatement)statement, (PsiStatement[])statements);
                        }
                    }
                    ct.deleteAndRestoreComments((PsiElement)statement);
                }
                new CommentTracker().deleteAndRestoreComments((PsiElement)var);
                continue;
            }
            if (firstAssignment == null) continue;
            var = DeclarationJoinLinesHandler.joinDeclarationAndAssignment((PsiLocalVariable)var, firstAssignment);
            InlineUtil.tryInlineGeneratedLocal(var, false);
        }
    }

    private static PsiLocalVariable[] addRange(PsiCodeBlock target, PsiCodeBlock body, PsiLocalVariable[] declaredVars) {
        PsiElement firstBodyElement = body.getFirstBodyElement();
        PsiElement lastBodyElement = body.getLastBodyElement();
        if (firstBodyElement == null || lastBodyElement == null) {
            return declaredVars;
        }
        PsiElement firstAdded = target.addRange(firstBodyElement, lastBodyElement);
        PsiLocalVariable[] updatedVars = new PsiLocalVariable[declaredVars.length];
        int index = 0;
        for (PsiElement e = firstAdded; index < updatedVars.length && e != null; e = e.getNextSibling()) {
            PsiLocalVariable var;
            PsiElement[] elements;
            if (!(e instanceof PsiDeclarationStatement) || (elements = ((PsiDeclarationStatement)e).getDeclaredElements()).length != 1 || (var = (PsiLocalVariable)ObjectUtils.tryCast((Object)elements[0], PsiLocalVariable.class)) == null || !var.getName().equals(declaredVars[index].getName())) continue;
            updatedVars[index++] = var;
        }
        assert (index == updatedVars.length);
        return updatedVars;
    }

    private static void updateFieldRefs(PsiMethod method, PsiClass aClass) {
        PsiCodeBlock body = method.getBody();
        assert (body != null);
        for (PsiThisExpression thisExpression : PsiTreeUtil.findChildrenOfType((PsiElement)body, PsiThisExpression.class)) {
            PsiField field;
            PsiElement parent = PsiUtil.skipParenthesizedExprUp((PsiElement)thisExpression.getParent());
            if (!(parent instanceof PsiReferenceExpression) || (field = (PsiField)ObjectUtils.tryCast((Object)((PsiReferenceExpression)parent).resolve(), PsiField.class)) == null || field.getContainingClass() != aClass) continue;
            thisExpression.delete();
        }
    }

    protected boolean preprocessUsages(@NotNull Ref<UsageInfo[]> refUsages) {
        if (refUsages == null) {
            InlineObjectProcessor.$$$reportNull$$$0(5);
        }
        UsageInfo[] usagesIn = (UsageInfo[])refUsages.get();
        MultiMap conflicts = new MultiMap();
        ReferencedElementsCollector collector = new ReferencedElementsCollector();
        this.myMethod.accept((PsiElementVisitor)collector);
        this.myNextMethod.accept((PsiElementVisitor)collector);
        Map<PsiMember, Set<PsiMember>> containersToReferenced = InlineMethodProcessor.getInaccessible(collector.myReferencedMembers, usagesIn, (PsiElement)this.myMethod);
        containersToReferenced.forEach((container, referencedInaccessible) -> {
            for (PsiMember referenced : referencedInaccessible) {
                if (referenced instanceof PsiField && !referenced.hasModifierProperty("static") && referenced.getContainingClass() == this.myMethod.getContainingClass()) continue;
                String referencedDescription = RefactoringUIUtil.getDescription((PsiElement)referenced, (boolean)true);
                String containerDescription = RefactoringUIUtil.getDescription((PsiElement)container, (boolean)true);
                String message = RefactoringBundle.message((String)"0.that.is.used.in.inlined.method.is.not.accessible.from.call.site.s.in.1", (Object[])new Object[]{referencedDescription, containerDescription});
                conflicts.putValue(container, (Object)StringUtil.capitalize((String)message));
            }
        });
        return this.showConflicts(conflicts, usagesIn);
    }

    @NotNull
    protected String getCommandName() {
        String string = JavaRefactoringBundle.message((String)"inline.object.command.name", (Object[])new Object[0]);
        if (string == null) {
            InlineObjectProcessor.$$$reportNull$$$0(6);
        }
        return string;
    }

    @Nullable
    public static InlineObjectProcessor create(PsiReference reference, PsiMethod method) {
        if (!InlineObjectProcessor.canInlineConstructorAndChainCall(reference, method)) {
            return null;
        }
        return new InlineObjectProcessor(method, reference);
    }

    @Contract(value="null, _ -> false")
    private static boolean canInlineConstructorAndChainCall(PsiReference reference, PsiMethod method) {
        PsiClass aClass;
        if (reference == null) {
            return false;
        }
        PsiElement element = reference.getElement();
        if (!(element instanceof PsiJavaCodeReferenceElement)) {
            return false;
        }
        PsiNewExpression expression = (PsiNewExpression)ObjectUtils.tryCast((Object)element.getParent(), PsiNewExpression.class);
        if (expression == null) {
            return false;
        }
        PsiMethodCallExpression call = ExpressionUtils.getCallForQualifier((PsiExpression)expression);
        if (call == null) {
            return false;
        }
        if (CommonJavaRefactoringUtil.getParentStatement((PsiElement)call, (boolean)true) == null) {
            return false;
        }
        PsiMethod nextMethod = call.resolveMethod();
        if (nextMethod == null) {
            return false;
        }
        PsiElement nav = nextMethod.getNavigationElement();
        if (nav instanceof PsiMethod) {
            nextMethod = (PsiMethod)nav;
        }
        if ((aClass = method.getContainingClass()) == null) {
            return false;
        }
        if (aClass.getContainingClass() != null && !aClass.hasModifierProperty("static")) {
            return false;
        }
        PsiClassType[] supers = aClass.getExtendsListTypes();
        if (supers.length > 1) {
            return false;
        }
        if (supers.length == 1 && !InlineObjectProcessor.isStatelessSuperClass(supers[0], new HashSet<PsiClass>())) {
            return false;
        }
        for (PsiField psiField : aClass.getFields()) {
            PsiExpression initializer;
            if (psiField.hasModifierProperty("static") || (initializer = psiField.getInitializer()) == null || !InlineObjectProcessor.mayLeakThis((PsiElement)initializer)) continue;
            return false;
        }
        for (PsiField psiField : aClass.getInitializers()) {
            if (psiField.hasModifierProperty("static")) continue;
            return false;
        }
        return !InlineObjectProcessor.mayLeakThis(method) && !InlineObjectProcessor.mayLeakThis(nextMethod);
    }

    /*
     * WARNING - void declaration
     */
    private static boolean isStatelessSuperClass(PsiClassType psiType, Set<PsiClass> checked) {
        PsiMethod[] constructors;
        if (TypeUtils.isJavaLangObject((PsiType)psiType) || TypeUtils.typeEquals((String)"java.lang.Record", (PsiType)psiType)) {
            return true;
        }
        PsiClass psiClass = psiType.resolve();
        if (psiClass == null || !checked.add(psiClass)) {
            return false;
        }
        for (PsiMethod psiMethod : constructors = psiClass.getConstructors()) {
            void var7_7;
            PsiCodeBlock body;
            if (!psiMethod.getParameterList().isEmpty()) continue;
            PsiElement nav = psiMethod.getNavigationElement();
            if (nav instanceof PsiMethod) {
                PsiMethod psiMethod2 = (PsiMethod)nav;
            }
            if ((body = var7_7.getBody()) != null && ControlFlowUtils.isEmptyCodeBlock((PsiCodeBlock)body)) continue;
            return false;
        }
        for (PsiMethod psiMethod : psiClass.getFields()) {
            if (psiMethod.hasModifierProperty("static")) continue;
            return false;
        }
        PsiClassType[] supers = psiClass.getExtendsListTypes();
        return supers.length == 0 || supers.length == 1 && InlineObjectProcessor.isStatelessSuperClass(supers[0], checked);
    }

    private static boolean mayLeakThis(PsiMethod method) {
        if (method == null) {
            return true;
        }
        PsiCodeBlock body = method.getBody();
        if (body == null) {
            return true;
        }
        return InlineObjectProcessor.mayLeakThis((PsiElement)body);
    }

    private static boolean mayLeakThis(PsiElement body) {
        class Visitor
        extends JavaRecursiveElementWalkingVisitor {
            boolean leak = false;

            Visitor() {
            }

            public void visitMethodCallExpression(@NotNull PsiMethodCallExpression call) {
                if (call == null) {
                    Visitor.$$$reportNull$$$0(0);
                }
                super.visitMethodCallExpression(call);
                PsiExpression qualifier = ExpressionUtils.getEffectiveQualifier((PsiReferenceExpression)call.getMethodExpression());
                if (qualifier instanceof PsiQualifiedExpression) {
                    this.leak = true;
                    this.stopWalking();
                }
            }

            public void visitNewExpression(@NotNull PsiNewExpression expression) {
                PsiClass target;
                PsiJavaCodeReferenceElement reference;
                if (expression == null) {
                    Visitor.$$$reportNull$$$0(1);
                }
                super.visitNewExpression(expression);
                if (expression.getQualifier() == null && (reference = expression.getClassReference()) != null && (target = (PsiClass)ObjectUtils.tryCast((Object)reference.resolve(), PsiClass.class)) != null && target.getContainingClass() != null && !target.hasModifierProperty("static")) {
                    this.leak = true;
                    this.stopWalking();
                }
            }

            public void visitThisExpression(@NotNull PsiThisExpression expression) {
                if (expression == null) {
                    Visitor.$$$reportNull$$$0(2);
                }
                super.visitThisExpression(expression);
                PsiElement parent = PsiUtil.skipParenthesizedExprUp((PsiElement)expression.getParent());
                if (!(parent instanceof PsiReferenceExpression)) {
                    this.leak = true;
                    this.stopWalking();
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "call";
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "expression";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/refactoring/inline/InlineObjectProcessor$1Visitor";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitMethodCallExpression";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitNewExpression";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitThisExpression";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }
        Visitor visitor2 = new Visitor();
        body.accept((PsiElementVisitor)visitor2);
        return visitor2.leak;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3, 6 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "usages";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 2: 
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/refactoring/inline/InlineObjectProcessor";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "refUsages";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/refactoring/inline/InlineObjectProcessor";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getElementsToWrite";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "findUsages";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getCommandName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createUsageViewDescriptor";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getElementsToWrite";
                break;
            }
            case 2: 
            case 3: 
            case 6: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "performRefactoring";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "preprocessUsages";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3, 6 -> new IllegalStateException(string);
        };
    }
}

