/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.inline;

import com.intellij.codeInsight.ExceptionUtil;
import com.intellij.java.refactoring.JavaRefactoringBundle;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Ref;
import com.intellij.pom.java.JavaFeature;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaRecursiveElementVisitor;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.PsiArrayAccessExpression;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiCallExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiThisExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.controlFlow.DefUseUtil;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.refactoring.BaseRefactoringProcessor;
import com.intellij.refactoring.changeSignature.ChangeInfo;
import com.intellij.refactoring.changeSignature.ChangeSignatureProcessorBase;
import com.intellij.refactoring.changeSignature.JavaChangeInfo;
import com.intellij.refactoring.changeSignature.JavaChangeInfoImpl;
import com.intellij.refactoring.changeSignature.ParameterInfoImpl;
import com.intellij.refactoring.inline.InlineParameterHandler;
import com.intellij.refactoring.inline.InlineViewDescriptor;
import com.intellij.refactoring.safeDelete.JavaSafeDeleteProcessor;
import com.intellij.refactoring.util.CanonicalTypes;
import com.intellij.refactoring.util.InlineUtil;
import com.intellij.refactoring.util.RefactoringUIUtil;
import com.intellij.usageView.UsageInfo;
import com.intellij.usageView.UsageViewDescriptor;
import com.intellij.usageView.UsageViewUtil;
import com.intellij.util.CommonJavaRefactoringUtil;
import com.intellij.util.JavaPsiConstructorUtil;
import com.intellij.util.VisibilityUtil;
import com.intellij.util.containers.MultiMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class InlineParameterExpressionProcessor
extends BaseRefactoringProcessor {
    private static final Logger LOG = Logger.getInstance(InlineParameterExpressionProcessor.class);
    public static final Key<Boolean> CREATE_LOCAL_FOR_TESTS = Key.create((String)"CREATE_INLINE_PARAMETER_LOCAL_FOR_TESTS");
    private final PsiCallExpression myMethodCall;
    @NotNull
    private final PsiMethod myMethod;
    private final PsiParameter myParameter;
    private PsiExpression myInitializer;
    private final boolean mySameClass;
    private final PsiCodeBlock myCallingBlock;
    private final boolean myCreateLocal;
    private JavaChangeInfo myChangeInfo;
    private UsageInfo[] myChangeSignatureUsages;

    public InlineParameterExpressionProcessor(PsiCallExpression methodCall, @NotNull PsiMethod method, PsiParameter parameter, PsiExpression initializer, boolean createLocal) {
        if (method == null) {
            InlineParameterExpressionProcessor.$$$reportNull$$$0(0);
        }
        super(method.getProject());
        this.myMethodCall = methodCall;
        this.myMethod = method;
        this.myParameter = parameter;
        this.myInitializer = initializer;
        this.myCreateLocal = createLocal;
        PsiClass callingClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)methodCall, PsiClass.class);
        this.mySameClass = callingClass == this.myMethod.getContainingClass();
        this.myCallingBlock = (PsiCodeBlock)PsiTreeUtil.getTopmostParentOfType((PsiElement)this.myMethodCall, PsiCodeBlock.class);
    }

    @NotNull
    protected String getCommandName() {
        String string = InlineParameterHandler.getRefactoringName();
        if (string == null) {
            InlineParameterExpressionProcessor.$$$reportNull$$$0(1);
        }
        return string;
    }

    @NotNull
    protected UsageViewDescriptor createUsageViewDescriptor(UsageInfo @NotNull [] usages) {
        if (usages == null) {
            InlineParameterExpressionProcessor.$$$reportNull$$$0(2);
        }
        return new InlineViewDescriptor((PsiElement)this.myParameter);
    }

    protected UsageInfo @NotNull [] findUsages() {
        int parameterIndex = this.myMethod.getParameterList().getParameterIndex(this.myParameter);
        final HashMap<PsiVariable, PsiExpression> localToParamRef = new HashMap<PsiVariable, PsiExpression>();
        PsiExpression[] arguments = this.myMethodCall.getArgumentList().getExpressions();
        for (int i = 0; i < arguments.length; ++i) {
            Object ref;
            PsiElement element;
            PsiExpression psiExpression;
            if (i == parameterIndex || !((psiExpression = arguments[i]) instanceof PsiReferenceExpression) || !PsiUtil.isJvmLocalVariable((PsiElement)(element = (ref = (PsiReferenceExpression)psiExpression).resolve()))) continue;
            PsiParameter param = this.myMethod.getParameterList().getParameters()[i];
            PsiExpression paramRef = JavaPsiFacade.getElementFactory((Project)this.myMethod.getProject()).createExpressionFromText(param.getName(), (PsiElement)this.myMethod);
            localToParamRef.put((PsiVariable)element, paramRef);
        }
        final ArrayList<UsageInfo> result = new ArrayList<UsageInfo>();
        this.myInitializer.accept((PsiElementVisitor)new JavaRecursiveElementVisitor(){

            public void visitReferenceExpression(@NotNull PsiReferenceExpression expression) {
                PsiLocalVariable localVariable;
                PsiElement[] elements;
                if (expression == null) {
                    1.$$$reportNull$$$0(0);
                }
                super.visitReferenceExpression(expression);
                PsiElement element = expression.resolve();
                if (element instanceof PsiLocalVariable && (elements = DefUseUtil.getDefs((PsiCodeBlock)InlineParameterExpressionProcessor.this.myCallingBlock, (PsiVariable)(localVariable = (PsiLocalVariable)element), (PsiElement)expression)).length == 1) {
                    PsiExpression localInitializer = null;
                    PsiElement psiElement = elements[0];
                    if (psiElement instanceof PsiLocalVariable) {
                        PsiLocalVariable var = (PsiLocalVariable)psiElement;
                        localInitializer = var.getInitializer();
                    } else {
                        psiElement = elements[0];
                        if (psiElement instanceof PsiAssignmentExpression) {
                            PsiAssignmentExpression assignment = (PsiAssignmentExpression)psiElement;
                            localInitializer = assignment.getRExpression();
                        } else {
                            PsiAssignmentExpression assignment;
                            PsiReferenceExpression ref;
                            PsiElement parent;
                            psiElement = elements[0];
                            if (psiElement instanceof PsiReferenceExpression && (parent = (ref = (PsiReferenceExpression)psiElement).getParent()) instanceof PsiAssignmentExpression && (assignment = (PsiAssignmentExpression)parent).getLExpression() == ref) {
                                localInitializer = assignment.getRExpression();
                            }
                        }
                    }
                    if (localInitializer != null) {
                        PsiElement replacement2 = localToParamRef.containsKey(localVariable) ? (PsiElement)localToParamRef.get(localVariable) : InlineParameterExpressionProcessor.replaceArgs(localToParamRef, localInitializer.copy());
                        result.add(new LocalReplacementUsageInfo((PsiReference)expression, replacement2));
                    }
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/intellij/refactoring/inline/InlineParameterExpressionProcessor$1", "visitReferenceExpression"));
            }
        });
        if (!this.myCreateLocal) {
            for (PsiReference ref : ReferencesSearch.search((PsiElement)this.myParameter).asIterable()) {
                result.add(new UsageInfo(ref));
            }
        }
        ArrayList<ParameterInfoImpl> psiParameters = new ArrayList<ParameterInfoImpl>();
        int paramIdx = 0;
        String paramName = this.myParameter.getName();
        for (PsiExpression param : this.myMethod.getParameterList().getParameters()) {
            if (!Comparing.strEqual((String)paramName, (String)param.getName())) {
                psiParameters.add(ParameterInfoImpl.create((int)paramIdx).withName(param.getName()).withType(param.getType()));
            }
            ++paramIdx;
        }
        PsiType returnType = this.myMethod.getReturnType();
        this.myChangeInfo = new JavaChangeInfoImpl(VisibilityUtil.getVisibilityModifier((PsiModifierList)this.myMethod.getModifierList()), this.myMethod, this.myMethod.getName(), returnType != null ? CanonicalTypes.createTypeWrapper((PsiType)returnType) : null, psiParameters.toArray(new ParameterInfoImpl[0]), null, false, Collections.emptySet(), Collections.emptySet());
        this.myChangeSignatureUsages = ChangeSignatureProcessorBase.findUsages((ChangeInfo)this.myChangeInfo);
        UsageInfo[] usageInfos = result.toArray(UsageInfo.EMPTY_ARRAY);
        UsageInfo[] usageInfoArray = UsageViewUtil.removeDuplicatedUsages((UsageInfo[])usageInfos);
        if (usageInfoArray == null) {
            InlineParameterExpressionProcessor.$$$reportNull$$$0(3);
        }
        return usageInfoArray;
    }

    private static PsiElement replaceArgs(final Map<PsiVariable, PsiElement> elementsToReplace, PsiElement expression) {
        final HashMap replacements = new HashMap();
        expression.accept((PsiElementVisitor)new JavaRecursiveElementVisitor(){

            public void visitReferenceExpression(@NotNull PsiReferenceExpression referenceExpression) {
                PsiVariable variable;
                PsiElement replacement2;
                if (referenceExpression == null) {
                    2.$$$reportNull$$$0(0);
                }
                super.visitReferenceExpression(referenceExpression);
                PsiElement resolved = referenceExpression.resolve();
                if (resolved instanceof PsiVariable && (replacement2 = (PsiElement)elementsToReplace.get(variable = (PsiVariable)resolved)) != null) {
                    replacements.put(referenceExpression, replacement2);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "referenceExpression", "com/intellij/refactoring/inline/InlineParameterExpressionProcessor$2", "visitReferenceExpression"));
            }
        });
        return CommonJavaRefactoringUtil.replaceElementsWithMap((PsiElement)expression, replacements);
    }

    protected boolean preprocessUsages(@NotNull Ref<UsageInfo[]> refUsages) {
        if (refUsages == null) {
            InlineParameterExpressionProcessor.$$$reportNull$$$0(4);
        }
        MultiMap conflicts = new MultiMap();
        JavaSafeDeleteProcessor.collectMethodConflicts((MultiMap<PsiElement, String>)conflicts, this.myMethod, this.myParameter);
        UsageInfo[] usages = (UsageInfo[])refUsages.get();
        InaccessibleExpressionsDetector detector = new InaccessibleExpressionsDetector((MultiMap<PsiElement, String>)conflicts);
        this.myInitializer.accept((PsiElementVisitor)detector);
        for (UsageInfo usage : usages) {
            LocalReplacementUsageInfo usageInfo;
            PsiElement replacement2;
            if (!(usage instanceof LocalReplacementUsageInfo) || (replacement2 = (usageInfo = (LocalReplacementUsageInfo)usage).getReplacement()) == null) continue;
            replacement2.accept((PsiElementVisitor)detector);
        }
        HashSet<PsiVariable> vars = new HashSet<PsiVariable>();
        for (UsageInfo usage : usages) {
            LocalReplacementUsageInfo usageInfo;
            PsiVariable var;
            if (!(usage instanceof LocalReplacementUsageInfo) || (var = (usageInfo = (LocalReplacementUsageInfo)usage).getVariable()) == null) continue;
            vars.add(var);
        }
        block2: for (PsiVariable var : vars) {
            for (PsiReference ref : ReferencesSearch.search((PsiElement)var).asIterable()) {
                PsiExpression exp;
                PsiElement element = ref.getElement();
                if (!(element instanceof PsiExpression) || !InlineParameterExpressionProcessor.isAccessedForWriting(exp = (PsiExpression)element)) continue;
                conflicts.putValue((Object)element, (Object)JavaRefactoringBundle.message((String)"inline.parameter.initializer.depends.on.inaccessible.value", (Object[])new Object[0]));
                continue block2;
            }
        }
        return this.showConflicts(conflicts, usages);
    }

    private static boolean isAccessedForWriting(PsiExpression expr) {
        PsiElement parent = expr.getParent();
        while (parent instanceof PsiArrayAccessExpression || parent instanceof PsiParenthesizedExpression) {
            expr = (PsiExpression)parent;
            parent = parent.getParent();
        }
        return PsiUtil.isAccessedForWriting((PsiExpression)expr);
    }

    protected void performRefactoring(UsageInfo @NotNull [] usages) {
        if (usages == null) {
            InlineParameterExpressionProcessor.$$$reportNull$$$0(5);
        }
        List thrownExceptions = ExceptionUtil.getThrownCheckedExceptions((PsiElement[])new PsiElement[]{this.myInitializer});
        HashSet<PsiVariable> varsUsedInInitializer = new HashSet<PsiVariable>();
        HashSet<PsiJavaCodeReferenceElement> paramRefsToInline = new HashSet<PsiJavaCodeReferenceElement>();
        HashMap<PsiElement, PsiElement> replacements = new HashMap<PsiElement, PsiElement>();
        for (UsageInfo usage : usages) {
            if (usage instanceof LocalReplacementUsageInfo) {
                LocalReplacementUsageInfo usageInfo = (LocalReplacementUsageInfo)usage;
                PsiElement element = usageInfo.getElement();
                PsiElement replacement2 = usageInfo.getReplacement();
                if (element != null && replacement2 != null) {
                    replacements.put(element, replacement2);
                }
                varsUsedInInitializer.add(usageInfo.getVariable());
                continue;
            }
            LOG.assertTrue(!this.myCreateLocal);
            paramRefsToInline.add((PsiJavaCodeReferenceElement)usage.getElement());
        }
        this.myInitializer = (PsiExpression)CommonJavaRefactoringUtil.replaceElementsWithMap((PsiElement)this.myInitializer, replacements);
        if (this.myCreateLocal) {
            PsiCodeBlock body = this.myMethod.getBody();
            if (body != null) {
                PsiElement anchor = this.findAnchorForLocalVariableDeclaration(body);
                PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)this.myMethod.getProject());
                PsiExpression refExpression = factory.createExpressionFromText(this.myParameter.getName(), anchor);
                PsiDeclarationStatement localDeclaration = factory.createVariableDeclarationStatement(this.myParameter.getName(), this.myParameter.getType(), refExpression);
                localDeclaration = (PsiDeclarationStatement)body.addAfter((PsiElement)localDeclaration, anchor);
                PsiLocalVariable declaredVar = (PsiLocalVariable)localDeclaration.getDeclaredElements()[0];
                PsiUtil.setModifierProperty((PsiModifierListOwner)declaredVar, (String)"final", (boolean)this.myParameter.hasModifierProperty("final"));
                InlineUtil.inlineVariable((PsiVariable)this.myParameter, this.myInitializer, (PsiJavaCodeReferenceElement)((PsiReferenceExpression)declaredVar.getInitializer()));
            }
        } else {
            for (PsiJavaCodeReferenceElement paramRef : paramRefsToInline) {
                PsiExpression expression = InlineUtil.inlineVariable((PsiVariable)this.myParameter, this.myInitializer, paramRef);
                CommonJavaRefactoringUtil.tryToInlineArrayCreationForVarargs((PsiExpression)expression);
            }
        }
        for (PsiVariable variable : varsUsedInInitializer) {
            if (variable == null || !variable.isValid() || ReferencesSearch.search((PsiElement)variable).findFirst() != null) continue;
            variable.delete();
        }
        ChangeSignatureProcessorBase.doChangeSignature((ChangeInfo)this.myChangeInfo, (UsageInfo[])this.myChangeSignatureUsages);
        if (!thrownExceptions.isEmpty()) {
            for (PsiClassType exception : thrownExceptions) {
                PsiClass exceptionClass = exception.resolve();
                if (exceptionClass == null) continue;
                PsiUtil.addException((PsiMethod)this.myMethod, (PsiClass)exceptionClass);
            }
        }
    }

    @Nullable
    private PsiElement findAnchorForLocalVariableDeclaration(PsiCodeBlock body) {
        PsiMethodCallExpression call;
        if (!JavaFeature.STATEMENTS_BEFORE_SUPER.isSufficient(PsiUtil.getLanguageLevel((PsiElement)body)) && (call = JavaPsiConstructorUtil.findThisOrSuperCallInConstructor((PsiMethod)this.myMethod)) != null) {
            return call.getParent();
        }
        return body.getLBrace();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/refactoring/inline/InlineParameterExpressionProcessor";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "usages";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "refUsages";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/refactoring/inline/InlineParameterExpressionProcessor";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getCommandName";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "findUsages";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 3: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "createUsageViewDescriptor";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "preprocessUsages";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "performRefactoring";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 3 -> new IllegalStateException(string);
        };
    }

    private class InaccessibleExpressionsDetector
    extends JavaRecursiveElementWalkingVisitor {
        private final MultiMap<PsiElement, String> myConflicts;

        InaccessibleExpressionsDetector(MultiMap<PsiElement, String> conflicts) {
            this.myConflicts = conflicts;
        }

        public void visitReferenceExpression(@NotNull PsiReferenceExpression expression) {
            PsiParameter param;
            PsiMember member;
            if (expression == null) {
                InaccessibleExpressionsDetector.$$$reportNull$$$0(0);
            }
            super.visitReferenceExpression(expression);
            PsiElement element = expression.resolve();
            if (element instanceof PsiMember && !(member = (PsiMember)element).hasModifierProperty("static") && !(member instanceof PsiClass)) {
                if (InlineParameterExpressionProcessor.this.myMethod.hasModifierProperty("static")) {
                    this.myConflicts.putValue((Object)expression, (Object)JavaRefactoringBundle.message((String)"inline.parameter.dependency.unavailable.in.parameter.method", (Object[])new Object[]{RefactoringUIUtil.getDescription((PsiElement)element, (boolean)false)}));
                }
            } else if (element instanceof PsiMethod || element instanceof PsiField) {
                if (!InlineParameterExpressionProcessor.this.mySameClass && !((PsiModifierListOwner)element).hasModifierProperty("static")) {
                    this.myConflicts.putValue((Object)expression, (Object)JavaRefactoringBundle.message((String)"inline.parameter.depends.on.non.static", (Object[])new Object[]{RefactoringUIUtil.getDescription((PsiElement)element, (boolean)true)}));
                } else if (!PsiUtil.isAccessible((PsiMember)((PsiMember)element), (PsiElement)InlineParameterExpressionProcessor.this.myMethod, null)) {
                    this.myConflicts.putValue((Object)expression, (Object)JavaRefactoringBundle.message((String)"inline.parameter.dependency.unavailable.in.parameter.method", (Object[])new Object[]{RefactoringUIUtil.getDescription((PsiElement)element, (boolean)true)}));
                }
            } else if (element instanceof PsiParameter && PsiTreeUtil.isAncestor((PsiElement)(param = (PsiParameter)element).getDeclarationScope(), (PsiElement)InlineParameterExpressionProcessor.this.myInitializer, (boolean)true)) {
                boolean bound = false;
                for (PsiParameter parameter : InlineParameterExpressionProcessor.this.myMethod.getParameterList().getParameters()) {
                    if (parameter == InlineParameterExpressionProcessor.this.myParameter || !parameter.getType().equals(param.getType()) || !parameter.getName().equals(param.getName())) continue;
                    bound = true;
                    break;
                }
                if (!bound) {
                    this.myConflicts.putValue((Object)expression, (Object)JavaRefactoringBundle.message((String)"inline.parameter.depends.on.caller.parameter", (Object[])new Object[]{RefactoringUIUtil.getDescription((PsiElement)element, (boolean)false)}));
                }
            }
        }

        public void visitThisExpression(@NotNull PsiThisExpression thisExpression) {
            if (thisExpression == null) {
                InaccessibleExpressionsDetector.$$$reportNull$$$0(1);
            }
            super.visitThisExpression(thisExpression);
            PsiJavaCodeReferenceElement qualifier = thisExpression.getQualifier();
            PsiElement containingClass = qualifier != null ? qualifier.resolve() : PsiTreeUtil.getParentOfType((PsiElement)InlineParameterExpressionProcessor.this.myMethodCall, PsiClass.class);
            PsiClass methodContainingClass = InlineParameterExpressionProcessor.this.myMethod.getContainingClass();
            LOG.assertTrue(methodContainingClass != null);
            if (!PsiTreeUtil.isAncestor((PsiElement)containingClass, (PsiElement)methodContainingClass, (boolean)false) || InlineParameterExpressionProcessor.this.myMethod.hasModifierProperty("static")) {
                this.myConflicts.putValue((Object)thisExpression, (Object)JavaRefactoringBundle.message((String)"inline.parameter.dependency.unavailable.in.parameter.method", (Object[])new Object[]{"<b><code>this</code></b>"}));
            }
        }

        public void visitNewExpression(@NotNull PsiNewExpression expression) {
            PsiElement psiElement;
            if (expression == null) {
                InaccessibleExpressionsDetector.$$$reportNull$$$0(2);
            }
            super.visitNewExpression(expression);
            PsiJavaCodeReferenceElement reference = expression.getClassOrAnonymousClassReference();
            if (reference != null && (psiElement = reference.resolve()) instanceof PsiClass) {
                PsiClass aClass = (PsiClass)psiElement;
                if (!expression.isArrayCreation() && InlineParameterExpressionProcessor.this.myMethod.hasModifierProperty("static") && (PsiUtil.isInnerClass((PsiClass)aClass) || PsiUtil.isLocalClass((PsiClass)aClass))) {
                    this.myConflicts.putValue((Object)reference, (Object)JavaRefactoringBundle.message((String)"inline.parameter.depends.on.non.static.class", (Object[])new Object[]{RefactoringUIUtil.getDescription((PsiElement)aClass, (boolean)true)}));
                } else if (!PsiUtil.isAccessible((PsiMember)aClass, (PsiElement)InlineParameterExpressionProcessor.this.myMethod, null)) {
                    this.myConflicts.putValue((Object)expression, (Object)JavaRefactoringBundle.message((String)"inline.parameter.dependency.unavailable.in.parameter.method", (Object[])new Object[]{RefactoringUIUtil.getDescription((PsiElement)aClass, (boolean)true)}));
                } else {
                    PsiClass methodContainingClass = InlineParameterExpressionProcessor.this.myMethod.getContainingClass();
                    LOG.assertTrue(methodContainingClass != null);
                    if (!PsiTreeUtil.isAncestor((PsiElement)InlineParameterExpressionProcessor.this.myMethod, (PsiElement)aClass, (boolean)false)) {
                        PsiClass parentClass;
                        PsiElement psiElement2;
                        PsiClass parent = aClass;
                        while ((psiElement2 = (parent = parent.getParent())) instanceof PsiClass && PsiUtil.isAccessible((PsiMember)(parentClass = (PsiClass)psiElement2), (PsiElement)InlineParameterExpressionProcessor.this.myMethod, null)) {
                        }
                        if (!(parent instanceof PsiFile)) {
                            this.myConflicts.putValue((Object)expression, (Object)JavaRefactoringBundle.message((String)"inline.parameter.dependency.unavailable.in.parameter.method", (Object[])new Object[]{RefactoringUIUtil.getDescription((PsiElement)aClass, (boolean)true)}));
                        }
                    }
                }
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "expression";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "thisExpression";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/refactoring/inline/InlineParameterExpressionProcessor$InaccessibleExpressionsDetector";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitReferenceExpression";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitThisExpression";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitNewExpression";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class LocalReplacementUsageInfo
    extends UsageInfo {
        private final PsiElement myReplacement;
        private final PsiVariable myVariable;

        LocalReplacementUsageInfo(@NotNull PsiReference element, @NotNull PsiElement replacement2) {
            PsiVariable var;
            if (element == null) {
                LocalReplacementUsageInfo.$$$reportNull$$$0(0);
            }
            if (replacement2 == null) {
                LocalReplacementUsageInfo.$$$reportNull$$$0(1);
            }
            super(element);
            PsiElement resolved = element.resolve();
            this.myVariable = resolved instanceof PsiVariable ? (var = (PsiVariable)resolved) : null;
            this.myReplacement = replacement2;
        }

        @Nullable
        public PsiElement getReplacement() {
            return this.myReplacement.isValid() ? this.myReplacement : null;
        }

        @Nullable
        public PsiVariable getVariable() {
            return this.myVariable != null && this.myVariable.isValid() ? this.myVariable : null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "element";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "replacement";
                    break;
                }
            }
            objectArray[1] = "com/intellij/refactoring/inline/InlineParameterExpressionProcessor$LocalReplacementUsageInfo";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

