/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.inlineSuperClass;

import com.intellij.codeInsight.TargetElementUtil;
import com.intellij.java.refactoring.JavaRefactoringBundle;
import com.intellij.lang.java.JavaLanguage;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceList;
import com.intellij.psi.search.searches.DirectClassInheritorsSearch;
import com.intellij.refactoring.inline.JavaInlineActionHandler;
import com.intellij.refactoring.inlineSuperClass.InlineSuperClassRefactoringDialog;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import org.jetbrains.annotations.Nullable;

public final class InlineSuperClassRefactoringHandler
extends JavaInlineActionHandler {
    public boolean isEnabledOnElement(PsiElement element) {
        return element instanceof PsiClass;
    }

    public boolean canInlineElement(PsiElement element) {
        if (!(element instanceof PsiClass)) {
            return false;
        }
        return element.getLanguage() == JavaLanguage.INSTANCE;
    }

    public void inlineElement(Project project, Editor editor, PsiElement element) {
        PsiElement gParent;
        PsiElement referenceElement;
        PsiElement parent;
        PsiElement resolve;
        PsiReference reference;
        if (DirectClassInheritorsSearch.search((PsiClass)((PsiClass)element)).findFirst() == null) {
            CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)JavaRefactoringBundle.message((String)"inline.super.no.inheritors.warning.message", (Object[])new Object[0]), (String)JavaRefactoringBundle.message((String)"inline.super.class", (Object[])new Object[0]), null);
            return;
        }
        PsiClass superClass = (PsiClass)element;
        if (!superClass.getManager().isInProject((PsiElement)superClass)) {
            CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)JavaRefactoringBundle.message((String)"inline.super.non.project.class.warning.message", (Object[])new Object[0]), (String)JavaRefactoringBundle.message((String)"inline.super.class", (Object[])new Object[0]), null);
            return;
        }
        PsiClass chosen = null;
        PsiReference psiReference = reference = editor != null ? TargetElementUtil.findReference((Editor)editor, (int)editor.getCaretModel().getOffset()) : null;
        if (reference != null && (resolve = reference.resolve()) == superClass && (parent = (referenceElement = reference.getElement()).getParent()) instanceof PsiReferenceList && (gParent = parent.getParent()) instanceof PsiClass) {
            chosen = (PsiClass)gParent;
        }
        new InlineSuperClassRefactoringDialog(project, superClass, chosen).show();
    }

    @Nullable
    public String getActionName(PsiElement element) {
        return JavaRefactoringBundle.message((String)"inline.super.class.action.name", (Object[])new Object[0]);
    }
}

