/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.inlineSuperClass.usageInfo;

import com.intellij.java.refactoring.JavaRefactoringBundle;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiArrayInitializerExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.refactoring.util.FixableUsageInfo;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.Nls;

public class ReplaceConstructorUsageInfo
extends FixableUsageInfo {
    private final PsiType myNewType;
    @Nls
    private String myConflict;

    public ReplaceConstructorUsageInfo(PsiNewExpression element, PsiType newType, PsiClass[] targetClasses) {
        super((PsiElement)element);
        PsiType type;
        this.myNewType = newType;
        PsiMethod[] constructors = targetClasses[0].getConstructors();
        PsiMethod constructor = element.resolveConstructor();
        if (constructor == null) {
            if (element.getArgumentList() != null && (constructors.length == 1 && !constructors[0].getParameterList().isEmpty() || constructors.length > 1)) {
                this.myConflict = JavaRefactoringBundle.message((String)"inline.super.no.ctor", (Object[])new Object[0]);
            }
        } else {
            PsiParameter[] superParameters = constructor.getParameterList().getParameters();
            boolean foundMatchingConstructor = constructors.length == 0 && superParameters.length == 0;
            block0: for (PsiMethod method : constructors) {
                PsiParameter[] parameters = method.getParameterList().getParameters();
                if (superParameters.length != parameters.length) continue;
                for (int i = 0; i < parameters.length; ++i) {
                    PsiParameter parameter = parameters[i];
                    if (!TypeConversionUtil.isAssignable((PsiType)TypeConversionUtil.erasure((PsiType)parameter.getType()), (PsiType)TypeConversionUtil.erasure((PsiType)superParameters[i].getType()))) continue block0;
                }
                foundMatchingConstructor = true;
            }
            if (!foundMatchingConstructor) {
                this.myConflict = JavaRefactoringBundle.message((String)"inline.super.no.ctor", (Object[])new Object[0]);
            }
        }
        if ((type = element.getType()) == null) {
            this.appendConflict(JavaRefactoringBundle.message((String)"inline.super.unknown.type", (Object[])new Object[0]));
            return;
        }
        if (!TypeConversionUtil.isAssignable((PsiType)(type = type.getDeepComponentType()), (PsiType)newType)) {
            String conflict = JavaRefactoringBundle.message((String)"inline.super.type.params.differ", (Object[])new Object[]{element.getText(), newType.getPresentableText(), type.getPresentableText()});
            this.appendConflict(conflict);
        }
        if (targetClasses.length > 1) {
            String conflict = JavaRefactoringBundle.message((String)"inline.super.ctor.can.be.replaced", (Object[])new Object[]{element.getText(), StringUtil.join((Object[])targetClasses, psiClass -> psiClass.getQualifiedName(), (String)", ")});
            this.appendConflict(conflict);
        }
    }

    private void appendConflict(@Nls String conflict) {
        this.myConflict = this.myConflict == null ? conflict : this.myConflict + "\n" + conflict;
    }

    public void fixUsage() throws IncorrectOperationException {
        PsiNewExpression newExpression = (PsiNewExpression)this.getElement();
        if (newExpression != null) {
            PsiElementFactory elementFactory = JavaPsiFacade.getElementFactory((Project)newExpression.getProject());
            StringBuilder buf = new StringBuilder();
            buf.append("new ").append(this.myNewType.getCanonicalText());
            PsiArrayInitializerExpression arrayInitializer = newExpression.getArrayInitializer();
            PsiType newExpressionType = newExpression.getType();
            assert (newExpressionType != null);
            if (arrayInitializer != null) {
                buf.append("[]".repeat(newExpressionType.getArrayDimensions()));
                buf.append(arrayInitializer.getText());
            } else {
                Object[] arrayDimensions = newExpression.getArrayDimensions();
                if (arrayDimensions.length > 0) {
                    buf.append("[");
                    buf.append(StringUtil.join((Object[])arrayDimensions, psiExpression -> psiExpression.getText(), (String)"]["));
                    buf.append("]");
                    for (int i = 0; i < newExpressionType.getArrayDimensions() - arrayDimensions.length; ++i) {
                        buf.append("[]");
                    }
                } else {
                    PsiExpressionList list = newExpression.getArgumentList();
                    if (list != null) {
                        buf.append(list.getText());
                    }
                }
            }
            newExpression.replace((PsiElement)elementFactory.createExpressionFromText(buf.toString(), (PsiElement)newExpression));
        }
    }

    public String getConflictMessage() {
        return this.myConflict;
    }
}

