/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.introduceField;

import com.intellij.java.refactoring.JavaRefactoringBundle;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiModifier;
import com.intellij.psi.PsiNameHelper;
import com.intellij.psi.PsiType;
import com.intellij.refactoring.JavaRefactoringSettings;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.introduceField.BaseExpressionToFieldHandler;
import com.intellij.refactoring.introduceField.IntroduceFieldCentralPanel;
import com.intellij.refactoring.introduceField.IntroduceFieldDialogPanel;
import com.intellij.refactoring.introduceField.IntroduceFieldHandler;
import com.intellij.refactoring.ui.NameSuggestionsField;
import com.intellij.refactoring.ui.NameSuggestionsManager;
import com.intellij.refactoring.ui.TypeSelector;
import com.intellij.refactoring.ui.TypeSelectorManager;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.refactoring.util.JavaNameSuggestionUtil;
import com.intellij.refactoring.util.RefactoringMessageUtil;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.update.Activatable;
import com.intellij.util.ui.update.UiNotifyConnector;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jetbrains.annotations.Nls;

class IntroduceFieldDialog
extends DialogWrapper {
    public static BaseExpressionToFieldHandler.InitializationPlace ourLastInitializerPlace;
    private final Project myProject;
    private final PsiClass myParentClass;
    private final PsiExpression myInitializerExpression;
    private final String myEnteredName;
    private final PsiLocalVariable myLocalVariable;
    private final boolean myIsInvokedOnDeclaration;
    private final boolean myWillBeDeclaredStatic;
    private final TypeSelectorManager myTypeSelectorManager;
    private NameSuggestionsField myNameField;
    private final IntroduceFieldCentralPanel myCentralPanel;
    private TypeSelector myTypeSelector;
    private NameSuggestionsManager myNameSuggestionsManager;

    IntroduceFieldDialog(Project project, PsiClass parentClass, PsiExpression initializerExpression, PsiLocalVariable localVariable, boolean isCurrentMethodConstructor, boolean isInvokedOnDeclaration, boolean willBeDeclaredStatic, PsiExpression[] occurrences, boolean allowInitInMethod, boolean allowInitInMethodIfAll, TypeSelectorManager typeSelectorManager, String enteredName) {
        super(project, true);
        this.myProject = project;
        this.myParentClass = parentClass;
        this.myInitializerExpression = initializerExpression;
        this.myEnteredName = enteredName;
        this.myCentralPanel = new IntroduceFieldDialogPanel(parentClass, initializerExpression, localVariable, isCurrentMethodConstructor, isInvokedOnDeclaration, willBeDeclaredStatic, occurrences, allowInitInMethod, allowInitInMethodIfAll, typeSelectorManager);
        this.myLocalVariable = localVariable;
        this.myIsInvokedOnDeclaration = isInvokedOnDeclaration;
        this.myWillBeDeclaredStatic = willBeDeclaredStatic;
        this.myTypeSelectorManager = typeSelectorManager;
        this.setTitle(IntroduceFieldDialog.getRefactoringName());
        this.init();
        this.myCentralPanel.initializeControls(initializerExpression, ourLastInitializerPlace);
        this.updateButtons();
    }

    public void setReplaceAllOccurrences(boolean replaceAll) {
        this.myCentralPanel.setReplaceAllOccurrences(replaceAll);
    }

    public String getEnteredName() {
        return this.myNameField.getEnteredName();
    }

    public BaseExpressionToFieldHandler.InitializationPlace getInitializerPlace() {
        return this.myCentralPanel.getInitializerPlace();
    }

    @PsiModifier.ModifierConstant
    public String getFieldVisibility() {
        return this.myCentralPanel.getFieldVisibility();
    }

    public boolean isReplaceAllOccurrences() {
        return this.myCentralPanel.isReplaceAllOccurrences();
    }

    public boolean isDeleteVariable() {
        return this.myCentralPanel.isDeleteVariable();
    }

    public boolean isDeclareFinal() {
        return this.myCentralPanel.isDeclareFinal();
    }

    public PsiType getFieldType() {
        return this.myTypeSelector.getSelectedType();
    }

    protected String getHelpId() {
        return "refactoring.introduceField";
    }

    protected JComponent createNorthPanel() {
        JPanel panel = new JPanel(new GridBagLayout());
        GridBagConstraints gbConstraints = new GridBagConstraints();
        gbConstraints.insets = JBUI.insets((int)4, (int)4, (int)4, (int)0);
        gbConstraints.anchor = 13;
        gbConstraints.fill = 1;
        gbConstraints.gridwidth = 1;
        gbConstraints.weightx = 0.0;
        gbConstraints.weighty = 1.0;
        gbConstraints.gridx = 0;
        gbConstraints.gridy = 0;
        final JLabel type = new JLabel(this.getTypeLabel());
        panel.add((Component)type, gbConstraints);
        ++gbConstraints.gridx;
        gbConstraints.insets = JBUI.insets((int)4, (int)0, (int)4, (int)4);
        gbConstraints.weightx = 0.0;
        this.myTypeSelector = this.myTypeSelectorManager.getTypeSelector();
        panel.add((Component)this.myTypeSelector.getComponent(), gbConstraints);
        gbConstraints.insets = JBUI.insets((int)4, (int)4, (int)4, (int)0);
        gbConstraints.gridwidth = 1;
        gbConstraints.weightx = 0.0;
        gbConstraints.weighty = 1.0;
        gbConstraints.gridx = 0;
        gbConstraints.gridy = 1;
        final JLabel namePrompt = new JLabel(RefactoringBundle.message((String)"name.prompt"));
        panel.add((Component)namePrompt, gbConstraints);
        gbConstraints.insets = JBUI.insets((int)4, (int)0, (int)4, (int)4);
        gbConstraints.gridwidth = 1;
        gbConstraints.weightx = 1.0;
        gbConstraints.gridx = 1;
        gbConstraints.gridy = 1;
        this.myNameField = new NameSuggestionsField(this.myProject);
        panel.add((Component)this.myNameField.getComponent(), gbConstraints);
        this.myNameField.addDataChangedListener(() -> this.updateButtons());
        namePrompt.setLabelFor(this.myNameField.getFocusableComponent());
        UiNotifyConnector.Once.installOn((Component)panel, (Activatable)new Activatable(){

            public void showNotify() {
                IntroduceFieldDialog.this.myNameSuggestionsManager = new NameSuggestionsManager(IntroduceFieldDialog.this.myTypeSelector, IntroduceFieldDialog.this.myNameField, JavaNameSuggestionUtil.createFieldNameGenerator((boolean)IntroduceFieldDialog.this.myWillBeDeclaredStatic, (PsiLocalVariable)IntroduceFieldDialog.this.myLocalVariable, (PsiExpression)IntroduceFieldDialog.this.myInitializerExpression, (boolean)IntroduceFieldDialog.this.myIsInvokedOnDeclaration, (String)IntroduceFieldDialog.this.myEnteredName, (PsiClass)IntroduceFieldDialog.this.myParentClass, (Project)IntroduceFieldDialog.this.myProject));
                IntroduceFieldDialog.this.myNameSuggestionsManager.setLabelsFor(type, namePrompt);
                Editor editor = IntroduceFieldDialog.this.myNameField.getEditor();
                if (editor != null) {
                    editor.getSelectionModel().setSelection(0, editor.getDocument().getTextLength());
                }
            }
        });
        return panel;
    }

    private void updateButtons() {
        this.setOKActionEnabled(PsiNameHelper.getInstance((Project)this.myProject).isIdentifier(this.getEnteredName()));
    }

    @Nls
    private String getTypeLabel() {
        return this.myWillBeDeclaredStatic ? JavaRefactoringBundle.message((String)"introduce.field.static.field.of.type", (Object[])new Object[0]) : JavaRefactoringBundle.message((String)"introduce.field.field.of.type", (Object[])new Object[0]);
    }

    protected JComponent createCenterPanel() {
        return this.myCentralPanel.createCenterPanel();
    }

    protected void doOKAction() {
        int answer;
        String fieldName = this.getEnteredName();
        String errorString = null;
        if ("".equals(fieldName)) {
            errorString = RefactoringBundle.message((String)"no.field.name.specified");
        } else if (!PsiNameHelper.getInstance((Project)this.myProject).isIdentifier(fieldName)) {
            errorString = RefactoringMessageUtil.getIncorrectIdentifierMessage((String)fieldName);
        }
        if (errorString != null) {
            CommonRefactoringUtil.showErrorMessage((String)IntroduceFieldHandler.getRefactoringNameText(), (String)errorString, (String)"refactoring.introduceField", (Project)this.myProject);
            return;
        }
        PsiField oldField = this.myParentClass.findFieldByName(fieldName, true);
        if (oldField != null && (answer = Messages.showYesNoDialog((Project)this.myProject, (String)RefactoringBundle.message((String)"field.exists", (Object[])new Object[]{fieldName, oldField.getContainingClass().getQualifiedName()}), (String)IntroduceFieldHandler.getRefactoringNameText(), (Icon)Messages.getWarningIcon())) != 0) {
            return;
        }
        this.myCentralPanel.saveFinalState();
        ourLastInitializerPlace = this.myCentralPanel.getInitializerPlace();
        JavaRefactoringSettings.getInstance().INTRODUCE_FIELD_VISIBILITY = this.getFieldVisibility();
        this.myNameSuggestionsManager.nameSelected();
        this.myTypeSelectorManager.typeSelected(this.getFieldType());
        super.doOKAction();
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myNameField.getFocusableComponent();
    }

    @NlsContexts.DialogTitle
    private static String getRefactoringName() {
        return RefactoringBundle.message((String)"introduce.field.title");
    }
}

