/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.introduceParameter;

import com.intellij.codeInsight.hint.EditorCodePreview;
import com.intellij.codeInsight.hints.presentation.InlayPresentation;
import com.intellij.codeInsight.template.impl.TemplateManagerImpl;
import com.intellij.codeInsight.template.impl.TemplateState;
import com.intellij.ide.DataManager;
import com.intellij.internal.statistic.eventLog.events.EventPair;
import com.intellij.java.JavaBundle;
import com.intellij.lang.LangBundle;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.markup.EffectType;
import com.intellij.openapi.editor.markup.HighlighterTargetArea;
import com.intellij.openapi.editor.markup.MarkupModel;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.codeStyle.SuggestedNameInfo;
import com.intellij.psi.codeStyle.VariableKind;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.util.PsiUtil;
import com.intellij.refactoring.AbstractJavaInplaceIntroducer;
import com.intellij.refactoring.JavaRefactoringSettings;
import com.intellij.refactoring.RefactoringActionHandler;
import com.intellij.refactoring.extractMethod.newImpl.inplace.EditorState;
import com.intellij.refactoring.extractMethod.newImpl.inplace.InplaceExtractUtils;
import com.intellij.refactoring.introduceParameter.InplaceIntroduceParameterUI;
import com.intellij.refactoring.introduceParameter.IntroduceParameterHandler;
import com.intellij.refactoring.introduceParameter.IntroduceParameterHelperKt;
import com.intellij.refactoring.introduceParameter.IntroduceParameterProcessor;
import com.intellij.refactoring.introduceParameter.IntroduceParameterUsagesCollector;
import com.intellij.refactoring.introduceParameter.JavaIntroduceParameterMethodUsagesProcessor;
import com.intellij.refactoring.introduceVariable.IntroduceVariableBase;
import com.intellij.refactoring.rename.inplace.TemplateInlayUtil;
import com.intellij.refactoring.ui.TypeSelectorManager;
import com.intellij.refactoring.ui.TypeSelectorManagerImpl;
import com.intellij.ui.JBColor;
import com.intellij.ui.components.labels.LinkLabel;
import com.intellij.util.ui.JBUI;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.util.ArrayList;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import kotlin.ranges.IntRange;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class InplaceIntroduceParameterPopup
extends AbstractJavaInplaceIntroducer {
    private final PsiMethod myMethod;
    private final PsiMethod myMethodToSearchFor;
    private final boolean myMustBeFinal;
    @NotNull
    private IntroduceVariableBase.JavaReplaceChoice myReplaceChoice;
    private int myParameterIndex;
    private final InplaceIntroduceParameterUI myPanel;
    private final PsiMethod myOriginalMethod;
    private PsiMethod myCreatedDelegate;
    private final EditorState myEditorState;
    private EditorCodePreview myEditorPreview;

    InplaceIntroduceParameterPopup(Project project, Editor editor, TypeSelectorManagerImpl typeSelectorManager, PsiExpression expr, PsiLocalVariable localVar, PsiMethod method, PsiMethod methodToSearchFor, PsiExpression[] occurrences, IntList parametersToRemove, boolean mustBeFinal,  @NotNull IntroduceVariableBase.JavaReplaceChoice replaceChoice) {
        if (replaceChoice == null) {
            InplaceIntroduceParameterPopup.$$$reportNull$$$0(0);
        }
        super(project, editor, expr, (PsiVariable)localVar, occurrences, typeSelectorManager, IntroduceParameterHandler.getRefactoringName());
        this.myParameterIndex = -1;
        this.myMethod = method;
        this.myOriginalMethod = (PsiMethod)method.copy();
        this.myMethodToSearchFor = methodToSearchFor;
        this.myMustBeFinal = mustBeFinal;
        this.myReplaceChoice = replaceChoice;
        this.myEditorState = new EditorState(project, editor);
        this.myPanel = new InplaceIntroduceParameterUI(project, localVar, expr, method, parametersToRemove, (TypeSelectorManager)typeSelectorManager, (PsiExpression[])this.myOccurrences){

            @Override
            protected PsiParameter getParameter() {
                return InplaceIntroduceParameterPopup.this.getParameter();
            }

            @Override
            protected void updateControls(JCheckBox[] removeParamsCb) {
                super.updateControls(removeParamsCb);
                if (InplaceIntroduceParameterPopup.this.myParameterIndex < 0) {
                    return;
                }
                InplaceIntroduceParameterPopup.this.restartInplaceIntroduceTemplate();
            }

            @Override
            protected IntList getParametersToRemove() {
                IntArrayList parameters = new IntArrayList();
                if (this.myCbReplaceAllOccurences == null || this.myCbReplaceAllOccurences.isSelected()) {
                    for (int i = 0; i < this.myParametersToRemove.length; ++i) {
                        if (this.myParametersToRemove[i] == null) continue;
                        parameters.add(i);
                    }
                }
                return parameters;
            }
        };
        GridBagConstraints gc = new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 18, 0, (Insets)JBUI.insetsLeft((int)6), 0, 0);
        this.myPanel.createDelegateCb(gc, this.myWholePanel);
        gc.insets.top = JBUI.scale((int)6);
        this.myWholePanel.add((Component)new LinkLabel<Object>(LangBundle.message((String)"inlay.rename.link.label.more.options", (Object[])new Object[0]), null){

            public void doClick() {
                new IntroduceParameterHandler().invoke(InplaceIntroduceParameterPopup.this.myProject, InplaceIntroduceParameterPopup.this.myEditor, InplaceIntroduceParameterPopup.this.myMethod.getContainingFile(), DataManager.getInstance().getDataContext((Component)InplaceIntroduceParameterPopup.this.myEditor.getComponent()));
            }
        }, gc);
    }

    protected void showDialogAdvertisement(@NonNls String actionId) {
        Shortcut shortcut = KeymapUtil.getPrimaryShortcut((String)actionId);
        Shortcut selectDelegateShortcut = KeymapUtil.getPrimaryShortcut((String)"SelectVirtualTemplateElement");
        if (shortcut != null && selectDelegateShortcut != null) {
            this.setAdvertisementText(JavaBundle.message((String)"introduce.parameter.advertisement.text", (Object[])new Object[]{KeymapUtil.getShortcutText((Shortcut)selectDelegateShortcut), KeymapUtil.getShortcutText((Shortcut)shortcut)}));
        } else {
            super.showDialogAdvertisement(actionId);
        }
    }

    @Override
    protected PsiVariable createFieldToStartTemplateOn(String[] names, PsiType defaultType) {
        PsiElementFactory elementFactory = JavaPsiFacade.getElementFactory((Project)this.myMethod.getProject());
        return (PsiVariable)WriteAction.compute(() -> {
            PsiParameter anchor = JavaIntroduceParameterMethodUsagesProcessor.getAnchorParameter(this.myMethod);
            PsiParameter psiParameter = (PsiParameter)this.myMethod.getParameterList().addAfter((PsiElement)elementFactory.createParameter(this.chooseName(names, this.myMethod.getLanguage()), defaultType), (PsiElement)anchor);
            PsiUtil.setModifierProperty((PsiModifierListOwner)psiParameter, (String)"final", (boolean)this.myPanel.hasFinalModifier());
            this.myParameterIndex = this.myMethod.getParameterList().getParameterIndex(psiParameter);
            return psiParameter;
        });
    }

    protected PsiElement checkLocalScope() {
        return this.myMethod;
    }

    protected SearchScope getReferencesSearchScope(VirtualFile file) {
        return new LocalSearchScope((PsiElement)this.myMethod);
    }

    @Override
    protected VariableKind getVariableKind() {
        return VariableKind.PARAMETER;
    }

    @Override
    protected SuggestedNameInfo suggestNames(PsiType defaultType, String propName) {
        return IntroduceParameterHandler.createNameSuggestionGenerator((PsiExpression)this.myExpr, propName, this.myProject, null).getSuggestedNameInfo(defaultType);
    }

    @Nullable
    private PsiParameter getParameter() {
        if (!this.myMethod.isValid()) {
            return null;
        }
        PsiParameter[] parameters = this.myMethod.getParameterList().getParameters();
        return parameters.length > this.myParameterIndex && this.myParameterIndex >= 0 ? parameters[this.myParameterIndex] : null;
    }

    protected JComponent getComponent() {
        return null;
    }

    protected void afterTemplateStart() {
        super.afterTemplateStart();
        TemplateState templateState2 = TemplateManagerImpl.getTemplateState((Editor)this.myEditor);
        if (templateState2 == null) {
            return;
        }
        TextRange currentVariableRange = templateState2.getCurrentVariableRange();
        if (currentVariableRange == null) {
            return;
        }
        IntroduceParameterUsagesCollector.started.log(new EventPair[]{IntroduceParameterUsagesCollector.replaceAll.with((Object)this.myReplaceChoice.isAll())});
        InlayPresentation presentation = IntroduceParameterHelperKt.createDelegatePresentation(templateState2, JavaBundle.message((String)"introduce.parameter.inlay.title.delegate", (Object[])new Object[0]), isSelected -> {
            this.myPanel.myCbGenerateDelegate.setSelected((boolean)isSelected);
            if (isSelected.booleanValue()) {
                this.createDelegate();
            } else {
                this.removeDelegate();
            }
            this.updatePreview((Disposable)templateState2);
        });
        TemplateInlayUtil.createNavigatableButton((TemplateState)templateState2, (int)currentVariableRange.getEndOffset(), (InlayPresentation)presentation);
        this.updatePreview((Disposable)templateState2);
    }

    @Nullable
    protected String getExpressionText(PsiExpression expr) {
        if (expr == null && this.myLocalVariable != null) {
            PsiExpression initializer = ((PsiVariable)this.myLocalVariable).getInitializer();
            return initializer != null ? initializer.getText() : ((PsiVariable)this.myLocalVariable).getName();
        }
        return super.getExpressionText((PsiElement)expr);
    }

    private void createDelegate() {
        PsiMethod createdDelegate = IntroduceParameterProcessor.createDelegate(this.myOriginalMethod, this.myExprText, this.myPanel.getParametersToRemove());
        this.myCreatedDelegate = (PsiMethod)WriteCommandAction.writeCommandAction((Project)this.myProject).compute(() -> (PsiMethod)this.myMethod.getParent().addBefore((PsiElement)createdDelegate, (PsiElement)this.myMethod));
    }

    private void removeDelegate() {
        PsiMethod delegate = this.myCreatedDelegate;
        if (delegate != null) {
            this.myCreatedDelegate = null;
            WriteCommandAction.writeCommandAction((Project)this.myProject).run(() -> delegate.delete());
        }
    }

    private void updatePreview(Disposable parentDisposable) {
        EditorCodePreview previousPreview = this.myEditorPreview;
        if (previousPreview != null) {
            Disposer.dispose((Disposable)previousPreview);
        }
        EditorCodePreview preview = EditorCodePreview.Companion.create(this.myEditor);
        Disposer.register((Disposable)parentDisposable, (Disposable)preview);
        this.myEditorPreview = preview;
        PsiParameter psiParameter = this.getParameter();
        if (psiParameter == null) {
            return;
        }
        MarkupModel markupModel = this.myEditor.getMarkupModel();
        TextRange newParameterRange = psiParameter.getTextRange();
        ArrayList<RangeHighlighter> highlighters = new ArrayList<RangeHighlighter>();
        highlighters.add(markupModel.addRangeHighlighter(newParameterRange.getStartOffset(), newParameterRange.getEndOffset(), 0, InplaceIntroduceParameterPopup.getTextAttributesForAdd(this.myEditor), HighlighterTargetArea.EXACT_RANGE));
        PsiParameterList list = this.myMethod.getParameterList();
        for (PsiParameter parameter : list.getParameters()) {
            if (parameter == psiParameter || !this.myPanel.isParamToRemove(parameter)) continue;
            TextRange range = parameter.getTextRange();
            highlighters.add(markupModel.addRangeHighlighter(range.getStartOffset(), range.getEndOffset(), 0, InplaceIntroduceParameterPopup.getTestAttributesForRemoval(), HighlighterTargetArea.EXACT_RANGE));
        }
        Document document = this.myEditor.getDocument();
        int previewLineStart = document.getLineNumber(this.myMethod.getTextOffset());
        int previewLineEnd = document.getLineNumber(list.getTextRange().getEndOffset());
        preview.addPreview(new IntRange(previewLineStart, previewLineEnd), IntroduceParameterHelperKt.onClickCallback(psiParameter));
        Disposer.register((Disposable)preview, () -> {
            for (RangeHighlighter highlighter : highlighters) {
                highlighter.dispose();
            }
        });
        PsiMethod delegate = this.myCreatedDelegate;
        if (delegate != null) {
            InplaceExtractUtils utils = InplaceExtractUtils.INSTANCE;
            Disposable highlighting = utils.createInsertedHighlighting(this.myEditor, delegate.getTextRange());
            Disposer.register((Disposable)preview, (Disposable)highlighting);
            IntRange linesForPreview = utils.getLinesFromTextRange(this.myEditor.getDocument(), delegate.getTextRange());
            utils.addPreview(preview, this.myEditor, linesForPreview, delegate.getTextRange().getStartOffset());
        }
    }

    public boolean isReplaceAllOccurrences() {
        return this.myReplaceChoice.isAll();
    }

    protected PsiVariable getVariable() {
        return this.getParameter();
    }

    protected boolean startsOnTheSameElement(RefactoringActionHandler handler, PsiElement element) {
        return handler instanceof IntroduceParameterHandler && super.startsOnTheSameElement(handler, element);
    }

    @Override
    protected void saveSettings(@NotNull PsiVariable psiVariable) {
        if (psiVariable == null) {
            InplaceIntroduceParameterPopup.$$$reportNull$$$0(1);
        }
        this.myPanel.saveSettings(JavaRefactoringSettings.getInstance());
    }

    public void finish(boolean success) {
        super.finish(success);
        if (!success) {
            this.performCleanup();
        }
    }

    protected void moveOffsetAfter(boolean success) {
        if (!success) {
            return;
        }
        super.moveOffsetAfter(success);
    }

    protected void performCleanup() {
        this.myEditorState.revert();
    }

    protected void performIntroduce() {
        boolean isDeleteLocalVariable = false;
        PsiExpression parameterInitializer = (PsiExpression)this.myExpr;
        if (this.getLocalVariable() != null) {
            if (this.myPanel.isUseInitializer()) {
                parameterInitializer = ((PsiVariable)this.getLocalVariable()).getInitializer();
            }
            isDeleteLocalVariable = this.myPanel.isDeleteLocalVariable();
        }
        IntroduceParameterUsagesCollector.settingsOnPerform.log(this.myProject, new EventPair[]{IntroduceParameterUsagesCollector.delegate.with((Object)this.isGenerateDelegate())});
        IntList parametersToRemove = this.myPanel.getParametersToRemove();
        IntroduceParameterProcessor processor = new IntroduceParameterProcessor(this.myProject, this.myMethod, this.myMethodToSearchFor, parameterInitializer, (PsiExpression)this.myExpr, (PsiLocalVariable)this.getLocalVariable(), isDeleteLocalVariable, this.getInputName(), this.myReplaceChoice, this.myPanel.getReplaceFieldsWithGetters(), this.myMustBeFinal || this.myPanel.isGenerateFinal(), false, false, this.getType(), parametersToRemove);
        processor.run();
        this.normalizeParameterIdxAccordingToRemovedParams(parametersToRemove);
        PsiParameter parameter = this.getParameter();
        if (parameter != null) {
            super.saveSettings((PsiVariable)parameter);
        }
    }

    public boolean isGenerateDelegate() {
        return this.myPanel.isGenerateDelegate();
    }

    @NotNull
    public IntroduceVariableBase.JavaReplaceChoice getReplaceChoice() {
        IntroduceVariableBase.JavaReplaceChoice javaReplaceChoice = this.myReplaceChoice;
        if (javaReplaceChoice == null) {
            InplaceIntroduceParameterPopup.$$$reportNull$$$0(2);
        }
        return javaReplaceChoice;
    }

    private static TextAttributes getTextAttributesForAdd(Editor editor) {
        TextAttributes textAttributes = new TextAttributes();
        textAttributes.setBackgroundColor(editor.getColorsScheme().getColor(EditorColors.ADDED_LINES_COLOR));
        return textAttributes;
    }

    private static TextAttributes getTestAttributesForRemoval() {
        TextAttributes textAttributes = new TextAttributes();
        textAttributes.setEffectType(EffectType.STRIKEOUT);
        textAttributes.setEffectColor((Color)JBColor.BLACK);
        return textAttributes;
    }

    protected String getActionName() {
        return "IntroduceParameter";
    }

    private void normalizeParameterIdxAccordingToRemovedParams(IntList parametersToRemove) {
        parametersToRemove.forEach(value -> {
            if (this.myParameterIndex >= value) {
                --this.myParameterIndex;
            }
        });
    }

    public void setReplaceAllOccurrences(boolean replaceAll) {
        this.myReplaceChoice = replaceAll ? IntroduceVariableBase.JavaReplaceChoice.ALL : IntroduceVariableBase.JavaReplaceChoice.NO;
    }

    public PsiMethod getMethodToIntroduceParameter() {
        return this.myMethod;
    }

    public PsiMethod getMethodToSearchFor() {
        return this.myMethodToSearchFor;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "replaceChoice";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiVariable";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/refactoring/introduceParameter/InplaceIntroduceParameterPopup";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/refactoring/introduceParameter/InplaceIntroduceParameterPopup";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getReplaceChoice";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "saveSettings";
                break;
            }
            case 2: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2 -> new IllegalStateException(string);
        };
    }
}

