/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.introduceParameter;

import com.intellij.java.refactoring.JavaRefactoringBundle;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.ui.LabeledComponent;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.codeStyle.JavaCodeStyleSettings;
import com.intellij.psi.util.PsiUtil;
import com.intellij.refactoring.JavaRefactoringSettings;
import com.intellij.refactoring.introduce.inplace.KeyboardComboSwitcher;
import com.intellij.refactoring.introduceParameter.IntroduceParameterSettingsUI;
import com.intellij.refactoring.ui.TypeSelectorManager;
import com.intellij.ui.SimpleListCellRenderer;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import it.unimi.dsi.fastutil.ints.IntList;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import javax.swing.border.Border;

public abstract class InplaceIntroduceParameterUI
extends IntroduceParameterSettingsUI {
    private JComboBox<Integer> myReplaceFieldsCb;
    private boolean myHasWriteAccess;
    private final Project myProject;
    private final TypeSelectorManager myTypeSelectorManager;
    private final PsiFile myFile;

    public InplaceIntroduceParameterUI(Project project, PsiLocalVariable onLocalVariable, PsiExpression onExpression, PsiMethod methodToReplaceIn, IntList parametersToRemove, TypeSelectorManager typeSelectorManager, PsiExpression[] occurrences) {
        super(onLocalVariable, onExpression, methodToReplaceIn, parametersToRemove);
        this.myProject = project;
        this.myTypeSelectorManager = typeSelectorManager;
        this.myFile = methodToReplaceIn.getContainingFile();
        for (PsiExpression occurrence : occurrences) {
            if (!PsiUtil.isAccessedForWriting((PsiExpression)occurrence)) continue;
            this.myHasWriteAccess = true;
            break;
        }
    }

    protected abstract PsiParameter getParameter();

    @Override
    protected JPanel createReplaceFieldsWithGettersPanel() {
        LabeledComponent component = new LabeledComponent();
        this.myReplaceFieldsCb = new ComboBox((Object[])new Integer[]{2, 1, 0});
        this.myReplaceFieldsCb.setRenderer((ListCellRenderer<Integer>)SimpleListCellRenderer.create((label, value, index) -> {
            String message = switch (value) {
                case 0 -> JavaRefactoringBundle.message((String)"do.not.replace", (Object[])new Object[0]);
                case 1 -> JavaRefactoringBundle.message((String)"replace.fields.inaccessible.in.usage.context", (Object[])new Object[0]);
                default -> JavaRefactoringBundle.message((String)"replace.all.fields", (Object[])new Object[0]);
            };
            label.setText(UIUtil.removeMnemonic((String)message));
        }));
        this.myReplaceFieldsCb.setSelectedItem(JavaRefactoringSettings.getInstance().INTRODUCE_PARAMETER_REPLACE_FIELDS_WITH_GETTERS);
        KeyboardComboSwitcher.setupActions(this.myReplaceFieldsCb, (Project)this.myProject);
        component.setComponent(this.myReplaceFieldsCb);
        component.setText(JavaRefactoringBundle.message((String)"replace.fields.used.in.expressions.with.their.getters", (Object[])new Object[0]));
        component.setLabelLocation("North");
        component.setBorder((Border)JBUI.Borders.empty((int)3, (int)3, (int)2, (int)2));
        return component;
    }

    @Override
    protected int getReplaceFieldsWithGetters() {
        return this.myReplaceFieldsCb != null ? (Integer)this.myReplaceFieldsCb.getSelectedItem() : 1;
    }

    @Override
    protected TypeSelectorManager getTypeSelectionManager() {
        return this.myTypeSelectorManager;
    }

    public boolean isGenerateFinal() {
        return this.hasFinalModifier();
    }

    public boolean hasFinalModifier() {
        if (this.myHasWriteAccess) {
            return false;
        }
        Boolean createFinals = JavaRefactoringSettings.getInstance().INTRODUCE_PARAMETER_CREATE_FINALS;
        return createFinals == null ? JavaCodeStyleSettings.getInstance((PsiFile)this.myFile).GENERATE_FINAL_PARAMETERS : createFinals;
    }
}

