/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.introduceParameter;

import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.refactoring.introduceParameter.InternalUsageInfo;
import com.intellij.refactoring.introduceParameter.IntroduceParameterData;
import com.intellij.refactoring.introduceParameter.IntroduceParameterMethodUsagesProcessor;
import com.intellij.refactoring.util.usageInfo.DefaultConstructorImplicitUsageInfo;
import com.intellij.refactoring.util.usageInfo.NoConstructorClassUsageInfo;
import com.intellij.usageView.UsageInfo;
import com.intellij.util.IncorrectOperationException;
import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayList;
import java.util.Objects;

public final class IntroduceParameterUtil {
    private IntroduceParameterUtil() {
    }

    public static boolean insideMethodToBeReplaced(PsiElement methodUsage, PsiMethod methodToReplaceIn) {
        for (PsiElement parent = methodUsage.getParent(); parent != null; parent = parent.getParent()) {
            if (!parent.equals((Object)methodToReplaceIn)) continue;
            return true;
        }
        return false;
    }

    public static boolean isMethodUsage(UsageInfo usageInfo) {
        for (IntroduceParameterMethodUsagesProcessor processor : (IntroduceParameterMethodUsagesProcessor[])IntroduceParameterMethodUsagesProcessor.EP_NAME.getExtensions()) {
            if (!processor.isMethodUsage(usageInfo)) continue;
            return true;
        }
        return false;
    }

    public static void addSuperCall(UsageInfo usage, UsageInfo[] usages, IntroduceParameterData data) throws IncorrectOperationException {
        for (IntroduceParameterMethodUsagesProcessor processor : (IntroduceParameterMethodUsagesProcessor[])IntroduceParameterMethodUsagesProcessor.EP_NAME.getExtensions()) {
            if (!processor.processAddSuperCall(data, usage, usages)) break;
        }
    }

    public static void addDefaultConstructor(UsageInfo usage, UsageInfo[] usages, IntroduceParameterData data) throws IncorrectOperationException {
        for (IntroduceParameterMethodUsagesProcessor processor : (IntroduceParameterMethodUsagesProcessor[])IntroduceParameterMethodUsagesProcessor.EP_NAME.getExtensions()) {
            if (!processor.processAddDefaultConstructor(data, usage, usages)) break;
        }
    }

    public static void changeExternalUsage(UsageInfo usage, UsageInfo[] usages, IntroduceParameterData data) throws IncorrectOperationException {
        for (IntroduceParameterMethodUsagesProcessor processor : (IntroduceParameterMethodUsagesProcessor[])IntroduceParameterMethodUsagesProcessor.EP_NAME.getExtensions()) {
            if (!processor.processChangeMethodUsage(data, usage, usages)) break;
        }
    }

    public static void changeMethodSignatureAndResolveFieldConflicts(UsageInfo usage, UsageInfo[] usages, IntroduceParameterData data) throws IncorrectOperationException {
        for (IntroduceParameterMethodUsagesProcessor processor : (IntroduceParameterMethodUsagesProcessor[])IntroduceParameterMethodUsagesProcessor.EP_NAME.getExtensions()) {
            if (!processor.processChangeMethodSignature(data, usage, usages)) break;
        }
    }

    public static void processUsages(UsageInfo[] usages, IntroduceParameterData data) {
        PsiManager manager = PsiManager.getInstance((Project)data.getProject());
        ArrayList<UsageInfo> methodUsages = new ArrayList<UsageInfo>();
        block5: for (UsageInfo usage : usages) {
            UsageInfo usageInfo;
            Objects.requireNonNull(usage);
            int n = 0;
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{InternalUsageInfo.class, DefaultConstructorImplicitUsageInfo.class, NoConstructorClassUsageInfo.class}, (Object)usageInfo, n)) {
                case 0: {
                    InternalUsageInfo info = (InternalUsageInfo)usageInfo;
                    continue block5;
                }
                case 1: {
                    DefaultConstructorImplicitUsageInfo info = (DefaultConstructorImplicitUsageInfo)usageInfo;
                    IntroduceParameterUtil.addSuperCall(info, usages, data);
                    continue block5;
                }
                case 2: {
                    NoConstructorClassUsageInfo info = (NoConstructorClassUsageInfo)usageInfo;
                    IntroduceParameterUtil.addDefaultConstructor(info, usages, data);
                    continue block5;
                }
                default: {
                    PsiElement element = usage.getElement();
                    if (element instanceof PsiMethod) {
                        if (manager.areElementsEquivalent(element, (PsiElement)data.getMethodToReplaceIn())) continue block5;
                        methodUsages.add(usage);
                        continue block5;
                    }
                    if (data.isGenerateDelegate()) continue block5;
                    IntroduceParameterUtil.changeExternalUsage(usage, usages, data);
                }
            }
        }
        for (UsageInfo usage : methodUsages) {
            IntroduceParameterUtil.changeMethodSignatureAndResolveFieldConflicts(usage, usages, data);
        }
    }

    public static boolean isMethodInUsages(IntroduceParameterData data, PsiMethod method, UsageInfo[] usages) {
        PsiManager manager = PsiManager.getInstance((Project)data.getProject());
        for (UsageInfo info : usages) {
            if (info instanceof DefaultConstructorImplicitUsageInfo || !manager.areElementsEquivalent(info.getElement(), (PsiElement)method)) continue;
            return true;
        }
        return false;
    }
}

