/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.introduceParameter;

import com.intellij.codeInsight.ChangeContextUtil;
import com.intellij.java.refactoring.JavaRefactoringBundle;
import com.intellij.lang.Language;
import com.intellij.lang.java.JavaLanguage;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiCall;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiMethodReferenceExpression;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameterListOwner;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.impl.ExpressionConverter;
import com.intellij.psi.impl.PsiDiamondTypeUtil;
import com.intellij.psi.infos.MethodCandidateInfo;
import com.intellij.psi.javadoc.PsiDocTag;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.introduceParameter.ExternalUsageInfo;
import com.intellij.refactoring.introduceParameter.IntroduceParameterData;
import com.intellij.refactoring.introduceParameter.IntroduceParameterMethodUsagesProcessor;
import com.intellij.refactoring.introduceParameter.IntroduceParameterUtil;
import com.intellij.refactoring.introduceParameter.OldReferenceResolver;
import com.intellij.refactoring.util.FieldConflictsResolver;
import com.intellij.refactoring.util.LambdaRefactoringUtil;
import com.intellij.refactoring.util.RefactoringUtil;
import com.intellij.refactoring.util.javadoc.MethodJavaDocHelper;
import com.intellij.usageView.UsageInfo;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.VisibilityUtil;
import com.intellij.util.containers.MultiMap;
import it.unimi.dsi.fastutil.ints.IntList;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class JavaIntroduceParameterMethodUsagesProcessor
implements IntroduceParameterMethodUsagesProcessor {
    private static final Logger LOG = Logger.getInstance(JavaIntroduceParameterMethodUsagesProcessor.class);

    private static boolean isJavaUsage(UsageInfo usage) {
        PsiElement e = usage.getElement();
        return e != null && e.getLanguage().is((Language)JavaLanguage.INSTANCE);
    }

    @Override
    public boolean isMethodUsage(UsageInfo usage) {
        return RefactoringUtil.isMethodUsage(usage.getElement()) && JavaIntroduceParameterMethodUsagesProcessor.isJavaUsage(usage);
    }

    @Override
    public boolean processChangeMethodUsage(IntroduceParameterData data, UsageInfo usage, UsageInfo[] usages) throws IncorrectOperationException {
        PsiExpression anchor;
        PsiExpression callExpression;
        PsiElement ref = usage.getElement();
        if (ref instanceof PsiMethodReferenceExpression) {
            callExpression = LambdaRefactoringUtil.convertToMethodCallInLambdaBody((PsiMethodReferenceExpression)((PsiMethodReferenceExpression)ref));
            if (callExpression == null) {
                return true;
            }
            ref = callExpression;
        } else if (!this.isMethodUsage(usage)) {
            return true;
        }
        callExpression = RefactoringUtil.getCallExpressionByMethodReference(ref);
        PsiExpressionList argList = RefactoringUtil.getArgumentListByMethodReference(ref);
        if (argList == null || callExpression == null) {
            return true;
        }
        PsiExpression[] oldArgs = argList.getExpressions();
        JavaResolveResult result = callExpression.resolveMethodGenerics();
        boolean varargs = result instanceof MethodCandidateInfo && ((MethodCandidateInfo)result).getApplicabilityLevel() == 2;
        PsiMethod methodToSearchFor = data.getMethodToSearchFor();
        if (!methodToSearchFor.isVarArgs()) {
            anchor = JavaIntroduceParameterMethodUsagesProcessor.getLast(oldArgs);
        } else {
            PsiParameter[] parameters = methodToSearchFor.getParameterList().getParameters();
            if (parameters.length > oldArgs.length) {
                anchor = JavaIntroduceParameterMethodUsagesProcessor.getLast(oldArgs);
            } else {
                LOG.assertTrue(parameters.length > 0);
                int lastNonVararg = parameters.length - 2;
                anchor = lastNonVararg >= 0 ? oldArgs[lastNonVararg] : null;
            }
        }
        PsiMethod method = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)argList, PsiMethod.class);
        if (method != null && IntroduceParameterUtil.isMethodInUsages(data, method, usages)) {
            argList.addAfter((PsiElement)JavaPsiFacade.getElementFactory((Project)data.getProject()).createExpressionFromText(data.getParameterName(), (PsiElement)argList), (PsiElement)anchor);
        } else {
            PsiElement initializer = ExpressionConverter.getExpression(data.getParameterInitializer().getExpression(), (Language)JavaLanguage.INSTANCE, (Project)data.getProject());
            assert (initializer instanceof PsiExpression);
            if (initializer instanceof PsiNewExpression && !PsiDiamondTypeUtil.canChangeContextForDiamond((PsiNewExpression)((PsiNewExpression)initializer), (PsiType)((PsiNewExpression)initializer).getType())) {
                initializer = PsiDiamondTypeUtil.expandTopLevelDiamondsInside((PsiExpression)((PsiNewExpression)initializer));
            }
            JavaIntroduceParameterMethodUsagesProcessor.substituteTypeParametersInInitializer(initializer, (PsiCall)callExpression, methodToSearchFor);
            ChangeContextUtil.encodeContextInfo((PsiElement)initializer, (boolean)true);
            PsiExpression newArg = (PsiExpression)argList.addAfter(initializer, (PsiElement)anchor);
            ChangeContextUtil.decodeContextInfo((PsiElement)newArg, null, null);
            ChangeContextUtil.clearContextInfo((PsiElement)initializer);
            new OldReferenceResolver((PsiCall)callExpression, newArg, data.getMethodToReplaceIn(), data.getReplaceFieldsWithGetters(), initializer).resolve(varargs);
        }
        PsiExpressionList argumentList = callExpression.getArgumentList();
        LOG.assertTrue(argumentList != null, (Object)callExpression.getText());
        JavaIntroduceParameterMethodUsagesProcessor.removeParametersFromCall(argumentList, data.getParameterListToRemove(), methodToSearchFor);
        return false;
    }

    private static void substituteTypeParametersInInitializer(PsiElement initializer, PsiCall callExpression, PsiMethod method) {
        Project project = method.getProject();
        PsiSubstitutor psiSubstitutor = callExpression.resolveMethodGenerics().getSubstitutor();
        RefactoringUtil.replaceMovedMemberTypeParameters(initializer, PsiUtil.typeParametersIterable((PsiTypeParameterListOwner)method), psiSubstitutor, JavaPsiFacade.getElementFactory((Project)project));
    }

    private static void removeParametersFromCall(@NotNull PsiExpressionList argList, IntList parametersToRemove, PsiMethod method) {
        if (argList == null) {
            JavaIntroduceParameterMethodUsagesProcessor.$$$reportNull$$$0(0);
        }
        int parametersCount = method.getParameterList().getParametersCount();
        PsiExpression[] exprs = argList.getExpressions();
        for (int i = parametersToRemove.size() - 1; i >= 0; --i) {
            int paramNum = parametersToRemove.getInt(i);
            try {
                if (method.isVarArgs() && paramNum == parametersCount - 1) {
                    for (int j = paramNum + 1; j < exprs.length; ++j) {
                        exprs[j].delete();
                    }
                    continue;
                }
                if (paramNum >= exprs.length) continue;
                exprs[paramNum].delete();
                continue;
            }
            catch (IncorrectOperationException e) {
                LOG.error((Throwable)e);
            }
        }
    }

    @Nullable
    private static PsiExpression getLast(PsiExpression[] oldArgs) {
        PsiExpression anchor = oldArgs.length > 0 ? oldArgs[oldArgs.length - 1] : null;
        return anchor;
    }

    @Override
    public void findConflicts(IntroduceParameterData data, UsageInfo[] usages, MultiMap<PsiElement, @Nls String> conflicts) {
        PsiMethod method = data.getMethodToReplaceIn();
        int parametersCount = method.getParameterList().getParametersCount();
        for (UsageInfo usage : usages) {
            PsiExpressionList argList;
            PsiElement element = usage.getElement();
            if (element instanceof PsiMethodReferenceExpression && !ApplicationManager.getApplication().isUnitTestMode()) {
                conflicts.putValue((Object)element, (Object)JavaRefactoringBundle.message((String)"expand.method.reference.warning", (Object[])new Object[0]));
            }
            if (!this.isMethodUsage(usage)) continue;
            PsiCall call = RefactoringUtil.getCallExpressionByMethodReference(element);
            PsiExpressionList psiExpressionList = argList = call != null ? call.getArgumentList() : null;
            if (argList == null) continue;
            int actualParamLength = argList.getExpressionCount();
            if (method.isVarArgs() && actualParamLength + 1 < parametersCount || !method.isVarArgs() && actualParamLength < parametersCount) {
                conflicts.putValue((Object)call, (Object)RefactoringBundle.message((String)"refactoring.introduce.parameter.incomplete.call.less.params", (Object[])new Object[]{call.getText(), parametersCount, actualParamLength}));
            }
            data.getParameterListToRemove().forEach(paramNum -> {
                if (paramNum >= actualParamLength) {
                    conflicts.putValue((Object)call, (Object)RefactoringBundle.message((String)"refactoring.introduce.parameter.incomplete.call.param.not.found", (Object[])new Object[]{call.getText(), paramNum, actualParamLength}));
                }
            });
        }
    }

    @Override
    public boolean processChangeMethodSignature(IntroduceParameterData data, UsageInfo usage, UsageInfo[] usages) throws IncorrectOperationException {
        PsiMethod method;
        block8: {
            block7: {
                PsiElement psiElement = usage.getElement();
                if (!(psiElement instanceof PsiMethod)) break block7;
                method = (PsiMethod)psiElement;
                if (JavaIntroduceParameterMethodUsagesProcessor.isJavaUsage(usage)) break block8;
            }
            return true;
        }
        FieldConflictsResolver fieldConflictsResolver = new FieldConflictsResolver(data.getParameterName(), method.getBody());
        MethodJavaDocHelper javaDocHelper = new MethodJavaDocHelper(method);
        PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)data.getProject());
        PsiClass superClass = data.getMethodToSearchFor().getContainingClass();
        PsiClass containingClass = method.getContainingClass();
        PsiSubstitutor substitutor = superClass != null && containingClass != null ? TypeConversionUtil.getSuperClassSubstitutor((PsiClass)superClass, (PsiClass)containingClass, (PsiSubstitutor)PsiSubstitutor.EMPTY) : PsiSubstitutor.EMPTY;
        PsiParameter parameter = factory.createParameter(data.getParameterName(), substitutor.substitute(data.getForcedType()));
        PsiUtil.setModifierProperty((PsiModifierListOwner)parameter, (String)"final", (boolean)data.isDeclareFinal());
        PsiParameterList parameterList = method.getParameterList();
        PsiParameter[] parameters = parameterList.getParameters();
        IntList parametersToRemove = data.getParameterListToRemove();
        for (int i = parametersToRemove.size() - 1; i >= 0; --i) {
            int paramNum = parametersToRemove.getInt(i);
            try {
                PsiParameter param = parameters[paramNum];
                PsiDocTag tag = javaDocHelper.getTagForParameter(param);
                if (tag != null) {
                    tag.delete();
                }
                param.delete();
                continue;
            }
            catch (IncorrectOperationException e) {
                LOG.error((Throwable)e);
            }
        }
        PsiParameter anchorParameter = JavaIntroduceParameterMethodUsagesProcessor.getAnchorParameter(method);
        parameter = (PsiParameter)parameterList.addAfter((PsiElement)parameter, (PsiElement)anchorParameter);
        JavaCodeStyleManager.getInstance((Project)data.getProject()).shortenClassReferences((PsiElement)parameter);
        PsiDocTag tagForAnchorParameter = javaDocHelper.getTagForParameter(anchorParameter);
        javaDocHelper.addParameterAfter(data.getParameterName(), tagForAnchorParameter);
        fieldConflictsResolver.fix();
        return false;
    }

    @Nullable
    public static PsiParameter getAnchorParameter(PsiMethod methodToReplaceIn) {
        PsiParameter anchorParameter;
        PsiParameterList parameterList = methodToReplaceIn.getParameterList();
        PsiParameter[] parameters = parameterList.getParameters();
        int length = parameters.length;
        if (!methodToReplaceIn.isVarArgs()) {
            anchorParameter = length > 0 ? parameters[length - 1] : null;
        } else {
            LOG.assertTrue(length > 0);
            LOG.assertTrue(parameters[length - 1].isVarArgs());
            anchorParameter = length > 1 ? parameters[length - 2] : null;
        }
        return anchorParameter;
    }

    @Override
    public boolean processAddDefaultConstructor(IntroduceParameterData data, UsageInfo usage, UsageInfo[] usages) {
        PsiClass aClass;
        block5: {
            block4: {
                PsiElement psiElement = usage.getElement();
                if (!(psiElement instanceof PsiClass)) break block4;
                aClass = (PsiClass)psiElement;
                if (JavaIntroduceParameterMethodUsagesProcessor.isJavaUsage(usage)) break block5;
            }
            return true;
        }
        if (aClass instanceof PsiAnonymousClass) {
            return true;
        }
        PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)data.getProject());
        PsiMethod constructor = factory.createMethodFromText(aClass.getName() + "(){}", (PsiElement)aClass);
        constructor = (PsiMethod)CodeStyleManager.getInstance((Project)data.getProject()).reformat((PsiElement)constructor);
        constructor = (PsiMethod)aClass.add((PsiElement)constructor);
        PsiUtil.setModifierProperty((PsiModifierListOwner)constructor, (String)VisibilityUtil.getVisibilityModifier((PsiModifierList)aClass.getModifierList()), (boolean)true);
        this.processAddSuperCall(data, new UsageInfo((PsiElement)constructor), usages);
        return false;
    }

    @Override
    public boolean processAddSuperCall(IntroduceParameterData data, UsageInfo usage, UsageInfo[] usages) throws IncorrectOperationException {
        PsiMethod constructor;
        block5: {
            block4: {
                PsiElement psiElement = usage.getElement();
                if (!(psiElement instanceof PsiMethod)) break block4;
                constructor = (PsiMethod)psiElement;
                if (JavaIntroduceParameterMethodUsagesProcessor.isJavaUsage(usage)) break block5;
            }
            return true;
        }
        if (!constructor.isConstructor()) {
            return true;
        }
        PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)data.getProject());
        PsiExpressionStatement superCall = (PsiExpressionStatement)factory.createStatementFromText("super();", (PsiElement)constructor);
        superCall = (PsiExpressionStatement)CodeStyleManager.getInstance((Project)data.getProject()).reformat((PsiElement)superCall);
        PsiCodeBlock body = constructor.getBody();
        PsiStatement[] statements = body.getStatements();
        superCall = statements.length > 0 ? (PsiExpressionStatement)body.addBefore((PsiElement)superCall, (PsiElement)statements[0]) : (PsiExpressionStatement)body.add((PsiElement)superCall);
        this.processChangeMethodUsage(data, new ExternalUsageInfo((PsiElement)((PsiMethodCallExpression)superCall.getExpression()).getMethodExpression()), usages);
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "argList", "com/intellij/refactoring/introduceParameter/JavaIntroduceParameterMethodUsagesProcessor", "removeParametersFromCall"));
    }
}

