/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.introduceParameter;

import com.intellij.codeInsight.generation.GenerateMembersUtil;
import com.intellij.java.JavaBundle;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiQualifiedExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.OverridingMethodsSearch;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.refactoring.introduceField.ElementToWorkOn;
import com.intellij.refactoring.introduceParameter.ClassMemberInExprUsageInfo;
import com.intellij.refactoring.introduceParameter.LocalVariableInExprUsageInfo;
import com.intellij.refactoring.introduceParameter.ParameterInExprUsageInfo;
import com.intellij.usageView.UsageInfo;
import com.intellij.util.ArrayUtil;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntCollection;
import it.unimi.dsi.fastutil.ints.IntIterator;
import it.unimi.dsi.fastutil.ints.IntList;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class Util {
    public static void analyzeExpression(PsiExpression expr, List<? super UsageInfo> localVars, List<? super UsageInfo> classMemberRefs, List<? super UsageInfo> params) {
        PsiElement[] children;
        if (expr instanceof PsiQualifiedExpression) {
            classMemberRefs.add(new ClassMemberInExprUsageInfo((PsiElement)expr));
        } else if (expr instanceof PsiReferenceExpression) {
            PsiReferenceExpression refExpr = (PsiReferenceExpression)expr;
            PsiElement subj = refExpr.resolve();
            if (subj instanceof PsiParameter) {
                params.add(new ParameterInExprUsageInfo((PsiElement)refExpr));
            } else if (subj instanceof PsiLocalVariable) {
                localVars.add(new LocalVariableInExprUsageInfo((PsiElement)refExpr));
            } else if (subj instanceof PsiField || subj instanceof PsiMethod) {
                classMemberRefs.add(new ClassMemberInExprUsageInfo((PsiElement)refExpr));
            }
        }
        for (PsiElement child : children = expr.getChildren()) {
            if (!(child instanceof PsiExpression)) continue;
            Util.analyzeExpression((PsiExpression)child, localVars, classMemberRefs, params);
        }
    }

    @NotNull
    private static PsiElement getPhysical(@NotNull PsiElement expr) {
        PsiElement physicalElement;
        if (expr == null) {
            Util.$$$reportNull$$$0(0);
        }
        if ((physicalElement = (PsiElement)expr.getUserData(ElementToWorkOn.PARENT)) != null) {
            expr = physicalElement;
        }
        PsiElement psiElement = expr;
        if (psiElement == null) {
            Util.$$$reportNull$$$0(1);
        }
        return psiElement;
    }

    public static PsiMethod getContainingMethod(PsiElement expr) {
        return (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)Util.getPhysical(expr), PsiMethod.class);
    }

    public static boolean isAncestor(PsiElement ancestor, PsiElement element, boolean strict) {
        TextRange exprRange = (TextRange)ancestor.getUserData(ElementToWorkOn.EXPR_RANGE);
        if (exprRange != null) {
            return exprRange.contains(element.getTextRange());
        }
        return PsiTreeUtil.isAncestor((PsiElement)Util.getPhysical(ancestor), (PsiElement)Util.getPhysical(element), (boolean)strict);
    }

    public static boolean anyFieldsWithGettersPresent(List<? extends UsageInfo> classMemberRefs) {
        for (UsageInfo usageInfo : classMemberRefs) {
            PsiReferenceExpression ref;
            PsiElement psiElement = usageInfo.getElement();
            if (!(psiElement instanceof PsiReferenceExpression) || !((psiElement = (ref = (PsiReferenceExpression)psiElement).resolve()) instanceof PsiField)) continue;
            PsiField psiField = (PsiField)psiElement;
            PsiMethod getterPrototype = GenerateMembersUtil.generateGetterPrototype((PsiField)psiField);
            PsiMethod getter = psiField.getContainingClass().findMethodBySignature(getterPrototype, true);
            if (getter == null) continue;
            return true;
        }
        return false;
    }

    @NotNull
    public static IntList findParametersToRemove(@NotNull PsiMethod method, @NotNull PsiExpression expr, PsiExpression @Nullable [] occurences) {
        PsiParameter[] parameters;
        if (method == null) {
            Util.$$$reportNull$$$0(2);
        }
        if (expr == null) {
            Util.$$$reportNull$$$0(3);
        }
        if ((parameters = method.getParameterList().getParameters()).length == 0) {
            return new IntArrayList();
        }
        IntOpenHashSet suspects = new IntOpenHashSet();
        expr.accept((PsiElementVisitor)new JavaRecursiveElementWalkingVisitor((IntSet)suspects){
            final /* synthetic */ IntSet val$suspects;
            {
                this.val$suspects = intSet;
            }

            public void visitReferenceExpression(@NotNull PsiReferenceExpression expression) {
                int i;
                if (expression == null) {
                    1.$$$reportNull$$$0(0);
                }
                super.visitReferenceExpression(expression);
                PsiElement resolved = expression.resolve();
                if (resolved instanceof PsiParameter && (i = ArrayUtil.find((Object[])parameters, (Object)resolved)) != -1) {
                    this.val$suspects.add(i);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/intellij/refactoring/introduceParameter/Util$1", "visitReferenceExpression"));
            }
        });
        Util.removeUsed(method, expr, occurences, (IntSet)suspects);
        if (suspects.isEmpty()) {
            return new IntArrayList();
        }
        if (!ProgressManager.getInstance().runProcessWithProgressSynchronously(() -> Util.lambda$findParametersToRemove$2(method, expr, occurences, (IntSet)suspects), JavaBundle.message((String)"progress.title.search.for.overriding.methods", (Object[])new Object[0]), true, method.getProject())) {
            return new IntArrayList();
        }
        return new IntArrayList((IntCollection)suspects);
    }

    private static void removeUsed(PsiMethod containingMethod, @NotNull PsiExpression expr, PsiExpression @Nullable [] occurences, IntSet suspects) {
        if (expr == null) {
            Util.$$$reportNull$$$0(4);
        }
        IntIterator iterator = suspects.iterator();
        while (iterator.hasNext()) {
            PsiParameter[] psiParameters;
            int paramNum = iterator.nextInt();
            if (paramNum >= (psiParameters = containingMethod.getParameterList().getParameters()).length) continue;
            PsiParameter parameter = psiParameters[paramNum];
            ReferencesSearch.search((PsiElement)parameter, (SearchScope)parameter.getResolveScope(), (boolean)false).forEach(reference -> {
                boolean stillCanBeRemoved;
                PsiElement element = reference.getElement();
                boolean bl = stillCanBeRemoved = Util.isAncestor((PsiElement)expr, element, false) || PsiUtil.isInsideJavadocComment((PsiElement)Util.getPhysical(element));
                if (!stillCanBeRemoved && occurences != null) {
                    for (PsiExpression occurence : occurences) {
                        if (!Util.isAncestor((PsiElement)occurence, element, false)) continue;
                        stillCanBeRemoved = true;
                        break;
                    }
                }
                if (!stillCanBeRemoved) {
                    iterator.remove();
                    return false;
                }
                return true;
            });
        }
    }

    private static /* synthetic */ void lambda$findParametersToRemove$2(PsiMethod method, PsiExpression expr, PsiExpression[] occurences, IntSet suspects) {
        OverridingMethodsSearch.search((PsiMethod)method).forEach(psiMethod -> {
            ReadAction.run(() -> Util.removeUsed(psiMethod, expr, occurences, suspects));
            return !suspects.isEmpty();
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expr";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/refactoring/introduceParameter/Util";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/refactoring/introduceParameter/Util";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getPhysical";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getPhysical";
                break;
            }
            case 1: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "findParametersToRemove";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "removeUsed";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1 -> new IllegalStateException(string);
        };
    }
}

