/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.introduceVariable;

import com.intellij.codeInsight.highlighting.HighlightManager;
import com.intellij.codeInsight.lookup.LookupManager;
import com.intellij.codeInsight.unwrap.ScopeHighlighter;
import com.intellij.codeInspection.RemoveRedundantTypeArgumentsUtil;
import com.intellij.featureStatistics.FeatureUsageTracker;
import com.intellij.java.refactoring.JavaRefactoringBundle;
import com.intellij.lang.LanguageRefactoringSupport;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.lang.refactoring.RefactoringSupportProvider;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.diagnostic.Attachment;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.editor.SelectionModel;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Pass;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.pom.java.JavaFeature;
import com.intellij.psi.GenericsUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.LambdaUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiDisjunctionType;
import com.intellij.psi.PsiDoWhileStatement;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiEnumConstant;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiForStatement;
import com.intellij.psi.PsiForeachStatement;
import com.intellij.psi.PsiIfStatement;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiPatternVariable;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiSwitchLabelStatementBase;
import com.intellij.psi.PsiTryStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeCastExpression;
import com.intellij.psi.PsiTypes;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.PsiWhileStatement;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.psi.codeStyle.JavaCodeStyleSettings;
import com.intellij.psi.codeStyle.SuggestedNameInfo;
import com.intellij.psi.impl.PsiDiamondTypeUtil;
import com.intellij.psi.impl.source.jsp.jspJava.JspCodeBlock;
import com.intellij.psi.impl.source.jsp.jspJava.JspHolderMethod;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageUtil;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.JavaPsiPatternUtil;
import com.intellij.psi.util.PsiExpressionTrimRenderer;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.refactoring.IntroduceHandlerBase;
import com.intellij.refactoring.IntroduceTargetChooser;
import com.intellij.refactoring.IntroduceVariableUtil;
import com.intellij.refactoring.JavaRefactoringSettings;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.chainCall.ChainCallExtractor;
import com.intellij.refactoring.introduce.inplace.AbstractInplaceIntroducer;
import com.intellij.refactoring.introduce.inplace.OccurrencesChooser;
import com.intellij.refactoring.introduceField.ElementToWorkOn;
import com.intellij.refactoring.introduceVariable.ChainCallInplaceIntroducer;
import com.intellij.refactoring.introduceVariable.InputValidator;
import com.intellij.refactoring.introduceVariable.IntroduceVariableSettings;
import com.intellij.refactoring.introduceVariable.IntroduceVariableTargetBlockChooser;
import com.intellij.refactoring.introduceVariable.JavaVariableInplaceIntroducer;
import com.intellij.refactoring.introduceVariable.ReassignVariableUtil;
import com.intellij.refactoring.introduceVariable.VariableExtractor;
import com.intellij.refactoring.listeners.RefactoringEventData;
import com.intellij.refactoring.listeners.RefactoringEventListener;
import com.intellij.refactoring.ui.TypeSelectorManagerImpl;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.refactoring.util.RefactoringUIUtil;
import com.intellij.refactoring.util.RefactoringUtil;
import com.intellij.refactoring.util.occurrences.ExpressionOccurrenceManager;
import com.intellij.refactoring.util.occurrences.NotInConstructorCallFilter;
import com.intellij.util.CommonJavaRefactoringUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.NotNullFunction;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.siyeh.ig.psiutils.ExpressionUtils;
import com.siyeh.ig.psiutils.VariableAccessUtils;
import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import one.util.streamex.EntryStream;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public abstract class IntroduceVariableBase
extends IntroduceHandlerBase {
    @NonNls
    private static final String REFACTORING_ID = "refactoring.extractVariable";
    private JavaVariableInplaceIntroducer myInplaceIntroducer;

    public void invoke(final @NotNull Project project, final Editor editor, final PsiFile file, DataContext dataContext) {
        SelectionModel selectionModel;
        if (project == null) {
            IntroduceVariableBase.$$$reportNull$$$0(0);
        }
        if (!(selectionModel = editor.getSelectionModel()).hasSelection()) {
            int offset = editor.getCaretModel().getOffset();
            IntroduceVariableUtil.IntroduceVariableCandidates info = IntroduceVariableUtil.getIntroduceVariableCandidates((Project)project, (Editor)editor, (PsiFile)file, (int)offset);
            TextRange suggestedSelection = info.bestRangeToExtractFrom();
            if (suggestedSelection != null) {
                selectionModel.setSelection(suggestedSelection.getStartOffset(), suggestedSelection.getEndOffset());
            } else {
                PsiElement[] statementsInRange = IntroduceVariableUtil.findStatementsAtOffset((Editor)editor, (PsiFile)file, (int)offset);
                List expressions = info.expressions();
                IntroduceTargetChooser.showChooser((Editor)editor, (List)expressions, (Pass)new Pass<PsiExpression>(){

                    public void pass(PsiExpression selectedValue) {
                        IntroduceVariableBase.this.invoke(project, editor, file, selectedValue.getTextRange().getStartOffset(), selectedValue.getTextRange().getEndOffset());
                    }
                }, (com.intellij.util.Function)new PsiExpressionTrimRenderer.RenderFunction(), (String)RefactoringBundle.message((String)"introduce.target.chooser.expressions.title"), (int)IntroduceVariableUtil.preferredSelection((PsiElement[])statementsInRange, (List)expressions), (NotNullFunction)ScopeHighlighter.NATURAL_RANGER);
                return;
            }
        }
        if (this.invoke(project, editor, file, selectionModel.getSelectionStart(), selectionModel.getSelectionEnd()) && LookupManager.getActiveLookup((Editor)editor) == null) {
            selectionModel.removeSelection();
        }
    }

    @Deprecated(forRemoval=true)
    @NotNull
    public static @NotNull Pair<@Nullable TextRange, @NotNull List<PsiExpression>> getExpressionsAndSelectionRange(@NotNull Project project, @NotNull Editor editor, @NotNull PsiFile file, int offset) {
        if (project == null) {
            IntroduceVariableBase.$$$reportNull$$$0(1);
        }
        if (editor == null) {
            IntroduceVariableBase.$$$reportNull$$$0(2);
        }
        if (file == null) {
            IntroduceVariableBase.$$$reportNull$$$0(3);
        }
        IntroduceVariableUtil.IntroduceVariableCandidates info = IntroduceVariableUtil.getIntroduceVariableCandidates((Project)project, (Editor)editor, (PsiFile)file, (int)offset);
        return new Pair((Object)info.bestRangeToExtractFrom(), (Object)info.expressions());
    }

    private boolean invoke(Project project, Editor editor, PsiFile file, int startOffset, int endOffset) {
        FeatureUsageTracker.getInstance().triggerFeatureUsed("refactoring.introduceVariable");
        PsiDocumentManager.getInstance((Project)project).commitAllDocuments();
        return this.invokeImpl(project, IntroduceVariableUtil.findExpressionInRange((Project)project, (PsiFile)file, (int)startOffset, (int)endOffset), editor);
    }

    @NotNull
    public Pair<List<PsiElement>, List<PsiExpression>> getPossibleAnchorsAndOccurrences(Project project, PsiExpression expr) {
        OccurrencesInfo occurrencesInfo = this.buildOccurrencesInfo(project, expr);
        LinkedHashMap<JavaReplaceChoice, List<PsiExpression>> occurrencesMap = occurrencesInfo.buildOccurrencesMap(expr);
        List anchors = occurrencesMap.values().stream().map(o -> IntroduceVariableBase.getAnchor(o.toArray(PsiExpression.EMPTY_ARRAY))).filter(Objects::nonNull).flatMap(anchor -> IntroduceVariableTargetBlockChooser.getContainers(anchor, expr).stream()).distinct().collect(Collectors.toList());
        Pair pair = Pair.create(anchors, occurrencesInfo.myOccurrences);
        if (pair == null) {
            IntroduceVariableBase.$$$reportNull$$$0(4);
        }
        return pair;
    }

    @NotNull
    public Map<String, JavaReplaceChoice> getPossibleReplaceChoices(Project project, PsiExpression expr) {
        OccurrencesInfo occurrencesInfo = this.buildOccurrencesInfo(project, expr);
        LinkedHashMap<JavaReplaceChoice, List<PsiExpression>> occurrencesMap = occurrencesInfo.buildOccurrencesMap(expr);
        Map<String, JavaReplaceChoice> map = occurrencesMap.entrySet().stream().collect(Collectors.toMap(entry -> ((JavaReplaceChoice)entry.getKey()).formatDescription(((List)entry.getValue()).size()), entry -> (JavaReplaceChoice)entry.getKey()));
        if (map == null) {
            IntroduceVariableBase.$$$reportNull$$$0(5);
        }
        return map;
    }

    @NotNull
    private OccurrencesInfo buildOccurrencesInfo(Project project, PsiExpression expr) {
        ErrorOrContainer result;
        PsiElement anchorStatement = IntroduceVariableBase.getAnchor((PsiElement)expr);
        ErrorOrContainer errorOrContainer = result = IntroduceVariableBase.getTempContainer(anchorStatement);
        Objects.requireNonNull(errorOrContainer);
        ErrorOrContainer errorOrContainer2 = errorOrContainer;
        int n = 0;
        PsiElement tempContainer = switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{ErrorOrContainer.Container.class, ErrorOrContainer.Error.class}, (Object)errorOrContainer2, n)) {
            default -> throw new MatchException(null, null);
            case 0 -> {
                ErrorOrContainer.Container container = (ErrorOrContainer.Container)errorOrContainer2;
                yield container.element();
            }
            case 1 -> {
                ErrorOrContainer.Error error = (ErrorOrContainer.Error)errorOrContainer2;
                this.showErrorMessage(project, null, error.message());
                yield null;
            }
        };
        ExpressionOccurrenceManager occurrenceManager = IntroduceVariableBase.createOccurrenceManager(expr, tempContainer);
        PsiExpression[] occurrences = occurrenceManager.getOccurrences();
        return new OccurrencesInfo(occurrences);
    }

    @Nullable
    private static JavaReplaceChoice findChoice(@NotNull LinkedHashMap<JavaReplaceChoice, List<PsiExpression>> occurrencesMap, @NotNull JavaReplaceChoice replaceChoice) {
        if (occurrencesMap == null) {
            IntroduceVariableBase.$$$reportNull$$$0(6);
        }
        if (replaceChoice == null) {
            IntroduceVariableBase.$$$reportNull$$$0(7);
        }
        return (JavaReplaceChoice)((Map.Entry)ContainerUtil.find(occurrencesMap.entrySet(), entry -> ((JavaReplaceChoice)entry.getKey()).formatDescription(0).equals(replaceChoice.formatDescription(0)))).getKey();
    }

    @Override
    protected boolean invokeImpl(Project project, PsiExpression expr, Editor editor) {
        return this.invokeImpl(project, expr, null, null, editor);
    }

    public boolean invokeImpl(Project project, PsiExpression expr, @Nullable PsiElement targetContainer, @Nullable JavaReplaceChoice replaceChoice, Editor editor) {
        IntroduceVariableResult introduceVariableResult;
        IntroduceVariableResult introduceVariableResult2 = introduceVariableResult = IntroduceVariableBase.getIntroduceVariableContext(project, expr, editor);
        Objects.requireNonNull(introduceVariableResult2);
        IntroduceVariableResult introduceVariableResult3 = introduceVariableResult2;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{IntroduceVariableResult.Context.class, IntroduceVariableResult.Error.class}, (Object)introduceVariableResult3, n)) {
            default: {
                throw new MatchException(null, null);
            }
            case 0: {
                IntroduceVariableResult.Context context = (IntroduceVariableResult.Context)introduceVariableResult3;
                return this.doRefactoring(project, targetContainer, replaceChoice, editor, context);
            }
            case 1: 
        }
        IntroduceVariableResult.Error error = (IntroduceVariableResult.Error)introduceVariableResult3;
        if (error.message != null) {
            this.showErrorMessage(project, editor, error.message);
        }
        return false;
    }

    private boolean doRefactoring(Project project, @Nullable PsiElement targetContainer, @Nullable JavaReplaceChoice replaceChoice, Editor editor, @NotNull IntroduceVariableResult.Context context) {
        if (context == null) {
            IntroduceVariableBase.$$$reportNull$$$0(8);
        }
        if (!CommonRefactoringUtil.checkReadOnlyStatus((Project)project, (PsiElement)context.file())) {
            return false;
        }
        LinkedHashMap<JavaReplaceChoice, List<PsiExpression>> occurrencesMap = context.occurrencesInfo.buildOccurrencesMap(context.expression);
        IntroduceVariablePass callback = new IntroduceVariablePass(project, context, editor, targetContainer);
        if (replaceChoice != null) {
            callback.accept(IntroduceVariableBase.findChoice(occurrencesMap, replaceChoice));
        } else if (!context.isInplaceAvailableOnDataContext) {
            callback.accept(null);
        } else {
            String title = context.occurrencesInfo.myChainMethodName != null && context.occurrenceManager.getOccurrences().length == 1 ? JavaRefactoringBundle.message((String)"replace.lambda.chain.detected", (Object[])new Object[0]) : RefactoringBundle.message((String)"replace.multiple.occurrences.found");
            IntroduceVariableBase.createOccurrencesChooser(editor).showChooser(occurrencesMap, title, (Consumer)callback);
        }
        return callback.wasSucceed;
    }

    @NotNull
    public static OccurrencesChooser<PsiExpression> createOccurrencesChooser(Editor editor) {
        return new OccurrencesChooser<PsiExpression>(editor){

            protected TextRange getOccurrenceRange(PsiExpression occurrence) {
                RangeMarker rangeMarker = (RangeMarker)occurrence.getUserData(ElementToWorkOn.TEXT_RANGE);
                if (rangeMarker != null) {
                    return rangeMarker.getTextRange();
                }
                return occurrence.getTextRange();
            }
        };
    }

    public static boolean canBeExtractedWithoutExplicitType(PsiExpression expr) {
        PsiExpression copy;
        PsiType type;
        return PsiUtil.isAvailable((JavaFeature)JavaFeature.LVTI, (PsiElement)expr) && (type = GenericsUtil.getVariableTypeByExpressionType((PsiType)expr.getType())) != null && !PsiTypes.nullType().equals(type) && PsiTypesUtil.isDenotableType((PsiType)type, (PsiElement)expr) && type.equals(GenericsUtil.getVariableTypeByExpressionType((PsiType)(copy = (PsiExpression)(type instanceof PsiDisjunctionType ? expr.copy() : LambdaUtil.copyWithExpectedType((PsiElement)expr, (PsiType)type))).getType()));
    }

    @NotNull
    public static IntroduceVariableResult getIntroduceVariableContext(@NotNull Project project, @Nullable PsiExpression expr, @Nullable Editor editor) {
        ErrorOrContainer errorOrContainer;
        String message;
        String enumInSwitchError;
        String message2;
        if (project == null) {
            IntroduceVariableBase.$$$reportNull$$$0(9);
        }
        if (expr != null) {
            PsiField f;
            PsiClass containingClass;
            message2 = IntroduceVariableUtil.getErrorMessage((PsiExpression)expr);
            if (message2 != null) {
                return new IntroduceVariableResult.Error(message2);
            }
            PsiExpression topLevelExpression = ExpressionUtils.getTopLevelExpression((PsiExpression)expr);
            PsiElement psiElement = topLevelExpression.getParent();
            if (psiElement instanceof PsiField && (containingClass = (f = (PsiField)psiElement).getContainingClass()) != null && containingClass.isInterface()) {
                message2 = JavaRefactoringBundle.message((String)"introduce.variable.message.cannot.extract.variable.in.interface", (Object[])new Object[0]);
                return new IntroduceVariableResult.Error(message2);
            }
        }
        if (expr != null && expr.getParent() instanceof PsiExpressionStatement) {
            FeatureUsageTracker.getInstance().triggerFeatureUsed("refactoring.introduceVariable.incompleteStatement");
        }
        if (IntroduceVariableUtil.LOG.isDebugEnabled()) {
            IntroduceVariableUtil.LOG.debug("expression:" + String.valueOf(expr));
        }
        if (expr == null || !expr.isPhysical()) {
            if (ReassignVariableUtil.reassign(editor)) {
                return new IntroduceVariableResult.Error(null);
            }
            if (expr == null) {
                message2 = JavaRefactoringBundle.message((String)"selected.block.should.represent.an.expression", (Object[])new Object[0]);
                return new IntroduceVariableResult.Error(message2);
            }
        }
        if ((enumInSwitchError = RefactoringUtil.checkEnumConstantInSwitchLabel(expr)) != null) {
            return new IntroduceVariableResult.Error(enumInSwitchError);
        }
        DumbService dumbService = DumbService.getInstance((Project)project);
        PsiType originalType = (PsiType)dumbService.computeWithAlternativeResolveEnabled(() -> CommonJavaRefactoringUtil.getTypeByExpressionWithExpectedType((PsiExpression)expr));
        if (originalType == null || LambdaUtil.notInferredType((PsiType)originalType)) {
            message = JavaRefactoringBundle.message((String)"unknown.expression.type", (Object[])new Object[0]);
            return new IntroduceVariableResult.Error(message);
        }
        if (PsiTypes.voidType().equals((Object)originalType)) {
            message = JavaRefactoringBundle.message((String)"selected.expression.has.void.type", (Object[])new Object[0]);
            return new IntroduceVariableResult.Error(message);
        }
        try {
            String typeText = (String)DumbService.getInstance((Project)project).computeWithAlternativeResolveEnabled(() -> GenericsUtil.getVariableTypeByExpressionType((PsiType)originalType).getCanonicalText());
            JavaPsiFacade.getElementFactory((Project)project).createTypeElementFromText(typeText, (PsiElement)expr);
        }
        catch (IncorrectOperationException ignore) {
            String message3 = JavaRefactoringBundle.message((String)"unknown.expression.type", (Object[])new Object[0]);
            return new IntroduceVariableResult.Error(message3);
        }
        for (PsiPatternVariable variable : JavaPsiPatternUtil.getExposedPatternVariables((PsiExpression)expr)) {
            if (!ContainerUtil.exists((Iterable)VariableAccessUtils.getVariableReferences((PsiVariable)variable), ref -> !PsiTreeUtil.isAncestor((PsiElement)expr, (PsiElement)ref, (boolean)true))) continue;
            String message4 = JavaRefactoringBundle.message((String)"selected.expression.introduces.pattern.variable", (Object[])new Object[]{variable.getName()});
            return new IntroduceVariableResult.Error(message4);
        }
        PsiElement anchorStatement = IntroduceVariableBase.getAnchor((PsiElement)expr);
        ErrorOrContainer errorOrContainer2 = errorOrContainer = IntroduceVariableBase.getTempContainer(anchorStatement);
        Objects.requireNonNull(errorOrContainer2);
        ErrorOrContainer errorOrContainer3 = errorOrContainer2;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{ErrorOrContainer.Container.class, ErrorOrContainer.Error.class}, (Object)errorOrContainer3, n)) {
            default -> throw new MatchException(null, null);
            case 0 -> {
                boolean isInplaceAvailableOnDataContext;
                ErrorOrContainer.Container container = (ErrorOrContainer.Container)errorOrContainer3;
                PsiFile file = Objects.requireNonNull(anchorStatement).getContainingFile();
                IntroduceVariableUtil.LOG.assertTrue(file != null, (Object)"expr.getContainingFile() == null");
                PsiElement nameSuggestionContext = editor == null ? null : file.findElementAt(editor.getCaretModel().getOffset());
                RefactoringSupportProvider supportProvider = LanguageRefactoringSupport.getInstance().forContext((PsiElement)expr);
                boolean v1 = isInplaceAvailableOnDataContext = supportProvider != null && editor != null && editor.getSettings().isVariableInplaceRenameEnabled() && supportProvider.isInplaceIntroduceAvailable((PsiElement)expr, nameSuggestionContext) && !IntroduceVariableBase.isInJspHolderMethod(expr);
                if (isInplaceAvailableOnDataContext) {
                    MultiMap conflicts = new MultiMap();
                    IntroduceVariableBase.checkInLoopCondition(expr, (MultiMap<PsiElement, String>)conflicts);
                    if (!conflicts.isEmpty()) {
                        yield new IntroduceVariableResult.Error(StringUtil.join(new TreeSet(conflicts.values()), (String)"<br>"), false);
                    }
                }
                ExpressionOccurrenceManager occurrenceManager = IntroduceVariableBase.createOccurrenceManager(expr, container.element());
                PsiExpression[] occurrences = occurrenceManager.getOccurrences();
                OccurrencesInfo occurrencesInfo = new OccurrencesInfo(occurrences);
                yield new IntroduceVariableResult.Context(expr, originalType, anchorStatement, occurrenceManager, occurrencesInfo, isInplaceAvailableOnDataContext);
            }
            case 1 -> {
                ErrorOrContainer.Error error = (ErrorOrContainer.Error)errorOrContainer3;
                yield new IntroduceVariableResult.Error(error.message(), false);
            }
        };
    }

    @Nullable
    public static PsiElement getAnchor(PsiElement place) {
        PsiExpression initializer;
        PsiField field;
        PsiElement anchorStatement = CommonJavaRefactoringUtil.getParentStatement((PsiElement)(place = IntroduceVariableBase.getPhysicalElement(place)), (boolean)false);
        if (anchorStatement == null && (field = (PsiField)PsiTreeUtil.getParentOfType((PsiElement)place, PsiField.class, (boolean)true, (Class[])new Class[]{PsiStatement.class})) != null && !(field instanceof PsiEnumConstant) && PsiTreeUtil.isAncestor((PsiElement)(initializer = field.getInitializer()), (PsiElement)place, (boolean)false)) {
            anchorStatement = initializer;
        }
        return anchorStatement;
    }

    @Nullable
    static PsiElement getAnchor(PsiExpression[] places) {
        if (places.length == 1) {
            return IntroduceVariableBase.getAnchor((PsiElement)places[0]);
        }
        PsiElement anchor = CommonJavaRefactoringUtil.getAnchorElementForMultipleExpressions((PsiExpression[])places, null);
        return anchor instanceof PsiField && !(anchor instanceof PsiEnumConstant) ? ((PsiField)anchor).getInitializer() : anchor;
    }

    @NotNull
    private static PsiElement getPhysicalElement(PsiElement place) {
        PsiElement physicalElement = (PsiElement)place.getUserData(ElementToWorkOn.PARENT);
        PsiElement psiElement = physicalElement != null ? physicalElement : place;
        if (psiElement == null) {
            IntroduceVariableBase.$$$reportNull$$$0(10);
        }
        return psiElement;
    }

    @NotNull
    protected static ErrorOrContainer getTempContainer(@Nullable PsiElement anchorStatement) {
        if (anchorStatement == null) {
            return new ErrorOrContainer.Error(JavaRefactoringBundle.message((String)"refactoring.is.not.supported.in.the.current.context", (Object[])new Object[]{IntroduceVariableBase.getRefactoringName()}));
        }
        String anchorMessage = IntroduceVariableBase.getAnchorBeforeMessage(anchorStatement);
        if (anchorMessage != null) {
            return new ErrorOrContainer.Error(anchorMessage);
        }
        PsiElement tempContainer = anchorStatement.getParent();
        if (!(tempContainer instanceof PsiCodeBlock) && !CommonJavaRefactoringUtil.isLoopOrIf((PsiElement)tempContainer) && !(tempContainer instanceof PsiLambdaExpression) && tempContainer.getParent() instanceof PsiLambdaExpression) {
            return new ErrorOrContainer.Error(JavaRefactoringBundle.message((String)"refactoring.is.not.supported.in.the.current.context", (Object[])new Object[]{IntroduceVariableBase.getRefactoringName()}));
        }
        return new ErrorOrContainer.Container(tempContainer);
    }

    private static ExpressionOccurrenceManager createOccurrenceManager(PsiExpression expr, @Nullable PsiElement tempContainer) {
        PsiClass containingClass;
        HashSet vars = new HashSet();
        ((SyntaxTraverser)((SyntaxTraverser)SyntaxTraverser.psiTraverser().withRoot((Object)expr)).filter(element -> element instanceof PsiReferenceExpression)).forEach(element -> {
            PsiElement resolve = ((PsiReferenceExpression)element).resolve();
            if (resolve instanceof PsiVariable) {
                vars.add((PsiVariable)resolve);
            }
        });
        PsiElement containerParent = tempContainer;
        PsiElement lastScope = tempContainer;
        while (!(containerParent instanceof PsiFile) && (!(containerParent instanceof PsiMethod) || (containingClass = ((PsiMethod)containerParent).getContainingClass()) != null && PsiUtil.isLocalOrAnonymousClass((PsiClass)containingClass) && !ContainerUtil.exists(vars, variable -> PsiTreeUtil.isAncestor((PsiElement)containingClass, (PsiElement)variable, (boolean)true)))) {
            PsiForStatement forStatement;
            if (containerParent instanceof PsiLambdaExpression) {
                Object[] parameters = ((PsiLambdaExpression)containerParent).getParameterList().getParameters();
                if (ContainerUtil.exists((Object[])parameters, vars::contains)) break;
            }
            if (containerParent instanceof PsiForStatement && ContainerUtil.exists(vars, arg_0 -> IntroduceVariableBase.lambda$createOccurrenceManager$11(forStatement = (PsiForStatement)containerParent, arg_0))) break;
            if (!((containerParent = containerParent.getParent()) instanceof PsiCodeBlock)) continue;
            lastScope = containerParent;
        }
        return new ExpressionOccurrenceManager(expr, lastScope, NotInConstructorCallFilter.INSTANCE);
    }

    private static boolean isInJspHolderMethod(PsiExpression expr) {
        PsiElement parent1 = expr.getParent();
        if (parent1 == null) {
            return false;
        }
        PsiElement parent2 = parent1.getParent();
        if (!(parent2 instanceof JspCodeBlock)) {
            return false;
        }
        PsiElement parent3 = parent2.getParent();
        return parent3 instanceof JspHolderMethod;
    }

    static boolean isFinalVariableOnLHS(PsiExpression expr) {
        PsiElement resolve;
        return expr instanceof PsiReferenceExpression && RefactoringUtil.isAssignmentLHS((PsiElement)expr) && (resolve = ((PsiReferenceExpression)expr).resolve()) instanceof PsiVariable && ((PsiVariable)resolve).hasModifierProperty("final");
    }

    public static PsiExpression simplifyVariableInitializer(PsiExpression initializer, PsiType expectedType) {
        return IntroduceVariableBase.simplifyVariableInitializer(initializer, expectedType, true);
    }

    public static PsiExpression simplifyVariableInitializer(PsiExpression initializer, PsiType expectedType, boolean inDeclaration) {
        if (initializer instanceof PsiTypeCastExpression) {
            PsiType operandType;
            PsiExpression operand = ((PsiTypeCastExpression)initializer).getOperand();
            if (operand != null && (operandType = operand.getType()) != null && TypeConversionUtil.isAssignable((PsiType)expectedType, (PsiType)operandType)) {
                return operand;
            }
        } else if (initializer instanceof PsiNewExpression) {
            PsiNewExpression newExpression = (PsiNewExpression)initializer;
            if (newExpression.getArrayInitializer() != null) {
                if (inDeclaration) {
                    return newExpression.getArrayInitializer();
                }
            } else {
                PsiExpression tryToDetectDiamondNewExpr;
                PsiJavaCodeReferenceElement ref = newExpression.getClassOrAnonymousClassReference();
                if (ref != null && (tryToDetectDiamondNewExpr = ((PsiVariable)JavaPsiFacade.getElementFactory((Project)initializer.getProject()).createVariableDeclarationStatement("x", expectedType, initializer, (PsiElement)initializer).getDeclaredElements()[0]).getInitializer()) instanceof PsiNewExpression && PsiDiamondTypeUtil.canCollapseToDiamond((PsiNewExpression)((PsiNewExpression)tryToDetectDiamondNewExpr), (PsiNewExpression)((PsiNewExpression)tryToDetectDiamondNewExpr), (PsiType)expectedType)) {
                    PsiElement paramList = RemoveRedundantTypeArgumentsUtil.replaceExplicitWithDiamond((PsiElement)ref.getParameterList());
                    return (PsiExpression)PsiTreeUtil.getParentOfType((PsiElement)paramList, PsiNewExpression.class);
                }
            }
        }
        return initializer;
    }

    @Override
    protected boolean invokeImpl(Project project, PsiLocalVariable localVariable, Editor editor) {
        throw new UnsupportedOperationException();
    }

    protected static void highlightReplacedOccurrences(Project project, Editor editor, PsiElement[] replacedOccurrences) {
        if (editor == null) {
            return;
        }
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            return;
        }
        HighlightManager highlightManager = HighlightManager.getInstance((Project)project);
        highlightManager.addOccurrenceHighlights(editor, replacedOccurrences, EditorColors.SEARCH_RESULT_ATTRIBUTES, true, null);
        WindowManager.getInstance().getStatusBar(project).setInfo(RefactoringBundle.message((String)"press.escape.to.remove.the.highlighting"));
    }

    protected abstract void showErrorMessage(@NotNull Project var1, @Nullable Editor var2, @NotNull String var3);

    protected boolean reportConflicts(MultiMap<PsiElement, String> conflicts, Project project, IntroduceVariableSettings settings) {
        return false;
    }

    public IntroduceVariableSettings getSettings(Project project, Editor editor, PsiExpression expr, PsiExpression[] occurrences, final TypeSelectorManagerImpl typeSelectorManager, boolean declareFinalIfAll, boolean anyAssignmentLHS, InputValidator validator, PsiElement anchor, final JavaReplaceChoice replaceChoice) {
        final boolean replaceAll = replaceChoice.isAll();
        SuggestedNameInfo suggestedName = CommonJavaRefactoringUtil.getSuggestedName((PsiType)typeSelectorManager.getDefaultType(), (PsiExpression)expr, (PsiElement)anchor);
        final String variableName = suggestedName.names.length > 0 ? suggestedName.names[0] : "v";
        final boolean declareFinal = replaceAll && declareFinalIfAll || !anyAssignmentLHS && IntroduceVariableBase.createFinals(anchor.getContainingFile()) || anchor instanceof PsiSwitchLabelStatementBase;
        final boolean declareVarType = IntroduceVariableBase.canBeExtractedWithoutExplicitType(expr) && IntroduceVariableBase.createVarType() && !replaceChoice.isChain();
        final boolean replaceWrite = anyAssignmentLHS && replaceAll;
        return new IntroduceVariableSettings(){

            @Override
            @NlsSafe
            public String getEnteredName() {
                return variableName;
            }

            @Override
            public boolean isReplaceAllOccurrences() {
                return replaceAll;
            }

            @Override
            public boolean isDeclareFinal() {
                return declareFinal;
            }

            @Override
            public boolean isDeclareVarType() {
                return declareVarType;
            }

            @Override
            public boolean isReplaceLValues() {
                return replaceWrite;
            }

            @Override
            public PsiType getSelectedType() {
                PsiType selectedType = typeSelectorManager.getTypeSelector().getSelectedType();
                return selectedType != null ? selectedType : typeSelectorManager.getDefaultType();
            }

            @Override
            public JavaReplaceChoice getReplaceChoice() {
                return replaceChoice;
            }

            @Override
            public boolean isOK() {
                return true;
            }
        };
    }

    public static boolean createFinals(@NotNull PsiFile file) {
        Boolean createFinals;
        if (file == null) {
            IntroduceVariableBase.$$$reportNull$$$0(11);
        }
        return (createFinals = JavaRefactoringSettings.getInstance().INTRODUCE_LOCAL_CREATE_FINALS) == null ? JavaCodeStyleSettings.getInstance((PsiFile)file).GENERATE_FINAL_LOCALS : createFinals;
    }

    public static boolean createVarType() {
        Boolean createVarType = JavaRefactoringSettings.getInstance().INTRODUCE_LOCAL_CREATE_VAR_TYPE;
        return createVarType != null && createVarType != false;
    }

    @NlsContexts.DialogMessage
    @Nullable
    private static String getAnchorBeforeMessage(PsiElement tempAnchorElement) {
        PsiMethod method;
        PsiExpression enclosingExpr;
        if (PsiUtil.isAvailable((JavaFeature)JavaFeature.STATEMENTS_BEFORE_SUPER, (PsiElement)tempAnchorElement)) {
            return null;
        }
        if (tempAnchorElement instanceof PsiExpressionStatement && (enclosingExpr = ((PsiExpressionStatement)tempAnchorElement).getExpression()) instanceof PsiMethodCallExpression && (method = ((PsiMethodCallExpression)enclosingExpr).resolveMethod()) != null && method.isConstructor()) {
            String message = JavaRefactoringBundle.message((String)"invalid.expression.context", (Object[])new Object[0]);
            return message;
        }
        return null;
    }

    public static void checkInLoopCondition(PsiExpression occurence, MultiMap<PsiElement, String> conflicts) {
        PsiElement loopForLoopCondition = RefactoringUtil.getLoopForLoopCondition(occurence);
        if (loopForLoopCondition == null || loopForLoopCondition instanceof PsiWhileStatement) {
            return;
        }
        List<PsiVariable> referencedVariables = RefactoringUtil.collectReferencedVariables((PsiElement)occurence);
        ArrayList<PsiVariable> modifiedInBody = new ArrayList<PsiVariable>();
        for (PsiVariable psiVariable : referencedVariables) {
            if (!RefactoringUtil.isModifiedInScope(psiVariable, loopForLoopCondition)) continue;
            modifiedInBody.add(psiVariable);
        }
        if (!modifiedInBody.isEmpty()) {
            for (PsiVariable variable : modifiedInBody) {
                String message = JavaRefactoringBundle.message((String)"is.modified.in.loop.body", (Object[])new Object[]{RefactoringUIUtil.getDescription((PsiElement)variable, (boolean)false)});
                conflicts.putValue((Object)variable, (Object)StringUtil.capitalize((String)message));
            }
            conflicts.putValue((Object)occurence, (Object)JavaRefactoringBundle.message((String)"introducing.variable.may.break.code.logic", (Object[])new Object[0]));
        }
    }

    public AbstractInplaceIntroducer getInplaceIntroducer() {
        return this.myInplaceIntroducer;
    }

    @NlsContexts.Command
    protected static String getRefactoringName() {
        return RefactoringBundle.message((String)"introduce.variable.title");
    }

    private static /* synthetic */ boolean lambda$createOccurrenceManager$11(PsiForStatement forStatement, PsiVariable variable) {
        return PsiTreeUtil.isAncestor((PsiElement)forStatement.getInitialization(), (PsiElement)variable, (boolean)true);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 5, 10 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 3: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 4: 
            case 5: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/refactoring/introduceVariable/IntroduceVariableBase";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "occurrencesMap";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "replaceChoice";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/refactoring/introduceVariable/IntroduceVariableBase";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getPossibleAnchorsAndOccurrences";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getPossibleReplaceChoices";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getPhysicalElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getExpressionsAndSelectionRange";
                break;
            }
            case 4: 
            case 5: 
            case 10: {
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "findChoice";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "doRefactoring";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getIntroduceVariableContext";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "createFinals";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4, 5, 10 -> new IllegalStateException(string);
        };
    }

    public static class OccurrencesInfo {
        List<PsiExpression> myOccurrences;
        List<PsiExpression> myNonWrite;
        boolean myCantReplaceAll;
        boolean myCantReplaceAllButWrite;
        boolean myHasWriteAccess;
        final String myChainMethodName;

        public OccurrencesInfo(PsiExpression[] occurrences) {
            this(occurrences, true);
        }

        public OccurrencesInfo(PsiExpression[] occurrences, boolean chainCallPossible) {
            this.myOccurrences = Arrays.asList(occurrences);
            this.myNonWrite = new ArrayList<PsiExpression>();
            this.myCantReplaceAll = false;
            this.myCantReplaceAllButWrite = false;
            for (PsiExpression occurrence : this.myOccurrences) {
                if (!RefactoringUtil.isAssignmentLHS((PsiElement)occurrence)) {
                    this.myNonWrite.add(occurrence);
                    continue;
                }
                if (IntroduceVariableBase.isFinalVariableOnLHS(occurrence)) {
                    this.myCantReplaceAll = true;
                    continue;
                }
                if (this.myNonWrite.isEmpty()) continue;
                this.myCantReplaceAllButWrite = true;
                this.myCantReplaceAll = true;
            }
            this.myHasWriteAccess = this.myOccurrences.size() > this.myNonWrite.size() && this.myOccurrences.size() > 1;
            this.myChainMethodName = chainCallPossible ? this.getChainCallExtractor() : null;
        }

        private String getChainCallExtractor() {
            if (this.myHasWriteAccess || this.myOccurrences.isEmpty()) {
                return null;
            }
            PsiExpression expression = this.myOccurrences.getFirst();
            if (this.myOccurrences.size() == 1 && expression.getParent() instanceof PsiLambdaExpression) {
                return null;
            }
            PsiElement parent = PsiTreeUtil.findCommonParent(this.myOccurrences);
            if (parent == null) {
                return null;
            }
            PsiType type = expression.getType();
            PsiLambdaExpression lambda = (PsiLambdaExpression)PsiTreeUtil.getParentOfType((PsiElement)parent, PsiLambdaExpression.class, (boolean)true, (Class[])new Class[]{PsiStatement.class});
            ChainCallExtractor extractor = (ChainCallExtractor)DumbService.getInstance((Project)expression.getProject()).computeWithAlternativeResolveEnabled(() -> ChainCallExtractor.findExtractor((PsiLambdaExpression)lambda, (PsiExpression)expression, (PsiType)type));
            if (extractor == null) {
                return null;
            }
            PsiParameter parameter = lambda.getParameterList().getParameters()[0];
            if (!ReferencesSearch.search((PsiElement)parameter).forEach(ref -> ContainerUtil.exists(this.myOccurrences, expr -> PsiTreeUtil.isAncestor((PsiElement)expr, (PsiElement)ref.getElement(), (boolean)false)))) {
                return null;
            }
            return extractor.getMethodName((PsiVariable)parameter, expression, type);
        }

        @NotNull
        public LinkedHashMap<JavaReplaceChoice, List<PsiExpression>> buildOccurrencesMap(PsiExpression expr) {
            LinkedHashMap<JavaReplaceChoice, List<PsiExpression>> occurrencesMap = new LinkedHashMap<JavaReplaceChoice, List<PsiExpression>>();
            if (this.myChainMethodName != null) {
                if (this.myOccurrences.size() > 1 && !this.myCantReplaceAll) {
                    occurrencesMap.put(JavaReplaceChoice.NO, Collections.singletonList(expr));
                    occurrencesMap.put(JavaReplaceChoice.ALL, this.myOccurrences);
                    occurrencesMap.put(new JavaReplaceChoice(OccurrencesChooser.ReplaceChoice.ALL, null, true){

                        @Override
                        public String formatDescription(int occurrencesCount) {
                            return JavaRefactoringBundle.message((String)"replace.all.and.extract", (Object[])new Object[]{occurrencesCount, myChainMethodName});
                        }
                    }, this.myOccurrences);
                } else {
                    JavaReplaceChoice noChain = new JavaReplaceChoice(OccurrencesChooser.ReplaceChoice.NO, JavaRefactoringBundle.message((String)"replace.inside.current.lambda", (Object[])new Object[0]), false);
                    JavaReplaceChoice chain = new JavaReplaceChoice(OccurrencesChooser.ReplaceChoice.NO, JavaRefactoringBundle.message((String)"replace.as.separate.operation", (Object[])new Object[]{this.myChainMethodName}), true);
                    occurrencesMap.put(noChain, Collections.singletonList(expr));
                    occurrencesMap.put(chain, Collections.singletonList(expr));
                }
            } else {
                boolean hasWrite;
                occurrencesMap.put(JavaReplaceChoice.NO, Collections.singletonList(expr));
                boolean bl = hasWrite = this.myHasWriteAccess && !this.myCantReplaceAllButWrite;
                if (hasWrite && this.myNonWrite.contains(expr)) {
                    occurrencesMap.put(JavaReplaceChoice.NO_WRITE, this.myNonWrite);
                }
                if (this.myOccurrences.size() > 1 && !this.myCantReplaceAll) {
                    if (hasWrite) {
                        JavaReplaceChoice choice = new JavaReplaceChoice(OccurrencesChooser.ReplaceChoice.ALL, this.myNonWrite.isEmpty() ? JavaRefactoringBundle.message((String)"replace.all.occurrences.changes.semantics", (Object[])new Object[]{this.myOccurrences.size()}) : JavaRefactoringBundle.message((String)"replace.all.read.and.write", (Object[])new Object[0]), false);
                        occurrencesMap.put(choice, this.myOccurrences);
                    } else {
                        this.generateScopeBasedChoices(expr, occurrencesMap);
                        occurrencesMap.put(JavaReplaceChoice.ALL, this.myOccurrences);
                    }
                }
            }
            LinkedHashMap<JavaReplaceChoice, List<PsiExpression>> linkedHashMap = occurrencesMap;
            if (linkedHashMap == null) {
                OccurrencesInfo.$$$reportNull$$$0(0);
            }
            return linkedHashMap;
        }

        private void generateScopeBasedChoices(PsiExpression expr, LinkedHashMap<JavaReplaceChoice, List<PsiExpression>> occurrencesMap) {
            Comparator treeOrder = (e1, e2) -> {
                if (PsiTreeUtil.isAncestor((PsiElement)e1, (PsiElement)e2, (boolean)true)) {
                    return 1;
                }
                if (PsiTreeUtil.isAncestor((PsiElement)e2, (PsiElement)e1, (boolean)true)) {
                    return -1;
                }
                return 0;
            };
            PsiElement physical = IntroduceVariableBase.getPhysicalElement((PsiElement)expr);
            TreeMap groupByBlock = (TreeMap)StreamEx.of(this.myOccurrences).map(place -> (PsiExpression)IntroduceVariableBase.getPhysicalElement((PsiElement)place)).groupingBy(e -> PsiTreeUtil.findCommonParent((PsiElement)e, (PsiElement)physical), () -> new TreeMap(treeOrder), Collectors.toList());
            IntroduceVariableUtil.LOG.assertTrue(!groupByBlock.isEmpty());
            ArrayList currentOccurrences = new ArrayList();
            HashMap counts = new HashMap();
            groupByBlock.forEach((parent, occurrences) -> {
                int sameKeywordCount;
                PsiElement nextParent = groupByBlock.higherKey(parent);
                if (nextParent == null) {
                    return;
                }
                currentOccurrences.addAll(occurrences);
                if (currentOccurrences.size() == 1) {
                    return;
                }
                String keyword = null;
                for (PsiElement current = parent.getParent(); current != nextParent; current = current.getParent()) {
                    if (current instanceof PsiIfStatement || current instanceof PsiWhileStatement || current instanceof PsiForStatement || current instanceof PsiTryStatement) {
                        keyword = current.getFirstChild().getText();
                    } else if (current instanceof PsiDoWhileStatement) {
                        keyword = "do-while";
                    } else if (current instanceof PsiForeachStatement) {
                        keyword = "for-each";
                    } else if (current instanceof PsiLambdaExpression) {
                        keyword = "lambda";
                    }
                    if (keyword != null) break;
                }
                if (keyword == null && nextParent instanceof PsiIfStatement) {
                    PsiStatement thenBranch = ((PsiIfStatement)nextParent).getThenBranch();
                    PsiStatement elseBranch = ((PsiIfStatement)nextParent).getElseBranch();
                    if (PsiTreeUtil.isAncestor((PsiElement)thenBranch, (PsiElement)parent, (boolean)false)) {
                        keyword = "if-then";
                    } else if (PsiTreeUtil.isAncestor((PsiElement)elseBranch, (PsiElement)parent, (boolean)false)) {
                        keyword = "else";
                    }
                }
                if (keyword != null && (sameKeywordCount = counts.merge(keyword, 1, Integer::sum).intValue()) <= 2) {
                    JavaReplaceChoice choice = JavaReplaceChoice.allOccurrencesInside(parent, sameKeywordCount, keyword);
                    occurrencesMap.put(choice, new ArrayList(currentOccurrences));
                }
            });
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/refactoring/introduceVariable/IntroduceVariableBase$OccurrencesInfo", "buildOccurrencesMap"));
        }
    }

    protected static sealed interface ErrorOrContainer {

        public record Error(@NlsContexts.DialogMessage @NotNull String message) implements ErrorOrContainer
        {
            private final @NlsContexts.DialogMessage @NotNull String message;

            public Error(@NlsContexts.DialogMessage @NotNull String message) {
                if (message == null) {
                    Error.$$$reportNull$$$0(0);
                }
            }

            @NlsContexts.DialogMessage
            @NotNull
            public String message() {
                String string = this.message;
                if (string == null) {
                    Error.$$$reportNull$$$0(1);
                }
                return string;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 3;
                    case 1 -> 2;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "message";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/refactoring/introduceVariable/IntroduceVariableBase$ErrorOrContainer$Error";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/refactoring/introduceVariable/IntroduceVariableBase$ErrorOrContainer$Error";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "message";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "<init>";
                        break;
                    }
                    case 1: {
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalArgumentException(string);
                    case 1 -> new IllegalStateException(string);
                };
            }
        }

        public record Container(@NotNull PsiElement element) implements ErrorOrContainer
        {
            @NotNull
            private final PsiElement element;

            public Container(@NotNull PsiElement element) {
                if (element == null) {
                    Container.$$$reportNull$$$0(0);
                }
            }

            @NotNull
            public PsiElement element() {
                PsiElement psiElement = this.element;
                if (psiElement == null) {
                    Container.$$$reportNull$$$0(1);
                }
                return psiElement;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 3;
                    case 1 -> 2;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "element";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/refactoring/introduceVariable/IntroduceVariableBase$ErrorOrContainer$Container";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/refactoring/introduceVariable/IntroduceVariableBase$ErrorOrContainer$Container";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "element";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "<init>";
                        break;
                    }
                    case 1: {
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalArgumentException(string);
                    case 1 -> new IllegalStateException(string);
                };
            }
        }
    }

    public static class JavaReplaceChoice
    implements OccurrencesChooser.BaseReplaceChoice {
        public static final JavaReplaceChoice NO = new JavaReplaceChoice(OccurrencesChooser.ReplaceChoice.NO, null, false);
        public static final JavaReplaceChoice NO_WRITE = new JavaReplaceChoice(OccurrencesChooser.ReplaceChoice.NO_WRITE, null, false);
        public static final JavaReplaceChoice ALL = new JavaReplaceChoice(OccurrencesChooser.ReplaceChoice.ALL, null, false);
        @Nls
        private final String myDescription;
        private final boolean myChain;
        private final OccurrencesChooser.ReplaceChoice myChoice;

        JavaReplaceChoice(@NotNull OccurrencesChooser.ReplaceChoice choice, @Nullable @Nls String description, boolean chain) {
            if (choice == null) {
                JavaReplaceChoice.$$$reportNull$$$0(0);
            }
            this.myChoice = choice;
            this.myDescription = description;
            this.myChain = chain;
        }

        public boolean isAll() {
            return this.myChoice.isAll();
        }

        public boolean isChain() {
            return this.myChain;
        }

        public PsiExpression[] filter(ExpressionOccurrenceManager manager) {
            PsiExpression[] psiExpressionArray;
            switch (this.myChoice) {
                default: {
                    throw new MatchException(null, null);
                }
                case NO: {
                    PsiExpression[] psiExpressionArray2 = new PsiExpression[1];
                    psiExpressionArray = psiExpressionArray2;
                    psiExpressionArray2[0] = manager.getMainOccurence();
                    break;
                }
                case NO_WRITE: {
                    psiExpressionArray = (PsiExpression[])((StreamEx)StreamEx.of((Object[])manager.getOccurrences()).filter(expr -> !PsiUtil.isAccessedForWriting((PsiExpression)expr))).toArray((Object[])PsiExpression.EMPTY_ARRAY);
                    break;
                }
                case ALL: {
                    psiExpressionArray = manager.getOccurrences();
                }
            }
            return psiExpressionArray;
        }

        public String formatDescription(int occurrencesCount) {
            return this.myDescription == null ? this.myChoice.formatDescription(occurrencesCount) : this.myDescription;
        }

        public String toString() {
            return this.formatDescription(0);
        }

        @NotNull
        private static JavaReplaceChoice allOccurrencesInside(final PsiElement parent, final int sameKeywordCount, final String finalKeyword) {
            return new JavaReplaceChoice(OccurrencesChooser.ReplaceChoice.ALL, null, false){

                @Override
                public PsiExpression[] filter(ExpressionOccurrenceManager manager) {
                    return (PsiExpression[])((StreamEx)StreamEx.of((Object[])manager.getOccurrences()).filter(expr -> PsiTreeUtil.isAncestor((PsiElement)parent, (PsiElement)IntroduceVariableBase.getPhysicalElement((PsiElement)expr), (boolean)true))).toArray((Object[])PsiExpression.EMPTY_ARRAY);
                }

                @Override
                public String formatDescription(int occurrencesCount) {
                    return JavaRefactoringBundle.message((String)"replace.occurrences.inside.statement", (Object[])new Object[]{occurrencesCount, finalKeyword, sameKeywordCount});
                }
            };
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "choice", "com/intellij/refactoring/introduceVariable/IntroduceVariableBase$JavaReplaceChoice", "<init>"));
        }
    }

    public static sealed interface IntroduceVariableResult {

        public record Context(@NotNull PsiExpression expression, @NotNull PsiType originalType, @NotNull PsiElement anchorStatement, @NotNull ExpressionOccurrenceManager occurrenceManager, @NotNull OccurrencesInfo occurrencesInfo, boolean isInplaceAvailableOnDataContext) implements IntroduceVariableResult
        {
            @NotNull
            private final PsiExpression expression;
            @NotNull
            private final PsiType originalType;
            @NotNull
            private final PsiElement anchorStatement;
            @NotNull
            private final ExpressionOccurrenceManager occurrenceManager;
            @NotNull
            private final OccurrencesInfo occurrencesInfo;

            public Context(@NotNull PsiExpression expression, @NotNull PsiType originalType, @NotNull PsiElement anchorStatement, @NotNull ExpressionOccurrenceManager occurrenceManager, @NotNull OccurrencesInfo occurrencesInfo, boolean isInplaceAvailableOnDataContext) {
                if (expression == null) {
                    Context.$$$reportNull$$$0(0);
                }
                if (originalType == null) {
                    Context.$$$reportNull$$$0(1);
                }
                if (anchorStatement == null) {
                    Context.$$$reportNull$$$0(2);
                }
                if (occurrenceManager == null) {
                    Context.$$$reportNull$$$0(3);
                }
                if (occurrencesInfo == null) {
                    Context.$$$reportNull$$$0(4);
                }
            }

            PsiFile file() {
                return this.anchorStatement.getContainingFile();
            }

            @NotNull
            public PsiExpression expression() {
                PsiExpression psiExpression = this.expression;
                if (psiExpression == null) {
                    Context.$$$reportNull$$$0(5);
                }
                return psiExpression;
            }

            @NotNull
            public PsiType originalType() {
                PsiType psiType = this.originalType;
                if (psiType == null) {
                    Context.$$$reportNull$$$0(6);
                }
                return psiType;
            }

            @NotNull
            public PsiElement anchorStatement() {
                PsiElement psiElement = this.anchorStatement;
                if (psiElement == null) {
                    Context.$$$reportNull$$$0(7);
                }
                return psiElement;
            }

            @NotNull
            public ExpressionOccurrenceManager occurrenceManager() {
                ExpressionOccurrenceManager expressionOccurrenceManager = this.occurrenceManager;
                if (expressionOccurrenceManager == null) {
                    Context.$$$reportNull$$$0(8);
                }
                return expressionOccurrenceManager;
            }

            @NotNull
            public OccurrencesInfo occurrencesInfo() {
                OccurrencesInfo occurrencesInfo = this.occurrencesInfo;
                if (occurrencesInfo == null) {
                    Context.$$$reportNull$$$0(9);
                }
                return occurrencesInfo;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 3;
                    case 5, 6, 7, 8, 9 -> 2;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "expression";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "originalType";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "anchorStatement";
                        break;
                    }
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "occurrenceManager";
                        break;
                    }
                    case 4: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "occurrencesInfo";
                        break;
                    }
                    case 5: 
                    case 6: 
                    case 7: 
                    case 8: 
                    case 9: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/refactoring/introduceVariable/IntroduceVariableBase$IntroduceVariableResult$Context";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/refactoring/introduceVariable/IntroduceVariableBase$IntroduceVariableResult$Context";
                        break;
                    }
                    case 5: {
                        objectArray = objectArray2;
                        objectArray2[1] = "expression";
                        break;
                    }
                    case 6: {
                        objectArray = objectArray2;
                        objectArray2[1] = "originalType";
                        break;
                    }
                    case 7: {
                        objectArray = objectArray2;
                        objectArray2[1] = "anchorStatement";
                        break;
                    }
                    case 8: {
                        objectArray = objectArray2;
                        objectArray2[1] = "occurrenceManager";
                        break;
                    }
                    case 9: {
                        objectArray = objectArray2;
                        objectArray2[1] = "occurrencesInfo";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "<init>";
                        break;
                    }
                    case 5: 
                    case 6: 
                    case 7: 
                    case 8: 
                    case 9: {
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalArgumentException(string);
                    case 5, 6, 7, 8, 9 -> new IllegalStateException(string);
                };
            }
        }

        public static final class Error
        implements IntroduceVariableResult {
            public final @NlsContexts.DialogMessage @Nullable String message;

            Error(@NlsContexts.DialogMessage @Nullable String message) {
                this(message, true);
            }

            Error(@NlsContexts.DialogMessage @Nullable String message, boolean shouldWrap) {
                this.message = message == null ? null : (shouldWrap ? RefactoringBundle.getCannotRefactorMessage((String)message) : message);
            }
        }
    }

    private class IntroduceVariablePass
    implements Consumer<JavaReplaceChoice> {
        boolean wasSucceed;
        @NotNull
        private final IntroduceVariableResult.Context context;
        @NotNull
        private final Project project;
        @NotNull
        private final Editor editor;
        @Nullable
        private final PsiElement targetContainer;

        private IntroduceVariablePass(@NotNull Project project, @NotNull IntroduceVariableResult.Context context, @Nullable Editor editor, PsiElement container) {
            if (project == null) {
                IntroduceVariablePass.$$$reportNull$$$0(0);
            }
            if (context == null) {
                IntroduceVariablePass.$$$reportNull$$$0(1);
            }
            if (editor == null) {
                IntroduceVariablePass.$$$reportNull$$$0(2);
            }
            this.wasSucceed = true;
            this.context = context;
            this.project = project;
            this.editor = editor;
            this.targetContainer = container;
        }

        @Override
        public void accept(JavaReplaceChoice choice) {
            Consumer<JavaReplaceChoice> dialogIntroduce = c -> CommandProcessor.getInstance().executeCommand(this.project, () -> this.introduce((JavaReplaceChoice)c), IntroduceVariableBase.getRefactoringName(), null);
            if (choice == null) {
                dialogIntroduce.accept(null);
            } else {
                DumbService.getInstance((Project)this.project).runWithAlternativeResolveEnabled(() -> this.inplaceIntroduce(this.project, this.editor, choice, this.targetContainer, this.context.occurrenceManager, this.context.originalType, dialogIntroduce));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void introduce(@Nullable JavaReplaceChoice choice) {
            PsiElement chosenAnchor;
            Object[] selectedOccurrences;
            IntroduceVariableSettings settings;
            PsiVariable variable;
            Editor topLevelEditor;
            block8: {
                block7: {
                    block6: {
                        if (!this.context.anchorStatement.isValid()) {
                            return;
                        }
                        topLevelEditor = !InjectedLanguageManager.getInstance((Project)this.project).isInjectedFragment(this.context.file()) ? InjectedLanguageUtil.getTopLevelEditor((Editor)this.editor) : this.editor;
                        variable = null;
                        try {
                            boolean hasWriteAccess = this.context.occurrencesInfo.myHasWriteAccess;
                            InputValidator validator = new InputValidator(IntroduceVariableBase.this, this.project, this.context.occurrenceManager);
                            TypeSelectorManagerImpl typeSelectorManager = new TypeSelectorManagerImpl(this.project, this.context.originalType, this.context.expression, this.context.occurrenceManager.getOccurrences());
                            boolean inFinalContext = this.context.occurrenceManager.isInFinalContext();
                            settings = IntroduceVariableBase.this.getSettings(this.project, topLevelEditor, this.context.expression, this.context.occurrenceManager.getOccurrences(), typeSelectorManager, inFinalContext, hasWriteAccess, validator, this.context.anchorStatement, choice);
                            if (settings.isOK()) break block6;
                            this.wasSucceed = false;
                        }
                        catch (Throwable throwable) {
                            RefactoringEventData afterData = new RefactoringEventData();
                            afterData.addElement(variable);
                            ((RefactoringEventListener)this.project.getMessageBus().syncPublisher(RefactoringEventListener.REFACTORING_EVENT_TOPIC)).refactoringDone(IntroduceVariableBase.REFACTORING_ID, afterData);
                            throw throwable;
                        }
                        RefactoringEventData afterData = new RefactoringEventData();
                        afterData.addElement(variable);
                        ((RefactoringEventListener)this.project.getMessageBus().syncPublisher(RefactoringEventListener.REFACTORING_EVENT_TOPIC)).refactoringDone(IntroduceVariableBase.REFACTORING_ID, afterData);
                        return;
                    }
                    JavaReplaceChoice finalChoice = settings.getReplaceChoice();
                    selectedOccurrences = finalChoice.filter(this.context.occurrenceManager);
                    if (selectedOccurrences.length != 0) break block7;
                    IntroduceVariableBase.this.showErrorMessage(this.project, this.editor, JavaRefactoringBundle.message((String)"introduce.variable.no.matching.occurrences", (Object[])new Object[0]));
                    this.wasSucceed = false;
                    RefactoringEventData afterData = new RefactoringEventData();
                    afterData.addElement(variable);
                    ((RefactoringEventListener)this.project.getMessageBus().syncPublisher(RefactoringEventListener.REFACTORING_EVENT_TOPIC)).refactoringDone(IntroduceVariableBase.REFACTORING_ID, afterData);
                    return;
                }
                chosenAnchor = IntroduceVariableBase.getAnchor((PsiExpression[])selectedOccurrences);
                if (chosenAnchor != null) break block8;
                String text = this.context.file().getText();
                String textWithOccurrences = ((EntryStream)StreamEx.of((Object[])selectedOccurrences).map(e -> IntroduceVariableBase.getPhysicalElement((PsiElement)e).getTextRange()).flatMapToEntry(range -> EntryStream.of((Object)range.getStartOffset(), (Object)"[", (Object)range.getEndOffset(), (Object)"]").toMap()).sortedBy(Map.Entry::getKey)).prepend((Object)0, (Object)"").append((Object)text.length(), (Object)"").map(Function.identity()).pairMap((prev, next) -> text.substring((Integer)prev.getKey(), (Integer)next.getKey()) + (String)next.getValue()).joining();
                IntroduceVariableUtil.LOG.error("Unable to find anchor for a new variable; selectedOccurrences.length = " + selectedOccurrences.length, new Attachment[]{new Attachment("source.java", textWithOccurrences)});
                RefactoringEventData afterData = new RefactoringEventData();
                afterData.addElement((PsiElement)variable);
                ((RefactoringEventListener)this.project.getMessageBus().syncPublisher(RefactoringEventListener.REFACTORING_EVENT_TOPIC)).refactoringDone(IntroduceVariableBase.REFACTORING_ID, afterData);
                return;
            }
            RefactoringEventData beforeData = new RefactoringEventData();
            beforeData.addElement((PsiElement)this.context.expression);
            ((RefactoringEventListener)this.project.getMessageBus().syncPublisher(RefactoringEventListener.REFACTORING_EVENT_TOPIC)).refactoringStarted(IntroduceVariableBase.REFACTORING_ID, beforeData);
            variable = VariableExtractor.introduce(this.project, this.context.expression, topLevelEditor, chosenAnchor, (PsiExpression[])selectedOccurrences, settings);
            RefactoringEventData afterData = new RefactoringEventData();
            afterData.addElement((PsiElement)variable);
            ((RefactoringEventListener)this.project.getMessageBus().syncPublisher(RefactoringEventListener.REFACTORING_EVENT_TOPIC)).refactoringDone(IntroduceVariableBase.REFACTORING_ID, afterData);
        }

        private void inplaceIntroduce(@NotNull Project project, Editor editor, @NotNull JavaReplaceChoice choice, @Nullable PsiElement targetContainer, @NotNull ExpressionOccurrenceManager occurrenceManager, @NotNull PsiType originalType, @NotNull Consumer<? super JavaReplaceChoice> dialogIntroduce) {
            if (project == null) {
                IntroduceVariablePass.$$$reportNull$$$0(3);
            }
            if (choice == null) {
                IntroduceVariablePass.$$$reportNull$$$0(4);
            }
            if (occurrenceManager == null) {
                IntroduceVariablePass.$$$reportNull$$$0(5);
            }
            if (originalType == null) {
                IntroduceVariablePass.$$$reportNull$$$0(6);
            }
            if (dialogIntroduce == null) {
                IntroduceVariablePass.$$$reportNull$$$0(7);
            }
            boolean inFinalContext = occurrenceManager.isInFinalContext();
            PsiExpression expr = occurrenceManager.getMainOccurence();
            Object[] selectedOccurrences = choice.filter(occurrenceManager);
            InputValidator validator = new InputValidator(IntroduceVariableBase.this, project, occurrenceManager);
            TypeSelectorManagerImpl typeSelectorManager = new TypeSelectorManagerImpl(project, originalType, expr, (PsiExpression[])selectedOccurrences);
            typeSelectorManager.setAllOccurrences(true);
            boolean hasWriteAccess = ContainerUtil.exists((Object[])selectedOccurrences, occ -> PsiUtil.isAccessedForWriting((PsiExpression)occ));
            PsiElement chosenAnchor = IntroduceVariableBase.getAnchor((PsiExpression[])selectedOccurrences);
            IntroduceVariableSettings settings = IntroduceVariableBase.this.getSettings(project, editor, expr, (PsiExpression[])selectedOccurrences, typeSelectorManager, inFinalContext, hasWriteAccess, validator, chosenAnchor, choice);
            if (choice.isChain()) {
                IntroduceVariableBase.this.myInplaceIntroducer = new ChainCallInplaceIntroducer(project, settings, chosenAnchor, editor, expr, (PsiExpression[])selectedOccurrences, typeSelectorManager, IntroduceVariableBase.getRefactoringName());
                if (!IntroduceVariableBase.this.myInplaceIntroducer.startInplaceIntroduceTemplate()) {
                    dialogIntroduce.accept(choice);
                }
            } else {
                boolean cantChangeFinalModifier = hasWriteAccess || inFinalContext && choice.isAll() || chosenAnchor instanceof PsiSwitchLabelStatementBase;
                Consumer<PsiElement> callback = arg_0 -> this.lambda$inplaceIntroduce$7(project, editor, settings, expr, cantChangeFinalModifier, (PsiExpression[])selectedOccurrences, typeSelectorManager, dialogIntroduce, choice, arg_0);
                if (targetContainer != null) {
                    callback.accept(targetContainer);
                } else {
                    IntroduceVariableTargetBlockChooser.chooseTargetAndPerform(editor, chosenAnchor, expr, callback);
                }
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private /* synthetic */ void lambda$inplaceIntroduce$7(Project project, Editor editor, IntroduceVariableSettings settings, PsiExpression expr, boolean cantChangeFinalModifier, PsiExpression[] selectedOccurrences, TypeSelectorManagerImpl typeSelectorManager, Consumer dialogIntroduce, JavaReplaceChoice choice, PsiElement container) {
            PsiElement anchor = container instanceof PsiLambdaExpression ? IntroduceVariableBase.getAnchor(container) : container;
            ErrorOrContainer errorOrContainer = IntroduceVariableBase.getTempContainer(anchor);
            if (!(errorOrContainer instanceof ErrorOrContainer.Error)) {
                IntroduceVariableBase.this.myInplaceIntroducer = new JavaVariableInplaceIntroducer(project, settings, anchor, editor, expr, cantChangeFinalModifier, selectedOccurrences, typeSelectorManager, IntroduceVariableBase.getRefactoringName());
                if (IntroduceVariableBase.this.myInplaceIntroducer.startInplaceIntroduceTemplate()) return;
                dialogIntroduce.accept(choice);
                return;
            }
            ErrorOrContainer.Error $b$0 = (ErrorOrContainer.Error)errorOrContainer;
            try {
                String patt1$temp;
                String message = patt1$temp = $b$0.message();
                IntroduceVariableBase.this.showErrorMessage(project, editor, message);
                return;
            }
            catch (Throwable throwable) {
                throw new MatchException(throwable.toString(), throwable);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "editor";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "choice";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "occurrenceManager";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "originalType";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dialogIntroduce";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/refactoring/introduceVariable/IntroduceVariableBase$IntroduceVariablePass";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[2] = "inplaceIntroduce";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static interface Validator {
        public boolean isOK(IntroduceVariableSettings var1);
    }
}

