/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.introduceVariable;

import com.intellij.codeInsight.template.impl.TemplateManagerImpl;
import com.intellij.codeInsight.template.impl.TemplateState;
import com.intellij.java.refactoring.JavaRefactoringBundle;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.editor.VisualPosition;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClassInitializer;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.ResolveState;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.controlFlow.ControlFlowUtil;
import com.intellij.psi.impl.light.LightElement;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.scope.processor.VariablesProcessor;
import com.intellij.psi.scope.util.PsiScopesUtil;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.refactoring.rename.inplace.InplaceRefactoring;
import com.intellij.ui.SimpleListCellRenderer;
import com.intellij.ui.awt.RelativePoint;
import java.awt.Component;
import java.awt.Point;
import java.util.ArrayList;
import java.util.Collection;
import javax.swing.ListCellRenderer;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;
import org.jetbrains.annotations.VisibleForTesting;

public final class ReassignVariableUtil {
    static final Key<SmartPsiElementPointer<PsiDeclarationStatement>> DECLARATION_KEY = Key.create((String)"var.type");
    static final Key<RangeMarker[]> OCCURRENCES_KEY = Key.create((String)"occurrences");

    private ReassignVariableUtil() {
    }

    @TestOnly
    public static void registerDeclaration(Editor editor, PsiDeclarationStatement declarationStatement, Disposable parentDisposable) {
        editor.putUserData(DECLARATION_KEY, (Object)SmartPointerManager.createPointer((PsiElement)declarationStatement));
        Disposer.register((Disposable)parentDisposable, () -> editor.putUserData(DECLARATION_KEY, null));
    }

    @VisibleForTesting
    public static boolean reassign(@Nullable Editor editor) {
        if (editor == null) {
            return false;
        }
        SmartPsiElementPointer pointer = (SmartPsiElementPointer)editor.getUserData(DECLARATION_KEY);
        PsiDeclarationStatement declaration = pointer != null ? (PsiDeclarationStatement)pointer.getElement() : null;
        PsiType type = ReassignVariableUtil.getVariableType(declaration);
        if (type != null) {
            VariablesProcessor proc = ReassignVariableUtil.findVariablesOfType(declaration, type);
            if (proc.size() > 0) {
                ArrayList<PsiVariable> vars = new ArrayList<PsiVariable>();
                for (int i = 0; i < proc.size(); ++i) {
                    PsiVariable variable = proc.getResult(i);
                    PsiElement outerCodeBlock = PsiUtil.getVariableCodeBlock((PsiVariable)variable, null);
                    if (outerCodeBlock == null || !ReferencesSearch.search((PsiElement)variable, (SearchScope)new LocalSearchScope(outerCodeBlock)).allMatch(reference -> ControlFlowUtil.getScopeEnforcingEffectiveFinality((PsiVariable)variable, (PsiElement)reference.getElement()) == null)) continue;
                    vars.add(variable);
                }
                if (vars.isEmpty()) {
                    return true;
                }
                if (vars.size() == 1) {
                    ReassignVariableUtil.replaceWithAssignment(declaration, proc.getResult(0), editor);
                    return true;
                }
                JBPopup popup = JBPopupFactory.getInstance().createPopupChooserBuilder(vars).setTitle(JavaRefactoringBundle.message((String)"introduce.local.variable.to.reassign.title", (Object[])new Object[0])).setRequestFocus(true).setRenderer((ListCellRenderer)SimpleListCellRenderer.create((label, value, index) -> {
                    if (value != null) {
                        label.setText(value.getName());
                        label.setIcon(value.getIcon(0));
                    }
                })).setItemChosenCallback(selectedValue -> ReassignVariableUtil.replaceWithAssignment(declaration, selectedValue, editor)).createPopup();
                if (ApplicationManager.getApplication().isHeadlessEnvironment()) {
                    popup.showInBestPositionFor(editor);
                } else {
                    VisualPosition visualPosition = editor.getCaretModel().getVisualPosition();
                    Point point = editor.visualPositionToXY(new VisualPosition(visualPosition.line + 1, visualPosition.column));
                    popup.show(new RelativePoint((Component)editor.getContentComponent(), point));
                }
            }
            return true;
        }
        return false;
    }

    @Nullable
    static PsiType getVariableType(@Nullable PsiDeclarationStatement declaration) {
        PsiElement[] declaredElements;
        if (declaration != null && (declaredElements = declaration.getDeclaredElements()).length > 0 && declaredElements[0] instanceof PsiVariable) {
            return ((PsiVariable)declaredElements[0]).getType();
        }
        return null;
    }

    static VariablesProcessor findVariablesOfType(final PsiDeclarationStatement declaration, final PsiType type) {
        PsiDeclarationStatement scope;
        VariablesProcessor proc = new VariablesProcessor(false){

            protected boolean check(PsiVariable var, ResolveState state) {
                for (PsiElement element : declaration.getDeclaredElements()) {
                    if (element != var && !(var instanceof LightElement)) continue;
                    return false;
                }
                return TypeConversionUtil.isAssignable((PsiType)var.getType(), (PsiType)type);
            }
        };
        for (scope = declaration; !(scope == null || scope instanceof PsiFile || scope instanceof PsiMethod || scope instanceof PsiLambdaExpression || scope instanceof PsiClassInitializer); scope = scope.getParent()) {
        }
        if (scope == null || DumbService.isDumb((Project)scope.getProject())) {
            return proc;
        }
        PsiScopesUtil.treeWalkUp((PsiScopeProcessor)proc, (PsiElement)declaration, (PsiElement)scope);
        return proc;
    }

    static void replaceWithAssignment(PsiDeclarationStatement declaration, PsiVariable variable, Editor editor) {
        PsiVariable var = (PsiVariable)declaration.getDeclaredElements()[0];
        PsiExpression initializer = var.getInitializer();
        WriteCommandAction.writeCommandAction((Project)declaration.getProject()).run(() -> {
            PsiElementFactory elementFactory = JavaPsiFacade.getElementFactory((Project)variable.getProject());
            String chosenVariableName = variable.getName();
            PsiStatement newDeclaration = elementFactory.createStatementFromText(chosenVariableName + " = " + initializer.getText() + ";", (PsiElement)declaration);
            Collection references = ReferencesSearch.search((PsiElement)var).findAll();
            newDeclaration = declaration.replace((PsiElement)newDeclaration);
            for (PsiReference reference : references) {
                PsiElement element = reference.getElement();
                if (!(element instanceof PsiExpression)) continue;
                element.replace((PsiElement)elementFactory.createExpressionFromText(chosenVariableName, (PsiElement)newDeclaration));
            }
            PsiModifierList modifierList = variable.getModifierList();
            if (modifierList != null) {
                modifierList.setModifierProperty("final", false);
            }
        });
        ReassignVariableUtil.finishTemplate(editor);
    }

    private static void finishTemplate(Editor editor) {
        TemplateState templateState2 = TemplateManagerImpl.getTemplateState((Editor)editor);
        InplaceRefactoring renamer = (InplaceRefactoring)editor.getUserData(InplaceRefactoring.INPLACE_RENAMER);
        if (templateState2 != null && renamer != null) {
            templateState2.gotoEnd(true);
            editor.putUserData(InplaceRefactoring.INPLACE_RENAMER, null);
        }
    }
}

