/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.memberPullUp;

import com.intellij.lang.ContextAwareActionHandler;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.psi.JavaDirectoryService;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassInitializer;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiEnumConstant;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.actions.RefactoringActionContextUtil;
import com.intellij.refactoring.classMembers.MemberInfoBase;
import com.intellij.refactoring.lang.ElementsHandler;
import com.intellij.refactoring.memberPullUp.JavaPullUpHandlerBase;
import com.intellij.refactoring.memberPullUp.PullUpConflictsUtil;
import com.intellij.refactoring.memberPullUp.PullUpDialog;
import com.intellij.refactoring.memberPullUp.PullUpProcessor;
import com.intellij.refactoring.ui.ConflictsDialog;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.refactoring.util.DocCommentPolicy;
import com.intellij.refactoring.util.RefactoringHierarchyUtil;
import com.intellij.refactoring.util.classMembers.MemberInfo;
import com.intellij.refactoring.util.classMembers.MemberInfoStorage;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class JavaPullUpHandler
implements PullUpDialog.Callback,
ElementsHandler,
ContextAwareActionHandler,
JavaPullUpHandlerBase {
    private PsiClass mySubclass;
    private Project myProject;

    public boolean isAvailableForQuickList(@NotNull Editor editor, @NotNull PsiFile file, @NotNull DataContext dataContext) {
        List elements;
        if (editor == null) {
            JavaPullUpHandler.$$$reportNull$$$0(0);
        }
        if (file == null) {
            JavaPullUpHandler.$$$reportNull$$$0(1);
        }
        if (dataContext == null) {
            JavaPullUpHandler.$$$reportNull$$$0(2);
        }
        if ((elements = CommonRefactoringUtil.findElementsFromCaretsAndSelections((Editor)editor, (PsiFile)file, PsiCodeBlock.class, e -> e instanceof PsiMember)).isEmpty()) {
            return false;
        }
        PsiClass psiClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)((PsiElement)elements.get(0)), PsiClass.class, (boolean)false);
        if (psiClass == null) {
            return false;
        }
        return psiClass instanceof PsiAnonymousClass || RefactoringActionContextUtil.isClassWithExtendsOrImplements(psiClass);
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile file, DataContext dataContext) {
        if (project == null) {
            JavaPullUpHandler.$$$reportNull$$$0(3);
        }
        editor.getScrollingModel().scrollToCaret(ScrollType.MAKE_VISIBLE);
        List elements = CommonRefactoringUtil.findElementsFromCaretsAndSelections((Editor)editor, (PsiFile)file, null, e -> e instanceof PsiMember);
        if (elements.isEmpty()) {
            String message = RefactoringBundle.getCannotRefactorMessage((String)RefactoringBundle.message((String)"the.caret.should.be.positioned.inside.a.class.to.pull.members.from"));
            CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)message, (String)JavaPullUpHandler.getRefactoringName(), (String)"refactoring.pullMembersUp");
        } else {
            this.invoke(project, elements.toArray(PsiElement.EMPTY_ARRAY), dataContext);
        }
    }

    public void runSilently(@NotNull PsiClass sourceClass, PsiClass targetSuperClass, MemberInfo[] membersToMove, DocCommentPolicy javaDocPolicy) {
        if (sourceClass == null) {
            JavaPullUpHandler.$$$reportNull$$$0(4);
        }
        new PullUpProcessor(sourceClass, targetSuperClass, membersToMove, javaDocPolicy).run();
    }

    public void invoke(@NotNull Project project, PsiElement @NotNull [] elements, DataContext dataContext) {
        PsiClass parentClass;
        PsiClass aClass;
        if (project == null) {
            JavaPullUpHandler.$$$reportNull$$$0(5);
        }
        if (elements == null) {
            JavaPullUpHandler.$$$reportNull$$$0(6);
        }
        this.myProject = project;
        PsiElement parent = PsiTreeUtil.findCommonParent((PsiElement[])elements);
        PsiClass psiClass = aClass = parent instanceof PsiClass ? (parentClass = (PsiClass)parent) : (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)parent, PsiClass.class, (boolean)false);
        if (aClass == null) {
            String message = RefactoringBundle.message((String)"error.select.class.to.be.refactored");
            CommonRefactoringUtil.showErrorHint((Project)project, null, (String)message, (String)JavaPullUpHandler.getRefactoringName(), (String)"refactoring.pullMembersUp");
            return;
        }
        HashSet<PsiElement> selectedMembers = new HashSet<PsiElement>();
        Collections.addAll(selectedMembers, elements);
        this.invoke(dataContext, aClass, selectedMembers);
    }

    private void invoke(DataContext dataContext, PsiClass aClass, Set<PsiElement> selectedMembers) {
        Editor editor;
        Editor editor2 = editor = dataContext != null ? (Editor)CommonDataKeys.EDITOR.getData(dataContext) : null;
        if (aClass == null) {
            String message = RefactoringBundle.getCannotRefactorMessage((String)RefactoringBundle.message((String)"is.not.supported.in.the.current.context", (Object[])new Object[]{JavaPullUpHandler.getRefactoringName()}));
            CommonRefactoringUtil.showErrorHint((Project)this.myProject, (Editor)editor, (String)message, (String)JavaPullUpHandler.getRefactoringName(), (String)"refactoring.pullMembersUp");
            return;
        }
        ArrayList<PsiClass> bases = RefactoringHierarchyUtil.createBasesList(aClass, false, true);
        if (bases.isEmpty()) {
            PsiClass containingClass = aClass.getContainingClass();
            if (containingClass != null) {
                this.invoke(dataContext, containingClass, Set.of(aClass));
                return;
            }
            String message = RefactoringBundle.getCannotRefactorMessage((String)RefactoringBundle.message((String)"class.does.not.have.base.classes.interfaces.in.current.project", (Object[])new Object[]{aClass.getQualifiedName()}));
            CommonRefactoringUtil.showErrorHint((Project)this.myProject, (Editor)editor, (String)message, (String)JavaPullUpHandler.getRefactoringName(), (String)"refactoring.pullMembersUp");
            return;
        }
        if (!CommonRefactoringUtil.checkReadOnlyStatus((Project)this.myProject, (PsiElement)aClass)) {
            return;
        }
        this.mySubclass = aClass;
        MemberInfoStorage memberInfoStorage = new MemberInfoStorage(this.mySubclass, (MemberInfoBase.Filter<PsiMember>)((MemberInfoBase.Filter)element -> {
            if (this.mySubclass.isEnum()) {
                PsiField field;
                PsiMethod method;
                if (element instanceof PsiMethod && PullUpDialog.isEnumSyntheticMethod(method = (PsiMethod)element)) {
                    return false;
                }
                if (element instanceof PsiEnumConstant || element instanceof PsiClassInitializer) {
                    return false;
                }
                if (element instanceof PsiField && !(field = (PsiField)element).hasModifierProperty("static")) {
                    return false;
                }
            }
            return true;
        }));
        List members = memberInfoStorage.getClassMemberInfos((PsiElement)this.mySubclass);
        for (MemberInfo memberInfo : members) {
            if (!selectedMembers.contains(memberInfo.getMember())) continue;
            memberInfo.setChecked(true);
        }
        new PullUpDialog(this.myProject, aClass, bases, memberInfoStorage, this).show();
    }

    @Override
    public boolean checkConflicts(PullUpDialog dialog) {
        List infos = dialog.getSelectedMemberInfos();
        MemberInfo[] memberInfos = infos.toArray(new MemberInfo[0]);
        PsiClass superClass = (PsiClass)dialog.getSuperClass();
        if (superClass == null || !this.checkWritable(superClass, memberInfos)) {
            return false;
        }
        MultiMap conflicts = new MultiMap();
        if (!ProgressManager.getInstance().runProcessWithProgressSynchronously(() -> ApplicationManager.getApplication().runReadAction(() -> {
            PsiPackage targetPackage;
            PsiDirectory targetDirectory = superClass.getContainingFile().getContainingDirectory();
            PsiPackage psiPackage = targetPackage = targetDirectory != null ? JavaDirectoryService.getInstance().getPackage(targetDirectory) : null;
            if (targetDirectory != null && targetPackage != null) {
                conflicts.putAllValues(PullUpConflictsUtil.checkConflicts(memberInfos, this.mySubclass, superClass, targetPackage, targetDirectory, dialog.getContainmentVerifier()));
            }
        }), RefactoringBundle.message((String)"detecting.possible.conflicts"), true, this.myProject)) {
            return false;
        }
        if (!conflicts.isEmpty()) {
            ConflictsDialog conflictsDialog = new ConflictsDialog(this.myProject, conflicts, () -> new PullUpProcessor(this.mySubclass, superClass, infos.toArray(new MemberInfo[0]), new DocCommentPolicy(dialog.getJavaDocPolicy())).run());
            boolean ok = conflictsDialog.showAndGet();
            if (!ok && conflictsDialog.isShowConflicts()) {
                dialog.close(1);
            }
            return ok;
        }
        return true;
    }

    private boolean checkWritable(PsiClass superClass, MemberInfo[] infos) {
        if (!CommonRefactoringUtil.checkReadOnlyStatus((Project)this.myProject, (PsiElement)superClass)) {
            return false;
        }
        for (MemberInfo info : infos) {
            if (info.getMember() instanceof PsiClass && info.getOverrides() != null || CommonRefactoringUtil.checkReadOnlyStatus((Project)this.myProject, (PsiElement)info.getMember())) continue;
            return false;
        }
        return true;
    }

    public boolean isEnabledOnElements(PsiElement[] elements) {
        return ContainerUtil.exists((Object[])elements, element -> element instanceof PsiMember);
    }

    @NlsContexts.DialogTitle
    public static String getRefactoringName() {
        return RefactoringBundle.message((String)"pull.members.up.title");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataContext";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceClass";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
        }
        objectArray2[1] = "com/intellij/refactoring/memberPullUp/JavaPullUpHandler";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "isAvailableForQuickList";
                break;
            }
            case 3: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "invoke";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "runSilently";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

