/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.migration;

import com.intellij.java.refactoring.JavaRefactoringBundle;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.refactoring.migration.EditMigrationDialogUi;
import com.intellij.refactoring.migration.EditMigrationEntryDialog;
import com.intellij.refactoring.migration.MigrationMap;
import com.intellij.refactoring.migration.MigrationMapEntry;
import com.intellij.refactoring.migration.MigrationMapSet;
import com.intellij.ui.ToolbarDecorator;
import com.intellij.ui.table.JBTable;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableModel;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.Nullable;

public class EditMigrationDialog
extends DialogWrapper {
    private EditMigrationDialogUi myUi;
    private JBTable myTable;
    private final Project myProject;
    private final MigrationMap myMigrationMap;
    private final MigrationMapSet myMigrationMapSet;
    private final String myEditedMapName;

    public EditMigrationDialog(Project project, MigrationMap migrationMap, MigrationMapSet migrationMapSet, String editedMapName) {
        super(project, true);
        this.myProject = project;
        this.myMigrationMap = migrationMap;
        this.myMigrationMapSet = migrationMapSet;
        this.myEditedMapName = editedMapName;
        this.setHorizontalStretch(1.2f);
        if (editedMapName.isEmpty()) {
            this.setTitle(JavaRefactoringBundle.message((String)"edit.migration.map.title.new", (Object[])new Object[0]));
        } else {
            this.setTitle(JavaRefactoringBundle.message((String)"edit.migration.map.title.existing", (Object[])new Object[0]));
        }
        this.setOKButtonText(JavaRefactoringBundle.message((String)"edit.migration.map.ok.button", (Object[])new Object[0]));
        this.init();
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myUi.getNameField();
    }

    @Nls
    public String getName() {
        @NlsSafe String text = this.myUi.getNameField().getText();
        return text;
    }

    @Nls
    public String getDescription() {
        @NlsSafe String text = this.myUi.getDescriptionTextArea().getText();
        return text;
    }

    protected JComponent createCenterPanel() {
        this.myUi = new EditMigrationDialogUi(this.myMigrationMapSet, ToolbarDecorator.createDecorator((JTable)this.createTable()).setAddAction(button -> this.addRow()).setRemoveAction(button -> this.removeSelectedRow()).setEditAction(button -> this.edit()).setMoveUpAction(button -> this.moveUp()).setMoveDownAction(button -> this.moveDown()).createPanel(), this);
        JTextField nameField = this.myUi.getNameField();
        nameField.setText(this.myMigrationMap.getName());
        this.myUi.getDescriptionTextArea().setText(this.myMigrationMap.getDescription());
        return this.myUi.getPanel();
    }

    private void edit() {
        EditMigrationEntryDialog dialog = new EditMigrationEntryDialog(this.myProject);
        int selected = this.myTable.getSelectedRow();
        if (selected < 0) {
            return;
        }
        MigrationMapEntry entry = this.myMigrationMap.getEntryAt(selected);
        dialog.setEntry(entry);
        if (!dialog.showAndGet()) {
            return;
        }
        dialog.updateEntry(entry);
        AbstractTableModel model = (AbstractTableModel)this.myTable.getModel();
        model.fireTableRowsUpdated(selected, selected);
    }

    private void addRow() {
        EditMigrationEntryDialog dialog = new EditMigrationEntryDialog(this.myProject);
        MigrationMapEntry entry = new MigrationMapEntry();
        dialog.setEntry(entry);
        if (!dialog.showAndGet()) {
            return;
        }
        dialog.updateEntry(entry);
        this.addEntry(entry);
    }

    private void addEntry(MigrationMapEntry entry) {
        this.myMigrationMap.addEntry(entry);
        AbstractTableModel model = (AbstractTableModel)this.myTable.getModel();
        model.fireTableRowsInserted(this.myMigrationMap.getEntryCount() - 1, this.myMigrationMap.getEntryCount() - 1);
        this.myTable.setRowSelectionInterval(this.myMigrationMap.getEntryCount() - 1, this.myMigrationMap.getEntryCount() - 1);
    }

    private void removeSelectedRow() {
        int selected = this.myTable.getSelectedRow();
        if (selected < 0) {
            return;
        }
        this.removeRow(selected);
    }

    private void removeRow(int selected) {
        this.myMigrationMap.removeEntryAt(selected);
        AbstractTableModel model = (AbstractTableModel)this.myTable.getModel();
        model.fireTableRowsDeleted(selected, selected);
        if (selected >= this.myMigrationMap.getEntryCount()) {
            --selected;
        }
        if (selected >= 0) {
            this.myTable.setRowSelectionInterval(selected, selected);
        }
    }

    private void moveUp() {
        int selected = this.myTable.getSelectedRow();
        if (selected < 1) {
            return;
        }
        MigrationMapEntry entry = this.myMigrationMap.getEntryAt(selected);
        MigrationMapEntry previousEntry = this.myMigrationMap.getEntryAt(selected - 1);
        this.myMigrationMap.setEntryAt(previousEntry, selected);
        this.myMigrationMap.setEntryAt(entry, selected - 1);
        AbstractTableModel model = (AbstractTableModel)this.myTable.getModel();
        model.fireTableRowsUpdated(selected - 1, selected);
        this.myTable.setRowSelectionInterval(selected - 1, selected - 1);
    }

    private void moveDown() {
        int selected = this.myTable.getSelectedRow();
        if (selected >= this.myMigrationMap.getEntryCount() - 1) {
            return;
        }
        MigrationMapEntry entry = this.myMigrationMap.getEntryAt(selected);
        MigrationMapEntry nextEntry = this.myMigrationMap.getEntryAt(selected + 1);
        this.myMigrationMap.setEntryAt(nextEntry, selected);
        this.myMigrationMap.setEntryAt(entry, selected + 1);
        AbstractTableModel model = (AbstractTableModel)this.myTable.getModel();
        model.fireTableRowsUpdated(selected, selected + 1);
        this.myTable.setRowSelectionInterval(selected + 1, selected + 1);
    }

    private JBTable createTable() {
        final String[] names = new String[]{JavaRefactoringBundle.message((String)"migration.type.column.header", (Object[])new Object[0]), JavaRefactoringBundle.message((String)"migration.old.name.column.header", (Object[])new Object[0]), JavaRefactoringBundle.message((String)"migration.new.name.column.header", (Object[])new Object[0])};
        AbstractTableModel dataModel = new AbstractTableModel(){

            @Override
            public int getColumnCount() {
                return 3;
            }

            @Override
            public int getRowCount() {
                return EditMigrationDialog.this.myMigrationMap.getEntryCount();
            }

            @Override
            public Object getValueAt(int row, int col) {
                String suffix;
                MigrationMapEntry entry = EditMigrationDialog.this.myMigrationMap.getEntryAt(row);
                if (col == 0) {
                    if (entry.getType() == 0 && entry.isRecursive()) {
                        return JavaRefactoringBundle.message((String)"migration.package.with.subpackages", (Object[])new Object[0]);
                    }
                    if (entry.getType() == 0 && !entry.isRecursive()) {
                        return JavaRefactoringBundle.message((String)"migration.package", (Object[])new Object[0]);
                    }
                    return JavaRefactoringBundle.message((String)"migration.class", (Object[])new Object[0]);
                }
                String string = suffix = entry.getType() == 0 ? ".*" : "";
                if (col == 1) {
                    return entry.getOldName() + suffix;
                }
                return entry.getNewName() + suffix;
            }

            @Override
            public String getColumnName(int column) {
                return names[column];
            }

            public Class<String> getColumnClass(int c) {
                return String.class;
            }
        };
        this.myTable = new JBTable((TableModel)dataModel);
        this.myTable.setSelectionMode(0);
        this.myTable.setVisibleRowCount(10);
        return this.myTable;
    }

    public void copyMap(@Nullable String mapName) {
        if (mapName == null) {
            return;
        }
        MigrationMap copiedMap = this.myMigrationMapSet.findMigrationMap(mapName);
        if (copiedMap == null) {
            return;
        }
        this.myUi.getNameField().setText(copiedMap.getName());
        this.myUi.getDescriptionTextArea().setText(copiedMap.getDescription());
        while (this.myTable.getRowCount() > 0) {
            this.removeRow(0);
        }
        for (int i = 0; i < copiedMap.getEntryCount(); ++i) {
            this.addEntry(copiedMap.getEntryAt(i));
        }
    }

    public ValidationInfo validateName(@Nullable String text) {
        if (text.isBlank()) {
            return new ValidationInfo(JavaRefactoringBundle.message((String)"migration.edit.empty.name", (Object[])new Object[0]));
        }
        if (this.myMigrationMapSet.findMigrationMap(text) != null && (this.myEditedMapName.isEmpty() || !text.equals(this.myEditedMapName))) {
            return new ValidationInfo(JavaRefactoringBundle.message((String)"migration.edit.existing.name", (Object[])new Object[0]));
        }
        return null;
    }

    public ValidationInfo validateTable() {
        if (this.myMigrationMap.getEntryCount() == 0) {
            return new ValidationInfo(JavaRefactoringBundle.message((String)"migration.edit.empty.table", (Object[])new Object[0]));
        }
        return null;
    }
}

