/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.migration;

import com.intellij.java.refactoring.JavaRefactoringBundle;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.MessageDialogBuilder;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.refactoring.migration.EditMigrationDialog;
import com.intellij.refactoring.migration.MigrationDialogUi;
import com.intellij.refactoring.migration.MigrationManager;
import com.intellij.refactoring.migration.MigrationMap;
import com.intellij.refactoring.migration.MigrationMapSet;
import com.intellij.ui.components.ActionLink;
import java.awt.Component;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jps.model.java.JavaModuleSourceRootTypes;

public class MigrationDialog
extends DialogWrapper {
    private static final Logger LOG = Logger.getInstance(MigrationDialog.class);
    private MigrationDialogUi myUi;
    private final Project myProject;
    private MigrationMap myMigrationMap;
    private final MigrationMapSet myMigrationMapSet;

    public MigrationDialog(Project project, MigrationMap migrationMap, MigrationMapSet migrationMapSet) {
        super(project, true);
        this.myProject = project;
        this.myMigrationMap = migrationMap;
        this.myMigrationMapSet = migrationMapSet;
        this.setTitle(JavaRefactoringBundle.message((String)"migration.dialog.title", (Object[])new Object[0]));
        this.setOKButtonText(JavaRefactoringBundle.message((String)"migration.dialog.ok.button.text", (Object[])new Object[0]));
        this.setResizable(false);
        this.init();
    }

    protected String getHelpId() {
        return "refactoring.migrate";
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myUi.preferredFocusedComponent();
    }

    protected JComponent createCenterPanel() {
        this.myUi = new MigrationDialogUi(this.myMigrationMap);
        this.myUi.getEditLink().addActionListener(event -> this.editMap(this.myMigrationMap));
        ActionLink removeLink = this.myUi.getRemoveLink();
        if (removeLink != null) {
            removeLink.addActionListener(event -> this.removeMap());
        }
        this.myUi.modulesCombo.setModules(this.getModuleOptions());
        this.myUi.modulesCombo.allowEmptySelection(JavaRefactoringBundle.message((String)"migration.dialog.scope.whole.project", (Object[])new Object[0]));
        return this.myUi.getPanel();
    }

    @NotNull
    private List<Module> getModuleOptions() {
        ModuleManager moduleManager = ModuleManager.getInstance((Project)this.myProject);
        ArrayList<Module> jvmModules = new ArrayList<Module>();
        for (Module module : moduleManager.getModules()) {
            ModuleRootManager moduleRootManager = ModuleRootManager.getInstance((Module)module);
            if (moduleRootManager.getSourceRoots(JavaModuleSourceRootTypes.SOURCES).isEmpty() && moduleRootManager.getSourceRoots(JavaModuleSourceRootTypes.RESOURCES).isEmpty()) continue;
            jvmModules.add(module);
        }
        ArrayList<Module> arrayList = jvmModules;
        if (arrayList == null) {
            MigrationDialog.$$$reportNull$$$0(0);
        }
        return arrayList;
    }

    private void editMap(MigrationMap map) {
        if (map == null) {
            return;
        }
        boolean predefined = MigrationMapSet.isPredefined(map.getFileName());
        MigrationMap mapToEdit = map;
        String editedMapName = "";
        if (predefined) {
            mapToEdit = map.cloneMap();
            mapToEdit.setName(JavaRefactoringBundle.message((String)"migration.edit.duplicated.migration.name", (Object[])new Object[]{mapToEdit.getName()}));
        } else {
            editedMapName = mapToEdit.getName();
        }
        EditMigrationDialog dialog = new EditMigrationDialog(this.myProject, mapToEdit, this.myMigrationMapSet, editedMapName);
        if (!dialog.showAndGet()) {
            return;
        }
        MigrationManager.updateMapFromDialog(mapToEdit, dialog);
        if (predefined) {
            try {
                this.myMigrationMapSet.addMap(mapToEdit);
                this.myMigrationMapSet.saveMaps();
                this.doCancelAction();
            }
            catch (IOException e) {
                LOG.error("Couldn't save migration maps.", (Throwable)e);
            }
        } else {
            this.myMigrationMap = mapToEdit;
            this.myUi.update(this.myMigrationMap);
        }
    }

    private void removeMap() {
        if (((MessageDialogBuilder.YesNo)MessageDialogBuilder.yesNo((String)JavaRefactoringBundle.message((String)"migration.dialog.alert.name", (Object[])new Object[0]), (String)JavaRefactoringBundle.message((String)"migration.dialog.alert.text", (Object[])new Object[]{this.myMigrationMap.getName()})).yesText(JavaRefactoringBundle.message((String)"migration.dialog.alert.delete", (Object[])new Object[0]))).ask((Component)this.myUi.getPanel())) {
            this.myMigrationMapSet.removeMap(this.myMigrationMap);
            try {
                this.myMigrationMapSet.saveMaps();
                this.doCancelAction();
            }
            catch (IOException e) {
                LOG.error("Couldn't save migration maps.", (Throwable)e);
            }
        }
    }

    @NotNull
    public GlobalSearchScope getMigrationScope() {
        Module selectedModule = this.myUi.getModulesCombo().getSelectedModule();
        if (selectedModule == null) {
            GlobalSearchScope globalSearchScope = GlobalSearchScope.projectScope((Project)this.myProject);
            if (globalSearchScope == null) {
                MigrationDialog.$$$reportNull$$$0(1);
            }
            return globalSearchScope;
        }
        GlobalSearchScope globalSearchScope = selectedModule.getModuleScope();
        if (globalSearchScope == null) {
            MigrationDialog.$$$reportNull$$$0(2);
        }
        return globalSearchScope;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/intellij/refactoring/migration/MigrationDialog";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getModuleOptions";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getMigrationScope";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

