/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.migration;

import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ProperTextRange;
import com.intellij.openapi.util.Segment;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMigration;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiReference;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.JavaClassReference;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.refactoring.migration.MigrationProcessor;
import com.intellij.usageView.UsageInfo;
import com.intellij.util.IncorrectOperationException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UReferenceExpression;
import org.jetbrains.uast.UastContextKt;
import org.jetbrains.uast.generate.UastCodeGenerationPluginKt;

public final class MigrationUtil {
    private static final Logger LOG = Logger.getInstance(MigrationUtil.class);

    private MigrationUtil() {
    }

    public static UsageInfo[] findPackageUsages(Project project, PsiMigration migration, String qName, GlobalSearchScope searchScope) {
        PsiPackage aPackage = MigrationUtil.findOrCreatePackage(project, migration, qName);
        return MigrationUtil.findRefs((PsiElement)aPackage, searchScope).toArray(UsageInfo.EMPTY_ARRAY);
    }

    @Nullable
    private static PsiElement bindNonJavaReference(PsiElement bindTo, PsiElement element, UsageInfo usage) {
        if (element instanceof PsiFile) {
            return null;
        }
        ProperTextRange range = usage.getRangeInElement();
        for (PsiReference reference : element.getReferences()) {
            JavaClassReference classReference;
            if (!(reference instanceof JavaClassReference) || !(classReference = (JavaClassReference)reference).getRangeInElement().equals((Object)range)) continue;
            return classReference.bindToElement(bindTo);
        }
        return bindTo;
    }

    public static UsageInfo[] findClassUsages(Project project, PsiMigration migration, String qName, GlobalSearchScope searchScope) {
        PsiClass[] classes = MigrationUtil.findOrCreateClass(project, migration, qName);
        ArrayList<UsageInfo> usages = new ArrayList<UsageInfo>();
        for (PsiClass aClass : classes) {
            usages.addAll(MigrationUtil.findRefs((PsiElement)aClass, searchScope));
        }
        return usages.toArray(UsageInfo.EMPTY_ARRAY);
    }

    private static List<UsageInfo> findRefs(PsiElement aClass, GlobalSearchScope searchScope) {
        ArrayList<UsageInfo> results = new ArrayList<UsageInfo>();
        for (PsiReference usage : ReferencesSearch.search((PsiElement)aClass, (SearchScope)searchScope, (boolean)false)) {
            results.add(new UsageInfo(usage));
        }
        results.sort(Comparator.comparing(u -> {
            VirtualFile file = u.getVirtualFile();
            return file == null ? null : file.getName();
        }).thenComparingInt(u -> {
            Segment range = u.getNavigationRange();
            return range == null ? 0 : range.getStartOffset();
        }));
        return results;
    }

    static void doMigration(PsiElement elementToBind, String newQName, UsageInfo[] usages, ArrayList<? super SmartPsiElementPointer<PsiElement>> refsToShorten) {
        try {
            SmartPointerManager smartPointerManager = SmartPointerManager.getInstance((Project)elementToBind.getProject());
            for (UsageInfo usage : usages) {
                PsiElement psiElement;
                UElement uElement;
                PsiClass[] inScope;
                PsiElement element;
                if (!(usage instanceof MigrationProcessor.MigrationUsageInfo)) continue;
                MigrationProcessor.MigrationUsageInfo usageInfo = (MigrationProcessor.MigrationUsageInfo)usage;
                if (!Objects.equals(newQName, usageInfo.mapEntry.getNewName()) || (element = usage.getElement()) == null || !element.isValid()) continue;
                if (elementToBind instanceof PsiClass && newQName != null && (inScope = JavaPsiFacade.getInstance((Project)element.getProject()).findClasses(newQName, element.getResolveScope())).length > 0) {
                    elementToBind = inScope[0];
                }
                if ((uElement = UastContextKt.toUElement((PsiElement)element)) instanceof UReferenceExpression) {
                    UReferenceExpression uReference = (UReferenceExpression)uElement;
                    psiElement = UastCodeGenerationPluginKt.bindToElement((UReferenceExpression)uReference, (PsiElement)elementToBind);
                } else {
                    psiElement = MigrationUtil.bindNonJavaReference(elementToBind, element, usage);
                }
                if (psiElement == null) continue;
                refsToShorten.add((SmartPsiElementPointer<PsiElement>)smartPointerManager.createSmartPsiElementPointer(psiElement));
            }
        }
        catch (IncorrectOperationException e) {
            LOG.error((Throwable)e);
        }
    }

    static PsiPackage findOrCreatePackage(Project project, PsiMigration migration, String qName) {
        PsiPackage aPackage = JavaPsiFacade.getInstance((Project)project).findPackage(qName);
        if (aPackage != null) {
            return aPackage;
        }
        return (PsiPackage)WriteAction.compute(() -> migration.createPackage(qName));
    }

    static PsiClass[] findOrCreateClass(Project project, PsiMigration migration, String qName) {
        PsiClass[] classes = JavaPsiFacade.getInstance((Project)project).findClasses(qName, GlobalSearchScope.allScope((Project)project));
        if (classes.length == 0) {
            classes = (PsiClass[])WriteAction.compute(() -> new PsiClass[]{migration.createClass(qName)});
        }
        return classes;
    }
}

